# flake8: noqa
# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import datetime
import os
import re
import sys

catalyst_root_path = "../"
sys.path.insert(0, os.path.abspath(catalyst_root_path))

# -- Project information -----------------------------------------------------

project = "Catalyst"
copyright = "{}, Scitator".format(datetime.datetime.now().year)
author = "Sergey Kolesnikov"

docs_repo = "catalyst"
docs_user = "catalyst-team"

releases_github_path = "catalyst-team/catalyst"


def get_version(mode: str = "full") -> str:
    """Docs? Contribution is welcome."""
    current_dir = os.path.abspath(os.path.dirname(__file__))
    root = os.path.dirname(current_dir)
    version_file = os.path.join(root, "catalyst", "__version__.py")
    if not os.path.exists(version_file):
        version_file = os.path.join(root, "__version__.py")

    version_ = "1.0"
    try:
        with open(version_file) as f:
            version_ = re.search(r'^__version__ = [\'"]([^\'"]*)[\'"]', f.read(), re.M).group(1)
    except Exception:
        pass

    if mode == "short":
        try:
            version_ = re.search(r"^(\d+\.\d+)", version_, re.M).group(1)
        except Exception:
            pass

    return version_


# The short X.Y version
version = get_version("short")
# The full version, including alpha/beta/rc tags
release = get_version("full")

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = "1.0"

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named "sphinx.ext.*") or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.viewcode",
    "sphinx.ext.githubpages",
    "sphinx.ext.napoleon",
    # "releases",
]

autodoc_inherit_docstrings = False
napoleon_google_docstring = True
napoleon_include_init_with_doc = True
napoleon_numpy_docstring = False

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = [".rst", ".md"]
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# Ignoring Third-party packages

autodoc_mock_imports = [
    "alchemy",
    "neptune",
    "wandb",
    "gym",
    "gridfs",
    "pymongo",
    "redis",
]

# autodoc_default_flags = [
#     "members", "undoc-members", "private-members",
#     "special-members", "inherited-members", "show-inheritance"
# ]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "catalyst_sphinx_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {}
# html_theme_options = {
#     "display_version": True,
#     "prev_next_buttons_location": "bottom",
#     "collapse_navigation": False,
#     "sticky_navigation": True,
#     "navigation_depth": 4,
# }

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ["_static"]

html_short_title = "Accelerated Deep Learning R&D"

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don"t match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``["localtoc.html", "relations.html", "sourcelink.html",
# "searchbox.html"]``.
#
# html_sidebars = {}

html_context = {
    "display_github": True,
    "source_url_prefix": (f"https://github.com/{docs_user}/{docs_repo}/tree/master/docs"),
    "github_host": "github.com",
    "github_user": docs_user,
    "github_repo": docs_repo,
    "github_version": "master",
    "conf_py_path": "/docs/",
    "source_suffix": ".rst",
}

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "Catalystdoc"

# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ("letterpaper" or "a4paper").
    #
    # "papersize": "letterpaper",
    # The font size ("10pt", "11pt" or "12pt").
    #
    # "pointsize": "10pt",
    # Additional stuff for the LaTeX preamble.
    #
    # "preamble": "",
    # Latex figure (float) alignment
    #
    # "figure_align": "htbp",
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "Catalyst.tex", "Catalyst Documentation", "Scitator", "manual",),
]

# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "catalyst", "Catalyst Documentation", [author], 1)]

# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "Catalyst",
        "Catalyst Documentation",
        author,
        "Catalyst",
        "One line description of project.",
        "Miscellaneous",
    ),
]

# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ""

# A unique identification for the text.
#
# epub_uid = ""

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]

# -- Extension configuration -------------------------------------------------

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True
