## Before submitting (checklist)

- [ ] Was this discussed/approved via a Github issue? (no need for typos and docs improvements)
- [ ] Did you read the [contribution guide](https://github.com/catalyst-team/catalyst/blob/master/CONTRIBUTING.md)?
- [ ] Did you check the code style? `catalyst-make-codestyle && catalyst-check-codestyle` (`pip install -U catalyst-codestyle`).
- [ ] Did you make sure to update the docs? We use Google format for all the methods and classes.
- [ ] Did you check the docs with `make check-docs`?
- [ ] Did you write any new necessary tests?
- [ ] Did you check that your code passes the unit tests `pytest .` ? 
- [ ] Did you add your new functionality to the docs?
- [ ] Did you update the [CHANGELOG](https://github.com/catalyst-team/catalyst/blob/master/CHANGELOG.md)?
- [ ] Did you run [colab minimal CI/CD](https://colab.research.google.com/github/catalyst-team/catalyst/blob/master/examples/notebooks/colab_ci_cd.ipynb) with `latest` and `minimal` requirements?

<!-- For CHANGELOG separate each item in unreleased section by blank line to reduce collisions -->


## Description

<!-- Add a more detailed description of the changes if needed. -->


## Related Issue

<!-- If your PR refers to a related issue, link it here. -->


## Type of Change

<!-- Mark with an `x` all the checkboxes that apply (like `[x]`) -->

- [ ] Examples / docs / tutorials / contributors update
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] Improvement (non-breaking change which improves an existing feature)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to change)


## PR review

Anyone in the community is free to review the PR once the tests have passed.
If we didn't discuss your PR in Github issues there's a high chance it will not be merged.

<!-- Thank you for your contribution! -->


### FAQ
Please review the FAQ before submitting an issue:
- [ ] I have read the [documentation and FAQ](https://catalyst-team.github.io/catalyst/)
- [ ] I have reviewed the [minimal examples section](https://github.com/catalyst-team/catalyst#minimal-examples)
- [ ] I have checked the [changelog](https://github.com/catalyst-team/catalyst/blob/master/CHANGELOG.md) for main framework updates
- [ ] I have read the [contribution guide](https://github.com/catalyst-team/catalyst/blob/master/CONTRIBUTING.md)
- [ ] I have joined [Catalyst slack (#__questions channel)](https://join.slack.com/t/catalyst-team-core/shared_invite/zt-d9miirnn-z86oKDzFMKlMG4fgFdZafw) for issue discussion
