---
name: Bug report
about: Create a report to help us improve
title: ''
labels: bug, help wanted
assignees: Scitator, bagxi, Ditwoo

---

## 🐛 Bug Report
<!-- A clear and concise description of what the bug is. -->


### How To Reproduce
Steps to reproduce the behavior:
1. Go to '...'
1. Run '....'
3. ...

<!-- If you have a code sample, error messages, stack traces, please provide it here as well --> 


#### Code sample
<!-- 
Ideally attach a minimal code sample to reproduce the decried issue. 
Minimal means having the shortest code but still preserving the bug. 
You could use minimal examples - https://github.com/catalyst-team/catalyst#minimal-examples.
-->

#### Screenshots
<!-- If applicable, add screenshots to help explain your problem.  -->


### Expected behavior
<!-- A clear and concise description of what you expected to happen. -->


### Environment
Please copy and paste the output from our environment collection script
```bash
catalyst-contrib --collect-env
# or manually
wget https://raw.githubusercontent.com/catalyst-team/catalyst/master/catalyst/contrib/scripts/collect_env.py
python collect_env.py
```
(or fill out the checklist below manually).

```bash
# example checklist, fill with your info
Catalyst version: 20.04.2
PyTorch version: 1.4.0
TensorFlow version: N/A
TensorBoard version: 2.2.1
OS: Mac OSX 10.15.4
Python version: 3.7
CUDA runtime version: No CUDA
Nvidia driver version: No CUDA
cuDNN version: No CUDA
```


### Additional context
<!-- Add any other context about the problem here. -->


### Checklist
- [ ] bug description
- [ ] steps to reproduce
- [ ] expected behavior
- [ ] environment
- [ ] code sample / screenshots
  
### FAQ
Please review the FAQ before submitting an issue:
- [ ] I have read the [documentation and FAQ](https://catalyst-team.github.io/catalyst/)
- [ ] I have reviewed the [minimal examples section](https://github.com/catalyst-team/catalyst#minimal-examples)
- [ ] I have checked the [changelog](https://github.com/catalyst-team/catalyst/blob/master/CHANGELOG.md) for main framework updates
- [ ] I have read the [contribution guide](https://github.com/catalyst-team/catalyst/blob/master/CONTRIBUTING.md)
- [ ] I have joined [Catalyst slack (#__questions channel)](https://join.slack.com/t/catalyst-team-core/shared_invite/zt-d9miirnn-z86oKDzFMKlMG4fgFdZafw) for issue discussion
