# coding=utf-8
# Distributed under the MIT software license, see the accompanying
# file LICENSE or http://www.opensource.org/licenses/mit-license.php.
from pyqrllib.pyqrllib import hstr2bin, bin2hstr


def binvec2hstr(data):
    return [bin2hstr(b) for b in data]


xmss_test_eseed1 = bytes([0x10, 0x02, 0x00] + [0] * 48)
xmss_test_eseed2 = bytes([0x10, 0x02, 0x00] + [1] * 48)

new_keys_expected = ('000000000000000000000000000000000000000000000000',
                     '\x83\xa9\x1aMzV\n\xbdA\xea\x95\xf4\x12\xcd\xe9\x8e\xda\x03v\x9dr\xb5u[\xb7\xc4\xabt3\xe750 ?\xa6p\xa4\xc6\xd4\xf2\xadZ\xc0\xf8\xf0\xce0\xa7', "2\xee\xe8\x08\xdc|]\xfe&\xfdHY\xb4\x15\xe5\xa7\x13\xbdv@6\xbb\xee\xfdzT\x1d\xa9\xa1\xcc{\x9f\xca\xf1}\xa09\xa6'V\xb685\xde\x17i\xe0^")

xmss_pk_expected1 = '000200eb0372d56b886645e7c036b480be95ed97bc431b4e828befd4162bf432858df83191da3442686282b3d5160f25cf162a517fd2131f83fbf2698a58f9c46afc5d'

xmss_pk_expected2 = '000200eb0372d56b886645e7c036b480be95ed97bc431b4e828befd4162bf432858df83191da3442686282b3d5160f25cf162a517fd2131f83fbf2698a58f9c46afc5d'

xmss_sk_expected1 = '00000000eda313c95591a023a5b37f361c07a5753a92d3d0427459f34c7895d727d62816b3aa2224eb9d823127d4f9f8a30fd7a1a02c6483d9c0f1fd41957b9ae4dfc63a3191da3442686282b3d5160f25cf162a517fd2131f83fbf2698a58f9c46afc5deb0372d56b886645e7c036b480be95ed97bc431b4e828befd4162bf432858df8'

xmss_sk_expected2 = '00000000cd7ec7a104f01855ea39946b36fb02e9484a5fe58f6ab04f5a6420cce1c3f06bd257d174803df26ed03edd1edc8c4fdcedd39cb250426b468b028c9b1ce0ee507c0e0d17374d4dfe29afdd0b1b4aed369809351b6ba6aeffbcc7eeb6bf3aa5190c38e56c770db22b33560fb5cb6ffa992d6d8d28fa94b915a7472316018f32c6'

xmss_mnemonic_eseed1 = '0002006b6c5c1c859079864060ff38e67940394bb4439fddafa6fc716731dec13a0f29ca9b9001527e8daf0851245cbf738435'
xmss_mnemonic_eseed2 = '0002004493ca509e5550a50af4c5a357c041b7bb4d15f77662d0bfe04d4c2ee1eff87a0580c7bc6878c468257a977fd167378e'
xmss_mnemonic_test1 = 'aback bunny honey shell brass fund lance hairy greedy villa told nearer defect row ease writer radius influx inter jacket tank beauty away oven organ abbey flick train quote magic career slope java earl'
xmss_mnemonic_test2 = 'aback bunny editor digit fine tight finish finish voice galley friend agency ridge render bet kin guide aside tecum star common budget wheel patron lobe leaky helm mildew heir fridge noun worthy heart lad'

xmss_sign_expected1 = '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'
xmss_sign_expected1_h = 4

xmss_sign_expected2 = '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'
xmss_sign_expected2_h = 4

hashchain_reveal_input = hstr2bin('32eee808dc7c5dfe26fd4859b415e5a713bd764036bbeefd7a541da9a1cc7b9fcaf17da039a62756b63835de1769e05e')

hashchain_reveal_expected1 = '1d607de5dc840ca31b6cdc8aa2a0c5e7158396b27103a3a128c97994d33e3fce'

message_example = 'ff00003030303030303065007b2274797065223a20224d42227d0000ffff00003030303030303261007b2274797065223a2022504c222c202264617461223a20225b5c223137322e31382e302e365c225d227d0000ffff00003030303030303065007b2274797065223a20225645227d0000ffff00003030303030306434007b2274797065223a20224342222c202264617461223a20227b5c22626c6f636b5f6e756d6265725c223a20302c205c22686561646572686173685c223a205b35332c203133302c203136382c2035372c203138332c203231352c203132302c203137382c203230392c2033302c203139342c203232332c203232312c2035382c2037322c203132342c2036322c203134382c203131302c2038312c2031392c203138392c2032372c203234332c203231382c2038372c203231372c203230332c203139382c2039372c2038342c2031395d7d227d0000ffff00003030303030303635007b2274797065223a20225645222c202264617461223a20227b5c2267656e657369735f707265765f686561646572686173685c223a205c2243727970746f6e69756d5c222c205c2276657273696f6e5c223a205c22616c7068612f302e3435615c227d227d0000ff'