import numpy as np 
from scipy.optimize import root
#from .stability import ell_init
from .equilibriumresult import EquilibriumResult

def haz_objb(inc, T_P, tipo, modelo, v0):
    
    X, W, Y ,P_T = np.array_split(inc,4)
    
    if tipo == 'T':
        P=P_T
        T=T_P
    elif tipo == 'P':
        T=P_T
        P=T_P
    
    global vx, vw, vy
    vx, vw, vy = v0
   
    
    fugX, vx = modelo.logfugef(X, T, P, 'L',vx)
    fugW, vw = modelo.logfugef(W, T, P, 'L', vw)
    fugY, vy = modelo.logfugef(Y, T, P, 'V', vy)
    
    K1 = np.exp(fugX-fugY)
    K2 = np.exp(fugX-fugW)
    return np.hstack([K1*X-Y,K2*X-W, X.sum()-1, Y.sum()-1,W.sum()-1])


def hazb(X0, W0, Y0, P_T, T_P, spec , model, v0 = [None, None, None], full_output = False):
    global vx, vw, vy
    sol1 = root(haz_objb, np.hstack([X0, W0, Y0, P_T]),args = (T_P, spec, model, v0))
    error = np.linalg.norm(sol1.fun)
    nfev = sol1.nfev
    sol = sol1.x
    if np.any(sol<0):
        raise Exception('negative Composition or T/P  founded')
    X, W, Y ,var = np.array_split(sol, 4)
    
    if full_output:
        if spec == 'T':
            P = var
            T = T_P
        elif spec == 'P':
            T = var
            P = T_P
        inc = {'T' : T, 'P': P, 'error':error, 'nfev':nfev,
        'X' : X, 'vx':vx, 'statex' : 'Liquid',
        'W' : W, 'vw':vw, 'statew' : 'Liquid',
       'Y' : Y, 'vy': vy, 'statey' : 'Vapor'}
        out = EquilibriumResult(inc)
        return out 
        
    return X, W, Y , var
    
    