from flags import Flags


class CHANNELMASK(Flags):
    FRONT_LEFT = 0x00000001
    FRONT_RIGHT = 0x00000002
    FRONT_CENTER = 0x00000004
    LOW_FREQUENCY = 0x00000008
    SURROUND_LEFT = 0x00000010
    SURROUND_RIGHT = 0x00000020
    BACK_LEFT = 0x00000040
    BACK_RIGHT = 0x00000080
    BACK_CENTER = 0x00000100
    MONO = FRONT_LEFT
    STEREO = FRONT_LEFT | FRONT_RIGHT
    LRC = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER
    QUAD = FRONT_LEFT | FRONT_RIGHT | SURROUND_LEFT | SURROUND_RIGHT
    SURROUND = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | SURROUND_LEFT | SURROUND_RIGHT
    FIVEPOINTONE = (
        FRONT_LEFT
        | FRONT_RIGHT
        | FRONT_CENTER
        | LOW_FREQUENCY
        | SURROUND_LEFT
        | SURROUND_RIGHT
    )
    FIVEPOINTONE_REARS = (
        FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | LOW_FREQUENCY | BACK_LEFT | BACK_RIGHT
    )
    SEVENPOINTZERO = (
        FRONT_LEFT
        | FRONT_RIGHT
        | FRONT_CENTER
        | SURROUND_LEFT
        | SURROUND_RIGHT
        | BACK_LEFT
        | BACK_RIGHT
    )
    SEVENPOINTONE = (
        FRONT_LEFT
        | FRONT_RIGHT
        | FRONT_CENTER
        | LOW_FREQUENCY
        | SURROUND_LEFT
        | SURROUND_RIGHT
        | BACK_LEFT
        | BACK_RIGHT
    )


class DEBUG_FLAGS(Flags):
    __no_flags_name__ = "LEVEL_NONE"
    LEVEL_ERROR = 0x00000001
    LEVEL_WARNING = 0x00000002
    LEVEL_LOG = 0x00000004
    TYPE_MEMORY = 0x00000100
    TYPE_FILE = 0x00000200
    TYPE_CODEC = 0x00000400
    TYPE_TRACE = 0x00000800
    DISPLAY_TIMESTAMPS = 0x00010000
    DISPLAY_LINENUMBERS = 0x00020000
    DISPLAY_THREAD = 0x00040000


class DRIVER_STATE(Flags):
    CONNECTED = 0x00000001
    DEFAULT = 0x00000002


class INIT_FLAGS(Flags):
    __no_flags_name__ = "NORMAL"
    STREAM_FROM_UPDATE = 0x00000001
    MIX_FROM_UPDATE = 0x00000002
    THREED_RIGHTHANDED = 0x00000004
    CHANNEL_LOWPASS = 0x00000100
    CHANNEL_DISTANCEFILTER = 0x00000200
    PROFILE_ENABLE = 0x00010000
    VOL0_BECOMES_VIRTUAL = 0x00020000
    GEOMETRY_USECLOSEST = 0x00040000
    PREFER_DOLBY_DOWNMIX = 0x00080000
    THREAD_UNSAFE = 0x00100000
    PROFILE_METER_ALL = 0x00200000


class MEMORY_TYPE(Flags):
    __no_flags_name__ = "NORMAL"
    STREAM_FILE = 0x00000001
    STREAM_DECODE = 0x00000002
    SAMPLEDATA = 0x00000004
    DSP_BUFFER = 0x00000008
    PLUGIN = 0x00000010
    XBOX360_PHYSICAL = 0x00100000
    PERSISTENT = 0x00200000
    SECONDARY = 0x00400000
    ALL = 0xFFFFFFFF


class MODE(Flags):
    __no_flags_name__ = "DEFAULT"
    LOOP_OFF = 0x00000001
    LOOP_NORMAL = 0x00000002
    LOOP_BIDI = 0x00000004
    TWOD = 0x00000008
    THREED = 0x00000010
    CREATESTREAM = 0x00000080
    CREATESAMPLE = 0x00000100
    CREATECOMPRESSEDSAMPLE = 0x00000200
    OPENUSER = 0x00000400
    OPENMEMORY = 0x00000800
    OPENMEMORY_POINT = 0x10000000
    OPENRAW = 0x00001000
    OPENONLY = 0x00002000
    ACCURATETIME = 0x00004000
    MPEGSEARCH = 0x00008000
    NONBLOCKING = 0x00010000
    UNIQUE = 0x00020000
    THREED_HEADRELATIVE = 0x00040000
    THREED_WORLDRELATIVE = 0x00080000
    THREED_INVERSEROLLOFF = 0x00100000
    THREED_LINEARROLLOFF = 0x00200000
    THREED_LINEARSQUAREROLLOFF = 0x00400000
    THREED_INVERSETAPEREDROLLOFF = 0x00800000
    THREED_CUSTOMROLLOFF = 0x04000000
    THREED_IGNOREGEOMETRY = 0x40000000
    IGNORETAGS = 0x02000000
    LOWMEM = 0x08000000
    LOADSECONDARYRAM = 0x20000000
    VIRTUAL_PLAYFROMSTART = 0x80000000


class SYSTEM_CALLBACK_TYPE(Flags):
    DEVICELISTCHANGED = 0x00000001
    DEVICELOST = 0x00000002
    MEMORYALLOCATIONFAILED = 0x00000004
    THREADCREATED = 0x00000008
    BADDSPCONNECTION = 0x00000010
    PREMIX = 0x00000020
    POSTMIX = 0x00000040
    ERROR = 0x00000080
    MIDMIX = 0x00000100
    THREADDESTROYED = 0x00000200
    PREUPDATE = 0x00000400
    POSTUPDATE = 0x00000800
    RECORDLISTCHANGED = 0x00001000
    ALL = 0xFFFFFFFF


class TIMEUNIT(Flags):
    MS = 0x00000001
    PCM = 0x00000002
    PCMBYTES = 0x00000004
    RAWBYTES = 0x00000008
    PCMFRACTION = 0x00000010
    MODORDER = 0x00000100
    MODROW = 0x00000200
    MODPATTERN = 0x00000400
    BUFFERED = 0x10000000
