"""Mloq lint command implementation."""
from pathlib import Path

import click
from omegaconf import DictConfig

from mloq.command import Command
from mloq.config.param_patch import param
from mloq.files import ASSETS_PATH, file, pyproject_toml


lint_req = file(
    "requirements-lint.txt",
    ASSETS_PATH / "lint",
    "list of exact versions of the packages used to check your code style",
    is_static=True,
)
LINT_FILES = [pyproject_toml, lint_req]


class LintCMD(Command):
    """Implement the functionality of the lint Command."""

    cmd_name = "lint"
    files = tuple(LINT_FILES)
    disable = param.Boolean(default=None, doc="Disable lint command?")
    docstring_checks = param.Boolean(True, doc="Apply docstring checks?")
    pyproject_extra = param.String("", doc="Additional pyproject.toml configuration")
    project_name = param.String("${globals.project_name}", doc="Select project name")
    makefile = param.Boolean(True, doc="Add check and style commands to makefile")
    poetry_requirements = param.Boolean(True, doc="Add check and style commands to makefile")
    ignore_files = param.ListSelector(
        default=[],
        doc="Ignore the following files",
        objects=[f.dst for f in LINT_FILES],
    )

    def interactive_config(self) -> DictConfig:
        """Generate the configuration of the project interactively."""
        click.echo("Provide the values to generate the packaging files.")
        return self.parse_config()

    def record_files(self) -> None:
        """Register the files that will be generated by mloq."""
        for _file in self.files:
            if _file.dst not in self.record.config.lint.ignore_files:
                self.record.register_file(file=_file, path=Path())
