var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// node_modules/aws-embedded-metrics/lib/Constants.js
var require_Constants = __commonJS({
  "node_modules/aws-embedded-metrics/lib/Constants.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Constants;
    (function(Constants2) {
      Constants2[Constants2["MAX_DIMENSIONS"] = 9] = "MAX_DIMENSIONS";
      Constants2["DEFAULT_NAMESPACE"] = "aws-embedded-metrics";
      Constants2[Constants2["MAX_METRICS_PER_EVENT"] = 100] = "MAX_METRICS_PER_EVENT";
      Constants2["DEFAULT_AGENT_HOST"] = "0.0.0.0";
      Constants2[Constants2["DEFAULT_AGENT_PORT"] = 25888] = "DEFAULT_AGENT_PORT";
    })(Constants = exports.Constants || (exports.Constants = {}));
  }
});

// node_modules/aws-embedded-metrics/lib/environment/Environments.js
var require_Environments = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/Environments.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Environments;
    (function(Environments2) {
      Environments2["Local"] = "Local";
      Environments2["Lambda"] = "Lambda";
      Environments2["Agent"] = "Agent";
      Environments2["EC2"] = "EC2";
      Environments2["ECS"] = "ECS";
      Environments2["Unknown"] = "";
    })(Environments || (Environments = {}));
    exports.default = Environments;
  }
});

// node_modules/aws-embedded-metrics/lib/config/EnvironmentConfigurationProvider.js
var require_EnvironmentConfigurationProvider = __commonJS({
  "node_modules/aws-embedded-metrics/lib/config/EnvironmentConfigurationProvider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Constants_1 = require_Constants();
    var Environments_1 = require_Environments();
    var ENV_VAR_PREFIX = "AWS_EMF";
    var ConfigKeys;
    (function(ConfigKeys2) {
      ConfigKeys2["LOG_GROUP_NAME"] = "LOG_GROUP_NAME";
      ConfigKeys2["LOG_STREAM_NAME"] = "LOG_STREAM_NAME";
      ConfigKeys2["ENABLE_DEBUG_LOGGING"] = "ENABLE_DEBUG_LOGGING";
      ConfigKeys2["SERVICE_NAME"] = "SERVICE_NAME";
      ConfigKeys2["SERVICE_TYPE"] = "SERVICE_TYPE";
      ConfigKeys2["AGENT_ENDPOINT"] = "AGENT_ENDPOINT";
      ConfigKeys2["ENVIRONMENT_OVERRIDE"] = "ENVIRONMENT";
      ConfigKeys2["NAMESPACE"] = "NAMESPACE";
    })(ConfigKeys || (ConfigKeys = {}));
    var EnvironmentConfigurationProvider = class {
      getConfiguration() {
        return {
          agentEndpoint: this.getEnvVariable(ConfigKeys.AGENT_ENDPOINT),
          debuggingLoggingEnabled: this.tryGetEnvVariableAsBoolean(ConfigKeys.ENABLE_DEBUG_LOGGING, false),
          logGroupName: this.getEnvVariable(ConfigKeys.LOG_GROUP_NAME),
          logStreamName: this.getEnvVariable(ConfigKeys.LOG_STREAM_NAME),
          serviceName: this.getEnvVariable(ConfigKeys.SERVICE_NAME) || this.getEnvVariableWithoutPrefix(ConfigKeys.SERVICE_NAME),
          serviceType: this.getEnvVariable(ConfigKeys.SERVICE_TYPE) || this.getEnvVariableWithoutPrefix(ConfigKeys.SERVICE_TYPE),
          environmentOverride: this.getEnvironmentOverride(),
          namespace: this.getEnvVariable(ConfigKeys.NAMESPACE) || Constants_1.Constants.DEFAULT_NAMESPACE
        };
      }
      getEnvVariableWithoutPrefix(configKey) {
        return process.env[configKey];
      }
      getEnvVariable(configKey) {
        return process.env[`${ENV_VAR_PREFIX}_${configKey}`];
      }
      tryGetEnvVariableAsBoolean(configKey, fallback) {
        const configValue = this.getEnvVariable(configKey);
        return !configValue ? fallback : configValue.toLowerCase() === "true";
      }
      getEnvironmentOverride() {
        const overrideValue = this.getEnvVariable(ConfigKeys.ENVIRONMENT_OVERRIDE);
        const environment = Environments_1.default[overrideValue];
        if (environment === void 0) {
          return Environments_1.default.Unknown;
        }
        return environment;
      }
    };
    exports.EnvironmentConfigurationProvider = EnvironmentConfigurationProvider;
  }
});

// node_modules/aws-embedded-metrics/lib/config/Configuration.js
var require_Configuration = __commonJS({
  "node_modules/aws-embedded-metrics/lib/config/Configuration.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var EnvironmentConfigurationProvider_1 = require_EnvironmentConfigurationProvider();
    var Configuration = new EnvironmentConfigurationProvider_1.EnvironmentConfigurationProvider().getConfiguration();
    exports.default = Configuration;
  }
});

// node_modules/aws-embedded-metrics/lib/utils/Logger.js
var require_Logger = __commonJS({
  "node_modules/aws-embedded-metrics/lib/utils/Logger.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var LOG = (...args) => {
      if (Configuration_1.default.debuggingLoggingEnabled) {
        console.log(...args);
      }
    };
    exports.LOG = LOG;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricValues.js
var require_MetricValues = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricValues.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MetricValues = class {
      constructor(value, unit) {
        this.values = [value];
        this.unit = unit || "None";
      }
      addValue(value) {
        this.values.push(value);
      }
    };
    exports.MetricValues = MetricValues;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricsContext.js
var require_MetricsContext = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricsContext.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var Logger_1 = require_Logger();
    var MetricValues_1 = require_MetricValues();
    var MetricsContext = class {
      constructor(namespace, properties, dimensions, defaultDimensions, shouldUseDefaultDimensions, timestamp) {
        this.metrics = new Map();
        this.meta = {};
        this.shouldUseDefaultDimensions = true;
        this.namespace = namespace || Configuration_1.default.namespace;
        this.properties = properties || {};
        this.dimensions = dimensions || [];
        this.timestamp = timestamp;
        this.meta.Timestamp = MetricsContext.resolveMetaTimestamp(timestamp);
        this.defaultDimensions = defaultDimensions || {};
        if (shouldUseDefaultDimensions != void 0) {
          this.shouldUseDefaultDimensions = shouldUseDefaultDimensions;
        }
      }
      static empty() {
        return new MetricsContext();
      }
      static resolveMetaTimestamp(timestamp) {
        if (timestamp instanceof Date) {
          return timestamp.getTime();
        } else if (timestamp) {
          return timestamp;
        } else {
          return Date.now();
        }
      }
      setNamespace(value) {
        this.namespace = value;
      }
      setProperty(key, value) {
        this.properties[key] = value;
      }
      setTimestamp(timestamp) {
        this.timestamp = timestamp;
        this.meta.Timestamp = MetricsContext.resolveMetaTimestamp(timestamp);
      }
      setDefaultDimensions(dimensions) {
        Logger_1.LOG(`Received default dimensions`, dimensions);
        this.defaultDimensions = dimensions;
      }
      putDimensions(incomingDimensionSet) {
        if (this.dimensions.length === 0) {
          this.dimensions.push(incomingDimensionSet);
          return;
        }
        for (let i = 0; i < this.dimensions.length; i++) {
          const existingDimensionSet = this.dimensions[i];
          const existingDimensionSetKeys = Object.keys(existingDimensionSet);
          const incomingDimensionSetKeys = Object.keys(incomingDimensionSet);
          if (existingDimensionSetKeys.length !== incomingDimensionSetKeys.length) {
            this.dimensions.push(incomingDimensionSet);
            return;
          }
          for (let j = 0; j < existingDimensionSetKeys.length; j++) {
            if (!incomingDimensionSetKeys.includes(existingDimensionSetKeys[j])) {
              this.dimensions.push(incomingDimensionSet);
              return;
            }
          }
        }
      }
      setDimensions(dimensionSets) {
        this.shouldUseDefaultDimensions = false;
        this.dimensions = dimensionSets;
      }
      getDimensions() {
        if (this.shouldUseDefaultDimensions === false) {
          return this.dimensions;
        }
        if (Object.keys(this.defaultDimensions).length === 0) {
          return this.dimensions;
        }
        if (this.dimensions.length === 0) {
          return [this.defaultDimensions];
        }
        return this.dimensions.map((custom) => {
          return Object.assign(Object.assign({}, this.defaultDimensions), custom);
        });
      }
      putMetric(key, value, unit) {
        const currentMetric = this.metrics.get(key);
        if (currentMetric) {
          currentMetric.addValue(value);
        } else {
          this.metrics.set(key, new MetricValues_1.MetricValues(value, unit));
        }
      }
      createCopyWithContext() {
        return new MetricsContext(this.namespace, Object.assign({}, this.properties), Object.assign([], this.dimensions), this.defaultDimensions, this.shouldUseDefaultDimensions, this.timestamp);
      }
    };
    exports.MetricsContext = MetricsContext;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricsLogger.js
var require_MetricsLogger = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricsLogger.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var MetricsContext_1 = require_MetricsContext();
    var MetricsLogger = class {
      constructor(resolveEnvironment, context) {
        this.configureContextForEnvironment = (context2, environment) => {
          const defaultDimensions = {
            LogGroup: environment.getLogGroupName(),
            ServiceName: Configuration_1.default.serviceName || environment.getName(),
            ServiceType: Configuration_1.default.serviceType || environment.getType()
          };
          context2.setDefaultDimensions(defaultDimensions);
          environment.configureContext(context2);
        };
        this.resolveEnvironment = resolveEnvironment;
        this.context = context || MetricsContext_1.MetricsContext.empty();
      }
      flush() {
        return __awaiter(this, void 0, void 0, function* () {
          const environment = yield this.resolveEnvironment();
          this.configureContextForEnvironment(this.context, environment);
          const sink = environment.getSink();
          yield sink.accept(this.context);
          this.context = this.context.createCopyWithContext();
        });
      }
      setProperty(key, value) {
        this.context.setProperty(key, value);
        return this;
      }
      putDimensions(dimensions) {
        this.context.putDimensions(dimensions);
        return this;
      }
      setDimensions(...dimensionSets) {
        this.context.setDimensions(dimensionSets);
        return this;
      }
      putMetric(key, value, unit) {
        this.context.putMetric(key, value, unit);
        return this;
      }
      setNamespace(value) {
        this.context.setNamespace(value);
        return this;
      }
      setTimestamp(timestamp) {
        this.context.setTimestamp(timestamp);
        return this;
      }
      new() {
        return new MetricsLogger(this.resolveEnvironment, this.context.createCopyWithContext());
      }
    };
    exports.MetricsLogger = MetricsLogger;
  }
});

// node_modules/aws-embedded-metrics/lib/serializers/LogSerializer.js
var require_LogSerializer = __commonJS({
  "node_modules/aws-embedded-metrics/lib/serializers/LogSerializer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Constants_1 = require_Constants();
    var LogSerializer = class {
      serialize(context) {
        const dimensionKeys = [];
        let dimensionProperties = {};
        context.getDimensions().forEach((d) => {
          const keys = Object.keys(d).slice(0, Constants_1.Constants.MAX_DIMENSIONS);
          dimensionKeys.push(keys);
          dimensionProperties = Object.assign(Object.assign({}, dimensionProperties), d);
        });
        const createBody = () => {
          return Object.assign(Object.assign(Object.assign({}, dimensionProperties), context.properties), { _aws: Object.assign(Object.assign({}, context.meta), { CloudWatchMetrics: [
            {
              Dimensions: dimensionKeys,
              Metrics: [],
              Namespace: context.namespace
            }
          ] }) });
        };
        const eventBatches = [];
        let currentBody = createBody();
        const currentMetricsInBody = () => currentBody._aws.CloudWatchMetrics[0].Metrics.length;
        const shouldSerialize = () => currentMetricsInBody() === Constants_1.Constants.MAX_METRICS_PER_EVENT;
        const serializeCurrentBody = () => {
          eventBatches.push(JSON.stringify(currentBody));
          currentBody = createBody();
        };
        for (const [key, metric] of context.metrics) {
          const metricValue = metric.values.length === 1 ? metric.values[0] : metric.values;
          currentBody[key] = metricValue;
          currentBody._aws.CloudWatchMetrics[0].Metrics.push({ Name: key, Unit: metric.unit });
          if (shouldSerialize()) {
            serializeCurrentBody();
          }
        }
        if (eventBatches.length === 0 || currentMetricsInBody() > 0) {
          serializeCurrentBody();
        }
        return eventBatches;
      }
    };
    exports.LogSerializer = LogSerializer;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/ConsoleSink.js
var require_ConsoleSink = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/ConsoleSink.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var LogSerializer_1 = require_LogSerializer();
    var ConsoleSink = class {
      constructor(serializer) {
        this.name = "ConsoleSink";
        this.serializer = serializer || new LogSerializer_1.LogSerializer();
      }
      accept(context) {
        const events = this.serializer.serialize(context);
        events.forEach((event) => console.log(event));
        return Promise.resolve();
      }
    };
    exports.ConsoleSink = ConsoleSink;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/connections/TcpClient.js
var require_TcpClient = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/connections/TcpClient.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var net = require("net");
    var Logger_1 = require_Logger();
    var TcpClient = class {
      constructor(endpoint) {
        this.endpoint = endpoint;
        this.socket = new net.Socket({ allowHalfOpen: true, writable: false }).setEncoding("utf8").setKeepAlive(true).setTimeout(5e3).on("timeout", () => this.disconnect("idle timeout")).on("end", () => this.disconnect("end")).on("data", (data) => Logger_1.LOG("TcpClient received data.", data));
      }
      warmup() {
        return __awaiter(this, void 0, void 0, function* () {
          try {
            yield this.establishConnection();
          } catch (err) {
            Logger_1.LOG("Failed to connect", err);
          }
        });
      }
      sendMessage(message) {
        return __awaiter(this, void 0, void 0, function* () {
          yield this.waitForOpenConnection();
          yield new Promise((resolve, reject) => {
            const onSendError = (err) => {
              Logger_1.LOG("Failed to write", err);
              reject(err);
            };
            const wasFlushedToKernel = this.socket.write(message, (err) => {
              if (!err) {
                Logger_1.LOG("Write succeeded");
                resolve();
              } else {
                onSendError(err);
              }
            });
            if (!wasFlushedToKernel) {
              Logger_1.LOG("TcpClient data was not flushed to kernel buffer and was queued in memory.");
            }
          });
        });
      }
      disconnect(eventName) {
        Logger_1.LOG("TcpClient disconnected due to:", eventName);
        this.socket.removeAllListeners();
        this.socket.destroy();
        this.socket.unref();
      }
      waitForOpenConnection() {
        return __awaiter(this, void 0, void 0, function* () {
          if (!this.socket.writeable || this.socket.readyState !== "open") {
            yield this.establishConnection();
          }
        });
      }
      establishConnection() {
        return __awaiter(this, void 0, void 0, function* () {
          yield new Promise((resolve, reject) => {
            const onError = (e) => {
              if (e.message.includes("EISCONN")) {
                resolve();
                return;
              }
              Logger_1.LOG("TCP Client received error", e);
              this.disconnect(e.message);
              reject(e);
            };
            const onConnect = () => {
              this.socket.removeListener("error", onError);
              Logger_1.LOG("TcpClient connected.", this.endpoint);
              resolve();
            };
            switch (this.socket.readyState) {
              case "open":
                resolve();
                break;
              case "opening":
                this.socket.once("connect", onConnect);
                this.socket.once("error", onError);
                break;
              default:
                Logger_1.LOG("opening connection with socket in state: ", this.socket.readyState);
                this.socket.connect(this.endpoint.port, this.endpoint.host, onConnect).once("error", onError);
                break;
            }
          });
        });
      }
    };
    exports.TcpClient = TcpClient;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/connections/UdpClient.js
var require_UdpClient = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/connections/UdpClient.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var dgram = require("dgram");
    var Logger_1 = require_Logger();
    var UdpClient = class {
      constructor(endpoint) {
        this.endpoint = endpoint;
      }
      warmup() {
        return Promise.resolve();
      }
      sendMessage(message) {
        return __awaiter(this, void 0, void 0, function* () {
          const client = dgram.createSocket("udp4");
          client.send(message, this.endpoint.port, this.endpoint.host, (error) => {
            if (error) {
              Logger_1.LOG(error);
            }
            client.close();
          });
          return Promise.resolve();
        });
      }
    };
    exports.UdpClient = UdpClient;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/AgentSink.js
var require_AgentSink = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/AgentSink.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var url = require("url");
    var Configuration_1 = require_Configuration();
    var LogSerializer_1 = require_LogSerializer();
    var Logger_1 = require_Logger();
    var TcpClient_1 = require_TcpClient();
    var UdpClient_1 = require_UdpClient();
    var TCP = "tcp:";
    var UDP = "udp:";
    var defaultTcpEndpoint = {
      host: "0.0.0.0",
      port: 25888,
      protocol: TCP
    };
    var parseEndpoint = (endpoint) => {
      try {
        if (!endpoint) {
          return defaultTcpEndpoint;
        }
        const parsedUrl = url.parse(endpoint);
        if (!parsedUrl.hostname || !parsedUrl.port || !parsedUrl.protocol) {
          Logger_1.LOG(`Failed to parse the provided agent endpoint. Falling back to the default TCP endpoint.`, parsedUrl);
          return defaultTcpEndpoint;
        }
        if (parsedUrl.protocol !== TCP && parsedUrl.protocol !== UDP) {
          Logger_1.LOG(`The provided agent endpoint protocol '${parsedUrl.protocol}' is not supported. Please use TCP or UDP. Falling back to the default TCP endpoint.`, parsedUrl);
          return defaultTcpEndpoint;
        }
        return {
          host: parsedUrl.hostname,
          port: Number(parsedUrl.port),
          protocol: parsedUrl.protocol
        };
      } catch (e) {
        Logger_1.LOG("Failed to parse the provided agent endpoint", e);
        return defaultTcpEndpoint;
      }
    };
    var AgentSink = class {
      constructor(logGroupName, logStreamName, serializer) {
        this.name = "AgentSink";
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.serializer = serializer || new LogSerializer_1.LogSerializer();
        this.endpoint = parseEndpoint(Configuration_1.default.agentEndpoint);
        this.socketClient = this.getSocketClient(this.endpoint);
        Logger_1.LOG("Using socket client", this.socketClient.constructor.name);
      }
      accept(context) {
        return __awaiter(this, void 0, void 0, function* () {
          if (this.logGroupName) {
            context.meta.LogGroupName = this.logGroupName;
          }
          if (this.logStreamName) {
            context.meta.LogStreamName = this.logStreamName;
          }
          const events = this.serializer.serialize(context);
          Logger_1.LOG(`Sending {} events to socket.`, events.length);
          for (let index = 0; index < events.length; index++) {
            const event = events[index];
            const message = event + "\n";
            const bytes = Buffer.from(message);
            yield this.socketClient.sendMessage(bytes);
          }
        });
      }
      getSocketClient(endpoint) {
        Logger_1.LOG("Getting socket client for connection.", endpoint);
        const client = endpoint.protocol === TCP ? new TcpClient_1.TcpClient(endpoint) : new UdpClient_1.UdpClient(endpoint);
        client.warmup();
        return client;
      }
    };
    exports.AgentSink = AgentSink;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/DefaultEnvironment.js
var require_DefaultEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/DefaultEnvironment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var AgentSink_1 = require_AgentSink();
    var Logger_1 = require_Logger();
    var DefaultEnvironment = class {
      probe() {
        return Promise.resolve(true);
      }
      getName() {
        if (!Configuration_1.default.serviceName) {
          Logger_1.LOG("Unknown ServiceName.");
          return "Unknown";
        }
        return Configuration_1.default.serviceName;
      }
      getType() {
        if (!Configuration_1.default.serviceType) {
          Logger_1.LOG("Unknown ServiceType.");
          return "Unknown";
        }
        return Configuration_1.default.serviceType;
      }
      getLogGroupName() {
        if (Configuration_1.default.logGroupName === "") {
          return "";
        }
        return Configuration_1.default.logGroupName ? Configuration_1.default.logGroupName : `${this.getName()}-metrics`;
      }
      configureContext() {
      }
      getSink() {
        if (!this.sink) {
          this.sink = new AgentSink_1.AgentSink(this.getLogGroupName(), Configuration_1.default.logStreamName);
        }
        return this.sink;
      }
    };
    exports.DefaultEnvironment = DefaultEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/utils/Fetch.js
var require_Fetch = __commonJS({
  "node_modules/aws-embedded-metrics/lib/utils/Fetch.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var http = require("http");
    var SOCKET_TIMEOUT = 1e3;
    var fetch = (url) => {
      return new Promise((resolve, reject) => {
        const request = http.get(url, { timeout: 2e3 }, (response) => {
          if (!response.statusCode) {
            reject(`Received undefined response status code from '${url}'`);
            return;
          }
          if (response.statusCode < 200 || response.statusCode > 299) {
            reject(new Error("Failed to load page, status code: " + response.statusCode));
            return;
          }
          const body = [];
          let bodyBytes = 0;
          response.on("data", (chunk) => {
            bodyBytes += chunk.length;
            body.push(chunk);
          });
          response.on("end", () => {
            let responseString;
            try {
              const buffer = Buffer.concat(body, bodyBytes);
              responseString = buffer.toString();
              const parsedJson = JSON.parse(responseString);
              resolve(parsedJson);
            } catch (e) {
              reject(`Failed to parse response from '${url}' as JSON. Received: ${responseString}`);
            }
          });
        }).on("error", (err) => {
          reject(err);
        });
        request.on("socket", (socket) => {
          socket.on("timeout", () => {
            request.abort();
            reject(`Socket timeout while connecting to '${url}'`);
          });
          socket.setTimeout(SOCKET_TIMEOUT);
        });
      });
    };
    exports.fetch = fetch;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/ECSEnvironment.js
var require_ECSEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/ECSEnvironment.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var AgentSink_1 = require_AgentSink();
    var Fetch_1 = require_Fetch();
    var Logger_1 = require_Logger();
    var os = require("os");
    var Constants_1 = require_Constants();
    var formatImageName = (imageName) => {
      if (imageName) {
        const splitImageName = imageName.split("/");
        return splitImageName[splitImageName.length - 1];
      }
      return imageName;
    };
    var ECSEnvironment = class {
      probe() {
        return __awaiter(this, void 0, void 0, function* () {
          if (!process.env.ECS_CONTAINER_METADATA_URI) {
            return Promise.resolve(false);
          }
          if (process.env.FLUENT_HOST && !Configuration_1.default.agentEndpoint) {
            this.fluentBitEndpoint = `tcp://${process.env.FLUENT_HOST}:${Constants_1.Constants.DEFAULT_AGENT_PORT}`;
            Configuration_1.default.agentEndpoint = this.fluentBitEndpoint;
            Logger_1.LOG(`Using FluentBit configuration. Endpoint: ${this.fluentBitEndpoint}`);
          }
          try {
            this.metadata = yield Fetch_1.fetch(process.env.ECS_CONTAINER_METADATA_URI);
            if (this.metadata) {
              this.metadata.FormattedImageName = formatImageName(this.metadata.Image);
              Logger_1.LOG(`Successfully collected ECS Container metadata.`);
            }
          } catch (e) {
            Logger_1.LOG("Failed to collect ECS Container Metadata.");
            Logger_1.LOG(e);
          }
          return true;
        });
      }
      getName() {
        var _a;
        if (Configuration_1.default.serviceName) {
          return Configuration_1.default.serviceName;
        }
        return ((_a = this.metadata) === null || _a === void 0 ? void 0 : _a.FormattedImageName) ? this.metadata.FormattedImageName : "Unknown";
      }
      getType() {
        return "AWS::ECS::Container";
      }
      getLogGroupName() {
        if (this.fluentBitEndpoint) {
          return "";
        }
        return Configuration_1.default.logGroupName || this.getName();
      }
      configureContext(context) {
        var _a, _b, _c, _d, _e;
        this.addProperty(context, "containerId", os.hostname());
        this.addProperty(context, "createdAt", (_a = this.metadata) === null || _a === void 0 ? void 0 : _a.CreatedAt);
        this.addProperty(context, "startedAt", (_b = this.metadata) === null || _b === void 0 ? void 0 : _b.StartedAt);
        this.addProperty(context, "image", (_c = this.metadata) === null || _c === void 0 ? void 0 : _c.Image);
        this.addProperty(context, "cluster", (_d = this.metadata) === null || _d === void 0 ? void 0 : _d.Labels["com.amazonaws.ecs.cluster"]);
        this.addProperty(context, "taskArn", (_e = this.metadata) === null || _e === void 0 ? void 0 : _e.Labels["com.amazonaws.ecs.task-arn"]);
        if (this.fluentBitEndpoint) {
          context.setDefaultDimensions({
            ServiceName: Configuration_1.default.serviceName || this.getName(),
            ServiceType: Configuration_1.default.serviceType || this.getType()
          });
        }
      }
      getSink() {
        if (!this.sink) {
          const logGroupName = this.fluentBitEndpoint ? "" : this.getLogGroupName();
          this.sink = new AgentSink_1.AgentSink(logGroupName);
        }
        return this.sink;
      }
      addProperty(context, key, value) {
        if (value) {
          context.setProperty(key, value);
        }
      }
    };
    exports.ECSEnvironment = ECSEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/EC2Environment.js
var require_EC2Environment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/EC2Environment.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var AgentSink_1 = require_AgentSink();
    var Fetch_1 = require_Fetch();
    var Logger_1 = require_Logger();
    var endpoint = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    var EC2Environment = class {
      probe() {
        return __awaiter(this, void 0, void 0, function* () {
          try {
            this.metadata = yield Fetch_1.fetch(endpoint);
            if (this.metadata) {
              return true;
            }
            return false;
          } catch (e) {
            Logger_1.LOG(e);
            return false;
          }
        });
      }
      getName() {
        if (!Configuration_1.default.serviceName) {
          Logger_1.LOG("Unknown ServiceName.");
          return "Unknown";
        }
        return Configuration_1.default.serviceName;
      }
      getType() {
        if (this.metadata) {
          return "AWS::EC2::Instance";
        }
        return "Unknown";
      }
      getLogGroupName() {
        return Configuration_1.default.logGroupName ? Configuration_1.default.logGroupName : `${this.getName()}-metrics`;
      }
      configureContext(context) {
        if (this.metadata) {
          context.setProperty("imageId", this.metadata.imageId);
          context.setProperty("instanceId", this.metadata.instanceId);
          context.setProperty("instanceType", this.metadata.instanceType);
          context.setProperty("privateIP", this.metadata.privateIp);
          context.setProperty("availabilityZone", this.metadata.availabilityZone);
        }
      }
      getSink() {
        if (!this.sink) {
          this.sink = new AgentSink_1.AgentSink(this.getLogGroupName(), Configuration_1.default.logStreamName);
        }
        return this.sink;
      }
    };
    exports.EC2Environment = EC2Environment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/LambdaEnvironment.js
var require_LambdaEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/LambdaEnvironment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ConsoleSink_1 = require_ConsoleSink();
    var LambdaEnvironment = class {
      probe() {
        return Promise.resolve(process.env.AWS_LAMBDA_FUNCTION_NAME ? true : false);
      }
      getName() {
        return process.env.AWS_LAMBDA_FUNCTION_NAME || "Unknown";
      }
      getType() {
        return "AWS::Lambda::Function";
      }
      getLogGroupName() {
        return this.getName();
      }
      configureContext(context) {
        this.addProperty(context, "executionEnvironment", process.env.AWS_EXECUTION_ENV);
        this.addProperty(context, "memorySize", process.env.AWS_LAMBDA_FUNCTION_MEMORY_SIZE);
        this.addProperty(context, "functionVersion", process.env.AWS_LAMBDA_FUNCTION_VERSION);
        this.addProperty(context, "logStreamId", process.env.AWS_LAMBDA_LOG_STREAM_NAME);
        const trace = this.getSampledTrace();
        if (trace) {
          this.addProperty(context, "traceId", trace);
        }
      }
      getSink() {
        if (!this.sink) {
          this.sink = new ConsoleSink_1.ConsoleSink();
        }
        return this.sink;
      }
      addProperty(context, key, value) {
        if (value) {
          context.setProperty(key, value);
        }
      }
      getSampledTrace() {
        if (process.env._X_AMZN_TRACE_ID && process.env._X_AMZN_TRACE_ID.includes("Sampled=1")) {
          return process.env._X_AMZN_TRACE_ID;
        }
      }
    };
    exports.LambdaEnvironment = LambdaEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/LocalEnvironment.js
var require_LocalEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/LocalEnvironment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var Logger_1 = require_Logger();
    var ConsoleSink_1 = require_ConsoleSink();
    var LocalEnvironment = class {
      probe() {
        return Promise.resolve(false);
      }
      getName() {
        if (!Configuration_1.default.serviceName) {
          Logger_1.LOG("Unknown ServiceName.");
          return "Unknown";
        }
        return Configuration_1.default.serviceName;
      }
      getType() {
        if (!Configuration_1.default.serviceType) {
          Logger_1.LOG("Unknown ServiceType.");
          return "Unknown";
        }
        return Configuration_1.default.serviceType;
      }
      getLogGroupName() {
        return Configuration_1.default.logGroupName ? Configuration_1.default.logGroupName : `${this.getName()}-metrics`;
      }
      configureContext() {
      }
      getSink() {
        if (!this.sink) {
          this.sink = new ConsoleSink_1.ConsoleSink();
        }
        return this.sink;
      }
    };
    exports.LocalEnvironment = LocalEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/EnvironmentDetector.js
var require_EnvironmentDetector = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/EnvironmentDetector.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Logger_1 = require_Logger();
    var DefaultEnvironment_1 = require_DefaultEnvironment();
    var ECSEnvironment_1 = require_ECSEnvironment();
    var EC2Environment_1 = require_EC2Environment();
    var LambdaEnvironment_1 = require_LambdaEnvironment();
    var Configuration_1 = require_Configuration();
    var Environments_1 = require_Environments();
    var LocalEnvironment_1 = require_LocalEnvironment();
    var lambdaEnvironment = new LambdaEnvironment_1.LambdaEnvironment();
    var ecsEnvironment = new ECSEnvironment_1.ECSEnvironment();
    var ec2Environment = new EC2Environment_1.EC2Environment();
    var defaultEnvironment = new DefaultEnvironment_1.DefaultEnvironment();
    var environments = [lambdaEnvironment, ecsEnvironment, ec2Environment];
    var environment = void 0;
    var getEnvironmentFromOverride = () => {
      switch (Configuration_1.default.environmentOverride) {
        case Environments_1.default.Agent:
          return defaultEnvironment;
        case Environments_1.default.EC2:
          return ec2Environment;
        case Environments_1.default.Lambda:
          return lambdaEnvironment;
        case Environments_1.default.ECS:
          return ecsEnvironment;
        case Environments_1.default.Local:
          return new LocalEnvironment_1.LocalEnvironment();
        case Environments_1.default.Unknown:
        default:
          return void 0;
      }
    };
    var discoverEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      Logger_1.LOG(`Discovering environment`);
      for (const envUnderTest of environments) {
        Logger_1.LOG(`Testing: ${envUnderTest.constructor.name}`);
        try {
          if (yield envUnderTest.probe()) {
            return envUnderTest;
          }
        } catch (e) {
          Logger_1.LOG(`Failed probe: ${envUnderTest.constructor.name}`);
        }
      }
      return defaultEnvironment;
    });
    var _resolveEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      Logger_1.LOG("Resolving environment");
      if (environment) {
        return environment;
      }
      if (Configuration_1.default.environmentOverride) {
        Logger_1.LOG("Environment override supplied", Configuration_1.default.environmentOverride);
        environment = getEnvironmentFromOverride();
        if (environment) {
          return environment;
        } else {
          Logger_1.LOG("Invalid environment provided. Falling back to auto-discovery.", Configuration_1.default.environmentOverride);
        }
      }
      environment = yield discoverEnvironment();
      return environment;
    });
    var environmentPromise = _resolveEnvironment();
    var resolveEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      return environmentPromise;
    });
    exports.resolveEnvironment = resolveEnvironment;
    var cleanResolveEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      yield environmentPromise;
      environment = void 0;
      return yield _resolveEnvironment();
    });
    exports.cleanResolveEnvironment = cleanResolveEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricsLoggerFactory.js
var require_MetricsLoggerFactory = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricsLoggerFactory.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var __1 = require_lib();
    var EnvironmentDetector_1 = require_EnvironmentDetector();
    var MetricsContext_1 = require_MetricsContext();
    var createMetricsLogger = () => {
      const context = MetricsContext_1.MetricsContext.empty();
      const logger = new __1.MetricsLogger(EnvironmentDetector_1.resolveEnvironment, context);
      return logger;
    };
    exports.createMetricsLogger = createMetricsLogger;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricScope.js
var require_MetricScope = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricScope.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Logger_1 = require_Logger();
    var MetricsLoggerFactory_1 = require_MetricsLoggerFactory();
    var metricScope2 = (handler2) => {
      const wrappedHandler = (...args) => __awaiter(void 0, void 0, void 0, function* () {
        const metrics = MetricsLoggerFactory_1.createMetricsLogger();
        try {
          return yield handler2(metrics)(...args);
        } finally {
          try {
            yield metrics.flush();
          } catch (e) {
            Logger_1.LOG("Failed to flush metrics", e);
          }
        }
      });
      return wrappedHandler;
    };
    exports.metricScope = metricScope2;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/Unit.js
var require_Unit = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/Unit.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Unit2;
    (function(Unit3) {
      Unit3["Seconds"] = "Seconds";
      Unit3["Microseconds"] = "Microseconds";
      Unit3["Milliseconds"] = "Milliseconds";
      Unit3["Bytes"] = "Bytes";
      Unit3["Kilobytes"] = "Kilobytes";
      Unit3["Megabytes"] = "Megabytes";
      Unit3["Gigabytes"] = "Gigabytes";
      Unit3["Terabytes"] = "Terabytes";
      Unit3["Bits"] = "Bits";
      Unit3["Kilobits"] = "Kilobits";
      Unit3["Megabits"] = "Megabits";
      Unit3["Gigabits"] = "Gigabits";
      Unit3["Terabits"] = "Terabits";
      Unit3["Percent"] = "Percent";
      Unit3["Count"] = "Count";
      Unit3["BytesPerSecond"] = "Bytes/Second";
      Unit3["KilobytesPerSecond"] = "Kilobytes/Second";
      Unit3["MegabytesPerSecond"] = "Megabytes/Second";
      Unit3["GigabytesPerSecond"] = "Gigabytes/Second";
      Unit3["TerabytesPerSecond"] = "Terabytes/Second";
      Unit3["BitsPerSecond"] = "Bits/Second";
      Unit3["KilobitsPerSecond"] = "Kilobits/Second";
      Unit3["MegabitsPerSecond"] = "Megabits/Second";
      Unit3["GigabitsPerSecond"] = "Gigabits/Second";
      Unit3["TerabitsPerSecond"] = "Terabits/Second";
      Unit3["CountPerSecond"] = "Count/Second";
      Unit3["None"] = "None";
    })(Unit2 = exports.Unit || (exports.Unit = {}));
  }
});

// node_modules/aws-embedded-metrics/lib/index.js
var require_lib = __commonJS({
  "node_modules/aws-embedded-metrics/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MetricsLogger_1 = require_MetricsLogger();
    exports.MetricsLogger = MetricsLogger_1.MetricsLogger;
    var ConsoleSink_1 = require_ConsoleSink();
    exports.LocalSink = ConsoleSink_1.ConsoleSink;
    var AgentSink_1 = require_AgentSink();
    exports.AgentSink = AgentSink_1.AgentSink;
    var MetricScope_1 = require_MetricScope();
    exports.metricScope = MetricScope_1.metricScope;
    var MetricsLoggerFactory_1 = require_MetricsLoggerFactory();
    exports.createMetricsLogger = MetricsLoggerFactory_1.createMetricsLogger;
    var Unit_1 = require_Unit();
    exports.Unit = Unit_1.Unit;
    var Configuration_1 = require_Configuration();
    exports.Configuration = Configuration_1.default;
  }
});

// src/monitored-certificate/certificate-monitor.lambda.ts
__export(exports, {
  handler: () => handler
});
var tls = __toModule(require("tls"));
var import_aws_embedded_metrics = __toModule(require_lib());

// src/backend/shared/env.lambda-shared.ts
var import_process = __toModule(require("process"));
function requireEnv(name) {
  const result = import_process.env[name];
  if (!result) {
    throw new Error(`No value specified for required environment variable: ${name}`);
  }
  return result;
}

// src/monitored-certificate/certificate-monitor.lambda.ts
var handler = (0, import_aws_embedded_metrics.metricScope)((metrics) => async (event, _context) => {
  console.log(`Event: ${JSON.stringify(event, null, 2)}`);
  const endpoint = requireEnv("HTTPS_ENDPOINT");
  const metricNamespace = requireEnv("METRIC_NAMESPACE");
  const metricName = requireEnv("METRIC_NAME");
  const now = new Date();
  const daysRemaining = await tlsValidDaysRemaining(endpoint, now);
  console.log(`The certificate has ${daysRemaining} remaining validity days`);
  metrics.setDimensions({ DomainName: endpoint });
  metrics.setNamespace(metricNamespace);
  metrics.putMetric(metricName, daysRemaining, import_aws_embedded_metrics.Unit.Count);
});
function tlsValidDaysRemaining(endpoint, now) {
  console.log(`Checking remaining validity time for certificate on ${endpoint}:443`);
  const sock = tls.connect({
    host: endpoint,
    port: 443,
    servername: endpoint
  });
  const closeThen = (cb) => sock.end(() => {
    sock.destroy();
    sock.unref();
    cb();
  });
  return new Promise((resolve, reject) => {
    const ok = (val) => closeThen(() => resolve(val));
    const ko = (reason) => closeThen(() => reject(reason));
    try {
      sock.once("error", (err) => err.code === "CERT_HAS_EXPIRED" ? ok(0) : ko(err));
      sock.once("secureConnect", () => {
        const cert = sock.getPeerCertificate();
        console.log(`Secure connection established: ${cert.fingerprint256} is valid from ${cert.valid_from} until ${cert.valid_to}`);
        const remainingMillis = new Date(cert.valid_to).getTime() - now.getTime();
        if (remainingMillis < 0) {
          console.error(`The certificate expired ${remainingMillis}ms ago!`);
          return ok(0);
        }
        ok(remainingMillis / 864e5);
      });
    } catch (e) {
      ko(e);
    }
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
