"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sqsQueueUrl = exports.stateMachineUrl = exports.s3ObjectUrl = exports.lambdaSearchLogGroupUrl = exports.lambdaFunctionUrl = void 0;
const core_1 = require("@aws-cdk/core");
function lambdaFunctionUrl(lambda) {
    return `/lambda/home#/functions/${lambda.functionName}`;
}
exports.lambdaFunctionUrl = lambdaFunctionUrl;
function lambdaSearchLogGroupUrl(lambda) {
    return `/cloudwatch/home#logsV2:log-groups/log-group/$252Faws$252flambda$252f${lambda.functionName}/log-events`;
}
exports.lambdaSearchLogGroupUrl = lambdaSearchLogGroupUrl;
function s3ObjectUrl(bucket, objectKey) {
    if (objectKey) {
        return `/s3/object/${bucket.bucketName}?prefix=${objectKey}`;
    }
    else {
        return `/s3/buckets/${bucket.bucketName}`;
    }
}
exports.s3ObjectUrl = s3ObjectUrl;
function stateMachineUrl(stateMachine) {
    return `/states/home#/statemachines/view/${stateMachine.stateMachineArn}`;
}
exports.stateMachineUrl = stateMachineUrl;
function sqsQueueUrl(queue) {
    const stack = core_1.Stack.of(queue);
    // We can't use the Queue URL as-is, because we can't "easily" URL-encode it in CFN...
    return `/sqs/v2/home#/queues/https%3A%2F%2Fsqs.${stack.region}.amazonaws.com%2F${stack.account}%2F${queue.queueName}`;
}
exports.sqsQueueUrl = sqsQueueUrl;
//# sourceMappingURL=data:application/json;base64,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