"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDenyListMap = void 0;
/**
 * Creates a map from a set of deny list rules and performs some verificatins.
 */
function createDenyListMap(rules) {
    const map = {};
    for (const entry of rules) {
        const versionSuffix = entry.version ? `/v${entry.version}` : '';
        const key = `${entry.package}${versionSuffix}`;
        if (key in map) {
            throw new Error(`Duplicate deny list entry: ${key}`);
        }
        map[key] = entry;
    }
    // iterate over all rules that match all versions and check that there
    // are no version-specific rules that are considered duplicates.
    for (const rule of rules.filter(x => !x.version)) {
        // if there are any keys in `map` that match this package name (with a version), report them as duplicates.
        const matches = Object.keys(map).filter(key => key.startsWith(rule.package + '/'));
        if (matches.length > 0) {
            throw new Error(`Found rules that match specific versions of "${rule.package}" (${matches.map(m => m.split('/v')[1]).join(',')}) but there is also a rule that matches all versions`);
        }
    }
    return map;
}
exports.createDenyListMap = createDenyListMap;
//# sourceMappingURL=data:application/json;base64,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