import * as certificatemanager from '@aws-cdk/aws-certificatemanager';
import { IAlarmAction } from '@aws-cdk/aws-cloudwatch';
import * as route53 from '@aws-cdk/aws-route53';
export * from './backend/deny-list/api';
/**
 * (experimental) Domain configuration for the website.
 *
 * @experimental
 */
export interface Domain {
    /**
     * (experimental) The root domain name where this instance of Construct Hub will be served.
     *
     * @experimental
     */
    readonly zone: route53.IHostedZone;
    /**
     * (experimental) The certificate to use for serving the Construct Hub over a custom domain.
     *
     * @default - a DNS-Validated certificate will be provisioned using the
     *   provided `hostedZone`.
     * @experimental
     */
    readonly cert: certificatemanager.ICertificate;
    /**
     * (experimental) Whether the certificate should be monitored for expiration, meaning high severity alarms will be raised if it is due to expire in less than 45 days.
     *
     * @default true
     * @experimental
     */
    readonly monitorCertificateExpiration?: boolean;
}
/**
 * (experimental) CloudWatch alarm actions to perform.
 *
 * @experimental
 */
export interface AlarmActions {
    /**
     * (experimental) The ARN of the CloudWatch alarm action to take for alarms of high-severity alarms.
     *
     * This must be an ARN that can be used with CloudWatch alarms.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-actions
     * @experimental
     */
    readonly highSeverity?: string;
    /**
     * (experimental) The CloudWatch alarm action to take for alarms of high-severity alarms.
     *
     * This must be an ARN that can be used with CloudWatch alarms.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-actions
     * @experimental
     */
    readonly highSeverityAction?: IAlarmAction;
    /**
     * (experimental) The ARN of the CloudWatch alarm action to take for alarms of normal severity.
     *
     * This must be an ARN that can be used with CloudWatch alarms.
     *
     * @default - no actions are taken in response to alarms of normal severity
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-actions
     * @experimental
     */
    readonly normalSeverity?: string;
    /**
     * (experimental) The CloudWatch alarm action to take for alarms of normal severity.
     *
     * This must be an ARN that can be used with CloudWatch alarms.
     *
     * @default - no actions are taken in response to alarms of normal severity
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-actions
     * @experimental
     */
    readonly normalSeverityAction?: IAlarmAction;
}
