"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const construct_hub_1 = require("../construct-hub");
const dummyAlarmAction = {
    highSeverity: 'arn:aws:sns:us-east-1:123456789012:mystack-mytopic-NZJ5JSMVGFIE',
};
test('minimal usage', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        alarmActions: dummyAlarmAction,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('with non-isolated lambdas', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        alarmActions: dummyAlarmAction,
        isolateLambdas: false,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('with domain', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    const zone = aws_route53_1.PublicHostedZone.fromHostedZoneAttributes(stack, 'Zone', {
        hostedZoneId: 'ZONEID',
        zoneName: 'my.construct.hub',
    });
    const cert = new aws_certificatemanager_1.DnsValidatedCertificate(stack, 'Cert', { hostedZone: zone, domainName: zone.zoneName });
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        domain: {
            zone, cert,
        },
        alarmActions: dummyAlarmAction,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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