"""
Variables used to generate the data in Macedo, et al. 2019.
"""

promoter_file_name = "hg19.cage_peak_phase1and2combined_tpm.osc.txt"
enhancer_file_name = "human_permissive_enhancers_phase_1_and_2_expression_tpm_matrix.txt"
enhancer_names_db = "Human.sample_name2library_id.txt"
sample_type_file = "sample types - FANTOM5.csv"
primary_cell_list = ["Adipocyte - breast", "Adipocyte - omental", "Adipocyte - perirenal",
                     "Adipocyte - subcutaneous", "Alveolar Epithelial Cells", "Amniotic Epithelial Cells",
                     "amniotic membrane cells", "Anulus Pulposus Cell", "Astrocyte - cerebellum",
                     "Astrocyte - cerebral cortex", "Basophils", "Bronchial Epithelial Cell",
                     "Cardiac Myocyte", "CD133+ stem cells - adult bone marrow derived",
                     "CD133+ stem cells - cord blood derived",
                     "CD14+ monocyte derived endothelial progenitor cells", "CD14+ Monocytes",
                     "CD14+ CD16- Monocytes", "CD14+ CD16+ Monocytes", "CD14- CD16+ Monocytes",
                     "CD19+ B Cells", "CD34 cells differentiated to erythrocyte lineage", "CD34+ Progenitors",
                     "CD34+ stem cells - adult bone marrow derived", "CD4+ T Cells",
                     "CD4+CD25+CD45RA- memory regulatory T cells", "CD4+CD25+CD45RA+ naive regulatory T cells",
                     "CD4+CD25-CD45RA- memory conventional T cells",
                     "CD4+CD25-CD45RA+ naive conventional T cells", "CD8+ T Cells", "Chondrocyte",
                     "chorionic membrane cells", "Ciliary Epithelial Cells", "common myeloid progenitor CMP",
                     "Corneal Epithelial Cells", "Dendritic Cells - monocyte immature derived",
                     "Dendritic Cells - plasmacytoid", "Endothelial Cells - Aortic",
                     "Endothelial Cells - Artery", "Endothelial Cells - Lymphatic",
                     "Endothelial Cells - Microvascular", "Endothelial Cells - Thoracic",
                     "Endothelial Cells - Umbilical vein", "Endothelial Cells - Vein", "Eosinophils",
                     "Esophageal Epithelial Cells", "Fibroblast - Aortic Adventitial", "Fibroblast - Cardiac",
                     "Fibroblast - Choroid Plexus", "Fibroblast - Conjunctival", "Fibroblast - Dermal",
                     "Fibroblast - Gingival", "Fibroblast - Lung", "Fibroblast - Lymphatic",
                     "Fibroblast - Mammary", "Fibroblast - Periodontal Ligament",
                     "Fibroblast - Pulmonary Artery", "Fibroblast - skin", "Fibroblast - Villous Mesenchymal",
                     "gamma delta positive T cells", "Gingival epithelial cells",
                     "granulocyte macrophage progenitor", "Hair Follicle Dermal Papilla Cells",
                     "Hair Follicle Outer Root Sheath Cells", "Hepatic Sinusoidal Endothelial Cells",
                     "Hepatic Stellate Cells (lipocyte)", "Hepatocyte", "immature langerhans cells",
                     "Intestinal epithelial cells (polarized)", "Iris Pigment Epithelial Cells",
                     "Keratinocyte - epidermal", "Keratinocyte - oral", "Keratocytes", "Lens Epithelial Cells",
                     "Macrophage - monocyte derived", "Mallassez-derived cells", "Mammary Epithelial Cell",
                     "Mast cell", "mature adipocyte", "Melanocyte", "Meningeal Cells",
                     "mesenchymal precursor cell - adipose", "mesenchymal precursor cell - bone marrow",
                     "mesenchymal precursor cell - cardiac", "Mesenchymal stem cells - adipose",
                     "Mesenchymal Stem Cells - amniotic membrane", "Mesenchymal Stem Cells - bone marrow",
                     "Mesenchymal stem cells - hepatic", "Mesenchymal stem cells - umbilical",
                     "Mesenchymal Stem Cells - Vertebral", "Mesenchymal Stem Cells - Wharton Jelly",
                     "Mesothelial Cells", "migratory langerhans cells",
                     "Multipotent Cord Blood Unrestricted Somatic Stem Cells", "Myoblast",
                     "nasal epithelial cells", "Natural Killer Cells", "Neural stem cells", "Neurons",
                     "Neutrophil", "Nucleus Pulposus Cell", "Olfactory epithelial cells",
                     "Oligodendrocyte - precursors", "Osteoblast", "Pancreatic stromal cells", "Pericytes",
                     "Perineurial Cells", "Placental Epithelial Cells",
                     "Preadipocyte - breast", "Preadipocyte - omental", "Preadipocyte - perirenal",
                     "Preadipocyte - subcutaneous", "Preadipocyte - visceral", "promyelocytes",
                     "Prostate Epithelial Cells", "Prostate Stromal Cells", "Renal Cortical Epithelial Cells",
                     "Renal Epithelial Cells", "Renal Glomerular Endothelial Cells", "Renal Mesangial Cells",
                     "Renal Proximal Tubular Epithelial Cell", "Retinal Pigment Epithelial Cells",
                     "salivary acinar cells", "Schwann Cells", "Sebocyte", "Sertoli Cells",
                     "Skeletal Muscle Cells", "Skeletal muscle cells differentiated into Myotubes",
                     "Skeletal Muscle Satellite Cells", "Small Airway Epithelial Cells",
                     "Smooth muscle cells - airway", "Smooth Muscle Cells - Aortic",
                     "Smooth Muscle Cells - Bladder", "Smooth Muscle Cells - Brachiocephalic",
                     "Smooth Muscle Cells - Brain Vascular", "Smooth Muscle Cells - Bronchial",
                     "Smooth Muscle Cells - Carotid", "Smooth Muscle Cells - Colonic",
                     "Smooth Muscle Cells - Coronary Artery", "Smooth Muscle Cells - Esophageal",
                     "Smooth Muscle Cells - Internal Thoracic Artery", "Smooth Muscle Cells - Intestinal",
                     "Smooth Muscle Cells - Prostate", "Smooth Muscle Cells - Pulmonary Artery",
                     "Smooth Muscle Cells - Subclavian Artery", "Smooth Muscle Cells - Tracheal",
                     "Smooth Muscle Cells - Umbilical artery", "Smooth Muscle Cells - Umbilical Vein",
                     "Smooth Muscle Cells - Uterine", "Synoviocyte", "tenocyte", "Trabecular Meshwork Cells",
                     "Tracheal Epithelial Cells", "Urothelial cells"]
primary_not_include_codes = {"Adipocyte - breast": "pre", "Adipocyte - omental": "pre",
                             "Adipocyte - perirenal": "pre", "Adipocyte - subcutaneous": "pre",
                             "Endothelial Cells - Vein": "Umbilical",
                             "Renal Epithelial Cells": "Cortical",
                             "Skeletal Muscle Cells": ["satellite", "differentiated"]}
cancer_not_include_codes = {"neuroectodermal tumor cell line": "peripheral", "Epithelioid mesothelioma": "No36"}
time_courses_not_include_codes = {"hIPS": "CCl2"}
primary_exclude_list = ["mesenchymal precursor cell - ovarian", "Osteoblast - differentiated",
                        "Peripheral Blood Mononuclear Cells", "Whole blood"]
primary_cells_supersets = {"CD14+ CD16- Monocytes": "CD14+ Monocytes",
                           "CD14+ CD16+ Monocytes": "CD14+ Monocytes",
                           "CD4+CD25+CD45RA- memory regulatory T cells": "CD4+ T Cells",
                           "CD4+CD25+CD45RA+ naive regulatory T cells": "CD4+ T Cells",
                           "CD4+CD25-CD45RA- memory conventional T cells": "CD4+ T Cells",
                           "CD4+CD25-CD45RA+ naive conventional T cells": "CD4+ T Cells"}
three_donors_cell_list = ["Adipocyte - omental", "Adipocyte - subcutaneous", "Alveolar Epithelial Cells",
                          "Amniotic Epithelial Cells", "amniotic membrane cells", "Astrocyte - cerebellum",
                          "Astrocyte - cerebral cortex", "Basophils", "Cardiac Myocyte", "CD14+ CD16- Monocytes",
                          "CD14+ CD16+ Monocytes", "CD14- CD16+ Monocytes",
                          "chorionic membrane cells", "Ciliary Epithelial Cells", "Corneal Epithelial Cells",
                          "Dendritic Cells - plasmacytoid",
                          "Endothelial Cells - Artery", "Endothelial Cells - Lymphatic",
                          "Endothelial Cells - Microvascular", "Endothelial Cells - Umbilical vein",
                          "Endothelial Cells - Vein", "Eosinophils", "Esophageal Epithelial Cells",
                          "Fibroblast - Aortic Adventitial", "Fibroblast - Choroid Plexus",
                          "Fibroblast - Lung", "Fibroblast - Lymphatic", "Fibroblast - Mammary",
                          "Fibroblast - Villous Mesenchymal", "Gingival epithelial cells",
                          "granulocyte macrophage progenitor", "Hair Follicle Dermal Papilla Cells",
                          "Hepatic Sinusoidal Endothelial Cells", "Hepatic Stellate Cells (lipocyte)", "Hepatocyte",
                          "Keratinocyte - epidermal", "Keratocytes", "Lens Epithelial Cells",
                          "Macrophage - monocyte derived", "Mallassez-derived cells", "Mammary Epithelial Cell",
                          "Meningeal Cells", "mesenchymal precursor cell - adipose",
                          "mesenchymal precursor cell - bone marrow", "Mesenchymal stem cells - hepatic",
                          "Mesothelial Cells", "migratory langerhans cells",
                          "Myoblast", "Natural Killer Cells", "Neurons", "Nucleus Pulposus Cell", "Osteoblast",
                          "Pericytes", "Placental Epithelial Cells", "Preadipocyte - omental",
                          "Preadipocyte - subcutaneous", "Preadipocyte - visceral", "Prostate Epithelial Cells",
                          "Prostate Stromal Cells", "Renal Epithelial Cells", "Renal Mesangial Cells",
                          "Renal Proximal Tubular Epithelial Cell",
                          "salivary acinar cells", "Schwann Cells", "Sebocyte",
                          "Skeletal muscle cells differentiated into Myotubes",
                          "Skeletal Muscle Satellite Cells", "Small Airway Epithelial Cells",
                          "Smooth Muscle Cells - Brachiocephalic",
                          "Smooth Muscle Cells - Brain Vascular", "Smooth Muscle Cells - Carotid",
                          "Smooth Muscle Cells - Colonic", "Smooth Muscle Cells - Coronary Artery",
                          "Smooth Muscle Cells - Internal Thoracic Artery", "Smooth Muscle Cells - Prostate",
                          "Smooth Muscle Cells - Pulmonary Artery", "Smooth Muscle Cells - Subclavian Artery",
                          "Smooth Muscle Cells - Tracheal",
                          "Smooth Muscle Cells - Umbilical Vein", "Synoviocyte",
                          "tenocyte", "Trabecular Meshwork Cells", "Tracheal Epithelial Cells"]
four_donors_cell_list = ["Smooth Muscle Cells - Umbilical Artery", "Retinal Pigment Epithelial Cells",
                         "Smooth Muscle Cells - Aortic", "Mesenchymal Stem Cells - umbilical",
                         "Endothelial Cells - Aortic", "Mesenchymal Stem Cells - adipose", "Urothelial Cells",
                         "mature adipocyte", "Mesenchymal Stem Cells - bone marrow", "Olfactory epithelial cells"]

cancer_celltype_list = ["acantholytic squamous carcinoma cell line:HCC1806",
                        "acute lymphoblastic leukemia (B-ALL) cell line",
                        "acute lymphoblastic leukemia (T-ALL) cell line",
                        "acute myeloid leukemia (FAB M0) cell line", "acute myeloid leukemia (FAB M1) cell line",
                        "acute myeloid leukemia (FAB M2) cell line", "acute myeloid leukemia (FAB M3) cell line",
                        "acute myeloid leukemia (FAB M4) cell line", "acute myeloid leukemia (FAB M4eo) cell line",
                        "acute myeloid leukemia (FAB M5) cell line", "acute myeloid leukemia (FAB M6) cell line",
                        "acute myeloid leukemia (FAB M7) cell line", "adenocarcinoma cell line:IM95m",
                        "adrenal cortex adenocarcinoma cell line:SW-13", "adult T-cell leukemia cell line:ATN-1",
                        "alveolar cell carcinoma cell line:SW 1573", "anaplastic carcinoma cell line:8305C",
                        "anaplastic large cell lymphoma cell line:Ki-JK",
                        "anaplastic squamous cell carcinoma cell line:RPMI 2650",
                        "argyrophil small cell carcinoma cell line:TC-YIK", "astrocytoma cell line:TM-31",
                        "b cell line:RPMI1788", "B lymphoblastoid cell line: GM12878 ENCODE",
                        "basal cell carcinoma cell line:TE 354", "bile duct carcinoma cell line",
                        "biphenotypic B myelomonocytic leukemia cell line:MV-4-11",
                        "bone marrow stromal cell line:StromaNKtert", "breast carcinoma cell line",
                        "bronchial squamous cell carcinoma cell line:KNS-62",
                        "bronchioalveolar carcinoma cell line", "bronchogenic carcinoma cell line:ChaGo-K-1",
                        "Burkitt lymphoma cell line", "carcinoid cell line", "carcinosarcoma cell line:JHUCS-1",
                        "cervical cancer cell line", "cholangiocellular carcinoma cell line:HuH-28",
                        "chondrosarcoma cell line:SW 1353", "choriocarcinoma cell line",
                        "chronic lymphocytic leukemia cell line:SKW-3",
                        "chronic myeloblastic leukemia cell line:KCL-22", "chronic myelogenous leukemia cell line",
                        "clear cell carcinoma cell line", "colon carcinoma cell line",
                        "cord blood derived cell line:COBL-a untreated",
                        "diffuse large B-cell lymphoma cell line:CTB-1", "ductal cell carcinoma cell line",
                        "embryonic kidney cell line: HEK293/SLAM untreated", "embryonic pancreas cell line",
                        "endometrial carcinoma cell line:OMC-2", "endometrial stromal sarcoma cell line:OMC-9",
                        "endometrioid adenocarcinoma cell line:JHUEM-1", "epidermoid carcinoma cell line",
                        "epithelioid sarcoma cell line", "epitheloid carcinoma cell line: HelaS3 ENCODE",
                        "Ewing sarcoma cell line:Hs 863",
                        "extraskeletal myxoid chondrosarcoma cell line:H-EMC-SS", "fibrosarcoma cell line:HT-1080",
                        "fibrous histiocytoma cell line:GCT TIB-223", "gall bladder carcinoma cell line",
                        "gastric adenocarcinoma cell line", "gastric cancer cell line",
                        "gastrointestinal carcinoma cell line:ECC12", "giant cell carcinoma cell line",
                        "glassy cell carcinoma cell line:HOKUG", "glioblastoma cell line", "glioma cell line:GI-1",
                        "granulosa cell tumor cell line:KGN", "hairy cell leukemia cell line:Mo",
                        "Hep-2 cells mock treated", "hepatic mesenchymal tumor cell line:LI90",
                        "hepatoblastoma cell line:HuH-6", "hepatocellular carcinoma cell line: HepG2 ENCODE",
                        "hepatoma cell line:Li-7", "hereditary spherocytic anemia cell line:WIL2-NS",
                        "Hodgkin lymphoma cell line:HD-Mar2", "keratoacanthoma cell line:HKA-1",
                        "Krukenberg tumor cell line:HSKTC", "large cell lung carcinoma cell line",
                        "large cell non-keratinizing squamous carcinoma cell line:SKG-II-SF",
                        "leiomyoblastoma cell line:G-402", "leiomyoma cell line", "leiomyosarcoma cell line:Hs 5",
                        "lens epithelial cell line:SRA", "leukemia chronic megakaryoblastic cell line:MEG-01",
                        "liposarcoma cell line", "lung adenocarcinoma cell line",
                        "lung adenocarcinoma papillary cell line:NCI-H441", "lymphangiectasia cell line:DS-1",
                        "lymphoma malignant hairy B-cell cell line:MLMA",
                        "malignant trichilemmal cyst cell line:DJM-1", "maxillary sinus tumor cell line:HSQ-89",
                        "medulloblastoma cell line", "melanoma cell line", "meningioma cell line:HKBMM",
                        "merkel cell carcinoma cell line",
                        "mesenchymal stem cell line:Hu5/E18", "mesodermal tumor cell line:HIRS-BM",
                        {"Biphasic mesothelioma": ["mesothelioma cell line:Mero-84", "mesothelioma cell line:Mero-48a",
                                                   "mesothelioma cell line:Mero-83", "mesothelioma cell line:NCI-H2452",
                                                   "mesothelioma cell line:Mero-25"]},
                        {"Sarcomatoid mesothelioma": ["mesothelioma cell line:NCI-H2052",
                                                      "mesothelioma cell line:NCI-H28",
                                                      "mesothelioma cell line:ONE58"]},
                        {"Epithelioid mesothelioma": ['mesothelioma cell line:ACC-MESO-1',
                                                      'mesothelioma cell line:ACC-MESO-4',
                                                      'mesothelioma cell line:Mero-14',
                                                      'mesothelioma cell line:Mero-41',
                                                      'mesothelioma cell line:Mero-82',
                                                      'mesothelioma cell line:Mero-95',
                                                      'mesothelioma cell line:NCI-H226',
                                                      'mesothelioma cell line:No36']},
                        "mixed mullerian tumor cell line:HTMMT",
                        "mucinous adenocarcinoma cell line:JHOM-1", "mucinous cystadenocarcinoma cell line:MCAS",
                        "myelodysplastic syndrome cell line:SKM-1", "myeloma cell line:PCM6",
                        "myxofibrosarcoma cell line", "neuroblastoma cell line", "neuroectodermal tumor cell line",
                        "neuroepithelioma cell line:SK-N-MC", "neurofibroma cell line:Hs 53",
                        "NK T cell leukemia cell line:KHYG-1",
                        "non T non B acute lymphoblastic leukemia cell line:P30/OHK",
                        "non-small cell lung cancer cell line:NCI-H1385",
                        "normal embryonic palatal mesenchymal cell line:HEPM",
                        "normal intestinal epithelial cell line:FHs 74 Int",
                        "oral squamous cell carcinoma cell line", "osteoclastoma cell line:Hs 706",
                        "osteosarcoma cell line", "pagetoid sarcoma cell line:Hs 925",
                        "pancreatic carcinoma cell line:NOR-P1", "papillary adenocarcinoma cell line:8505C",
                        "papillotubular adenocarcinoma cell line:TGBC18TKB",
                        "peripheral neuroectodermal tumor cell line:KU-SN",
                        "pharyngeal carcinoma cell line:Detroit 562", "plasma cell leukemia cell line:ARH-77",
                        "pleomorphic hepatocellular carcinoma cell line:SNU-387", "prostate cancer cell line",
                        "rectal cancer cell line:TT1TKB", "renal cell carcinoma cell line",
                        "retinoblastoma cell line:Y79", "rhabdomyosarcoma cell line",
                        "sacrococcigeal teratoma cell line:HTST", "schwannoma cell line:HS-PSS",
                        "serous adenocarcinoma cell line", "serous cystadenocarcinoma cell line:HTOA",
                        "signet ring carcinoma cell line", "small cell cervical cancer cell line:HCSC-1",
                        "small cell gastrointestinal carcinoma cell line:ECC10",
                        "small cell lung carcinoma cell line",
                        "small-cell gastrointestinal carcinoma cell line:ECC4", "somatostatinoma cell line:QGP-1",
                        "spindle cell sarcoma cell line:Hs 132",
                        "splenic lymphoma with villous lymphocytes cell line:SLVL",
                        "squamous cell carcinoma cell line:EC-GI-10", "squamous cell carcinoma cell line:JHUS-nk1",
                        "squamous cell carcinoma cell line:T3M-5", "squamous cell lung carcinoma cell line",
                        "synovial sarcoma cell line:HS-SY-II", "T cell lymphoma cell line:HuT 102 TIB-162",
                        "teratocarcinoma cell line", "testicular germ cell embryonal carcinoma cell line",
                        "thymic carcinoma cell line:Ty-82", "thyroid carcinoma cell line",
                        "transitional cell carcinoma cell line", "tridermal teratoma cell line:HGRT",
                        "tubular adenocarcinoma cell line:SUIT-2", "Wilms tumor cell line",
                        "xeroderma pigentosum b cell line:XPL 17"]
cancer_donors_list = ['acantholytic squamous carcinoma cell line:HCC1806',
                      'acute lymphoblastic leukemia (B-ALL) cell line:BALL-1',
                      'acute lymphoblastic leukemia (B-ALL) cell line:NALM-6',
                      'acute lymphoblastic leukemia (T-ALL) cell line:HPB-ALL',
                      'acute lymphoblastic leukemia (T-ALL) cell line:Jurkat',
                      'acute myeloid leukemia (FAB M0) cell line:Kasumi-3',
                      'acute myeloid leukemia (FAB M0) cell line:KG-1',
                      'acute myeloid leukemia (FAB M1) cell line:HYT-1',
                      'acute myeloid leukemia (FAB M2) cell line:Kasumi-1',
                      'acute myeloid leukemia (FAB M2) cell line:Kasumi-6',
                      'acute myeloid leukemia (FAB M2) cell line:NKM-1',
                      'acute myeloid leukemia (FAB M3) cell line:HL60',
                      'acute myeloid leukemia (FAB M4) cell line:FKH-1',
                      'acute myeloid leukemia (FAB M4) cell line:HNT-34',
                      'acute myeloid leukemia (FAB M4eo) cell line:EoL-1',
                      'acute myeloid leukemia (FAB M4eo) cell line:EoL-3',
                      'acute myeloid leukemia (FAB M5) cell line:NOMO-1',
                      'acute myeloid leukemia (FAB M5) cell line:P31/FUJ',
                      'acute myeloid leukemia (FAB M5) cell line:THP-1 (fresh)',
                      'acute myeloid leukemia (FAB M5) cell line:U-937 DE-4',
                      'acute myeloid leukemia (FAB M6) cell line:EEB',
                      'acute myeloid leukemia (FAB M6) cell line:F-36E',
                      'acute myeloid leukemia (FAB M6) cell line:F-36P',
                      'acute myeloid leukemia (FAB M7) cell line:MKPL-1',
                      'acute myeloid leukemia (FAB M7) cell line:M-MOK', 'adenocarcinoma cell line:IM95m',
                      'adrenal cortex adenocarcinoma cell line:SW-13', 'adult T-cell leukemia cell line:ATN-1',
                      'alveolar cell carcinoma cell line:SW 1573', 'anaplastic carcinoma cell line:8305C',
                      'anaplastic large cell lymphoma cell line:Ki-JK',
                      'anaplastic squamous cell carcinoma cell line:RPMI 2650',
                      'argyrophil small cell carcinoma cell line:TC-YIK', 'astrocytoma cell line:TM-31',
                      'b cell line:RPMI1788', 'B lymphoblastoid cell line: GM12878 ENCODE',
                      'basal cell carcinoma cell line:TE 354.T', 'bile duct carcinoma cell line:HuCCT1',
                      'bile duct carcinoma cell line:TFK-1',
                      'biphenotypic B myelomonocytic leukemia cell line:MV-4-11',
                      'bone marrow stromal cell line:StromaNKtert', 'breast carcinoma cell line:MCF7',
                      'breast carcinoma cell line:MDA-MB-453',
                      'bronchial squamous cell carcinoma cell line:KNS-62',
                      'bronchioalveolar carcinoma cell line:NCI-H358',
                      'bronchioalveolar carcinoma cell line:NCI-H650',
                      'bronchogenic carcinoma cell line:ChaGo-K-1', 'Burkitt lymphoma cell line:DAUDI',
                      'Burkitt lymphoma cell line:RAJI', 'carcinoid cell line:NCI-H1770',
                      'carcinoid cell line:NCI-H727', 'carcinoid cell line:SK-PN-DW',
                      'carcinosarcoma cell line:JHUCS-1', 'cervical cancer cell line:D98-AH2',
                      'cervical cancer cell line:ME-180', 'cholangiocellular carcinoma cell line:HuH-28',
                      'chondrosarcoma cell line:SW 1353', 'choriocarcinoma cell line:BeWo',
                      'choriocarcinoma cell line:SCH', 'choriocarcinoma cell line:T3M-3',
                      'chronic lymphocytic leukemia cell line:SKW-3',
                      'chronic myeloblastic leukemia cell line:KCL-22',
                      'chronic myelogenous leukemia cell line:K562',
                      'chronic myelogenous leukemia cell line:KU812',
                      'chronic myelogenous leukemia cell line:MEG-A2', 'clear cell carcinoma cell line:JHOC-5',
                      'clear cell carcinoma cell line:TEN', 'colon carcinoma cell line:CACO-2',
                      'colon carcinoma cell line:COLO-320', 'cord blood derived cell line:COBL-a untreated',
                      'diffuse large B-cell lymphoma cell line:CTB-1', 'ductal cell carcinoma cell line:KLM-1',
                      'ductal cell carcinoma cell line:MIA Paca2',
                      'embryonic kidney cell line: HEK293/SLAM untreated', 'embryonic pancreas cell line:1B2C6',
                      'embryonic pancreas cell line:1C3D3', 'embryonic pancreas cell line:1C3IKEI',
                      'embryonic pancreas cell line:2C6', 'endometrial carcinoma cell line:OMC-2',
                      'endometrial stromal sarcoma cell line:OMC-9',
                      'endometrioid adenocarcinoma cell line:JHUEM-1', 'epidermoid carcinoma cell line:A431',
                      'epidermoid carcinoma cell line:Ca Ski', 'epithelioid sarcoma cell line:HS-ES-1',
                      'epithelioid sarcoma cell line:HS-ES-2R', 'epitheloid carcinoma cell line: HelaS3 ENCODE',
                      'Ewing sarcoma cell line:Hs 863.T',
                      'extraskeletal myxoid chondrosarcoma cell line:H-EMC-SS', 'fibrosarcoma cell line:HT-1080',
                      'fibrous histiocytoma cell line:GCT TIB-223', 'gall bladder carcinoma cell line:TGBC14TKB',
                      'gall bladder carcinoma cell line:TGBC2TKB', 'gastric adenocarcinoma cell line:MKN1',
                      'gastric adenocarcinoma cell line:MKN45', 'gastric cancer cell line:AZ521',
                      'gastric cancer cell line:GSS', 'gastrointestinal carcinoma cell line:ECC12',
                      'giant cell carcinoma cell line:LU65', 'giant cell carcinoma cell line:Lu99B',
                      'glassy cell carcinoma cell line:HOKUG', 'glioblastoma cell line:A172',
                      'glioblastoma cell line:T98G', 'glioma cell line:GI-1',
                      'granulosa cell tumor cell line:KGN', 'hairy cell leukemia cell line:Mo',
                      'Hep-2 cells mock treated', 'hepatic mesenchymal tumor cell line:LI90',
                      'hepatoblastoma cell line:HuH-6', 'hepatocellular carcinoma cell line: HepG2 ENCODE',
                      'hepatoma cell line:Li-7', 'hereditary spherocytic anemia cell line:WIL2-NS',
                      'Hodgkin lymphoma cell line:HD-Mar2', 'keratoacanthoma cell line:HKA-1',
                      'Krukenberg tumor cell line:HSKTC', 'large cell lung carcinoma cell line:IA-LM',
                      'large cell lung carcinoma cell line:NCI-H460',
                      'large cell non-keratinizing squamous carcinoma cell line:SKG-II-SF',
                      'leiomyoblastoma cell line:G-402', 'leiomyoma cell line:10964C',
                      'leiomyoma cell line:15242A', 'leiomyoma cell line:15425', 'leiomyosarcoma cell line:Hs 5',
                      'lens epithelial cell line:SRA', 'leukemia, chronic megakaryoblastic cell line:MEG-01',
                      'liposarcoma cell line:KMLS-1', 'liposarcoma cell line:SW 872',
                      'lung adenocarcinoma cell line:A549', 'lung adenocarcinoma cell line:PC-14',
                      'lung adenocarcinoma, papillary cell line:NCI-H441', 'lymphangiectasia cell line:DS-1',
                      'lymphoma, malignant, hairy B-cell cell line:MLMA',
                      'malignant trichilemmal cyst cell line:DJM-1', 'maxillary sinus tumor cell line:HSQ-89',
                      'medulloblastoma cell line:D283 Med', 'medulloblastoma cell line:ONS-76',
                      'melanoma cell line:COLO 679', 'melanoma cell line:G-361', 'meningioma cell line:HKBMM',
                      'merkel cell carcinoma cell line:MKL-1', 'merkel cell carcinoma cell line:MS-1',
                      'mesenchymal stem cell line:Hu5/E18', 'mesodermal tumor cell line:HIRS-BM',
                      'mesothelioma cell line:ACC-MESO-1', 'mesothelioma cell line:ACC-MESO-4',
                      'mesothelioma cell line:Mero-14', 'mesothelioma cell line:Mero-25',
                      'mesothelioma cell line:Mero-41', 'mesothelioma cell line:Mero-48a',
                      'mesothelioma cell line:Mero-82', 'mesothelioma cell line:Mero-83',
                      'mesothelioma cell line:Mero-84', 'mesothelioma cell line:Mero-95',
                      'mesothelioma cell line:NCI-H2052', 'mesothelioma cell line:NCI-H226',
                      'mesothelioma cell line:NCI-H2452', 'mesothelioma cell line:NCI-H28',
                      'mesothelioma cell line:No36', 'mesothelioma cell line:ONE58',
                      'mixed mullerian tumor cell line:HTMMT', 'mucinous adenocarcinoma cell line:JHOM-1',
                      'mucinous cystadenocarcinoma cell line:MCAS', 'myelodysplastic syndrome cell line:SKM-1',
                      'myeloma cell line:PCM6', 'myxofibrosarcoma cell line:MFH-ino',
                      'myxofibrosarcoma cell line:NMFH-1', 'neuroblastoma cell line:CHP-134',
                      'neuroblastoma cell line:NB-1', 'neuroblastoma cell line:NBsusSR',
                      'neuroblastoma cell line:NH-12', 'neuroectodermal tumor cell line:FU-RPNT-1',
                      'neuroectodermal tumor cell line:FU-RPNT-2', 'neuroectodermal tumor cell line:TASK1',
                      'neuroepithelioma cell line:SK-N-MC', 'neurofibroma cell line:Hs 53.T',
                      'NK T cell leukemia cell line:KHYG-1',
                      'non T non B acute lymphoblastic leukemia cell line:P30/OHK',
                      'non-small cell lung cancer cell line:NCI-H1385',
                      'normal embryonic palatal mesenchymal cell line:HEPM',
                      'normal intestinal epithelial cell line:FHs 74 Int',
                      'oral squamous cell carcinoma cell line:Ca9-22',
                      'oral squamous cell carcinoma cell line:HO-1-u-1',
                      'oral squamous cell carcinoma cell line:HSC-3',
                      'oral squamous cell carcinoma cell line:SAS', 'osteoclastoma cell line:Hs 706.T',
                      'osteosarcoma cell line:143B/TK', 'osteosarcoma cell line:HS-Os-1',
                      'pagetoid sarcoma cell line:Hs 925', 'pancreatic carcinoma cell line:NOR-P1',
                      'papillary adenocarcinoma cell line:8505C',
                      'papillotubular adenocarcinoma cell line:TGBC18TKB',
                      'peripheral neuroectodermal tumor cell line:KU-SN',
                      'pharyngeal carcinoma cell line:Detroit 562', 'plasma cell leukemia cell line:ARH-77',
                      'pleomorphic hepatocellular carcinoma cell line:SNU-387',
                      'prostate cancer cell line:DU145', 'prostate cancer cell line:PC-3',
                      'rectal cancer cell line:TT1TKB', 'renal cell carcinoma cell line:OS-RC-2',
                      'renal cell carcinoma cell line:TUHR10TKB', 'retinoblastoma cell line:Y79',
                      'rhabdomyosarcoma cell line:KYM-1', 'rhabdomyosarcoma cell line:RMS-YM',
                      'sacrococcigeal teratoma cell line:HTST', 'schwannoma cell line:HS-PSS',
                      'serous adenocarcinoma cell line:JHOS-2', 'serous adenocarcinoma cell line:SK-OV-3-R',
                      'serous cystadenocarcinoma cell line:HTOA', 'signet ring carcinoma cell line:Kato III',
                      'signet ring carcinoma cell line:NUGC-4', 'small cell cervical cancer cell line:HCSC-1',
                      'small cell gastrointestinal carcinoma cell line:ECC10',
                      'small cell lung carcinoma cell line:DMS 144', 'small cell lung carcinoma cell line:LK-2',
                      'small cell lung carcinoma cell line:NCI-H82', 'small cell lung carcinoma cell line:WA-hT',
                      'small-cell gastrointestinal carcinoma cell line:ECC4', 'somatostatinoma cell line:QGP-1',
                      'spindle cell sarcoma cell line:Hs 132.T',
                      'splenic lymphoma with villous lymphocytes cell line:SLVL',
                      'squamous cell carcinoma cell line:EC-GI-10', 'squamous cell carcinoma cell line:JHUS-nk1',
                      'squamous cell carcinoma cell line:T3M-5', 'squamous cell lung carcinoma cell line:EBC-1',
                      'squamous cell lung carcinoma cell line:LC-1F',
                      'squamous cell lung carcinoma cell line:RERF-LC-AI', 'synovial sarcoma cell line:HS-SY-II',
                      'T cell lymphoma cell line:HuT 102 TIB-162', 'teratocarcinoma cell line:NCC-IT-A3',
                      'teratocarcinoma cell line:NCR-G1', 'teratocarcinoma cell line:PA-1',
                      'testicular germ cell embryonal carcinoma cell line:ITO-II',
                      'testicular germ cell embryonal carcinoma cell line:NEC14',
                      'testicular germ cell embryonal carcinoma cell line:NEC15',
                      'testicular germ cell embryonal carcinoma cell line:NEC8',
                      'thymic carcinoma cell line:Ty-82', 'thyroid carcinoma cell line:KHM-5M',
                      'thyroid carcinoma cell line:TCO-1', 'transitional cell carcinoma cell line:Hs 769',
                      'transitional-cell carcinoma cell line:5637',
                      'transitional-cell carcinoma cell line:JMSU1', 'tridermal teratoma cell line:HGRT',
                      'tubular adenocarcinoma cell line:SUIT-2', 'Wilms tumor cell line:G-401',
                      'Wilms tumor cell line:HFWT', 'xeroderma pigentosum b cell line:XPL 17']
cancer_three_donors_list = ["acute myeloid leukemia (FAB M2) cell line", "acute myeloid leukemia (FAB M6) cell line",
                            "carcinoid cell line", "choriocarcinoma cell line", "leiomyoma cell line",
                            "neuroectodermal tumor cell line",
                            "squamous cell lung carcinoma cell line", "teratocarcinoma cell line",
                            "transitional cell carcinoma cell line"]
cancer_three_donors_bio_rep_list = ["B lymphoblastoid cell line: GM12878 ENCODE",
                                    "epitheloid carcinoma cell line: HelaS3 ENCODE", "Hep-2 cells mock treated",
                                    "hepatocellular carcinoma cell line: HepG2 ENCODE"]
cancer_four_donors_list = ["embryonic pancreas cell line", "neuroblastoma cell line",
                           "oral squamous cell carcinoma cell line", "small cell lung carcinoma cell line",
                           "testicular germ cell embryonal carcinoma cell line"]

primary_cell_list_vencodes_k4_sampling_promoters = ['Adipocyte - breast', 'Adipocyte - perirenal',
                                                    'Adipocyte - subcutaneous', 'Alveolar Epithelial Cells',
                                                    'Amniotic Epithelial Cells', 'Astrocyte - cerebellum',
                                                    'Astrocyte - cerebral cortex', 'Basophils',
                                                    'CD133+ stem cells - adult bone marrow derived',
                                                    'CD133+ stem cells - cord blood derived', 'CD14+ CD16+ Monocytes',
                                                    'CD14+ CD16- Monocytes',
                                                    'CD14+ monocyte derived endothelial progenitor cells',
                                                    'CD19+ B Cells',
                                                    'CD34 cells differentiated to erythrocyte lineage',
                                                    'CD34+ Progenitors',
                                                    'CD34+ stem cells - adult bone marrow derived',
                                                    'CD4+CD25+CD45RA- memory regulatory T cells', 'Cardiac Myocyte',
                                                    'Chondrocyte', 'Ciliary Epithelial Cells',
                                                    'Corneal Epithelial Cells',
                                                    'Dendritic Cells - monocyte immature derived',
                                                    'Dendritic Cells - plasmacytoid', 'Endothelial Cells - Artery',
                                                    'Endothelial Cells - Lymphatic',
                                                    'Endothelial Cells - Microvascular',
                                                    'Endothelial Cells - Thoracic',
                                                    'Endothelial Cells - Umbilical vein', 'Endothelial Cells - Vein',
                                                    'Fibroblast - Aortic Adventitial', 'Fibroblast - Choroid Plexus',
                                                    'Fibroblast - Conjunctival', 'Fibroblast - Lung',
                                                    'Fibroblast - Lymphatic', 'Fibroblast - Mammary',
                                                    'Fibroblast - Pulmonary Artery',
                                                    'Fibroblast - Villous Mesenchymal', 'Gingival epithelial cells',
                                                    'Hair Follicle Dermal Papilla Cells',
                                                    'Hair Follicle Outer Root Sheath Cells',
                                                    'Hepatic Stellate Cells (lipocyte)', 'Hepatocyte',
                                                    'Intestinal epithelial cells (polarized)',
                                                    'Iris Pigment Epithelial Cells', 'Keratinocyte - epidermal',
                                                    'Keratinocyte - oral', 'Keratocytes', 'Lens Epithelial Cells',
                                                    'Macrophage - monocyte derived', 'Mallassez-derived cells',
                                                    'Mammary Epithelial Cell', 'Mast cell', 'Meningeal Cells',
                                                    'Mesenchymal Stem Cells - Vertebral',
                                                    'Mesenchymal Stem Cells - Wharton Jelly',
                                                    'Mesenchymal Stem Cells - amniotic membrane',
                                                    'Mesenchymal stem cells - hepatic',
                                                    'Mesenchymal stem cells - umbilical', 'Mesothelial Cells',
                                                    'Multipotent Cord Blood Unrestricted Somatic Stem Cells',
                                                    'Myoblast', 'Natural Killer Cells', 'Neural stem cells', 'Neurons',
                                                    'Nucleus Pulposus Cell', 'Olfactory epithelial cells',
                                                    'Oligodendrocyte - precursors', 'Osteoblast',
                                                    'Pancreatic stromal cells', 'Pericytes', 'Perineurial Cells',
                                                    'Placental Epithelial Cells', 'Preadipocyte - breast',
                                                    'Preadipocyte - omental', 'Preadipocyte - perirenal',
                                                    'Prostate Epithelial Cells', 'Prostate Stromal Cells',
                                                    'Renal Cortical Epithelial Cells',
                                                    'Renal Glomerular Endothelial Cells', 'Renal Mesangial Cells',
                                                    'Renal Proximal Tubular Epithelial Cell',
                                                    'Retinal Pigment Epithelial Cells', 'Schwann Cells', 'Sebocyte',
                                                    'Sertoli Cells', 'Small Airway Epithelial Cells',
                                                    'Smooth Muscle Cells - Bladder',
                                                    'Smooth Muscle Cells - Brain Vascular',
                                                    'Smooth Muscle Cells - Bronchial', 'Smooth Muscle Cells - Colonic',
                                                    'Smooth Muscle Cells - Esophageal',
                                                    'Smooth Muscle Cells - Internal Thoracic Artery',
                                                    'Smooth Muscle Cells - Intestinal',
                                                    'Smooth Muscle Cells - Tracheal',
                                                    'Smooth Muscle Cells - Umbilical Vein',
                                                    'Smooth Muscle Cells - Umbilical artery',
                                                    'Smooth Muscle Cells - Uterine', 'Smooth muscle cells - airway',
                                                    'Synoviocyte', 'Trabecular Meshwork Cells',
                                                    'Tracheal Epithelial Cells', 'Urothelial cells',
                                                    'amniotic membrane cells', 'chorionic membrane cells',
                                                    'common myeloid progenitor CMP', 'gamma delta positive T cells',
                                                    'granulocyte macrophage progenitor', 'immature langerhans cells',
                                                    'mature adipocyte', 'mesenchymal precursor cell - adipose',
                                                    'mesenchymal precursor cell - bone marrow',
                                                    'mesenchymal precursor cell - cardiac',
                                                    'migratory langerhans cells', 'nasal epithelial cells',
                                                    'promyelocytes', 'salivary acinar cells', 'tenocyte']

primary_cell_list_vencodes_k4_sampling_enhancers = ['Adipocyte - breast', 'Adipocyte - omental',
                                                    'Adipocyte - perirenal', 'Adipocyte - subcutaneous',
                                                    'Alveolar Epithelial Cells', 'Amniotic Epithelial Cells',
                                                    'amniotic membrane cells', 'Anulus Pulposus Cell',
                                                    'Astrocyte - cerebellum', 'Astrocyte - cerebral cortex',
                                                    'Basophils', 'CD133+ stem cells - adult bone marrow derived',
                                                    'CD133+ stem cells - cord blood derived', 'CD14+ CD16- Monocytes',
                                                    'CD14+ CD16+ Monocytes',
                                                    'CD14+ monocyte derived endothelial progenitor cells',
                                                    'CD19+ B Cells', 'CD34 cells differentiated to erythrocyte lineage',
                                                    'CD34+ Progenitors', 'CD34+ stem cells - adult bone marrow derived',
                                                    'CD4+CD25+CD45RA- memory regulatory T cells',
                                                    'chorionic membrane cells', 'Ciliary Epithelial Cells',
                                                    'Dendritic Cells - plasmacytoid', 'Endothelial Cells - Aortic',
                                                    'Endothelial Cells - Artery', 'Endothelial Cells - Lymphatic',
                                                    'Endothelial Cells - Microvascular', 'Endothelial Cells - Thoracic',
                                                    'Endothelial Cells - Umbilical vein', 'Endothelial Cells - Vein',
                                                    'Fibroblast - Aortic Adventitial', 'Fibroblast - Choroid Plexus',
                                                    'Fibroblast - Conjunctival',
                                                    'Fibroblast - Pulmonary Artery', 'gamma delta positive T cells',
                                                    'Gingival epithelial cells', 'Hair Follicle Dermal Papilla Cells',
                                                    'Hair Follicle Outer Root Sheath Cells',
                                                    'Hepatic Stellate Cells (lipocyte)', 'Hepatocyte',
                                                    'immature langerhans cells',
                                                    'Intestinal epithelial cells (polarized)',
                                                    'Iris Pigment Epithelial Cells', 'Keratinocyte - epidermal',
                                                    'Keratinocyte - oral', 'Lens Epithelial Cells',
                                                    'Macrophage - monocyte derived', 'Mallassez-derived cells',
                                                    'Mammary Epithelial Cell', 'Mast cell', 'mature adipocyte',
                                                    'Meningeal Cells', 'mesenchymal precursor cell - adipose',
                                                    'mesenchymal precursor cell - bone marrow',
                                                    'mesenchymal precursor cell - cardiac',
                                                    'Mesenchymal Stem Cells - amniotic membrane',
                                                    'Mesenchymal stem cells - hepatic',
                                                    'Mesenchymal Stem Cells - Vertebral',
                                                    'Mesenchymal Stem Cells - Wharton Jelly', 'Mesothelial Cells',
                                                    'migratory langerhans cells',
                                                    'Multipotent Cord Blood Unrestricted Somatic Stem Cells',
                                                    'Myoblast', 'nasal epithelial cells', 'Natural Killer Cells',
                                                    'Neural stem cells', 'Neurons', 'Nucleus Pulposus Cell',
                                                    'Olfactory epithelial cells', 'Oligodendrocyte - precursors',
                                                    'Osteoblast', 'Pancreatic stromal cells', 'Pericytes',
                                                    'Perineurial Cells', 'Placental Epithelial Cells',
                                                    'Preadipocyte - breast', 'Preadipocyte - omental',
                                                    'Preadipocyte - perirenal', 'Preadipocyte - subcutaneous',
                                                    'Preadipocyte - visceral', 'Prostate Epithelial Cells',
                                                    'Prostate Stromal Cells', 'Renal Cortical Epithelial Cells',
                                                    'Renal Epithelial Cells',
                                                    'Renal Mesangial Cells', 'Renal Proximal Tubular Epithelial Cell',
                                                    'Retinal Pigment Epithelial Cells', 'salivary acinar cells',
                                                    'Sertoli Cells',
                                                    'Skeletal muscle cells differentiated into Myotubes',
                                                    'Skeletal Muscle Satellite Cells', 'Small Airway Epithelial Cells',
                                                    'Smooth Muscle Cells - Bladder',
                                                    'Smooth Muscle Cells - Brachiocephalic',
                                                    'Smooth Muscle Cells - Brain Vascular',
                                                    'Smooth Muscle Cells - Bronchial', 'Smooth Muscle Cells - Colonic',
                                                    'Smooth Muscle Cells - Coronary Artery',
                                                    'Smooth Muscle Cells - Esophageal',

                                                    'Smooth Muscle Cells - Intestinal',


                                                    'Smooth Muscle Cells - Umbilical artery',
                                                    'Smooth Muscle Cells - Uterine', 'Synoviocyte', 'tenocyte',
                                                    'Tracheal Epithelial Cells', 'Urothelial cells']

# Variables for tests:
test_promoter_file_name = "test_hg19.cage_peak_phase1and2combined_tpm.osc.txt"
test_enhancer_file_name = "test_human_permissive_enhancers_phase_1_and_2_expression_tpm_matrix.txt"
expression_data1 = "expression_data1.csv"
expression_data2 = "expression_data2.csv"
