# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['syracuse']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.6,<3.7', 'networkx[default]>=3.0,<4.0', 'numpy>=1.24,<1.25']

setup_kwargs = {
    'name': 'syracuse',
    'version': '0.2.0',
    'description': 'The Syracuse problem (aka Collatz conjecture) library',
    'long_description': '![PyPI - Python Version](https://img.shields.io/pypi/pyversions/syracuse)\n![GitHub release (latest by date)](https://img.shields.io/github/v/release/devfred78/syracuse)\n![GitHub](https://img.shields.io/github/license/devfred78/syracuse)\n![GitHub issues](https://img.shields.io/github/issues/devfred78/syracuse)\n![GitHub pull requests](https://img.shields.io/github/issues-pr/devfred78/syracuse)\n\n![Graph of the first 26 compressed Collatz sequences](https://github.com/devfred78/syracuse/blob/main/assets/graph_compressed_syracuse_26.png?raw=True)\n*(Graph of the first 26 compressed Collatz sequences)*\n\n# Syracuse\n\nsyracuse, The Syracuse problem (aka Collatz conjecture) library.\n\n## About the project\n\nThe syracuse library provides a way to generate Collatz sequences (either "normal" or compressed forms) and some functions to deal with.\n\n### The Collatz conjecture\n\nThe Collatz conjecture, also known as the "3n + 1 problem" or the "Syracuse problem", is an unsolved hypothesis in mathematics that concerns a sequence of operations applied to a positive integer. The conjecture states that no matter what the starting value of this integer is, the sequence will always eventually reach the value 1.\n\nMore specifically, the Collatz conjecture states that if one takes a positive integer n and applies the following function:\n\n- If n is even, divide it by 2.\n- If n is odd, multiply it by 3 and add 1.\n\nThen, repeat the process with the resulting value, applying the function over and over again until the value of n eventually reaches 1.\n\n> For example, if one takes n = 6, the sequence for the Collatz conjecture would be:\n> 6, 3, 10, 5, 16, 8, 4, 2, 1.\n\nThe Collatz conjecture asserts that this sequence will always eventually reach the value 1, no matter what positive integer n one starts with. Although the conjecture has been computationally tested for extremely large values, it remains unproven to this day.\n\n### The compressed form\n\n*(definition partially inspired by the [relevant article on Wikipedia](https://en.wikipedia.org/wiki/Collatz_conjecture))*\n\nSince 3n+1 is even whenever n is odd, one may instead use the "compressed" form of the Collatz function:\n\n- if n is even, divide it by 2.\n- if n is odd, multiply it by 3, add 1 **and divide the result by 2**.\n\nThis definition yields smaller values for the stopping time and total stopping time without changing the overall dynamics of the process. \n\n> For example, consider the Collatz sequence for the number 17:\n> 17, 52, 26, 13, 40, 20, 10, 5, 16, 8, 4, 2, 1\n>\n> The compressed form of this sequence would be:\n> 17, 26, 13, 20, 10, 5, 8, 4, 2, 1\n\nThe compressed form of the Collatz sequence has been the subject of much research, as it provides insights into the behavior of the original sequence and can be used to search for cycles and other patterns. However, the Collatz conjecture itself remains unproven, and the compressed form of the sequence does not provide a proof or disproof of the conjecture.\n\n### Why the name "syracuse" ?\n\nThe Collatz conjecture is also known as the Syracuse problem because it was first introduced by Lothar Collatz in a 1950 paper, where he credited his colleague, mathematician Helmut Hasse, with calling it the Syracuse problem. The name "Syracuse" refers to the University of Syracuse, where Collatz was working at the time.\n\nThe name "Syracuse problem" has since become a common alternative to "Collatz conjecture", especially in French and Italian-speaking countries, where it is often referred to as the "problème de Syracuse" or "problema di Syracuse", respectively.\n\nRegardless of the name used, the conjecture remains one of the most famous and challenging open problems in mathematics, and it continues to attract the attention of mathematicians and computer scientists around the world.\n\n## Getting started\n\n### Prerequisites\n\nOf course, syracuse cannot run without Python ! More precisely, it requires at least the 3.11 version of our beloved language.\n\nsyracuse depends on the following packages. The installation of syracuse should install automatically those packages if they are missing on your system. If it fails, you can install them individually:\n\n* networkx: version 3.0.0 or above\n\n\t```sh\n\tpip install networkx["default"]\n\t```\n\n* matplotlib: version 3.6.0 or above\n\n\t```sh\n\tpip install matplotlib\n\t```\n\n* numpy: version 1.24.0 or above\n\n\t```sh\n\tpip install numpy\n\t```\n### Installation\n\nInstall from PyPi with:\n\n```sh\npip install syracuse\n```\n\nAs an alternative, you can download the `*.whl` file from the last [release on the syracuse Github repository](https://github.com/devfred78/syracuse/releases), and execute the following command (replace "X.Y.Z" by the right version number):\n\n```sh\npip install syracuse-X.Y.Z-py3-none-any.whl\n```\n\n## Usage\n\nPlease refer to the [documentation](https://devfred78.github.io/syracuse/).\n\n## Contributing\n\nContributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement" or "bug", according to whether you want to share a proposal of a new function, or to record an anomaly.\n\nDon\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n\n## License\n\nDistributed under the MIT License. Check out [LICENSE.md](https://github.com/devfred78/syracuse/blob/main/LICENSE.md) file for more information.\n\n## Acknowledgments\n\nI would like greatfully to thank:\n\nGraphviz [authors](https://graphviz.org/) for this impressive graph visualization software, especially for the creation of the useful [DOT Langage](https://graphviz.org/doc/info/lang.html).\n\n[The Matplotlib development team](https://matplotlib.org/) for providing a very powerful library "for creating static, animated, and interactive visualizations in Python".\n\nNumPy [community](https://numpy.org/) for this fundamental tool to be used as a priority if you want make serious scientific computations with Python.\n\n[MkDocs](https://www.mkdocs.org/), [mkdocstrings](https://mkdocstrings.github.io/) and [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/) for giving the ability to create in a very simple way an accessible documentation for either tiny or big projects.\n\n[Make a README](https://www.makeareadme.com/), [Sayan Mondal](https://medium.com/swlh/how-to-make-the-perfect-readme-md-on-github-92ed5771c061), [Hillary Nyakundi](https://www.freecodecamp.org/news/how-to-write-a-good-readme-file/) and [othneildrew](https://github.com/othneildrew/Best-README-Template) for providing very interesting materials to write good README files (far better than I can write by myself !).\n\n[Choose an open source license](https://choosealicense.com/) for helping to choose the best suitable license for this project.\n\n[Semantic Versioning](https://semver.org/) for providing clear specifications for versioning projects.\n\n[Real Python](https://realpython.com/) for contributing really increasing skills in Python for everyone, novices or veterans.\n\n[GitHub](https://github.com/) for hosting this project, and helping to share it.\n\n[Pypi](https://pypi.org/) for providing a very convenient way to share modules and package to the entire Python community.\n\nAnd, of course, all the former, current and further contributors of this project !',
    'author': 'devfred78',
    'author_email': '97401939+devfred78@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/devfred78/syracuse',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.11,<3.12',
}


setup(**setup_kwargs)
