# mypy-boto3-lambda<a id="mypy-boto3-lambda"></a>

[![PyPI - mypy-boto3-lambda](https://img.shields.io/pypi/v/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-lambda?color=blue)](https://pypistats.org/packages/mypy-boto3-lambda)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Lambda 1.17.90](https://boto3.amazonaws.com/v1/documentation/api/1.17.90/reference/services/lambda.html#Lambda)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.15.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-lambda docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lambda/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-lambda](#mypy-boto3-lambda)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `Lambda` service.

```bash
python -m pip install boto3-stubs[lambda]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[lambda]` in your environment:
  `python -m pip install 'boto3-stubs[lambda]'`

Both type checking and auto-complete should work for `Lambda` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[lambda]` in your environment:
  `python -m pip install 'boto3-stubs[lambda]'`

Both type checking and auto-complete should work for `Lambda` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[lambda]` in your environment:
  `python -m pip install 'boto3-stubs[lambda]'`
- Run `mypy` as usual

Type checking should work for `Lambda` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[lambda]` in your environment:
  `python -m pip install 'boto3-stubs[lambda]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Lambda` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`LambdaClient` provides annotations for `boto3.client("lambda")`.

```python
import boto3

from mypy_boto3_lambda import LambdaClient

client: LambdaClient = boto3.client("lambda")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LambdaClient = session.client("lambda")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_lambda.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_lambda import LambdaClient
from mypy_boto3_lambda.paginator import (
    ListAliasesPaginator,
    ListCodeSigningConfigsPaginator,
    ListEventSourceMappingsPaginator,
    ListFunctionEventInvokeConfigsPaginator,
    ListFunctionsPaginator,
    ListFunctionsByCodeSigningConfigPaginator,
    ListLayerVersionsPaginator,
    ListLayersPaginator,
    ListProvisionedConcurrencyConfigsPaginator,
    ListVersionsByFunctionPaginator,
)

client: LambdaClient = boto3.client("lambda")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_code_signing_configs_paginator: ListCodeSigningConfigsPaginator = client.get_paginator("list_code_signing_configs")
list_event_source_mappings_paginator: ListEventSourceMappingsPaginator = client.get_paginator("list_event_source_mappings")
list_function_event_invoke_configs_paginator: ListFunctionEventInvokeConfigsPaginator = client.get_paginator("list_function_event_invoke_configs")
list_functions_paginator: ListFunctionsPaginator = client.get_paginator("list_functions")
list_functions_by_code_signing_config_paginator: ListFunctionsByCodeSigningConfigPaginator = client.get_paginator("list_functions_by_code_signing_config")
list_layer_versions_paginator: ListLayerVersionsPaginator = client.get_paginator("list_layer_versions")
list_layers_paginator: ListLayersPaginator = client.get_paginator("list_layers")
list_provisioned_concurrency_configs_paginator: ListProvisionedConcurrencyConfigsPaginator = client.get_paginator("list_provisioned_concurrency_configs")
list_versions_by_function_paginator: ListVersionsByFunctionPaginator = client.get_paginator("list_versions_by_function")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_lambda.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_lambda import LambdaClient
from mypy_boto3_lambda.waiter import (
    FunctionActiveWaiter,
    FunctionExistsWaiter,
    FunctionUpdatedWaiter,
)

client: LambdaClient = boto3.client("lambda")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
function_active_waiter: FunctionActiveWaiter = client.get_waiter("function_active")
function_exists_waiter: FunctionExistsWaiter = client.get_waiter("function_exists")
function_updated_waiter: FunctionUpdatedWaiter = client.get_waiter("function_updated")
```

### Literals<a id="literals"></a>

`mypy_boto3_lambda.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_lambda.literals import (
    CodeSigningPolicyType,
    EndPointTypeType,
    EventSourcePositionType,
    FunctionActiveWaiterName,
    FunctionExistsWaiterName,
    FunctionResponseTypeType,
    FunctionUpdatedWaiterName,
    FunctionVersionType,
    InvocationTypeType,
    LastUpdateStatusReasonCodeType,
    LastUpdateStatusType,
    ListAliasesPaginatorName,
    ListCodeSigningConfigsPaginatorName,
    ListEventSourceMappingsPaginatorName,
    ListFunctionEventInvokeConfigsPaginatorName,
    ListFunctionsByCodeSigningConfigPaginatorName,
    ListFunctionsPaginatorName,
    ListLayerVersionsPaginatorName,
    ListLayersPaginatorName,
    ListProvisionedConcurrencyConfigsPaginatorName,
    ListVersionsByFunctionPaginatorName,
    LogTypeType,
    PackageTypeType,
    ProvisionedConcurrencyStatusEnumType,
    RuntimeType,
    SourceAccessTypeType,
    StateReasonCodeType,
    StateType,
    TracingModeType,
)

def check_value(value: CodeSigningPolicyType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_lambda.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_lambda.type_defs import (
    AccountLimitTypeDef,
    AccountUsageTypeDef,
    AddLayerVersionPermissionResponseTypeDef,
    AddPermissionResponseTypeDef,
    AliasConfigurationTypeDef,
    AliasRoutingConfigurationTypeDef,
    AllowedPublishersTypeDef,
    CodeSigningConfigTypeDef,
    CodeSigningPoliciesTypeDef,
    ConcurrencyTypeDef,
    CreateCodeSigningConfigResponseTypeDef,
    DeadLetterConfigTypeDef,
    DestinationConfigTypeDef,
    EnvironmentErrorTypeDef,
    EnvironmentResponseTypeDef,
    EnvironmentTypeDef,
    EventSourceMappingConfigurationTypeDef,
    FileSystemConfigTypeDef,
    FunctionCodeLocationTypeDef,
    FunctionCodeTypeDef,
    FunctionConfigurationTypeDef,
    FunctionEventInvokeConfigTypeDef,
    GetAccountSettingsResponseTypeDef,
    GetCodeSigningConfigResponseTypeDef,
    GetFunctionCodeSigningConfigResponseTypeDef,
    GetFunctionConcurrencyResponseTypeDef,
    GetFunctionResponseTypeDef,
    GetLayerVersionPolicyResponseTypeDef,
    GetLayerVersionResponseTypeDef,
    GetPolicyResponseTypeDef,
    GetProvisionedConcurrencyConfigResponseTypeDef,
    ImageConfigErrorTypeDef,
    ImageConfigResponseTypeDef,
    ImageConfigTypeDef,
    InvocationResponseTypeDef,
    InvokeAsyncResponseTypeDef,
    LayerTypeDef,
    LayerVersionContentInputTypeDef,
    LayerVersionContentOutputTypeDef,
    LayerVersionsListItemTypeDef,
    LayersListItemTypeDef,
    ListAliasesResponseTypeDef,
    ListCodeSigningConfigsResponseTypeDef,
    ListEventSourceMappingsResponseTypeDef,
    ListFunctionEventInvokeConfigsResponseTypeDef,
    ListFunctionsByCodeSigningConfigResponseTypeDef,
    ListFunctionsResponseTypeDef,
    ListLayerVersionsResponseTypeDef,
    ListLayersResponseTypeDef,
    ListProvisionedConcurrencyConfigsResponseTypeDef,
    ListTagsResponseTypeDef,
    ListVersionsByFunctionResponseTypeDef,
    OnFailureTypeDef,
    OnSuccessTypeDef,
    PaginatorConfigTypeDef,
    ProvisionedConcurrencyConfigListItemTypeDef,
    PublishLayerVersionResponseTypeDef,
    PutFunctionCodeSigningConfigResponseTypeDef,
    PutProvisionedConcurrencyConfigResponseTypeDef,
    ResponseMetadataTypeDef,
    SelfManagedEventSourceTypeDef,
    SourceAccessConfigurationTypeDef,
    TracingConfigResponseTypeDef,
    TracingConfigTypeDef,
    UpdateCodeSigningConfigResponseTypeDef,
    VpcConfigResponseTypeDef,
    VpcConfigTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccountLimitTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-lambda` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-lambda docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lambda/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
