"""
Fire model ignition formats
"""

# Core imports
from string import Template
import textwrap
from datetime import datetime
from ._version import __version__


class QuicFire:
    fmt_4 = Template(
        textwrap.dedent(
            f"""
            ! ==================================================================
            ! QUIC-Fire ignition input file
            ! Format 4 - Point ignitions
            ! Total elapsed time: $elapsed_time seconds
            !
            ! Generated by DripTorch v{__version__} on {datetime.now().isoformat()}
            ! ==================================================================
            igntype=4
            &aeriallist
            naerial=$n_rows
            targettemp=1000.0
            ramprate=172.00
            /
            $rows
            """
        )
    )

    fmt_5 = Template(
        textwrap.dedent(
            f"""
            ! ==================================================================
            ! QUIC-Fire ignition input file
            ! Format 5 - Interpolated path ignitions
            ! Total elapsed time: $elapsed_time seconds
            !
            ! Generated by DripTorch v{__version__} on {datetime.now().isoformat()}
            ! ==================================================================
            igntype=5
            &atvlist
            natv=$n_rows
            targettemp=1000.0
            flamedistance=4.00
            /
            $rows
            """
        )
    )
