# Generated by Django 2.2.2 on 2019-07-18 12:12

from django.db import migrations, models
import django.db.models.deletion
import wagtail.core.blocks
import wagtail.core.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0041_group_collection_permissions_verbose_name_plural'),
        ('wagtailimages', '0001_squashed_0021'),
    ]

    operations = [
        migrations.CreateModel(
            name='DropDownPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'verbose_name': 'Dropdown',
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='SlideMixin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(max_length=60)),
                ('text', models.TextField(help_text='Slide text', max_length=200)),
                ('buttons', wagtail.core.fields.StreamField([('buttons', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of a custom URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='Custom URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the custom URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'))], blank=True, null=True)),
                ('image', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LinkPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('link_url', models.CharField(blank=True, max_length=255, null=True, verbose_name='link to a custom URL')),
                ('url_append', models.CharField(blank=True, help_text='Use this to optionally append a #hash or querystring to the URL.', max_length=255, verbose_name='append to URL')),
                ('link_page', models.ForeignKey(blank=True, help_text='Ignored if the custom URL is used', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page', verbose_name='*OR* Link to an internal page')),
            ],
            options={
                'verbose_name': 'Internal or external link',
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='CardMixin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(max_length=40)),
                ('text', models.TextField(help_text='Card text content', max_length=200)),
                ('buttons', wagtail.core.fields.StreamField([('buttons', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of a custom URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='Custom URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the custom URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'))], blank=True, null=True)),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
    ]
