from setuptools import setup, find_packages
import os

# Read the README file
def read_readme():
    with open("README.md", "r", encoding="utf-8") as fh:
        return fh.read()

# Read the LICENSE file
def read_license():
    with open("LICENSE", "r", encoding="utf-8") as fh:
        return fh.read()

setup(
    name="rulify",
    version="0.1.0",
    author="Ertuğrul Kara",
    author_email="ertugrulkra@gmail.com",  # Add your email
    description="A lightweight, chainable rule engine for Python",
    long_description=read_readme(),
    long_description_content_type="text/markdown",
    url="https://github.com/ertugrulkra/rulify",
    project_urls={
        "Bug Reports": "https://github.com/ertugrulkra/rulify/issues",
        "Source": "https://github.com/ertugrulkra/rulify",
        "Documentation": "https://github.com/ertugrulkra/rulify#readme",
    },
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Software Development :: Libraries",
    ],
    keywords="rule engine, rules, business logic, workflow, automation, python",
    python_requires=">=3.8",
    license="MIT",
    include_package_data=True,
    zip_safe=False,
)
