#!/usr/bin/env python3
"""
Test runner for rulify package.
"""
import unittest
import sys
import os

# Add the project root to the Python path
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

# Import test modules
from tests.test_rule import TestRule
from tests.test_engine import TestRuleEngine
from tests.test_integration import TestRulifyIntegration

def run_tests():
    """Run all tests and return the result."""
    # Create test suite
    test_suite = unittest.TestSuite()
    
    # Add test cases
    test_suite.addTest(unittest.makeSuite(TestRule))
    test_suite.addTest(unittest.makeSuite(TestRuleEngine))
    test_suite.addTest(unittest.makeSuite(TestRulifyIntegration))
    
    # Run tests
    runner = unittest.TextTestRunner(verbosity=2)
    result = runner.run(test_suite)
    
    return result.wasSuccessful()

if __name__ == "__main__":
    success = run_tests()
    sys.exit(0 if success else 1)
