"""
Custom exceptions for the rulify package.
"""


class RuleError(Exception):
    """Base exception for rule-related errors."""
    pass


class RuleConditionError(RuleError):
    """Raised when a rule condition fails to evaluate."""
    pass


class RuleActionError(RuleError):
    """Raised when a rule action fails to execute."""
    pass


class RuleEngineError(RuleError):
    """Raised when the rule engine encounters an error."""
    pass
