# Generated by Django 5.0.7 on 2024-07-12 11:38

import django.db.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("extras", "0115_convert_dashboard_widgets"),
        ("netbox_dns", "0005_alter_zone_view_not_null"),
        ("tenancy", "0015_contactassignment_rename_content_type"),
    ]

    operations = [
        migrations.CreateModel(
            name="RecordTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=200, unique=True)),
                ("record_name", models.CharField(max_length=255)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("type", models.CharField()),
                ("value", models.CharField(max_length=65535)),
                ("status", models.CharField(default="active")),
                ("ttl", models.PositiveIntegerField(blank=True, null=True)),
                ("disable_ptr", models.BooleanField(default=False)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="tenancy.tenant",
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="ZoneTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=200, unique=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "admin_c",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="netbox_dns.contact",
                    ),
                ),
                (
                    "billing_c",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="netbox_dns.contact",
                    ),
                ),
                (
                    "nameservers",
                    models.ManyToManyField(
                        blank=True, related_name="+", to="netbox_dns.nameserver"
                    ),
                ),
                (
                    "record_templates",
                    models.ManyToManyField(
                        blank=True,
                        related_name="zone_templates",
                        to="netbox_dns.recordtemplate",
                    ),
                ),
                (
                    "registrant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="netbox_dns.contact",
                    ),
                ),
                (
                    "registrar",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="netbox_dns.registrar",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "tech_c",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="netbox_dns.contact",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="tenancy.tenant",
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
    ]
