# Generated by Django 5.0.1 on 2024-02-12 14:49

from dns import name as dns_name

import django.core.validators
import django.db.models.deletion
import netbox_dns.fields.address
import netbox_dns.fields.network
import netbox_dns.fields.rfc2317
import taggit.managers
import utilities.json
from django.db import migrations, models

from netbox_dns.choices import RecordTypeChoices
from netbox_dns.utilities import arpa_to_prefix


def fqdn(record):
    if record.name == "@":
        return f"{record.zone.name}."

    return f"{record.name}.{record.zone.name}."


def address_from_name(record):
    prefix = arpa_to_prefix(fqdn(record))
    if prefix is not None:
        return prefix.ip

    return None


def update_ip_addresses(apps, schema_editor):
    Record = apps.get_model("netbox_dns", "Record")

    for record in Record.objects.filter(type=RecordTypeChoices.PTR):
        record.ip_address = address_from_name(record)
        record.save()

    for record in Record.objects.filter(
        type__in=(RecordTypeChoices.A, RecordTypeChoices.AAAA)
    ):
        record.ip_address = record.value
        record.save()


def update_record_fqdn(apps, schema_editor):
    Record = apps.get_model("netbox_dns", "Record")

    for record in Record.objects.filter(fqdn__isnull=True):
        zone = dns_name.from_text(record.zone.name, origin=dns_name.root)
        _fqdn = dns_name.from_text(record.name, origin=zone)

        record.fqdn = _fqdn.to_text()

        record.save()


class Migration(migrations.Migration):
    replaces = [
        ("netbox_dns", "0001_squashed_netbox_dns_0_15"),
        ("netbox_dns", "0020_netbox_3_4"),
        ("netbox_dns", "0021_record_ip_address"),
        ("netbox_dns", "0022_search"),
        ("netbox_dns", "0023_alter_record_value"),
        ("netbox_dns", "0024_tenancy"),
        ("netbox_dns", "0025_ipam_coupling_cf"),
        ("netbox_dns", "0026_domain_registration"),
        ("netbox_dns", "0027_alter_registrar_iana_id"),
        ("netbox_dns", "0028_rfc2317_fields"),
        ("netbox_dns", "0029_record_fqdn"),
    ]

    initial = True

    dependencies = [
        ("extras", "0073_journalentry_tags_custom_fields"),
        ("ipam", "0066_iprange_mark_utilized"),
        ("tenancy", "0010_tenant_relax_uniqueness"),
    ]

    operations = [
        migrations.CreateModel(
            name="NameServer",
            fields=[
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
            ],
            options={
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="View",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
            ],
            options={
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="Zone",
            fields=[
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "status",
                    models.CharField(blank=True, default="active", max_length=50),
                ),
                (
                    "nameservers",
                    models.ManyToManyField(
                        blank=True, related_name="zones", to="netbox_dns.nameserver"
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "view",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="netbox_dns.view",
                    ),
                ),
                (
                    "default_ttl",
                    models.PositiveIntegerField(
                        blank=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                    ),
                ),
                (
                    "soa_expire",
                    models.PositiveIntegerField(
                        validators=[django.core.validators.MinValueValidator(1)]
                    ),
                ),
                (
                    "soa_minimum",
                    models.PositiveIntegerField(
                        validators=[django.core.validators.MinValueValidator(1)]
                    ),
                ),
                (
                    "soa_mname",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="zones_soa",
                        to="netbox_dns.nameserver",
                    ),
                ),
                (
                    "soa_refresh",
                    models.PositiveIntegerField(
                        validators=[django.core.validators.MinValueValidator(1)]
                    ),
                ),
                (
                    "soa_retry",
                    models.PositiveIntegerField(
                        validators=[django.core.validators.MinValueValidator(1)]
                    ),
                ),
                ("soa_rname", models.CharField(max_length=255)),
                (
                    "soa_serial",
                    models.BigIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(4294967295),
                        ],
                    ),
                ),
                (
                    "soa_ttl",
                    models.PositiveIntegerField(
                        validators=[django.core.validators.MinValueValidator(1)]
                    ),
                ),
                ("soa_serial_auto", models.BooleanField(default=True)),
                (
                    "arpa_network",
                    netbox_dns.fields.network.NetworkField(blank=True, null=True),
                ),
            ],
            options={
                "ordering": ("view", "name"),
                "unique_together": {("view", "name")},
            },
        ),
        migrations.CreateModel(
            name="Record",
            fields=[
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("type", models.CharField(max_length=10)),
                ("name", models.CharField(max_length=255)),
                ("value", models.CharField(max_length=1000)),
                ("ttl", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "zone",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="netbox_dns.zone",
                    ),
                ),
                ("status", models.CharField(default="active", max_length=50)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("managed", models.BooleanField(default=False)),
                ("disable_ptr", models.BooleanField(default=False)),
                (
                    "ptr_record",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="address_record",
                        to="netbox_dns.record",
                    ),
                ),
                (
                    "ip_address",
                    netbox_dns.fields.address.AddressField(blank=True, null=True),
                ),
            ],
            options={
                "ordering": ("zone", "name", "type", "value", "status"),
            },
        ),
        migrations.AlterField(
            model_name="record",
            name="value",
            field=models.CharField(max_length=65535),
        ),
        migrations.AddField(
            model_name="nameserver",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="netbox_dns_nameservers",
                to="tenancy.tenant",
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="netbox_dns_records",
                to="tenancy.tenant",
            ),
        ),
        migrations.AddField(
            model_name="view",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="netbox_dns_views",
                to="tenancy.tenant",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="netbox_dns_zones",
                to="tenancy.tenant",
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="ipam_ip_address",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="netbox_dns_records",
                to="ipam.ipaddress",
            ),
        ),
        migrations.CreateModel(
            name="Registrar",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("iana_id", models.IntegerField(blank=True, null=True)),
                ("referral_url", models.URLField(blank=True, max_length=255)),
                ("whois_server", models.CharField(blank=True, max_length=255)),
                ("address", models.CharField(blank=True, max_length=200)),
                ("abuse_email", models.EmailField(blank=True, max_length=254)),
                ("abuse_phone", models.CharField(blank=True, max_length=50)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "ordering": ("name", "iana_id"),
            },
        ),
        migrations.CreateModel(
            name="Contact",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=100)),
                ("contact_id", models.CharField(max_length=50, unique=True)),
                ("organization", models.CharField(blank=True, max_length=200)),
                ("street", models.CharField(blank=True, max_length=50)),
                ("city", models.CharField(blank=True, max_length=50)),
                ("state_province", models.CharField(blank=True, max_length=255)),
                ("postal_code", models.CharField(blank=True, max_length=20)),
                ("country", models.CharField(blank=True, max_length=2)),
                ("phone", models.CharField(blank=True, max_length=50)),
                ("phone_ext", models.CharField(blank=True, max_length=50)),
                ("fax", models.CharField(blank=True, max_length=50)),
                ("fax_ext", models.CharField(blank=True, max_length=50)),
                ("email", models.EmailField(blank=True, max_length=254)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "ordering": ("name", "contact_id"),
            },
        ),
        migrations.AddField(
            model_name="zone",
            name="admin_c",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="admin_c_zones",
                to="netbox_dns.contact",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="billing_c",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="billing_c_zones",
                to="netbox_dns.contact",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="registrant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="netbox_dns.contact",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="registrar",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="netbox_dns.registrar",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="registry_domain_id",
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name="zone",
            name="tech_c",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="tech_c_zones",
                to="netbox_dns.contact",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="rfc2317_prefix",
            field=netbox_dns.fields.rfc2317.RFC2317NetworkField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="zone",
            name="rfc2317_parent_managed",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="zone",
            name="rfc2317_parent_zone",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="rfc2317_child_zones",
                to="netbox_dns.zone",
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="rfc2317_cname_record",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="rfc2317_ptr_records",
                to="netbox_dns.record",
            ),
        ),
        migrations.RunPython(update_ip_addresses),
        migrations.AddField(
            model_name="record",
            name="fqdn",
            field=models.CharField(default=None, max_length=255, null=True, blank=True),
        ),
        migrations.RunPython(update_record_fqdn),
    ]
