from typing import *
from .lexer import *

class AST(object):
    pass


class Pointer(AST):
    def __init__(self, target: str) -> None:
        self.target = target
    
    def __repr__(self) -> str:
        return f"{self.__class__.__qualname__}(target={self.target!r})"


class StatementPointer(Pointer):
    pass


class TokenPointer(Pointer):
    pass


class Expr(AST):
    pass


class ExprList(AST):
    def __init__(self, exprs) -> None:
        self.exprs = exprs
    
    def __repr__(self) -> str:
        return f"{self.__class__.__qualname__}(exprs={self.exprs!r})"


class Quantifier(Expr):
    def __init__(self, expr: Expr) -> None:
        self.expr = expr
    
    def __repr__(self) -> str:
        return f"{self.__class__.__qualname__}(expr={self.expr!r})"


class ZeroOrMore(Quantifier):
    pass


class OneOrMore(Quantifier):
    pass


class ZeroOrOne(Quantifier):
    pass


class OrOp(Expr):
    def __init__(self, exprs: List[Expr]) -> None:
        self.exprs = exprs
    
    def __repr__(self) -> str:
        return f"{self.__class__.__qualname__}(exprs={self.exprs!r})"


class NamedItem(Expr):
    def __init__(self, name: str, expr: Expr) -> None:
        self.name = name
        self.expr = expr

    def __repr__(self) -> str:
        return f"{self.__class__.__qualname__}(name={self.name!r}, expr={self.expr!r})"


class Statement(object):
    def __init__(self, name: str, grammar: List[Expr], action=None) -> None:
        self.name = name
        self.grammar = grammar
        self.action = action
    
    def __repr__(self) -> str:
        return f"{self.__class__.__qualname__}(name={self.name!r}, grammar={self.grammar!r})"




class GrammarLexer(Lexer):
    ID =        r"[a-z0-9_]+"
    TOKEN =     r"[A-Z0-9_]+"
    COLON =     r"\:"
    OR =        r"\|"
    STAR =      r"\*"
    PLUS =      r"\+"
    QMARK =     r"\?"
    LPAREN =    r"\("
    RPAREN =    r"\)"
    TERMINATE = r";"
    EQ        = r"="
    @token(r"\{[\s\S]+?\}")
    def ACTION(self, t):
        t.value = t.value[1:-1].strip()
        return t
    
    ignore = " \t\n"


# refer to metagrammar.gram
# Code @generated by parsergen; do not edit!
from parsergen.parser_utils import GeneratedParser, TokenStream, Node, Filler
from parsergen.parser_utils import memoize, memoize_left_rec
from functools import reduce

class CustomParser(GeneratedParser):
    @memoize
    def statement_list(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self._loop_0()
            if not self.match(part): break
            parts.append(part)
            part = self.expect('EOF')
            if not self.match(part): break
            parts.append(part)
            # match:
            s = parts[0]
            return s
        self.goto(pos)

        return None

    def _loop_0(self):
        children = []
        while True:
            pos = self.mark()
            part = self.statement()
            if self.match(part): children.append(part)
            else:
                self.goto(pos)
                break
        return children
    @memoize
    def statement(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self._maybe_1()
            if not self.match(part): break
            parts.append(part)
            part = self._loop_2()
            if not self.match(part): break
            parts.append(part)
            part = self._maybe_3()
            if not self.match(part): break
            parts.append(part)
            part = self.expect('TERMINATE')
            if not self.match(part): break
            parts.append(part)
            # match:
            n = parts[0]
            es = parts[1]
            a = parts[2]
            return Statement(
                n[0].value if not isinstance(n, Filler) and not isinstance(n[0], Filler) else "<>",
                es,
                action=a.value if not isinstance(a, Filler) else None
            )
        self.goto(pos)

        return None

    def _maybe_1(self):
        pos = self.mark()
        part = self._expr_list_4()
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    def _expr_list_4(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self._maybe_5()
            if not self.match(part): break
            parts.append(part)
            part = self.expect('COLON')
            if not self.match(part): break
            parts.append(part)
            return parts
        self.goto(pos)
        return None
    def _maybe_5(self):
        pos = self.mark()
        part = self.expect('ID')
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    def _loop_2(self):
        children = []
        while True:
            pos = self.mark()
            part = self.expr()
            if self.match(part): children.append(part)
            else:
                self.goto(pos)
                break
        return children
    def _maybe_3(self):
        pos = self.mark()
        part = self.expect('ACTION')
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    @memoize_left_rec
    def expr_list(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self._loop_6()
            if not self.match(part): break
            parts.append(part)
            # match:
            es = parts[0]
            return ExprList(es)
        self.goto(pos)

        return None

    def _loop_6(self):
        children = []
        while True:
            pos = self.mark()
            part = self.expr()
            if self.match(part): children.append(part)
            else:
                self.goto(pos)
                break
        return children
    @memoize_left_rec
    def expr(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self._maybe_7()
            if not self.match(part): break
            parts.append(part)
            part = self.prec4()
            if not self.match(part): break
            parts.append(part)
            # match:
            name = parts[0]
            v = parts[1]
            return NamedItem(name[0].value, v) if not isinstance(name, Filler) else v
        self.goto(pos)

        return None

    def _maybe_7(self):
        pos = self.mark()
        part = self._expr_list_8()
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    def _expr_list_8(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.expect('ID')
            if not self.match(part): break
            parts.append(part)
            part = self.expect('EQ')
            if not self.match(part): break
            parts.append(part)
            return parts
        self.goto(pos)
        return None
    @memoize_left_rec
    def prec4(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.prec3()
            if not self.match(part): break
            parts.append(part)
            part = self._loop_9()
            if not self.match(part): break
            parts.append(part)
            # match:
            v = parts[0]
            others = parts[1]
            return OrOp(exprs=[v]+[o[1] for o in others]) if len(others) > 0 else v
        self.goto(pos)

        return None

    def _loop_9(self):
        children = []
        while True:
            pos = self.mark()
            part = self._expr_list_10()
            if self.match(part): children.append(part)
            else:
                self.goto(pos)
                break
        return children
    def _expr_list_10(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.expect('OR')
            if not self.match(part): break
            parts.append(part)
            part = self.prec3()
            if not self.match(part): break
            parts.append(part)
            return parts
        self.goto(pos)
        return None
    @memoize_left_rec
    def prec3(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.prec2()
            if not self.match(part): break
            parts.append(part)
            part = self._maybe_11()
            if not self.match(part): break
            parts.append(part)
            # match:
            v = parts[0]
            s = parts[1]
            return ZeroOrMore(v) if not isinstance(s, Filler) else v
        self.goto(pos)

        return None

    def _maybe_11(self):
        pos = self.mark()
        part = self.expect('STAR')
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    @memoize_left_rec
    def prec2(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.prec1()
            if not self.match(part): break
            parts.append(part)
            part = self._maybe_12()
            if not self.match(part): break
            parts.append(part)
            # match:
            v = parts[0]
            s = parts[1]
            return OneOrMore(v) if not isinstance(s, Filler) else v
        self.goto(pos)

        return None

    def _maybe_12(self):
        pos = self.mark()
        part = self.expect('PLUS')
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    @memoize_left_rec
    def prec1(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.factor()
            if not self.match(part): break
            parts.append(part)
            part = self._maybe_13()
            if not self.match(part): break
            parts.append(part)
            # match:
            v = parts[0]
            s = parts[1]
            return ZeroOrOne(v) if not isinstance(s, Filler) else v
        self.goto(pos)

        return None

    def _maybe_13(self):
        pos = self.mark()
        part = self.expect('QMARK')
        if self.match(part): return part
        self.goto(pos)
        return Filler()
    @memoize_left_rec
    def factor(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.item()
            if not self.match(part): break
            parts.append(part)
            # match:
            i = parts[0]
            return i
        self.goto(pos)

        parts = []
        for _ in range(1):
            part = self.expect('LPAREN')
            if not self.match(part): break
            parts.append(part)
            part = self.expr_list()
            if not self.match(part): break
            parts.append(part)
            part = self.expect('RPAREN')
            if not self.match(part): break
            parts.append(part)
            # match:
            es = parts[1]
            return es
        self.goto(pos)

        return None

    @memoize
    def item(self):
        pos = self.mark()
        parts = []
        for _ in range(1):
            part = self.expect('ID')
            if not self.match(part): break
            parts.append(part)
            # match:
            i = parts[0]
            return StatementPointer(i.value)
        self.goto(pos)

        parts = []
        for _ in range(1):
            part = self.expect('TOKEN')
            if not self.match(part): break
            parts.append(part)
            # match:
            i = parts[0]
            return TokenPointer(i.value)
        self.goto(pos)

        return None