# coding: utf-8

"""
    Aspose.PDF Cloud API Reference


Copyright (c) 2021 Aspose.PDF Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.



    OpenAPI spec version: 3.0
    
"""


from pprint import pformat
from six import iteritems
import re


class Bookmark(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'links': 'list[Link]',
        'title': 'str',
        'italic': 'bool',
        'bold': 'bool',
        'color': 'Color',
        'action': 'str',
        'level': 'int',
        'destination': 'str',
        'page_display': 'str',
        'page_display_bottom': 'int',
        'page_display_left': 'int',
        'page_display_right': 'int',
        'page_display_top': 'int',
        'page_display_zoom': 'int',
        'page_number': 'int',
        'remote_file': 'str',
        'bookmarks': 'Bookmarks'
    }

    attribute_map = {
        'links': 'Links',
        'title': 'Title',
        'italic': 'Italic',
        'bold': 'Bold',
        'color': 'Color',
        'action': 'Action',
        'level': 'Level',
        'destination': 'Destination',
        'page_display': 'PageDisplay',
        'page_display_bottom': 'PageDisplay_Bottom',
        'page_display_left': 'PageDisplay_Left',
        'page_display_right': 'PageDisplay_Right',
        'page_display_top': 'PageDisplay_Top',
        'page_display_zoom': 'PageDisplay_Zoom',
        'page_number': 'PageNumber',
        'remote_file': 'RemoteFile',
        'bookmarks': 'Bookmarks'
    }

    def __init__(self, links=None, title=None, italic=None, bold=None, color=None, action=None, level=None, destination=None, page_display=None, page_display_bottom=None, page_display_left=None, page_display_right=None, page_display_top=None, page_display_zoom=None, page_number=None, remote_file=None, bookmarks=None):
        """
        Bookmark - a model defined in Swagger
        """

        self._links = None
        self._title = None
        self._italic = None
        self._bold = None
        self._color = None
        self._action = None
        self._level = None
        self._destination = None
        self._page_display = None
        self._page_display_bottom = None
        self._page_display_left = None
        self._page_display_right = None
        self._page_display_top = None
        self._page_display_zoom = None
        self._page_number = None
        self._remote_file = None
        self._bookmarks = None

        if links is not None:
          self.links = links
        if title is not None:
          self.title = title
        if italic is not None:
          self.italic = italic
        if bold is not None:
          self.bold = bold
        if color is not None:
          self.color = color
        if action is not None:
          self.action = action
        if level is not None:
          self.level = level
        if destination is not None:
          self.destination = destination
        if page_display is not None:
          self.page_display = page_display
        if page_display_bottom is not None:
          self.page_display_bottom = page_display_bottom
        if page_display_left is not None:
          self.page_display_left = page_display_left
        if page_display_right is not None:
          self.page_display_right = page_display_right
        if page_display_top is not None:
          self.page_display_top = page_display_top
        if page_display_zoom is not None:
          self.page_display_zoom = page_display_zoom
        if page_number is not None:
          self.page_number = page_number
        if remote_file is not None:
          self.remote_file = remote_file
        if bookmarks is not None:
          self.bookmarks = bookmarks

    @property
    def links(self):
        """
        Gets the links of this Bookmark.
        Link to the document.

        :return: The links of this Bookmark.
        :rtype: list[Link]
        """
        return self._links

    @links.setter
    def links(self, links):
        """
        Sets the links of this Bookmark.
        Link to the document.

        :param links: The links of this Bookmark.
        :type: list[Link]
        """

        self._links = links

    @property
    def title(self):
        """
        Gets the title of this Bookmark.
        Get the Title;

        :return: The title of this Bookmark.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Bookmark.
        Get the Title;

        :param title: The title of this Bookmark.
        :type: str
        """

        self._title = title

    @property
    def italic(self):
        """
        Gets the italic of this Bookmark.
        Is bookmark italic.

        :return: The italic of this Bookmark.
        :rtype: bool
        """
        return self._italic

    @italic.setter
    def italic(self, italic):
        """
        Sets the italic of this Bookmark.
        Is bookmark italic.

        :param italic: The italic of this Bookmark.
        :type: bool
        """

        self._italic = italic

    @property
    def bold(self):
        """
        Gets the bold of this Bookmark.
        Is bookmark bold.

        :return: The bold of this Bookmark.
        :rtype: bool
        """
        return self._bold

    @bold.setter
    def bold(self, bold):
        """
        Sets the bold of this Bookmark.
        Is bookmark bold.

        :param bold: The bold of this Bookmark.
        :type: bool
        """

        self._bold = bold

    @property
    def color(self):
        """
        Gets the color of this Bookmark.
        Get the color

        :return: The color of this Bookmark.
        :rtype: Color
        """
        return self._color

    @color.setter
    def color(self, color):
        """
        Sets the color of this Bookmark.
        Get the color

        :param color: The color of this Bookmark.
        :type: Color
        """

        self._color = color

    @property
    def action(self):
        """
        Gets the action of this Bookmark.
        Gets or sets the action bound with the bookmark. If PageNumber is presented the action can not be specified. The action type includes: \"GoTo\", \"GoToR\", \"Launch\", \"Named\".

        :return: The action of this Bookmark.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this Bookmark.
        Gets or sets the action bound with the bookmark. If PageNumber is presented the action can not be specified. The action type includes: \"GoTo\", \"GoToR\", \"Launch\", \"Named\".

        :param action: The action of this Bookmark.
        :type: str
        """

        self._action = action

    @property
    def level(self):
        """
        Gets the level of this Bookmark.
        Gets or sets bookmark's hierarchy level.

        :return: The level of this Bookmark.
        :rtype: int
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this Bookmark.
        Gets or sets bookmark's hierarchy level.

        :param level: The level of this Bookmark.
        :type: int
        """

        self._level = level

    @property
    def destination(self):
        """
        Gets the destination of this Bookmark.
        Gets or sets bookmark's destination page. Required if action is set as string.Empty.

        :return: The destination of this Bookmark.
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this Bookmark.
        Gets or sets bookmark's destination page. Required if action is set as string.Empty.

        :param destination: The destination of this Bookmark.
        :type: str
        """

        self._destination = destination

    @property
    def page_display(self):
        """
        Gets the page_display of this Bookmark.
        Gets or sets the type of display bookmark's destination page.

        :return: The page_display of this Bookmark.
        :rtype: str
        """
        return self._page_display

    @page_display.setter
    def page_display(self, page_display):
        """
        Sets the page_display of this Bookmark.
        Gets or sets the type of display bookmark's destination page.

        :param page_display: The page_display of this Bookmark.
        :type: str
        """

        self._page_display = page_display

    @property
    def page_display_bottom(self):
        """
        Gets the page_display_bottom of this Bookmark.
        Gets or sets the bottom coordinate of page display.

        :return: The page_display_bottom of this Bookmark.
        :rtype: int
        """
        return self._page_display_bottom

    @page_display_bottom.setter
    def page_display_bottom(self, page_display_bottom):
        """
        Sets the page_display_bottom of this Bookmark.
        Gets or sets the bottom coordinate of page display.

        :param page_display_bottom: The page_display_bottom of this Bookmark.
        :type: int
        """

        self._page_display_bottom = page_display_bottom

    @property
    def page_display_left(self):
        """
        Gets the page_display_left of this Bookmark.
        Gets or sets the left coordinate of page display.

        :return: The page_display_left of this Bookmark.
        :rtype: int
        """
        return self._page_display_left

    @page_display_left.setter
    def page_display_left(self, page_display_left):
        """
        Sets the page_display_left of this Bookmark.
        Gets or sets the left coordinate of page display.

        :param page_display_left: The page_display_left of this Bookmark.
        :type: int
        """

        self._page_display_left = page_display_left

    @property
    def page_display_right(self):
        """
        Gets the page_display_right of this Bookmark.
        Gets or sets the right coordinate of page display.

        :return: The page_display_right of this Bookmark.
        :rtype: int
        """
        return self._page_display_right

    @page_display_right.setter
    def page_display_right(self, page_display_right):
        """
        Sets the page_display_right of this Bookmark.
        Gets or sets the right coordinate of page display.

        :param page_display_right: The page_display_right of this Bookmark.
        :type: int
        """

        self._page_display_right = page_display_right

    @property
    def page_display_top(self):
        """
        Gets the page_display_top of this Bookmark.
        Gets or sets the top coordinate of page display.

        :return: The page_display_top of this Bookmark.
        :rtype: int
        """
        return self._page_display_top

    @page_display_top.setter
    def page_display_top(self, page_display_top):
        """
        Sets the page_display_top of this Bookmark.
        Gets or sets the top coordinate of page display.

        :param page_display_top: The page_display_top of this Bookmark.
        :type: int
        """

        self._page_display_top = page_display_top

    @property
    def page_display_zoom(self):
        """
        Gets the page_display_zoom of this Bookmark.
        Gets or sets the zoom factor of page display.

        :return: The page_display_zoom of this Bookmark.
        :rtype: int
        """
        return self._page_display_zoom

    @page_display_zoom.setter
    def page_display_zoom(self, page_display_zoom):
        """
        Sets the page_display_zoom of this Bookmark.
        Gets or sets the zoom factor of page display.

        :param page_display_zoom: The page_display_zoom of this Bookmark.
        :type: int
        """

        self._page_display_zoom = page_display_zoom

    @property
    def page_number(self):
        """
        Gets the page_number of this Bookmark.
        Gets or sets the number of bookmark's destination page. 

        :return: The page_number of this Bookmark.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number):
        """
        Sets the page_number of this Bookmark.
        Gets or sets the number of bookmark's destination page. 

        :param page_number: The page_number of this Bookmark.
        :type: int
        """

        self._page_number = page_number

    @property
    def remote_file(self):
        """
        Gets the remote_file of this Bookmark.
        Gets or sets the file (path) which is required for \"GoToR\" action of bookmark.

        :return: The remote_file of this Bookmark.
        :rtype: str
        """
        return self._remote_file

    @remote_file.setter
    def remote_file(self, remote_file):
        """
        Sets the remote_file of this Bookmark.
        Gets or sets the file (path) which is required for \"GoToR\" action of bookmark.

        :param remote_file: The remote_file of this Bookmark.
        :type: str
        """

        self._remote_file = remote_file

    @property
    def bookmarks(self):
        """
        Gets the bookmarks of this Bookmark.
        The children bookmarks.

        :return: The bookmarks of this Bookmark.
        :rtype: Bookmarks
        """
        return self._bookmarks

    @bookmarks.setter
    def bookmarks(self, bookmarks):
        """
        Sets the bookmarks of this Bookmark.
        The children bookmarks.

        :param bookmarks: The bookmarks of this Bookmark.
        :type: Bookmarks
        """

        self._bookmarks = bookmarks

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Bookmark):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
