"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const acm = require("@aws-cdk/aws-certificatemanager");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const laravel_1 = require("./laravel");
const app = new cdk.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new cdk.Stack(app, 'demo-laravel', { env });
const certArn = stack.node.tryGetContext('ACM_CERT_ARN');
const cert = certArn ? acm.Certificate.fromCertificateArn(stack, 'Cert', certArn) : undefined;
const vpc = getOrCreateVpc(stack);
/**
 * laravel-nginx-php-fpm
 */
new laravel_1.Laravel(stack, 'LaravelNginxDemo', {
    vpc,
    auroraServerless: true,
    spot: true,
    enableExecuteCommand: true,
    code: path.join(__dirname, '../services/laravel-nginx-php-fpm'),
    loadbalancer: cert ? { port: 443, certificate: [cert] } : { port: 80 },
    efsFileSystem: {
        vpc,
        removalPolicy: cdk.RemovalPolicy.DESTROY,
    },
});
/**
 * laravel-bitnami
 */
new laravel_1.Laravel(stack, 'LaravelBitnamiDemo', {
    vpc,
    auroraServerless: true,
    spot: true,
    enableExecuteCommand: true,
    code: path.join(__dirname, '../services/laravel-bitnami'),
    containerPort: 3000,
    loadbalancer: cert ? { port: 443, certificate: [cert] } : { port: 80 },
    efsFileSystem: {
        vpc,
        removalPolicy: cdk.RemovalPolicy.DESTROY,
    },
});
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1'
        || process.env.CDK_USE_DEFAULT_VPC === '1' ? ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubGFyYXZlbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5sYXJhdmVsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkJBQTZCO0FBQzdCLHVEQUF1RDtBQUN2RCx3Q0FBd0M7QUFDeEMscUNBQXFDO0FBQ3JDLHVDQUFvQztBQUVwQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQjtJQUN0QyxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUI7Q0FDekMsQ0FBQztBQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsY0FBYyxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUMxRCxNQUFNLE9BQU8sR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsQ0FBQztBQUN6RCxNQUFNLElBQUksR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0FBQzlGLE1BQU0sR0FBRyxHQUFHLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUVsQzs7R0FFRztBQUNILElBQUksaUJBQU8sQ0FBQyxLQUFLLEVBQUUsa0JBQWtCLEVBQUU7SUFDckMsR0FBRztJQUNILGdCQUFnQixFQUFFLElBQUk7SUFDdEIsSUFBSSxFQUFFLElBQUk7SUFDVixvQkFBb0IsRUFBRSxJQUFJO0lBQzFCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxtQ0FBbUMsQ0FBQztJQUMvRCxZQUFZLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxHQUFHLEVBQUUsV0FBVyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsRUFBRSxFQUFFO0lBQ3RFLGFBQWEsRUFBRTtRQUNiLEdBQUc7UUFDSCxhQUFhLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxPQUFPO0tBQ3pDO0NBQ0YsQ0FBQyxDQUFDO0FBR0g7O0dBRUc7QUFDSCxJQUFJLGlCQUFPLENBQUMsS0FBSyxFQUFFLG9CQUFvQixFQUFFO0lBQ3ZDLEdBQUc7SUFDSCxnQkFBZ0IsRUFBRSxJQUFJO0lBQ3RCLElBQUksRUFBRSxJQUFJO0lBQ1Ysb0JBQW9CLEVBQUUsSUFBSTtJQUMxQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsNkJBQTZCLENBQUM7SUFDekQsYUFBYSxFQUFFLElBQUk7SUFDbkIsWUFBWSxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsR0FBRyxFQUFFLFdBQVcsRUFBRSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsSUFBSSxFQUFFLEVBQUUsRUFBRTtJQUN0RSxhQUFhLEVBQUU7UUFDYixHQUFHO1FBQ0gsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTztLQUN6QztDQUNGLENBQUMsQ0FBQztBQUdILFNBQVMsY0FBYyxDQUFDLEtBQW9CO0lBQzFDLDBDQUEwQztJQUMxQyxPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGlCQUFpQixDQUFDLEtBQUssR0FBRztXQUNyRCxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFtQixLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDcEcsS0FBSyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztZQUN0QyxHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEVBQUUsS0FBSyxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1lBQ3JGLElBQUksR0FBRyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxXQUFXLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUMvRCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGFjbSBmcm9tICdAYXdzLWNkay9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcbmltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IExhcmF2ZWwgfSBmcm9tICcuL2xhcmF2ZWwnO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBlbnYgPSB7XG4gIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OLFxuICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxufTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2RlbW8tbGFyYXZlbCcsIHsgZW52IH0pO1xuY29uc3QgY2VydEFybiA9IHN0YWNrLm5vZGUudHJ5R2V0Q29udGV4dCgnQUNNX0NFUlRfQVJOJyk7XG5jb25zdCBjZXJ0ID0gY2VydEFybiA/IGFjbS5DZXJ0aWZpY2F0ZS5mcm9tQ2VydGlmaWNhdGVBcm4oc3RhY2ssICdDZXJ0JywgY2VydEFybikgOiB1bmRlZmluZWQ7XG5jb25zdCB2cGMgPSBnZXRPckNyZWF0ZVZwYyhzdGFjayk7XG5cbi8qKlxuICogbGFyYXZlbC1uZ2lueC1waHAtZnBtXG4gKi9cbm5ldyBMYXJhdmVsKHN0YWNrLCAnTGFyYXZlbE5naW54RGVtbycsIHtcbiAgdnBjLFxuICBhdXJvcmFTZXJ2ZXJsZXNzOiB0cnVlLFxuICBzcG90OiB0cnVlLFxuICBlbmFibGVFeGVjdXRlQ29tbWFuZDogdHJ1ZSxcbiAgY29kZTogcGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL3NlcnZpY2VzL2xhcmF2ZWwtbmdpbngtcGhwLWZwbScpLFxuICBsb2FkYmFsYW5jZXI6IGNlcnQgPyB7IHBvcnQ6IDQ0MywgY2VydGlmaWNhdGU6IFtjZXJ0XSB9IDogeyBwb3J0OiA4MCB9LFxuICBlZnNGaWxlU3lzdGVtOiB7XG4gICAgdnBjLFxuICAgIHJlbW92YWxQb2xpY3k6IGNkay5SZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gIH0sXG59KTtcblxuXG4vKipcbiAqIGxhcmF2ZWwtYml0bmFtaVxuICovXG5uZXcgTGFyYXZlbChzdGFjaywgJ0xhcmF2ZWxCaXRuYW1pRGVtbycsIHtcbiAgdnBjLFxuICBhdXJvcmFTZXJ2ZXJsZXNzOiB0cnVlLFxuICBzcG90OiB0cnVlLFxuICBlbmFibGVFeGVjdXRlQ29tbWFuZDogdHJ1ZSxcbiAgY29kZTogcGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL3NlcnZpY2VzL2xhcmF2ZWwtYml0bmFtaScpLFxuICBjb250YWluZXJQb3J0OiAzMDAwLFxuICBsb2FkYmFsYW5jZXI6IGNlcnQgPyB7IHBvcnQ6IDQ0MywgY2VydGlmaWNhdGU6IFtjZXJ0XSB9IDogeyBwb3J0OiA4MCB9LFxuICBlZnNGaWxlU3lzdGVtOiB7XG4gICAgdnBjLFxuICAgIHJlbW92YWxQb2xpY3k6IGNkay5SZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gIH0sXG59KTtcblxuXG5mdW5jdGlvbiBnZXRPckNyZWF0ZVZwYyhzY29wZTogY2RrLkNvbnN0cnVjdCk6IGVjMi5JVnBjIHtcbiAgLy8gdXNlIGFuIGV4aXN0aW5nIHZwYyBvciBjcmVhdGUgYSBuZXcgb25lXG4gIHJldHVybiBzY29wZS5ub2RlLnRyeUdldENvbnRleHQoJ3VzZV9kZWZhdWx0X3ZwYycpID09PSAnMSdcbiAgICB8fCBwcm9jZXNzLmVudi5DREtfVVNFX0RFRkFVTFRfVlBDID09PSAnMScgPyBlYzIuVnBjLmZyb21Mb29rdXAoc2NvcGUsICdWcGMnLCB7IGlzRGVmYXVsdDogdHJ1ZSB9KSA6XG4gICAgc2NvcGUubm9kZS50cnlHZXRDb250ZXh0KCd1c2VfdnBjX2lkJykgP1xuICAgICAgZWMyLlZwYy5mcm9tTG9va3VwKHNjb3BlLCAnVnBjJywgeyB2cGNJZDogc2NvcGUubm9kZS50cnlHZXRDb250ZXh0KCd1c2VfdnBjX2lkJykgfSkgOlxuICAgICAgbmV3IGVjMi5WcGMoc2NvcGUsICdWcGMnLCB7IG1heEF6czogMywgbmF0R2F0ZXdheXM6IDEgfSk7XG59XG4iXX0=