import * as ec2 from '@aws-cdk/aws-ec2';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface DatabaseProps {
    /**
     * The VPC for the database.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * VPC subnets for database.
     *
     * @stability stable
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * The database instance type.
     *
     * @default r5.large
     * @stability stable
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The database instance engine.
     *
     * @default - MySQL 8.0.21
     * @stability stable
     */
    readonly instanceEngine?: rds.IInstanceEngine;
    /**
     * The database cluster engine.
     *
     * @default rds.AuroraMysqlEngineVersion.VER_2_09_1
     * @stability stable
     */
    readonly clusterEngine?: rds.IClusterEngine;
    /**
     * enable aurora serverless.
     *
     * @default false
     * @stability stable
     */
    readonly auroraServerless?: boolean;
    /**
     * Whether to use single RDS instance rather than RDS cluster.
     *
     * Not recommended for production.
     *
     * @default false
     * @stability stable
     */
    readonly singleDbInstance?: boolean;
    /**
     * database backup retension.
     *
     * @default - 7 days
     * @stability stable
     */
    readonly backupRetention?: cdk.Duration;
    /**
     * Allow database connection.
     *
     * @default - the whole VPC CIDR
     * @stability stable
     */
    readonly allowFrom?: ec2.IConnectable;
    /**
     * Default database name to create.
     *
     * @default - do not create any default database
     * @stability stable
     */
    readonly defaultDatabaseName?: string;
}
/**
 * Database configuration.
 *
 * @stability stable
 */
export interface DatabaseCofig {
    /**
     * The database secret.
     *
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * The database connnections.
     *
     * @stability stable
     */
    readonly connections: ec2.Connections;
    /**
     * The endpoint address for the database.
     *
     * @stability stable
     */
    readonly endpoint: string;
    /**
     * The databasae identifier.
     *
     * @stability stable
     */
    readonly identifier: string;
}
/**
 * Represents the database instance or database cluster.
 *
 * @stability stable
 */
export declare class Database extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly clusterEndpointHostname: string;
    /**
     * @stability stable
     */
    readonly clusterIdentifier: string;
    /**
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * @stability stable
     */
    readonly connections: ec2.Connections;
    private readonly _mysqlListenerPort;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
    private _createRdsInstance;
    private _createRdsCluster;
    private _createServerlessCluster;
}
