from sqlalchemy import Column, Sequence
from sqlalchemy.dialects.postgresql import DOUBLE_PRECISION, UUID, TIMESTAMP, TIME, SMALLINT
from sqlalchemy.types import VARCHAR, BIGINT, DATE, INTEGER, NUMERIC, BOOLEAN, TEXT
from base import PrimaryBase

class Simulations(PrimaryBase):
    __tablename__ = 'simulations'
    __table_args__ = {'schema': 'public'}
    
    id = Column(BIGINT, primary_key=True, autoincrement=True)
    project_id = Column(BIGINT, nullable=False, autoincrement=False)
    user_id = Column(BIGINT, nullable=False, autoincrement=False)
    name = Column(VARCHAR(191), autoincrement=False)
    rpt_name = Column(VARCHAR(191), autoincrement=False)
    status = Column(VARCHAR(30), autoincrement=False)
    message = Column(TEXT, autoincrement=False)
    analysis_begun_on = Column(VARCHAR(30), autoincrement=False)
    analysis_ended_on = Column(VARCHAR(30), autoincrement=False)
    inp_file = Column(VARCHAR(191), autoincrement=False)
    subcatchment_file = Column(VARCHAR(191), autoincrement=False)
    node_file = Column(VARCHAR(191), autoincrement=False)
    link_file = Column(VARCHAR(191), autoincrement=False)
    text_file = Column(VARCHAR(191), autoincrement=False)
    report_file = Column(VARCHAR(191), autoincrement=False)
    out_file = Column(VARCHAR(191), autoincrement=False)
    json_file = Column(VARCHAR(191), autoincrement=False)
    created_at = Column(TIMESTAMP, autoincrement=False)
    updated_at = Column(TIMESTAMP, autoincrement=False)
    reports_parser_status = Column(SMALLINT, nullable=False, autoincrement=False)
    links_parser_status = Column(SMALLINT, nullable=False, autoincrement=False)
    nodes_parser_status = Column(SMALLINT, nullable=False, autoincrement=False)
    subcatchments_parser_status = Column(SMALLINT, nullable=False, autoincrement=False)
    nodes = Column(INTEGER, nullable=False, autoincrement=False)
    links = Column(INTEGER, nullable=False, autoincrement=False)
    subcatchments = Column(INTEGER, nullable=False, autoincrement=False)
    nodes_inserted = Column(INTEGER, nullable=False, autoincrement=False)
    links_inserted = Column(INTEGER, nullable=False, autoincrement=False)
    subcatchments_inserted = Column(INTEGER, nullable=False, autoincrement=False)
    use_real_time_data = Column(VARCHAR(191), autoincrement=False)
    option_start_date_time = Column(TIMESTAMP, autoincrement=False)
    option_end_date_time = Column(TIMESTAMP, autoincrement=False)
    parsed_node_file = Column(VARCHAR(191), autoincrement=False)
    parsed_link_file = Column(VARCHAR(191), autoincrement=False)
    parsed_subcatchment_file = Column(VARCHAR(191), autoincrement=False)
    is_auto = Column(SMALLINT, autoincrement=False)
    node_geojson = Column(VARCHAR(191), autoincrement=False)
    link_geojson = Column(VARCHAR(191), autoincrement=False)
    subcatchment_geojson = Column(VARCHAR(191), autoincrement=False)
    group_name = Column(VARCHAR(191), autoincrement=False)
    forecast = Column(VARCHAR(191), autoincrement=False)
    hindcast = Column(VARCHAR(191), autoincrement=False)
    is_backtest = Column(INTEGER, autoincrement=False)
    floodplain_boundary_output = Column(VARCHAR(191), autoincrement=False)
    depth_raster_output = Column(VARCHAR(191), autoincrement=False)
    water_surface_elevation_raster_output = Column(VARCHAR(191), autoincrement=False)
    velocity_raster_output = Column(VARCHAR(191), autoincrement=False)
    flood_severity_raster_output = Column(VARCHAR(191), autoincrement=False)
    wms_url_fbo = Column(TEXT, autoincrement=False)
    wfs_url_fbo = Column(TEXT, autoincrement=False)
    wms_url_dro = Column(TEXT, autoincrement=False)
    wfs_url_dro = Column(TEXT, autoincrement=False)
    wms_url_wser = Column(TEXT, autoincrement=False)
    wfs_url_wser = Column(TEXT, autoincrement=False)
    wms_url_vro = Column(TEXT, autoincrement=False)
    wfs_url_vro = Column(TEXT, autoincrement=False)
    wms_url_fsro = Column(TEXT, autoincrement=False)
    wfs_url_fsro = Column(TEXT, autoincrement=False)
    vro_legend_url = Column(TEXT, autoincrement=False)
    dro_legend_url = Column(TEXT, autoincrement=False)
    fsro_legend_url = Column(TEXT, autoincrement=False)
    wser_legend_url = Column(TEXT, autoincrement=False)
    lof_nodes_completed = Column(INTEGER, autoincrement=False)
    lof_links_completed = Column(INTEGER, autoincrement=False)
    flooded_structures_path = Column(TEXT, autoincrement=False)
    flooded_roads_path = Column(TEXT, autoincrement=False)
    parsing_begun_on = Column(TIMESTAMP, autoincrement=False)
    parsing_ended_on = Column(TIMESTAMP, autoincrement=False)
    risk_map_status = Column(INTEGER, autoincrement=False)
    floodplain_status = Column(INTEGER, autoincrement=False)
    geoserver_status = Column(INTEGER, autoincrement=False)
    floodplain_intersection_status = Column(INTEGER, autoincrement=False)
    rainfall_event_id = Column(INTEGER, autoincrement=False)
