from sqlalchemy import Column, Sequence
from sqlalchemy.dialects.postgresql import DOUBLE_PRECISION, UUID, TIMESTAMP, TIME
from sqlalchemy.types import VARCHAR, BIGINT, DATE, INTEGER, NUMERIC, BOOLEAN, TEXT
from base import PrimaryBase

class Projects(PrimaryBase):
    __tablename__ = 'projects'
    __table_args__ = {'schema': 'public'}
    
    id = Column(BIGINT, primary_key=True, autoincrement=True)
    name = Column(VARCHAR(100), nullable=False, autoincrement=False)
    created_at = Column(TIMESTAMP, autoincrement=False)
    updated_at = Column(TIMESTAMP, autoincrement=False)
    projection = Column(INTEGER, autoincrement=False)
    type = Column(VARCHAR(10), autoincrement=False)
    map_lat = Column(VARCHAR(30), autoincrement=False)
    map_lng = Column(VARCHAR(30), autoincrement=False)
    map_zoom = Column(VARCHAR(30), autoincrement=False)
    map_id = Column(INTEGER, autoincrement=False)
    inp_uploaded_at = Column(TIMESTAMP, autoincrement=False)
    inp_processed_at = Column(TIMESTAMP, autoincrement=False)
    progress = Column(VARCHAR(255), autoincrement=False)
    group = Column(VARCHAR(20), nullable=False, autoincrement=False)
    lofp = Column(DOUBLE_PRECISION, autoincrement=False)
    cofp = Column(DOUBLE_PRECISION, autoincrement=False)
    copy_success = Column(INTEGER, autoincrement=False)
    imp_transpo = Column(VARCHAR(191), autoincrement=False)
    imp_fac = Column(VARCHAR(191), autoincrement=False)
    imp_util_gas = Column(VARCHAR(191), autoincrement=False)
    imp_util_electric = Column(VARCHAR(191), autoincrement=False)
    imp_util_cable = Column(VARCHAR(191), autoincrement=False)
    imp_util_internet = Column(VARCHAR(191), autoincrement=False)
    imp_util_water = Column(VARCHAR(191), autoincrement=False)
    imp_util_wastewater = Column(VARCHAR(191), autoincrement=False)
    imp_util_stormwater = Column(VARCHAR(191), autoincrement=False)
    imp_util_other1 = Column(VARCHAR(191), autoincrement=False)
    imp_util_other2 = Column(VARCHAR(191), autoincrement=False)
    tmdl_contrib = Column(VARCHAR(191), autoincrement=False)
    pipe_unit_cost = Column(VARCHAR(191), autoincrement=False)
    struc_unit_cost = Column(VARCHAR(191), autoincrement=False)
    preferred_simulator = Column(VARCHAR(191), autoincrement=False)
    settings = Column(TEXT, autoincrement=False)
    deleted_at = Column(TIMESTAMP, autoincrement=False)
    imp_layers = Column(VARCHAR(191), autoincrement=False)
    team_id = Column(VARCHAR(191), autoincrement=False)
    dem_file = Column(VARCHAR(191), autoincrement=False)
    use_risk_map = Column(VARCHAR(191), nullable=False, autoincrement=False)
    cof_counties_array = Column(TEXT, autoincrement=False)
    cof_model_array = Column(VARCHAR(191), autoincrement=False)
    cof_model_id = Column(INTEGER, autoincrement=False)
    lof_model_array = Column(VARCHAR(191), autoincrement=False)
    lof_model_id = Column(INTEGER, autoincrement=False)
    dwf_filter_by = Column(VARCHAR(191), autoincrement=False)
    dwf_start_date = Column(VARCHAR(191), autoincrement=False)
    dwf_end_date = Column(VARCHAR(191), autoincrement=False)
    dwf_model_id = Column(INTEGER, autoincrement=False)
    dwf_simulation_id = Column(INTEGER, autoincrement=False)
    wwf_filter_by = Column(VARCHAR(191), autoincrement=False)
    wwf_start_date = Column(INTEGER, autoincrement=False)
    wwf_end_date = Column(INTEGER, autoincrement=False)
    wwf_model_id = Column(INTEGER, autoincrement=False)
    wwf_event_id = Column(INTEGER, autoincrement=False)
    wwf_simulation_id = Column(INTEGER, autoincrement=False)
    rainfall_analysis_id_filter = Column(INTEGER, autoincrement=False)
    rainfall_analysis_gauge_id_filter = Column(INTEGER, autoincrement=False)
