from sqlalchemy import Column, Sequence
from sqlalchemy.dialects.postgresql import DOUBLE_PRECISION, UUID, TIMESTAMP, TIME
from sqlalchemy.types import VARCHAR, BIGINT, DATE, INTEGER, NUMERIC, BOOLEAN, TEXT
from base import PrimaryBase

class InpNaturalChannelAm(PrimaryBase):
    __tablename__ = 'inp_natural_channel_am'
    __table_args__ = {'schema': 'public'}
    
    id = Column(BIGINT, primary_key=True, autoincrement=True)
    city = Column(VARCHAR(191), autoincrement=False)
    name = Column(VARCHAR(191), autoincrement=False)
    is_ineligib = Column(VARCHAR(191), autoincrement=False)
    is_cond_est = Column(VARCHAR(191), autoincrement=False)
    source = Column(VARCHAR(191), autoincrement=False)
    comments = Column(VARCHAR(191), autoincrement=False)
    watershed_name = Column(VARCHAR(191), autoincrement=False)
    owner = Column(VARCHAR(191), autoincrement=False)
    ins_date = Column(DATE, autoincrement=False)
    shape = Column(VARCHAR(191), autoincrement=False)
    dim1 = Column(VARCHAR(191), autoincrement=False)
    dim2 = Column(VARCHAR(191), autoincrement=False)
    no_barrels = Column(VARCHAR(191), autoincrement=False)
    length = Column(VARCHAR(191), autoincrement=False)
    material = Column(VARCHAR(191), autoincrement=False)
    line_type = Column(VARCHAR(191), autoincrement=False)
    main_type = Column(VARCHAR(191), autoincrement=False)
    us_node = Column(VARCHAR(191), autoincrement=False)
    ds_node = Column(VARCHAR(191), autoincrement=False)
    dep_cover = Column(VARCHAR(191), autoincrement=False)
    us_inv_elev = Column(VARCHAR(191), autoincrement=False)
    ds_inv_elev = Column(VARCHAR(191), autoincrement=False)
    slope = Column(VARCHAR(191), autoincrement=False)
    jnt_type = Column(VARCHAR(191), autoincrement=False)
    asso_str = Column(VARCHAR(191), autoincrement=False)
    lat_con = Column(VARCHAR(191), autoincrement=False)
    bed_cond = Column(VARCHAR(191), autoincrement=False)
    trench_bf = Column(VARCHAR(191), autoincrement=False)
    des_life = Column(VARCHAR(191), autoincrement=False)
    des_storm = Column(VARCHAR(191), autoincrement=False)
    function = Column(VARCHAR(191), autoincrement=False)
    thickness = Column(VARCHAR(191), autoincrement=False)
    coating = Column(VARCHAR(191), autoincrement=False)
    lining = Column(VARCHAR(191), autoincrement=False)
    status = Column(VARCHAR(191), autoincrement=False)
    line_cond = Column(VARCHAR(191), autoincrement=False)
    ext_coat_cond = Column(VARCHAR(191), autoincrement=False)
    ht_bedding = Column(VARCHAR(191), autoincrement=False)
    des_str_pipe = Column(VARCHAR(191), autoincrement=False)
    pl_ins_date = Column(VARCHAR(191), autoincrement=False)
    ext_coat_age = Column(VARCHAR(191), autoincrement=False)
    pipe_vint = Column(VARCHAR(191), autoincrement=False)
    pipe_class = Column(VARCHAR(191), autoincrement=False)
    a_struc_cond = Column(VARCHAR(191), autoincrement=False)
    dis_mater = Column(VARCHAR(191), autoincrement=False)
    pg_full_len = Column(VARCHAR(191), autoincrement=False)
    soil_type = Column(VARCHAR(191), autoincrement=False)
    gw_table = Column(VARCHAR(191), autoincrement=False)
    location = Column(VARCHAR(191), autoincrement=False)
    dead_load = Column(VARCHAR(191), autoincrement=False)
    live_load = Column(VARCHAR(191), autoincrement=False)
    av_preci_int = Column(VARCHAR(191), autoincrement=False)
    av_preci_dur = Column(VARCHAR(191), autoincrement=False)
    frost_pen = Column(VARCHAR(191), autoincrement=False)
    s_corro = Column(VARCHAR(191), autoincrement=False)
    near_trees = Column(VARCHAR(191), autoincrement=False)
    pipe_dir = Column(VARCHAR(191), autoincrement=False)
    ext_temp = Column(VARCHAR(191), autoincrement=False)
    his_ext_eve = Column(VARCHAR(191), autoincrement=False)
    catch_area = Column(VARCHAR(191), autoincrement=False)
    ws_int = Column(VARCHAR(191), autoincrement=False)
    wet_dry_cyc = Column(VARCHAR(191), autoincrement=False)
    nn_homo_soil = Column(VARCHAR(191), autoincrement=False)
    aci_runoff = Column(VARCHAR(191), autoincrement=False)
    soil_res = Column(VARCHAR(191), autoincrement=False)
    soil_dis = Column(VARCHAR(191), autoincrement=False)
    soil_sul = Column(VARCHAR(191), autoincrement=False)
    soil_ph = Column(VARCHAR(191), autoincrement=False)
    soil_moi_ret = Column(VARCHAR(191), autoincrement=False)
    st_curr = Column(VARCHAR(191), autoincrement=False)
    tidal_inf = Column(VARCHAR(191), autoincrement=False)
    av_flow_vel = Column(VARCHAR(191), autoincrement=False)
    min_flow_vel = Column(VARCHAR(191), autoincrement=False)
    max_flow_vel = Column(VARCHAR(191), autoincrement=False)
    ave_pres = Column(VARCHAR(191), autoincrement=False)
    min_pres = Column(VARCHAR(191), autoincrement=False)
    max_pres = Column(VARCHAR(191), autoincrement=False)
    known_leak = Column(VARCHAR(191), autoincrement=False)
    of_freq = Column(VARCHAR(191), autoincrement=False)
    surcharge = Column(VARCHAR(191), autoincrement=False)
    inflow_infil = Column(VARCHAR(191), autoincrement=False)
    exfiltration = Column(VARCHAR(191), autoincrement=False)
    deb_level = Column(VARCHAR(191), autoincrement=False)
    sed_level = Column(VARCHAR(191), autoincrement=False)
    smell_level = Column(VARCHAR(191), autoincrement=False)
    stag_water = Column(VARCHAR(191), autoincrement=False)
    flooding = Column(VARCHAR(191), autoincrement=False)
    dep_by_dia = Column(VARCHAR(191), autoincrement=False)
    maint_fre = Column(VARCHAR(191), autoincrement=False)
    vel_flow_spl = Column(VARCHAR(191), autoincrement=False)
    outlet_prot = Column(VARCHAR(191), autoincrement=False)
    conv_cap = Column(VARCHAR(191), autoincrement=False)
    mode_res_av = Column(VARCHAR(191), autoincrement=False)
    res_2yr = Column(VARCHAR(191), autoincrement=False)
    res_5yr = Column(VARCHAR(191), autoincrement=False)
    res_10yr = Column(VARCHAR(191), autoincrement=False)
    res_25yr = Column(VARCHAR(191), autoincrement=False)
    res_50yr = Column(VARCHAR(191), autoincrement=False)
    res_100yr = Column(VARCHAR(191), autoincrement=False)
    res_500yr = Column(VARCHAR(191), autoincrement=False)
    lt_sim_res = Column(VARCHAR(191), autoincrement=False)
    pacp_cond = Column(VARCHAR(191), autoincrement=False)
    mt_rec = Column(VARCHAR(191), autoincrement=False)
    cctv_rec = Column(VARCHAR(191), autoincrement=False)
    ren_rec = Column(VARCHAR(191), autoincrement=False)
    fail_rec = Column(VARCHAR(191), autoincrement=False)
    comp_rec = Column(VARCHAR(191), autoincrement=False)
    cap_cost = Column(VARCHAR(191), autoincrement=False)
    yr_om_cost = Column(VARCHAR(191), autoincrement=False)
    con_spec = Column(VARCHAR(191), autoincrement=False)
    lof = Column(VARCHAR(191), autoincrement=False)
    eco_imp = Column(VARCHAR(191), autoincrement=False)
    trans_imp = Column(VARCHAR(191), autoincrement=False)
    crit_imp = Column(VARCHAR(191), autoincrement=False)
    utility_imp = Column(VARCHAR(191), autoincrement=False)
    tmdl_imp = Column(VARCHAR(191), autoincrement=False)
    under_pave = Column(VARCHAR(191), autoincrement=False)
    proxi_rail = Column(VARCHAR(191), autoincrement=False)
    repl_cost = Column(VARCHAR(191), autoincrement=False)
    cof = Column(VARCHAR(191), autoincrement=False)
    bre = Column(VARCHAR(191), autoincrement=False)
    cip_id = Column(VARCHAR(191), autoincrement=False)
    max_allow_vel = Column(VARCHAR(191), autoincrement=False)
    max_allow_pres = Column(VARCHAR(191), autoincrement=False)
    mt_score = Column(VARCHAR(191), autoincrement=False)
    vs_inspect_rec = Column(VARCHAR(191), autoincrement=False)
    vs_inspect_score = Column(VARCHAR(191), autoincrement=False)
    em_inspect_rec = Column(VARCHAR(191), autoincrement=False)
    em_inspect_score = Column(VARCHAR(191), autoincrement=False)
    cctv_score = Column(VARCHAR(191), autoincrement=False)
    ac_inspect_rec = Column(VARCHAR(191), autoincrement=False)
    ac_inspect_score = Column(VARCHAR(191), autoincrement=False)
    ultra_test_rec = Column(VARCHAR(191), autoincrement=False)
    ultra_test_score = Column(VARCHAR(191), autoincrement=False)
    pipe_map_rec = Column(VARCHAR(191), autoincrement=False)
    pipe_map_score = Column(VARCHAR(191), autoincrement=False)
    radio_test_rec = Column(VARCHAR(191), autoincrement=False)
    radio_test_score = Column(VARCHAR(191), autoincrement=False)
    thermo_test_rec = Column(VARCHAR(191), autoincrement=False)
    thermo_test_score = Column(VARCHAR(191), autoincrement=False)
    other_test_rec = Column(VARCHAR(191), autoincrement=False)
    other_test_score = Column(VARCHAR(191), autoincrement=False)
    ren_score = Column(VARCHAR(191), autoincrement=False)
    fail_score = Column(VARCHAR(191), autoincrement=False)
    comp_score = Column(VARCHAR(191), autoincrement=False)
    rem_use_life = Column(VARCHAR(191), autoincrement=False)
    watershed_id = Column(VARCHAR(191), autoincrement=False)
    huc_12_id = Column(VARCHAR(191), autoincrement=False)
    land_use = Column(VARCHAR(191), autoincrement=False)
    tree_canopy = Column(VARCHAR(191), autoincrement=False)
    last_inspection_date = Column(VARCHAR(191), autoincrement=False)
    construction_performance_index = Column(VARCHAR(191), autoincrement=False)
    mukey = Column(VARCHAR(191), autoincrement=False)
    cond_comments = Column(VARCHAR(191), autoincrement=False)
    flow_area = Column(VARCHAR(191), autoincrement=False)
    proxi_road = Column(VARCHAR(191), autoincrement=False)
    proxi_gas = Column(VARCHAR(191), autoincrement=False)
    proxi_elec = Column(VARCHAR(191), autoincrement=False)
    severity_imp = Column(VARCHAR(191), autoincrement=False)
    usnodeid = Column(VARCHAR(191), autoincrement=False)
    dsnodeid = Column(VARCHAR(191), autoincrement=False)
    pred_dsinvelev = Column(VARCHAR(191), autoincrement=False)
    pred_usinvelev = Column(VARCHAR(191), autoincrement=False)
    pred_material = Column(VARCHAR(191), autoincrement=False)
    pred_dim1 = Column(VARCHAR(191), autoincrement=False)
    pred_dim2 = Column(VARCHAR(191), autoincrement=False)
    pred_lineshape = Column(VARCHAR(191), autoincrement=False)
    pred_nobarrels = Column(VARCHAR(191), autoincrement=False)
    project_id = Column(INTEGER, autoincrement=False)
    neerstndstr = Column(VARCHAR(191), autoincrement=False)
    is_pred_material = Column(VARCHAR(191), autoincrement=False)
    pred_ds_inv_elev = Column(VARCHAR(191), autoincrement=False)
    is_pred_dsinvelev = Column(VARCHAR(191), autoincrement=False)
    pred_us_inv_elev = Column(VARCHAR(191), autoincrement=False)
    is_pred_usinvelev = Column(VARCHAR(191), autoincrement=False)
    pred_flow_area = Column(VARCHAR(191), autoincrement=False)
    is_pred_flow_area = Column(VARCHAR(191), autoincrement=False)
    enviro_imp = Column(INTEGER, autoincrement=False)
    lu_imp = Column(INTEGER, autoincrement=False)
    flood_risk = Column(NUMERIC(8, 2), autoincrement=False)
    stream_risk = Column(NUMERIC(8, 2), autoincrement=False)
    storm_sewer_risk = Column(NUMERIC(8, 2), autoincrement=False)
    groundwater_index_risk = Column(NUMERIC(8, 2), autoincrement=False)
    infiltration_risk = Column(NUMERIC(8, 2), autoincrement=False)
    inflow_risk = Column(NUMERIC(8, 2), autoincrement=False)
    basin_index_risk = Column(NUMERIC(8, 2), autoincrement=False)
    rehab = Column(BOOLEAN, autoincrement=False)
    rehab_date = Column(DATE, autoincrement=False)
    rehab_material = Column(VARCHAR(191), autoincrement=False)
    condition_date = Column(DATE, autoincrement=False)
    is_pred_dim1 = Column(VARCHAR(191), autoincrement=False)
    state = Column(VARCHAR(191), autoincrement=False)
    account_id = Column(VARCHAR(191), autoincrement=False)
    rehab_action = Column(VARCHAR(191), autoincrement=False)
    frost_depth = Column(DOUBLE_PRECISION, autoincrement=False)
    gr_water_lvl_frm_land_surf = Column(DOUBLE_PRECISION, autoincrement=False)
    county = Column(VARCHAR(191), autoincrement=False)
    country = Column(VARCHAR(191), autoincrement=False)
    gr_water_station_url = Column(TEXT, autoincrement=False)
    pred_ins_date = Column(VARCHAR(191), autoincrement=False)
    is_pred_ins_date = Column(VARCHAR(191), autoincrement=False)
    asset_name = Column(VARCHAR(191), autoincrement=False)
