# Vesicash Python SDK v1.0.0
![Vesicash Logo](https://trizact.vesicash.com/assets/image/vesi-logo.png)
## Table Of Contents
1. Installation
2. Usage
3. Available Services
4. Contribution
5. Bug Reporting

### 1.Installation
```pip install vesicashapi```

### 2. Usage
# Create Transaction
```from vesicashapi.transactions import Transactions

transaction = Transactions.create(
    title="Purchase Of An Iphone",
    type="oneoff",
    quantity=1,
    amount=20000,
    description="Iphone Purchase",
    parties={
        'sender': 5841206525,
        'recipient': 9432695230,
        'buyer': 5841206525,
        'seller': 9432695230,
        'charge_bearer': 5841206525
    },
    inspection_period=1,
    due_date="2/12/2020",
    currency="NGN"
)

print(transaction)`

# Login / Sign Up
`from vesicashapi.auth import Auth

"""
Login example
"""

login = Auth.login(
    username="precious@vesicash.com",
    password="test"
)

print(login)

"""
Sign up example
"""

signup = Auth.signup(
    email_address="precious@vesicash.com",
    password="test"
)

print(signup)```

### 3. Available Services
1. Authentication
2. Admin
3. Transactions
4. Payment
5. Notifications
6. Upload
7. Subscription

### 4. Contribution
Make a pull request with detailed explanation of what got changed/improved/suggested.

### 5. Bug Reporting
Open an issue! Thanks.