# generated by datamodel-codegen:
#   filename:  journal.json
#   timestamp: 2022-05-24T09:26:50+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from easyDataverse.core import DataverseBase
from pydantic import Field


class TypeOfArticle(Enum):
    """
    Indicates what kind of article this is, for example, a research article, a commentary, a book or product review, a case report, a calendar, etc (based on JATS).
    """

    abstract = 'abstract'
    addendum = 'addendum'
    announcement = 'announcement'
    article_commentary = 'article-commentary'
    book_review = 'book review'
    books_received = 'books received'
    brief_report = 'brief report'
    calendar = 'calendar'
    case_report = 'case report'
    collection = 'collection'
    correction = 'correction'
    data_paper = 'data paper'
    discussion = 'discussion'
    dissertation = 'dissertation'
    editorial = 'editorial'
    in_brief = 'in brief'
    introduction = 'introduction'
    letter = 'letter'
    meeting_report = 'meeting report'
    news = 'news'
    obituary = 'obituary'
    oration = 'oration'
    partial_retraction = 'partial retraction'
    product_review = 'product review'
    rapid_communication = 'rapid communication'
    reply = 'reply'
    reprint = 'reprint'
    research_article = 'research article'
    retraction = 'retraction'
    review_article = 'review article'
    translation = 'translation'
    other = 'other'


class JournalData(DataverseBase):
    volume: Optional[str] = Field(
        None,
        description='The journal volume which this Dataset is associated with (e.g., Volume 4).',
        multiple=False,
        typeClass='primitive',
        typeName='journalVolume',
    )
    issue: Optional[str] = Field(
        None,
        description='The journal issue number which this Dataset is associated with (e.g., Number 2, Autumn).',
        multiple=False,
        typeClass='primitive',
        typeName='journalIssue',
    )
    publication_date: Optional[str] = Field(
        None,
        description='The publication date for this journal volume/issue, which this Dataset is associated with (e.g., 1999).',
        multiple=False,
        typeClass='primitive',
        typeName='journalPubDate',
    )


class Journal(DataverseBase):
    journal_data: List[JournalData] = Field(
        default_factory=list,
        description='Indicates the volume, issue and date of a journal, which this Dataset is associated with.',
        multiple=True,
        typeClass='compound',
        typeName='journalVolumeIssue',
    )
    type_of_article: Optional[TypeOfArticle] = Field(
        None,
        description='Indicates what kind of article this is, for example, a research article, a commentary, a book or product review, a case report, a calendar, etc (based on JATS). ',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='journalArticleType',
    )
    _metadatablock_name: Optional[str] = 'journal'


    def add_journal_data(
        self,
        volume: Optional[str] = None,
        issue: Optional[str] = None,
        publication_date: Optional[str] = None,
    ):
        """Function used to add an instance of JournalData to the metadatablock.

        Args:
        
            volume (string): The journal volume which this Dataset is associated with (e.g., Volume 4).
            issue (string): The journal issue number which this Dataset is associated with (e.g., Number 2, Autumn).
            publication_date (string): The publication date for this journal volume/issue, which this Dataset is associated with (e.g., 1999).

        """

        self.journal_data.append(
            JournalData(
                volume=volume, issue=issue, publication_date=publication_date
            )
        )
