# generated by datamodel-codegen:
#   filename:  geospatial.json
#   timestamp: 2022-05-24T09:26:50+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from easyDataverse.core import DataverseBase
from pydantic import Field


class CountryNation(Enum):
    """
    The country or nation that the Dataset is about.
    """

    afghanistan = 'Afghanistan'
    albania = 'Albania'
    algeria = 'Algeria'
    american__samoa = 'American Samoa'
    andorra = 'Andorra'
    angola = 'Angola'
    anguilla = 'Anguilla'
    antarctica = 'Antarctica'
    antigua_and__barbuda = 'Antigua and Barbuda'
    argentina = 'Argentina'
    armenia = 'Armenia'
    aruba = 'Aruba'
    australia = 'Australia'
    austria = 'Austria'
    azerbaijan = 'Azerbaijan'
    bahamas = 'Bahamas'
    bahrain = 'Bahrain'
    bangladesh = 'Bangladesh'
    barbados = 'Barbados'
    belarus = 'Belarus'
    belgium = 'Belgium'
    belize = 'Belize'
    benin = 'Benin'
    bermuda = 'Bermuda'
    bhutan = 'Bhutan'
    bolivia___plurinational__state_of = 'Bolivia, Plurinational State of'
    bonaire___sint__eustatius_and__saba = 'Bonaire, Sint Eustatius and Saba'
    bosnia_and__herzegovina = 'Bosnia and Herzegovina'
    botswana = 'Botswana'
    bouvet__island = 'Bouvet Island'
    brazil = 'Brazil'
    british__indian__ocean__territory = 'British Indian Ocean Territory'
    brunei__darussalam = 'Brunei Darussalam'
    bulgaria = 'Bulgaria'
    burkina__faso = 'Burkina Faso'
    burundi = 'Burundi'
    cambodia = 'Cambodia'
    cameroon = 'Cameroon'
    canada = 'Canada'
    cape__verde = 'Cape Verde'
    cayman__islands = 'Cayman Islands'
    central__african__republic = 'Central African Republic'
    chad = 'Chad'
    chile = 'Chile'
    china = 'China'
    christmas__island = 'Christmas Island'
    cocos___keeling___islands = 'Cocos (Keeling) Islands'
    colombia = 'Colombia'
    comoros = 'Comoros'
    congo = 'Congo'
    congo__the__democratic__republic_of_the = 'Congo, the Democratic Republic of the'
    cook__islands = 'Cook Islands'
    costa__rica = 'Costa Rica'
    croatia = 'Croatia'
    cuba = 'Cuba'
    curaçao = 'Curaçao'
    cyprus = 'Cyprus'
    czech__republic = 'Czech Republic'
    côte_d__ivoire = 'Côte d\'Ivoire'
    denmark = 'Denmark'
    djibouti = 'Djibouti'
    dominica = 'Dominica'
    dominican__republic = 'Dominican Republic'
    ecuador = 'Ecuador'
    egypt = 'Egypt'
    el__salvador = 'El Salvador'
    equatorial__guinea = 'Equatorial Guinea'
    eritrea = 'Eritrea'
    estonia = 'Estonia'
    ethiopia = 'Ethiopia'
    falkland__islands___malvinas_ = 'Falkland Islands (Malvinas)'
    faroe__islands = 'Faroe Islands'
    fiji = 'Fiji'
    finland = 'Finland'
    france = 'France'
    french__guiana = 'French Guiana'
    french__polynesia = 'French Polynesia'
    french__southern__territories = 'French Southern Territories'
    gabon = 'Gabon'
    gambia = 'Gambia'
    georgia = 'Georgia'
    germany = 'Germany'
    ghana = 'Ghana'
    gibraltar = 'Gibraltar'
    greece = 'Greece'
    greenland = 'Greenland'
    grenada = 'Grenada'
    guadeloupe = 'Guadeloupe'
    guam = 'Guam'
    guatemala = 'Guatemala'
    guernsey = 'Guernsey'
    guinea = 'Guinea'
    guinea__bissau = 'Guinea-Bissau'
    guyana = 'Guyana'
    haiti = 'Haiti'
    heard__island_and__mcdonald__islands = 'Heard Island and Mcdonald Islands'
    holy__see___vatican__city__state_ = 'Holy See (Vatican City State)'
    honduras = 'Honduras'
    hong__kong = 'Hong Kong'
    hungary = 'Hungary'
    iceland = 'Iceland'
    india = 'India'
    indonesia = 'Indonesia'
    iran___islamic__republic_of = 'Iran, Islamic Republic of'
    iraq = 'Iraq'
    ireland = 'Ireland'
    isle_of__man = 'Isle of Man'
    israel = 'Israel'
    italy = 'Italy'
    jamaica = 'Jamaica'
    japan = 'Japan'
    jersey = 'Jersey'
    jordan = 'Jordan'
    kazakhstan = 'Kazakhstan'
    kenya = 'Kenya'
    kiribati = 'Kiribati'
    korea___democratic__people_s__republic_of = (
        'Korea, Democratic People\'s Republic of'
    )
    korea___republic_of = 'Korea, Republic of'
    kuwait = 'Kuwait'
    kyrgyzstan = 'Kyrgyzstan'
    lao__people_s__democratic__republic = 'Lao People\'s Democratic Republic'
    latvia = 'Latvia'
    lebanon = 'Lebanon'
    lesotho = 'Lesotho'
    liberia = 'Liberia'
    libya = 'Libya'
    liechtenstein = 'Liechtenstein'
    lithuania = 'Lithuania'
    luxembourg = 'Luxembourg'
    macao = 'Macao'
    macedonia__the__former__yugoslav__republic_of = (
        'Macedonia, the Former Yugoslav Republic of'
    )
    madagascar = 'Madagascar'
    malawi = 'Malawi'
    malaysia = 'Malaysia'
    maldives = 'Maldives'
    mali = 'Mali'
    malta = 'Malta'
    marshall__islands = 'Marshall Islands'
    martinique = 'Martinique'
    mauritania = 'Mauritania'
    mauritius = 'Mauritius'
    mayotte = 'Mayotte'
    mexico = 'Mexico'
    micronesia___federated__states_of = 'Micronesia, Federated States of'
    moldova___republic_of = 'Moldova, Republic of'
    monaco = 'Monaco'
    mongolia = 'Mongolia'
    montenegro = 'Montenegro'
    montserrat = 'Montserrat'
    morocco = 'Morocco'
    mozambique = 'Mozambique'
    myanmar = 'Myanmar'
    namibia = 'Namibia'
    nauru = 'Nauru'
    nepal = 'Nepal'
    netherlands = 'Netherlands'
    new__caledonia = 'New Caledonia'
    new__zealand = 'New Zealand'
    nicaragua = 'Nicaragua'
    niger = 'Niger'
    nigeria = 'Nigeria'
    niue = 'Niue'
    norfolk__island = 'Norfolk Island'
    northern__mariana__islands = 'Northern Mariana Islands'
    norway = 'Norway'
    oman = 'Oman'
    pakistan = 'Pakistan'
    palau = 'Palau'
    palestine___state_of = 'Palestine, State of'
    panama = 'Panama'
    papua__new__guinea = 'Papua New Guinea'
    paraguay = 'Paraguay'
    peru = 'Peru'
    philippines = 'Philippines'
    pitcairn = 'Pitcairn'
    poland = 'Poland'
    portugal = 'Portugal'
    puerto__rico = 'Puerto Rico'
    qatar = 'Qatar'
    romania = 'Romania'
    russian__federation = 'Russian Federation'
    rwanda = 'Rwanda'
    réunion = 'Réunion'
    saint__barthélemy = 'Saint Barthélemy'
    saint__helena___ascension_and__tristan_da__cunha = (
        'Saint Helena, Ascension and Tristan da Cunha'
    )
    saint__kitts_and__nevis = 'Saint Kitts and Nevis'
    saint__lucia = 'Saint Lucia'
    saint__martin___french_part_ = 'Saint Martin (French part)'
    saint__pierre_and__miquelon = 'Saint Pierre and Miquelon'
    saint__vincent_and_the__grenadines = 'Saint Vincent and the Grenadines'
    samoa = 'Samoa'
    san__marino = 'San Marino'
    sao__tome_and__principe = 'Sao Tome and Principe'
    saudi__arabia = 'Saudi Arabia'
    senegal = 'Senegal'
    serbia = 'Serbia'
    seychelles = 'Seychelles'
    sierra__leone = 'Sierra Leone'
    singapore = 'Singapore'
    sint__maarten___dutch_part_ = 'Sint Maarten (Dutch part)'
    slovakia = 'Slovakia'
    slovenia = 'Slovenia'
    solomon__islands = 'Solomon Islands'
    somalia = 'Somalia'
    south__africa = 'South Africa'
    south__georgia_and_the__south__sandwich__islands = (
        'South Georgia and the South Sandwich Islands'
    )
    south__sudan = 'South Sudan'
    spain = 'Spain'
    sri__lanka = 'Sri Lanka'
    sudan = 'Sudan'
    suriname = 'Suriname'
    svalbard_and__jan__mayen = 'Svalbard and Jan Mayen'
    swaziland = 'Swaziland'
    sweden = 'Sweden'
    switzerland = 'Switzerland'
    syrian__arab__republic = 'Syrian Arab Republic'
    taiwan___province_of__china = 'Taiwan, Province of China'
    tajikistan = 'Tajikistan'
    tanzania___united__republic_of = 'Tanzania, United Republic of'
    thailand = 'Thailand'
    timor__leste = 'Timor-Leste'
    togo = 'Togo'
    tokelau = 'Tokelau'
    tonga = 'Tonga'
    trinidad_and__tobago = 'Trinidad and Tobago'
    tunisia = 'Tunisia'
    turkey = 'Turkey'
    turkmenistan = 'Turkmenistan'
    turks_and__caicos__islands = 'Turks and Caicos Islands'
    tuvalu = 'Tuvalu'
    uganda = 'Uganda'
    ukraine = 'Ukraine'
    united__arab__emirates = 'United Arab Emirates'
    united__kingdom = 'United Kingdom'
    united__states = 'United States'
    united__states__minor__outlying__islands = 'United States Minor Outlying Islands'
    uruguay = 'Uruguay'
    uzbekistan = 'Uzbekistan'
    vanuatu = 'Vanuatu'
    venezuela___bolivarian__republic_of = 'Venezuela, Bolivarian Republic of'
    viet__nam = 'Viet Nam'
    virgin__islands___british = 'Virgin Islands, British'
    virgin__islands__u_s_ = 'Virgin Islands, U.S.'
    wallis_and__futuna = 'Wallis and Futuna'
    western__sahara = 'Western Sahara'
    yemen = 'Yemen'
    zambia = 'Zambia'
    zimbabwe = 'Zimbabwe'
    åland__islands = 'Åland Islands'


class GeographicCoverage(DataverseBase):
    country___nation: Optional[CountryNation] = Field(
        None,
        description='The country or nation that the Dataset is about.',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='country',
    )
    state___province: Optional[str] = Field(
        None,
        description='The state or province that the Dataset is about. Use GeoNames for correct spelling and avoid abbreviations.',
        multiple=False,
        typeClass='primitive',
        typeName='state',
    )
    city: Optional[str] = Field(
        None,
        description='The name of the city that the Dataset is about. Use GeoNames for correct spelling and avoid abbreviations.',
        multiple=False,
        typeClass='primitive',
        typeName='city',
    )
    other: Optional[str] = Field(
        None,
        description='Other information on the geographic coverage of the data.',
        multiple=False,
        typeClass='primitive',
        typeName='otherGeographicCoverage',
    )


class GeographicBoundingBox(DataverseBase):
    west_longitude: Optional[str] = Field(
        None,
        description='Westernmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -180,0 <= West  Bounding Longitude Value <= 180,0.',
        multiple=False,
        typeClass='primitive',
        typeName='westLongitude',
    )
    east_longitude: Optional[str] = Field(
        None,
        description='Easternmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -180,0 <= East Bounding Longitude Value <= 180,0.',
        multiple=False,
        typeClass='primitive',
        typeName='eastLongitude',
    )
    north_latitude: Optional[str] = Field(
        None,
        description='Northernmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -90,0 <= North Bounding Latitude Value <= 90,0.',
        multiple=False,
        typeClass='primitive',
        typeName='northLongitude',
    )
    south_latitude: Optional[str] = Field(
        None,
        description='Southernmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -90,0 <= South Bounding Latitude Value <= 90,0.',
        multiple=False,
        typeClass='primitive',
        typeName='southLongitude',
    )


class Geospatial(DataverseBase):
    geographic_coverage: List[GeographicCoverage] = Field(
        default_factory=list,
        description='Information on the geographic coverage of the data. Includes the total geographic scope of the data.',
        multiple=True,
        typeClass='compound',
        typeName='geographicCoverage',
    )
    geographic_unit: Optional[List] = Field(
        None,
        description='Lowest level of geographic aggregation covered by the Dataset, e.g., village, county, region.',
        multiple=True,
        typeClass='primitive',
        typeName='geographicUnit',
    )
    geographic_bounding_box: List[GeographicBoundingBox] = Field(
        default_factory=list,
        description="The fundamental geometric description for any Dataset that models geography is the geographic bounding box. It describes the minimum box, defined by west and east longitudes and north and south latitudes, which includes the largest geographic extent of the  Dataset's geographic coverage. This element is used in the first pass of a coordinate-based search. Inclusion of this element in the codebook is recommended, but is required if the bound polygon box is included. ",
        multiple=True,
        typeClass='compound',
        typeName='geographicBoundingBox',
    )
    _metadatablock_name: Optional[str] = 'geospatial'


    def add_geographic_bounding_box(
        self,
        west_longitude: Optional[str] = None,
        east_longitude: Optional[str] = None,
        north_latitude: Optional[str] = None,
        south_latitude: Optional[str] = None,
    ):
        """Function used to add an instance of GeographicBoundingBox to the metadatablock.

        Args:
        
            west_longitude (string): Westernmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -180,0 <= West  Bounding Longitude Value <= 180,0.
            east_longitude (string): Easternmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -180,0 <= East Bounding Longitude Value <= 180,0.
            north_latitude (string): Northernmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -90,0 <= North Bounding Latitude Value <= 90,0.
            south_latitude (string): Southernmost coordinate delimiting the geographic extent of the Dataset. A valid range of values,  expressed in decimal degrees, is -90,0 <= South Bounding Latitude Value <= 90,0.

        """

        self.geographic_bounding_box.append(
            GeographicBoundingBox(
                west_longitude=west_longitude, east_longitude=east_longitude, north_latitude=north_latitude, south_latitude=south_latitude
            )
        )


    def add_geographic_coverage(
        self,
        country___nation: Optional[CountryNation] = None,
        state___province: Optional[str] = None,
        city: Optional[str] = None,
        other: Optional[str] = None,
    ):
        """Function used to add an instance of GeographicCoverage to the metadatablock.

        Args:
        
            country___nation (Enum): The country or nation that the Dataset is about.
            state___province (string): The state or province that the Dataset is about. Use GeoNames for correct spelling and avoid abbreviations.
            city (string): The name of the city that the Dataset is about. Use GeoNames for correct spelling and avoid abbreviations.
            other (string): Other information on the geographic coverage of the data.

        """

        self.geographic_coverage.append(
            GeographicCoverage(
                country___nation=country___nation, state___province=state___province, city=city, other=other
            )
        )
