# generated by datamodel-codegen:
#   filename:  astrophysics.json
#   timestamp: 2022-05-24T09:26:50+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from easyDataverse.core import DataverseBase
from pydantic import Field


class Type(Enum):
    """
    The nature or genre of the content of the files in the dataset.
    """

    image = 'Image'
    mosaic = 'Mosaic'
    event_list = 'EventList'
    spectrum = 'Spectrum'
    cube = 'Cube'
    table = 'Table'
    catalog = 'Catalog'
    light_curve = 'LightCurve'
    simulation = 'Simulation'
    figure = 'Figure'
    artwork = 'Artwork'
    animation = 'Animation'
    pretty_picture = 'PrettyPicture'
    documentation = 'Documentation'
    other = 'Other'
    library = 'Library'
    press__release = 'Press Release'
    facsimile = 'Facsimile'
    historical = 'Historical'
    observation = 'Observation'
    object = 'Object'
    value = 'Value'
    value_pair = 'ValuePair'
    survey = 'Survey'


class RedshiftValue(DataverseBase):
    minimum: Optional[float] = Field(
        None,
        description='The minimum value of the redshift (unitless) or Doppler velocity (km/s in the data object.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Redshift.MinimumValue',
    )
    maximum: Optional[float] = Field(
        None,
        description='The maximum value of the redshift (unitless) or Doppler velocity (km/s in the data object.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Redshift.MaximumValue',
    )


class DatasetDateRange(DataverseBase):
    start: Optional[str] = Field(
        None,
        description='Dataset Start Date',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Temporal.StartTime',
    )
    end: Optional[str] = Field(
        None,
        description='Dataset End Date',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Temporal.StopTime',
    )


class WavelengthRange(DataverseBase):
    minimum__m_: Optional[float] = Field(
        None,
        alias='minimum_(m)',
        description='The minimum wavelength of the spectral bandpass, in meters.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Spectral.MinimumWavelength',
    )
    maximum__m_: Optional[float] = Field(
        None,
        alias='maximum_(m)',
        description='The maximum wavelength of the spectral bandpass, in meters.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Spectral.MaximumWavelength',
    )


class Astrophysics(DataverseBase):
    redshift_value: List = Field(
        default_factory=list,
        description='The value of the redshift (unitless) or Doppler velocity (km/s in the data object.',
        multiple=True,
        typeClass='primitive',
        typeName='coverage.RedshiftValue',
    )
    dataset_date_range: List[DatasetDateRange] = Field(
        default_factory=list,
        description=' Time period covered by the data.',
        multiple=True,
        typeClass='compound',
        typeName='coverage.Temporal',
    )
    type: Optional[Union[List, Type]] = Field(
        None,
        description='The nature or genre of the content of the files in the dataset.',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='astroType',
    )
    facility: Optional[List] = Field(
        None,
        description='The observatory or facility where the data was obtained. ',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='astroFacility',
    )
    instrument: Optional[List] = Field(
        None,
        description='The instrument used to collect the data.',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='astroInstrument',
    )
    object: Optional[List] = Field(
        None,
        description='Astronomical Objects represented in the data (Given as SIMBAD recognizable names preferred).',
        multiple=True,
        typeClass='primitive',
        typeName='astroObject',
    )
    spatial_resolution: Optional[str] = Field(
        None,
        description='The spatial (angular) resolution that is typical of the observations, in decimal degrees.',
        multiple=False,
        typeClass='primitive',
        typeName='resolution.Spatial',
    )
    spectral_resolution: Optional[str] = Field(
        None,
        description='The spectral resolution that is typical of the observations, given as the ratio \\u03bb/\\u0394\\u03bb.',
        multiple=False,
        typeClass='primitive',
        typeName='resolution.Spectral',
    )
    time_resolution: Optional[str] = Field(
        None,
        description='The temporal resolution that is typical of the observations, given in seconds.',
        multiple=False,
        typeClass='primitive',
        typeName='resolution.Temporal',
    )
    bandpass: Optional[List] = Field(
        None,
        description='Conventional bandpass name',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='coverage.Spectral.Bandpass',
    )
    central_wavelength__m_: Optional[List] = Field(
        None,
        alias='central_wavelength_(m)',
        description='The central wavelength of the spectral bandpass, in meters.',
        multiple=True,
        typeClass='primitive',
        typeName='coverage.Spectral.CentralWavelength',
    )
    sky_coverage: Optional[List] = Field(
        None,
        description='The sky coverage of the data object.',
        multiple=True,
        typeClass='primitive',
        typeName='coverage.Spatial',
    )
    depth_coverage: Optional[float] = Field(
        None,
        description='The (typical) depth coverage, or sensitivity, of the data object in Jy.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Depth',
    )
    object_density: Optional[float] = Field(
        None,
        description='The (typical) density of objects, catalog entries, telescope pointings, etc., on the sky, in number per square degree.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.ObjectDensity',
    )
    object_count: Optional[int] = Field(
        None,
        description='The total number of objects, catalog entries, etc., in the data object.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.ObjectCount',
    )
    fraction_of_sky: Optional[float] = Field(
        None,
        description='The fraction of the sky represented in the observations, ranging from 0 to 1.',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.SkyFraction',
    )
    polarization: Optional[str] = Field(
        None,
        description='The polarization coverage',
        multiple=False,
        typeClass='primitive',
        typeName='coverage.Polarization',
    )
    redshifttype: Optional[str] = Field(
        None,
        description='RedshiftType string C "Redshift"; or "Optical" or "Radio" definitions of Doppler velocity used in the data object.',
        multiple=False,
        typeClass='primitive',
        typeName='redshiftType',
    )
    redshift_resolution: Optional[float] = Field(
        None,
        description='The resolution in redshift (unitless) or Doppler velocity (km/s) in the data object.',
        multiple=False,
        typeClass='primitive',
        typeName='resolution.Redshift',
    )
    wavelength_range: List[WavelengthRange] = Field(
        default_factory=list,
        description='The minimum and maximum wavelength of the spectral bandpass.',
        multiple=True,
        typeClass='compound',
        typeName='coverage.Spectral.Wavelength',
    )
    _metadatablock_name: Optional[str] = 'astrophysics'


    def add_dataset_date_range(
        self,
        start: Optional[str] = None,
        end: Optional[str] = None,
    ):
        """Function used to add an instance of DatasetDateRange to the metadatablock.

        Args:
        
            start (string): Dataset Start Date
            end (string): Dataset End Date

        """

        self.dataset_date_range.append(
            DatasetDateRange(
                start=start, end=end
            )
        )


    def add_redshift_value(
        self,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
    ):
        """Function used to add an instance of RedshiftValue to the metadatablock.

        Args:
        
            minimum (number): The minimum value of the redshift (unitless) or Doppler velocity (km/s in the data object.
            maximum (number): The maximum value of the redshift (unitless) or Doppler velocity (km/s in the data object.

        """

        self.redshift_value.append(
            RedshiftValue(
                minimum=minimum, maximum=maximum
            )
        )


    def add_wavelength_range(
        self,
        minimum__m_: Optional[float] = None,
        maximum__m_: Optional[float] = None,
    ):
        """Function used to add an instance of WavelengthRange to the metadatablock.

        Args:
        
            minimum_(m) (number): The minimum wavelength of the spectral bandpass, in meters.
            maximum_(m) (number): The maximum wavelength of the spectral bandpass, in meters.

        """

        self.wavelength_range.append(
            WavelengthRange(
                extra_data=extra_data
            )
        )
