[![](https://raw.githubusercontent.com/accounting-intelligent-ai/cpanlp/main/cpanlp.png)](https://cpanlp.com)

CPANLP: Certified Public Accountant Natural Language Processing toolkit

We are the accounting-intelligent-ai Team of Beijing Foreign Studies University. We develop A package for intelligent certified accountants.
我们是北外形式会计博士课题组，致力推动具有经济学基础的会计学的语言学转向(The Linguistic Turn of Accounting on Economic Basis)。


Redefining [Accounting](https://cpanlp.com/overview/redefine)!
Developed by **Bfsu Intelligent Accounting Team** (c) 2023
[Github](https://github.com/accounting-intelligent-ai/cpanlp)

[![PyPI - Python Version](https://img.shields.io/static/v1?label=pypi&message=v1.0.29&color=blue)](https://pypi.org/project/cpanlp/)
## 特点

## 安装说明
```python
pip install cpanlp
```

## 主要功能
1.获取今日财报
```python
import cpanlp as cp
df = cp.gettoday()
```
|    | 标题                                               |   证券代码 | 证券简称   | 网址                                                            | 日期       |   id |
|---:|:---------------------------------------------------|-----------:|:-----------|:----------------------------------------------------------------|:-----------|-----:|
|  0 | 唐源电气：国金证券关于唐源电气2022年度现场检查报告 |     300789 | 唐源电气   | http://static.cninfo.com.cn/finalpage/2023-01-03/1215519757.PDF | 2023-01-03 |    1 |

```python
report = cp.getreport(df.iloc[0, 3])
```

2.模拟会计科目
```python
import cpanlp as cp
资产1 = cp.Asset(account="黄金", debit=1000,date="2023-01-01")
print(资产1.bubble)
```

3.描述信息不对称
```python
import cpanlp as cp
info = cp.AsymmetricInformation("投资人", "企业A", "我很有兴趣投资您的企业", "我有有限的预算")
info.get_advantage()
```
Check out: https://cpanlp.com