# -*- coding: utf-8 -*-
"""mCalcAux.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1FuA0K633irR8qVLlHj7et2T8DJh7pCHz
"""

# -----------------------------------------------------------
# Necessary methods to main calculations of the model.
#
# (C) 2021 Borja García, Valladolid, Spain
# Released under MIT License (MIT)
# email borjagarmarpy@gmail.com
# -----------------------------------------------------------

import numpy as np
import math

# import sys
# from importlib import reload
# sys.path.append('/content/drive/MyDrive/Burbuja/Difusion-Trabajando/Metodos')
# from mSetters import *

##############
############ Delta Managment
##############

def setDeltaSlug( self ):
  self.delta_s = (1 - math.sqrt( 2 - self.Ub/self.Utp )) * self.rc

### 
# End Delta Managment
###

##############
############ Cosine Develope of Velocity ( C ) Managment
##############

def defaultVelocityBubble( self, y  ):
  return ( self.Ub + self.dens*self.g*self.rc**2/(4*self.visc) * (1 - ( (self.rc-y)/self.rc)**2 + 2*((self.rc-self.delta_b)/self.rc)**2 * np.log((self.rc-y)/self.rc)) )

def defaultVelocitySlug( self, y ):
  return ( self.Ub - 2*self.Utp*(1 - ( self.rc - y )**2/self.rc**2) )

def setVelocityBubble( self, fun=None, args=None ):
  if( type(fun)==type(None) ):
    self.c_b = self.CosineDevelope( self.defaultVelocityBubble, range_=[0, self.getDeltaBubble()], N=self.N, accurate=1000 )
  else:
    self.c_b = self.CosineDevelope( fun, args=args, range_=[0, self.getDeltaBubble()], N=self.N, accurate=1000 )

def setVelocitySlug( self, fun=None, args=None ):
  if( type(fun)==type(None) ):
    self.c_s = self.CosineDevelope( self.defaultVelocitySlug, range_=[0, self.getDeltaBubble()], N=self.N, accurate=1000 )
  else:
    self.c_s = self.CosineDevelope( fun, args=args, range_=[0, self.getDeltaBubble()], N=self.N, accurate=1000 )

def CosineDevelope( self, func, args = None, range_=[0, 1], N=50, accurate=200 ):
  from scipy import integrate
  if( range_[1] != 0 ):
    range_[1] = 2 * range_[1]
  if( range_[0] != 0 ):
    range_[0] = 2 * range_[0]
  
  x = np.linspace( range_[0], range_[1], accurate )
  interv = range_[1] - range_[0]
  
  if( type(args) == type(None) ):
    coefs = np.array([ 1/(interv) * integrate.simps( func(x), x )  ])
  else:
    coefs = np.array([ 1/(interv) * integrate.simps( func(x, args), x )  ])
  
  for n in range(1, N):
    if( type(args) == type(None) ):
      integ = integrate.simps( 2/interv * func(x)*np.cos( n*math.pi/(interv) * x ) , x)
    else:
      integ = integrate.simps( 2/interv * func(x, args)*np.cos( n*math.pi/(interv) * x ) , x)
    coefs = np.append( coefs, integ )
  return coefs

def setCBuble( self ):

  res = np.array( [( self.dens * self.g)/self.visc * 1/3 * self.delta_b**2 + self.Ub] )
  for n in range(1, self.N+1):
    cn = (self.dens * self.g * (2 * self.delta_b)**2 )/( self.visc * (n * math.pi)**2 ) * ( - 1) * (1 + math.cos(n*math.pi) )
    res = np.append( res, cn )
  return res

def setCSlug( self ):

  Re = self.dens * 2 * self.rc * self.Utp / self.visc
  K = ( - 16 * self.dens * self.Utp**2 )/( self.Re * self.rc )
  res = np.array( [-1/6 * K/self.visc * self.delta_s ** 2] )

  for n in range(1, self.N+1):
    coef1 = 1/2 * K/self.visc * (2 * self.delta_s)**2/( n * math.pi )**2 
    coseno1 = -1-3 * math.cos( n * math.pi )
    coef2 = self.Ub * 4 /(n * math.pi)**2
    coseno2 =  math.cos( n * math.pi ) - 1
    cn =  coef1 * coseno1 - coef2 * coseno2
    res = np.append( res, cn )
  return res

###
# End Cosine Develope of Velocity ( C ) Managment
###

