# Generated by Django 3.0.7 on 2020-06-13 14:34

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SchoolTerm',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='Name')),
                ('date_start', models.DateField(verbose_name='Start date')),
                ('date_end', models.DateField(verbose_name='End date')),
            ],
            options={
                'verbose_name': 'School term',
                'verbose_name_plural': 'School terms',
            },
        ),
        migrations.AlterModelManagers(
            name='group',
            managers=[
            ],
        ),
        migrations.AlterField(
            model_name='group',
            name='name',
            field=models.CharField(max_length=255, verbose_name='Long name'),
        ),
        migrations.AlterField(
            model_name='group',
            name='short_name',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Short name'),
        ),
        migrations.AddField(
            model_name='group',
            name='school_term',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                    related_name='+', to='core.SchoolTerm', verbose_name='Linked school term'),
        ),
        migrations.AddConstraint(
            model_name='group',
            constraint=models.UniqueConstraint(fields=('school_term', 'name'), name='unique_school_term_name'),
        ),
        migrations.AddConstraint(
            model_name='group',
            constraint=models.UniqueConstraint(fields=('school_term', 'short_name'), name='unique_school_term_short_name'),
        ),
        migrations.AddField(
            model_name='schoolterm',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site'),
        ),
    ]
