# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sdbcx
from typing_extensions import Literal


class Privilege(object):
    """
    Const

    defines a list of flags (bitmaps) which determines the access rights of a user or a user group.
    
    This list may grow in the future.

    See Also:
        `API Privilege <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1sdbcx_1_1Privilege.html>`_
    """
    SELECT: Literal[1]
    """
    indicates that a user is allowed to read the data.
    """
    INSERT: Literal[2]
    """
    indicates that a user is allowed to insert new data.
    """
    UPDATE: Literal[4]
    """
    indicates that a user is allowed to update data.
    """
    DELETE: Literal[8]
    """
    indicates that a user is allowed to delete data.
    """
    READ: Literal[16]
    """
    indicates that a user is allowed to read the structure of a definition object.
    """
    CREATE: Literal[32]
    """
    indicates that a user is allowed to create a definition object.
    """
    ALTER: Literal[64]
    """
    indicates that a user is allowed to alter an existing object.
    """
    REFERENCE: Literal[128]
    """
    indicates that a user is allowed to set foreign keys for a table.
    """
    DROP: Literal[256]
    """
    indicates that a user is allowed to drop a definition object.
    """

