## -*- coding: utf-8; -*-
<%inherit file="/page.mako" />

<%def name="title()">${index_title}</%def>

<%def name="content_title()"></%def>

<%def name="context_menu_items()">
  ${parent.context_menu_items()}
  % if request.has_perm('datasync_changes.list'):
      <li>${h.link_to("View DataSync Changes", url('datasyncchanges'))}</li>
  % endif
</%def>

<%def name="page_content()">
  % if expose_websockets and not supervisor_error:
      <b-notification type="is-warning"
                      :active="websocketBroken"
                      :closable="false">
        Server connection was broken - please refresh page to see accurate status!
      </b-notification>
  % endif
  <b-field label="Supervisor Status">
    <div style="display: flex;">

      % if supervisor_error:
          <pre class="has-background-warning">${supervisor_error}</pre>
      % else:
          <pre :class="(processInfo && processInfo.statename == 'RUNNING') ? 'has-background-success' : 'has-background-warning'">{{ processDescription }}</pre>
      % endif

      <div style="margin-left: 1rem;">
        % if request.has_perm('datasync.restart'):
            ${h.form(url('datasync.restart'), **{'@submit': 'restartProcess'})}
            ${h.csrf_token(request)}
            <b-button type="is-primary"
                      native-type="submit"
                      icon-pack="fas"
                      icon-left="redo"
                      :disabled="restartingProcess">
              {{ restartingProcess ? "Working, please wait..." : "Restart Process" }}
            </b-button>
            ${h.end_form()}
        % endif
      </div>

    </div>
  </b-field>

  <b-field label="Watcher Status">
    <b-table :data="watchers">
      % if buefy_0_8:
      <template slot-scope="props">
      % endif
        <b-table-column field="key"
                        label="Watcher"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.key }}
        </b-table-column>
        <b-table-column field="spec"
                        label="Spec"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.spec }}
        </b-table-column>
        <b-table-column field="dbkey"
                        label="DB Key"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.dbkey }}
        </b-table-column>
        <b-table-column field="delay"
                        label="Delay"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.delay }} second(s)
        </b-table-column>
        <b-table-column field="lastrun"
                        label="Last Watched"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           <span v-html="props.row.lastrun"></span>
        </b-table-column>
        <b-table-column field="status"
                        label="Status"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
          <span :class="props.row.status == 'okay' ? 'has-background-success' : 'has-background-warning'">
            {{ props.row.status }}
          </span>
        </b-table-column>
      % if buefy_0_8:
      </template>
      % endif
    </b-table>
  </b-field>

  <b-field label="Consumer Status">
    <b-table :data="consumers">
      % if buefy_0_8:
      <template slot-scope="props">
      % endif
        <b-table-column field="key"
                        label="Consumer"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.key }}
        </b-table-column>
        <b-table-column field="spec"
                        label="Spec"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.spec }}
        </b-table-column>
        <b-table-column field="dbkey"
                        label="DB Key"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.dbkey }}
        </b-table-column>
        <b-table-column field="delay"
                        label="Delay"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.delay }} second(s)
        </b-table-column>
        <b-table-column field="changes"
                        label="Pending Changes"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
           {{ props.row.changes }}
        </b-table-column>
        <b-table-column field="status"
                        label="Status"
                        % if not buefy_0_8:
                        v-slot="props"
                        % endif
                        >
          <span :class="props.row.status == 'okay' ? 'has-background-success' : 'has-background-warning'">
            {{ props.row.status }}
          </span>
        </b-table-column>
      % if buefy_0_8:
      </template>
      % endif
    </b-table>
  </b-field>
</%def>

<%def name="modify_this_page_vars()">
  <script type="text/javascript">

    ThisPageData.processInfo = ${json.dumps(process_info)|n}

    ThisPage.computed.processDescription = function() {
        let info = this.processInfo
        if (info) {
            return `${'$'}{info.group}:${'$'}{info.name}    ${'$'}{info.statename}    ${'$'}{info.description}`
        } else {
            return "NO PROCESS INFO AVAILABLE"
        }
    }

    ThisPageData.restartingProcess = false
    ThisPageData.watchers = ${json.dumps(watcher_data)|n}
    ThisPageData.consumers = ${json.dumps(consumer_data)|n}

    ThisPage.methods.restartProcess = function() {
        this.restartingProcess = true
    }

    % if expose_websockets and not supervisor_error:

        ThisPageData.ws = null
        ThisPageData.websocketBroken = false

        ThisPage.mounted = function() {

            ## TODO: should be a cleaner way to get this url?
            let url = '${url('ws.datasync.status')}'
            url = url.replace(/^http(s?):/, 'ws$1:')

            this.ws = new WebSocket(url)
            let that = this

            this.ws.onclose = (event) => {
                // websocket closing means 1 of 2 things:
                // - user navigated away from page intentionally
                // - server connection was broken somehow
                // only one of those is "bad" and we only want to
                // display warning in 2nd case.  so we simply use a
                // brief delay to "rule out" the 1st scenario
                setTimeout(() => { that.websocketBroken = true },
                           3000)
            }

            this.ws.onmessage = (event) => {
                that.processInfo = JSON.parse(event.data)
            }
        }

    % endif

  </script>
</%def>


${parent.body()}
