from ..openwrt.renderer import OpenWrtRenderer as BaseRenderer


class OpenWrtRenderer(BaseRenderer):
    """
    OpenWRT Renderer for OpenWISP 1.x backend

    It uses a slightly different template
    than the default OpenWRT renderer in order
    to provide backward compatibility with the
    format that was generated by OpenWISP Manager.

    E.g.:

    # OpenWISP Manager:
    config 'system' 'system'
        option 'hostname' 'openwisp-test'

    # standard OpenWRT conf generated by netjsonconfig:
    config system 'system'
        option hostname 'openwisp-test'
    """

    pass
