# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pymedphys',
 'pymedphys._base',
 'pymedphys._bundle',
 'pymedphys._data',
 'pymedphys._dev',
 'pymedphys._dicom',
 'pymedphys._dicom.constants',
 'pymedphys._dicom.ct',
 'pymedphys._dicom.delivery',
 'pymedphys._dicom.rtplan',
 'pymedphys._dicom.structure',
 'pymedphys._dicom.utilities',
 'pymedphys._electronfactors',
 'pymedphys._gamma',
 'pymedphys._gamma.api',
 'pymedphys._gamma.implementation',
 'pymedphys._gamma.utilities',
 'pymedphys._gui',
 'pymedphys._icom',
 'pymedphys._imports',
 'pymedphys._losslessjpeg',
 'pymedphys._mocks',
 'pymedphys._monaco',
 'pymedphys._mosaiq',
 'pymedphys._mudensity',
 'pymedphys._mudensity.delivery',
 'pymedphys._mudensity.plt',
 'pymedphys._trf',
 'pymedphys._utilities',
 'pymedphys._utilities.algorithms',
 'pymedphys._utilities.constants',
 'pymedphys._utilities.filehash',
 'pymedphys._utilities.transforms',
 'pymedphys._vendor.apipkg',
 'pymedphys._vendor.pylinac',
 'pymedphys._vendor.pylinac.core',
 'pymedphys._wlutz',
 'pymedphys.cli',
 'pymedphys.cli.labs',
 'pymedphys.labs',
 'pymedphys.labs.fileformats',
 'pymedphys.labs.fileformats.mapcheck',
 'pymedphys.labs.fileformats.mephysto',
 'pymedphys.labs.fileformats.profiler',
 'pymedphys.labs.film',
 'pymedphys.labs.managelogfiles',
 'pymedphys.labs.paulking',
 'pymedphys.labs.pedromartinez',
 'pymedphys.labs.pedromartinez.oncentra',
 'pymedphys.labs.pedromartinez.utils',
 'pymedphys.labs.pinnacle',
 'pymedphys.labs.serviceplans',
 'pymedphys.labs.tpscompare']

package_data = \
{'': ['*'],
 'pymedphys._bundle': ['src/main/*', 'src/renderer/*'],
 'pymedphys._gui': ['streamlit/*'],
 'pymedphys.labs': ['serviceplans/templates/*']}

install_requires = \
['Pillow',
 'PyYAML',
 'attrs',
 'cython',
 'dbfread',
 'imageio',
 'keyring',
 'matplotlib',
 'numpy>=1.12,<2.0',
 'packaging',
 'pandas',
 'pydicom',
 'pynetdicom',
 'python_dateutil',
 'requests',
 'scikit-image',
 'scipy',
 'shapely>=1.7.0',
 'streamlit',
 'timeago',
 'tqdm',
 'watchdog']

extras_require = \
{':python_version < "3.8"': ['pymssql<3.0.0'],
 ':python_version >= "3.6.0" and python_version < "3.7.0"': ['dataclasses'],
 'docs': ['sphinx>=1.4,<1.8',
          'sphinx-rtd-theme>=0.4.3,<0.5.0',
          'sphinx-autobuild',
          'sphinxcontrib-napoleon',
          'sphinx-argparse',
          'nbsphinx',
          'jupyter_client',
          'ipython',
          'ipykernel',
          'm2r'],
 'ml': ['tf-nightly>=2.2.0.dev20200306', 'tf-estimator-nightly', 'tb-nightly'],
 'pylint': ['pylint', 'pytest-pylint'],
 'pytest': ['pytest', 'pytest-sugar', 'hypothesis', 'psutil']}

entry_points = \
{'console_scripts': ['pymedphys = pymedphys.cli.main:pymedphys_cli']}

setup_kwargs = {
    'name': 'pymedphys',
    'version': '0.27.0',
    'description': 'Medical Physics library',
    'long_description': '|logo|\n\n.. |logo| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/pymedphys_title.png\n    :target: https://docs.pymedphys.com/\n\n.. START_OF_DOCS_IMPORT\n\n**A community effort to develop an open standard library for Medical Physics\nin Python. Building quality transparent software together via peer review\nand open source distribution. Open code is better science.**\n\n|build| |pypi| |python| |license|\n\n.. |build| image:: https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fpymedphys%2Fpymedphys%2Fbadge&label=build&logo=none\n    :target: https://actions-badge.atrox.dev/pymedphys/pymedphys/goto\n\n.. |pypi| image:: https://img.shields.io/pypi/v/pymedphys\n    :target: https://pypi.org/project/pymedphys/\n\n.. |python| image:: https://img.shields.io/pypi/pyversions/pymedphys\n    :target: https://pypi.org/project/pymedphys/\n\n.. |license| image:: https://img.shields.io/pypi/l/pymedphys\n    :target: https://choosealicense.com/licenses/apache-2.0/\n\n\nWhat is PyMedPhys?\n------------------\n\nA place to share, review, improve, and transparently learn off of each\nother’s code. It is an open-source library of tools that we all have access\nto. It is inspired by the collaborative work of our physics peers in astronomy\nand their `Astropy Project`_. PyMedPhys is available on `PyPI`_ and `GitHub`_.\n\n.. _`Astropy Project`: http://www.astropy.org/\n.. _`PyPI`: https://pypi.org/project/pymedphys/\n.. _`GitHub`: https://github.com/pymedphys/pymedphys\n\n\nTable of contents\n-----------------\n\n`Tutorials`_\n........................\n\nGet started with a hands-on introduction to PyMedPhys for beginners\n\n`How-To guides`_\n........................\n\nGuides and recipes for common problems and tasks\n\n`Reference`_\n............................\n\nTechnical reference for the `library`_ (modules, functions and classes),\nas well as the available `command line tools`_.\n\n`Background`_\n..............................\n\nExplanation and discussion of key topics and concepts\n\n\nBeta level of development\n-------------------------\n\nPyMedPhys is currently within the ``beta`` stage of its life-cycle. It will\nstay in this stage until the version number leaves ``0.x.x`` and enters\n``1.x.x``. While PyMedPhys is in ``beta`` stage, **no API is guaranteed to be\nstable from one release to the next.** In fact, it is very likely that the\nentire API will change multiple times before a ``1.0.0`` release. In practice,\nthis means that upgrading ``pymedphys`` to a new version will possibly break\nany code that was using the old version of pymedphys. We try to be abreast of\nthis by providing details of any breaking changes from one release to the next\nwithin the `Release Notes`_.\n\nOur Team\n--------\n\nPyMedPhys is what it is today due to its contributors.\nCore contributors and contributors who have been active in the last six months\nas well as their respective employers are presented below.\n\nCore contributor(s)\n...................\n\n* `Simon Biggs`_\n    * `Riverina Cancer Care Centre`_, Australia\n\n.. _`Simon Biggs`: https://github.com/SimonBiggs\n\n\nActive contributors\n...................\n\n* `Matthew Jennings`_\n    * `Royal Adelaide Hospital`_, Australia\n\n.. _`Matthew Jennings`: https://github.com/Matthew-Jennings\n\n* `Jake Rembish`_\n    * `UT Health San Antonio`_, USA\n\n.. _`Jake Rembish`: https://github.com/rembishj\n\n* `Phillip Chlap`_\n    * `University of New South Wales`_, Australia\n    * `South Western Sydney Local Health District`_, Australia\n\n.. _`Phillip Chlap`: https://github.com/pchlap\n\n* `Pedro Martinez`_\n    * `University of Calgary`_, Canada\n    * `Tom Baker Cancer Centre`_, Canada\n\n.. _`Pedro Martinez`: https://github.com/peterg1t\n\n* `Jacob McAloney`_\n    * `Riverina Cancer Care Centre`_, Australia\n\n.. _`Jacob McAloney`: https://github.com/JacobMcAloney\n\n* `Matthew Cooper`_\n    * University of Sydney, Australia\n\n.. _`Matthew Cooper`: https://github.com/matthewdeancooper\n\n\n|rccc| |rah| |uth| |uoc|\n\nPast contributors\n.................\n\n* `Matthew Sobolewski <https://github.com/msobolewski>`_\n* `Paul King <https://github.com/kingrpaul>`_\n\n\n.. |rccc| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/rccc_200x200.png\n    :target: `Riverina Cancer Care Centre`_\n\n.. |rah| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/gosa_200x200.png\n    :target: `Royal Adelaide Hospital`_\n\n.. |jarmc| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/jarmc_200x200.png\n    :target: `Anderson Regional Cancer Center`_\n\n.. |nbcc| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/nbcc_200x200.png\n    :target: `Northern Beaches Cancer Care`_\n\n.. |uoc| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/uoc_200x200.png\n    :target: `University of Calgary`_\n\n.. |uth| image:: https://github.com/pymedphys/pymedphys/raw/master/docs/logos/UTHSA_logo.png\n    :target: `UT Health San Antonio`_\n\n.. _`Riverina Cancer Care Centre`: http://www.riverinacancercare.com.au/\n\n.. _`Royal Adelaide Hospital`: http://www.rah.sa.gov.au/\n\n.. _`University of New South Wales`: https://www.unsw.edu.au/\n\n.. _`South Western Sydney Local Health District`: https://www.swslhd.health.nsw.gov.au/\n\n.. _`Anderson Regional Cancer Center`: http://www.andersonregional.org/CancerCenter.aspx\n\n.. _`Northern Beaches Cancer Care`: http://www.northernbeachescancercare.com.au/\n\n.. _`University of Calgary`: http://www.ucalgary.ca/\n\n.. _`Tom Baker Cancer Centre`: https://www.ahs.ca/tbcc\n\n.. _`UT Health San Antonio`: https://www.uthscsa.edu/academics/biomedical-sciences/programs/radiological-sciences-phd\n\n\n.. END_OF_DOCS_IMPORT\n\n.. _`Tutorials`: https://docs.pymedphys.com/tutes\n.. _`How-To guides`: https://docs.pymedphys.com/howto\n.. _`Reference`: https://docs.pymedphys.com/ref\n.. _`Background`: https://docs.pymedphys.com/background\n\n.. _`library`: https://docs.pymedphys.com/ref/lib\n.. _`command line tools`: https://docs.pymedphys.com/ref/cli\n\n.. _`Release Notes`: http://docs.pymedphys.com/release-notes.html\n',
    'author': 'PyMedPhys Contributors',
    'author_email': 'developers@pymedphys.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://pymedphys.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
