# coding: utf-8

"""

    Copyright (c) 2020 Aspose.BarCode for Cloud

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.

"""


import pprint
import re  # noqa: F401

import six


class ReaderParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "type": "DecodeBarcodeType",
        "checksum_validation": "ChecksumValidation",
        "detect_encoding": "bool",
        "preset": "PresetType",
        "rect_x": "int",
        "rect_y": "int",
        "rect_width": "int",
        "rect_height": "int",
        "strip_fnc": "bool",
        "timeout": "int",
        "median_smoothing_window_size": "int",
        "allow_median_smoothing": "bool",
        "allow_complex_background": "bool",
        "allow_datamatrix_industrial_barcodes": "bool",
        "allow_decreased_image": "bool",
        "allow_detect_scan_gap": "bool",
        "allow_incorrect_barcodes": "bool",
        "allow_invert_image": "bool",
        "allow_micro_white_spots_removing": "bool",
        "allow_one_d_fast_barcodes_detector": "bool",
        "allow_one_d_wiped_bars_restoration": "bool",
        "allow_qr_micro_qr_restoration": "bool",
        "allow_regular_image": "bool",
        "allow_salt_and_pepper_filtering": "bool",
        "allow_white_spots_removing": "bool",
        "region_likelihood_threshold_percent": "float",
        "scan_window_sizes": "list[int]",
        "similarity": "float",
        "skip_diagonal_search": "bool",
        "australian_post_encoding_table": "CustomerInformationInterpretingType",
    }

    attribute_map = {
        "type": "Type",
        "checksum_validation": "ChecksumValidation",
        "detect_encoding": "DetectEncoding",
        "preset": "Preset",
        "rect_x": "RectX",
        "rect_y": "RectY",
        "rect_width": "RectWidth",
        "rect_height": "RectHeight",
        "strip_fnc": "StripFNC",
        "timeout": "Timeout",
        "median_smoothing_window_size": "MedianSmoothingWindowSize",
        "allow_median_smoothing": "AllowMedianSmoothing",
        "allow_complex_background": "AllowComplexBackground",
        "allow_datamatrix_industrial_barcodes": "AllowDatamatrixIndustrialBarcodes",
        "allow_decreased_image": "AllowDecreasedImage",
        "allow_detect_scan_gap": "AllowDetectScanGap",
        "allow_incorrect_barcodes": "AllowIncorrectBarcodes",
        "allow_invert_image": "AllowInvertImage",
        "allow_micro_white_spots_removing": "AllowMicroWhiteSpotsRemoving",
        "allow_one_d_fast_barcodes_detector": "AllowOneDFastBarcodesDetector",
        "allow_one_d_wiped_bars_restoration": "AllowOneDWipedBarsRestoration",
        "allow_qr_micro_qr_restoration": "AllowQRMicroQrRestoration",
        "allow_regular_image": "AllowRegularImage",
        "allow_salt_and_pepper_filtering": "AllowSaltAndPepperFiltering",
        "allow_white_spots_removing": "AllowWhiteSpotsRemoving",
        "region_likelihood_threshold_percent": "RegionLikelihoodThresholdPercent",
        "scan_window_sizes": "ScanWindowSizes",
        "similarity": "Similarity",
        "skip_diagonal_search": "SkipDiagonalSearch",
        "australian_post_encoding_table": "AustralianPostEncodingTable",
    }

    def __init__(
        self,
        type=None,
        checksum_validation=None,
        detect_encoding=None,
        preset=None,
        rect_x=None,
        rect_y=None,
        rect_width=None,
        rect_height=None,
        strip_fnc=None,
        timeout=None,
        median_smoothing_window_size=None,
        allow_median_smoothing=None,
        allow_complex_background=None,
        allow_datamatrix_industrial_barcodes=None,
        allow_decreased_image=None,
        allow_detect_scan_gap=None,
        allow_incorrect_barcodes=None,
        allow_invert_image=None,
        allow_micro_white_spots_removing=None,
        allow_one_d_fast_barcodes_detector=None,
        allow_one_d_wiped_bars_restoration=None,
        allow_qr_micro_qr_restoration=None,
        allow_regular_image=None,
        allow_salt_and_pepper_filtering=None,
        allow_white_spots_removing=None,
        region_likelihood_threshold_percent=None,
        scan_window_sizes=None,
        similarity=None,
        skip_diagonal_search=None,
        australian_post_encoding_table=None,
    ):  # noqa: E501
        """ReaderParams - a model defined in Swagger"""  # noqa: E501

        self._type = None
        self._checksum_validation = None
        self._detect_encoding = None
        self._preset = None
        self._rect_x = None
        self._rect_y = None
        self._rect_width = None
        self._rect_height = None
        self._strip_fnc = None
        self._timeout = None
        self._median_smoothing_window_size = None
        self._allow_median_smoothing = None
        self._allow_complex_background = None
        self._allow_datamatrix_industrial_barcodes = None
        self._allow_decreased_image = None
        self._allow_detect_scan_gap = None
        self._allow_incorrect_barcodes = None
        self._allow_invert_image = None
        self._allow_micro_white_spots_removing = None
        self._allow_one_d_fast_barcodes_detector = None
        self._allow_one_d_wiped_bars_restoration = None
        self._allow_qr_micro_qr_restoration = None
        self._allow_regular_image = None
        self._allow_salt_and_pepper_filtering = None
        self._allow_white_spots_removing = None
        self._region_likelihood_threshold_percent = None
        self._scan_window_sizes = None
        self._similarity = None
        self._skip_diagonal_search = None
        self._australian_post_encoding_table = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if checksum_validation is not None:
            self.checksum_validation = checksum_validation
        if detect_encoding is not None:
            self.detect_encoding = detect_encoding
        if preset is not None:
            self.preset = preset
        if rect_x is not None:
            self.rect_x = rect_x
        if rect_y is not None:
            self.rect_y = rect_y
        if rect_width is not None:
            self.rect_width = rect_width
        if rect_height is not None:
            self.rect_height = rect_height
        if strip_fnc is not None:
            self.strip_fnc = strip_fnc
        if timeout is not None:
            self.timeout = timeout
        if median_smoothing_window_size is not None:
            self.median_smoothing_window_size = median_smoothing_window_size
        if allow_median_smoothing is not None:
            self.allow_median_smoothing = allow_median_smoothing
        if allow_complex_background is not None:
            self.allow_complex_background = allow_complex_background
        if allow_datamatrix_industrial_barcodes is not None:
            self.allow_datamatrix_industrial_barcodes = allow_datamatrix_industrial_barcodes
        if allow_decreased_image is not None:
            self.allow_decreased_image = allow_decreased_image
        if allow_detect_scan_gap is not None:
            self.allow_detect_scan_gap = allow_detect_scan_gap
        if allow_incorrect_barcodes is not None:
            self.allow_incorrect_barcodes = allow_incorrect_barcodes
        if allow_invert_image is not None:
            self.allow_invert_image = allow_invert_image
        if allow_micro_white_spots_removing is not None:
            self.allow_micro_white_spots_removing = allow_micro_white_spots_removing
        if allow_one_d_fast_barcodes_detector is not None:
            self.allow_one_d_fast_barcodes_detector = allow_one_d_fast_barcodes_detector
        if allow_one_d_wiped_bars_restoration is not None:
            self.allow_one_d_wiped_bars_restoration = allow_one_d_wiped_bars_restoration
        if allow_qr_micro_qr_restoration is not None:
            self.allow_qr_micro_qr_restoration = allow_qr_micro_qr_restoration
        if allow_regular_image is not None:
            self.allow_regular_image = allow_regular_image
        if allow_salt_and_pepper_filtering is not None:
            self.allow_salt_and_pepper_filtering = allow_salt_and_pepper_filtering
        if allow_white_spots_removing is not None:
            self.allow_white_spots_removing = allow_white_spots_removing
        if region_likelihood_threshold_percent is not None:
            self.region_likelihood_threshold_percent = region_likelihood_threshold_percent
        if scan_window_sizes is not None:
            self.scan_window_sizes = scan_window_sizes
        if similarity is not None:
            self.similarity = similarity
        if skip_diagonal_search is not None:
            self.skip_diagonal_search = skip_diagonal_search
        if australian_post_encoding_table is not None:
            self.australian_post_encoding_table = australian_post_encoding_table

    @property
    def type(self):
        """Gets the type of this ReaderParams.  # noqa: E501

        The type of barcode to read.  # noqa: E501

        :return: The type of this ReaderParams.  # noqa: E501
        :rtype: DecodeBarcodeType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReaderParams.

        The type of barcode to read.  # noqa: E501

        :param type: The type of this ReaderParams.  # noqa: E501
        :type: DecodeBarcodeType
        """

        self._type = type

    @property
    def checksum_validation(self):
        """Gets the checksum_validation of this ReaderParams.  # noqa: E501

        Enable checksum validation during recognition for 1D barcodes. Default is treated as Yes for symbologies which must contain checksum, as No where checksum only possible. Checksum never used: Codabar Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN Checksum always used: Rest symbologies  # noqa: E501

        :return: The checksum_validation of this ReaderParams.  # noqa: E501
        :rtype: ChecksumValidation
        """
        return self._checksum_validation

    @checksum_validation.setter
    def checksum_validation(self, checksum_validation):
        """Sets the checksum_validation of this ReaderParams.

        Enable checksum validation during recognition for 1D barcodes. Default is treated as Yes for symbologies which must contain checksum, as No where checksum only possible. Checksum never used: Codabar Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN Checksum always used: Rest symbologies  # noqa: E501

        :param checksum_validation: The checksum_validation of this ReaderParams.  # noqa: E501
        :type: ChecksumValidation
        """

        self._checksum_validation = checksum_validation

    @property
    def detect_encoding(self):
        """Gets the detect_encoding of this ReaderParams.  # noqa: E501

        A flag which force engine to detect codetext encoding for Unicode.  # noqa: E501

        :return: The detect_encoding of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._detect_encoding

    @detect_encoding.setter
    def detect_encoding(self, detect_encoding):
        """Sets the detect_encoding of this ReaderParams.

        A flag which force engine to detect codetext encoding for Unicode.  # noqa: E501

        :param detect_encoding: The detect_encoding of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._detect_encoding = detect_encoding

    @property
    def preset(self):
        """Gets the preset of this ReaderParams.  # noqa: E501

        Preset allows to configure recognition quality and speed manually. You can quickly set up Preset by embedded presets: HighPerformance, NormalQuality, HighQuality, MaxBarCodes or you can manually configure separate options. Default value of Preset is NormalQuality.  # noqa: E501

        :return: The preset of this ReaderParams.  # noqa: E501
        :rtype: PresetType
        """
        return self._preset

    @preset.setter
    def preset(self, preset):
        """Sets the preset of this ReaderParams.

        Preset allows to configure recognition quality and speed manually. You can quickly set up Preset by embedded presets: HighPerformance, NormalQuality, HighQuality, MaxBarCodes or you can manually configure separate options. Default value of Preset is NormalQuality.  # noqa: E501

        :param preset: The preset of this ReaderParams.  # noqa: E501
        :type: PresetType
        """

        self._preset = preset

    @property
    def rect_x(self):
        """Gets the rect_x of this ReaderParams.  # noqa: E501

        Set X for area for recognition.  # noqa: E501

        :return: The rect_x of this ReaderParams.  # noqa: E501
        :rtype: int
        """
        return self._rect_x

    @rect_x.setter
    def rect_x(self, rect_x):
        """Sets the rect_x of this ReaderParams.

        Set X for area for recognition.  # noqa: E501

        :param rect_x: The rect_x of this ReaderParams.  # noqa: E501
        :type: int
        """

        self._rect_x = rect_x

    @property
    def rect_y(self):
        """Gets the rect_y of this ReaderParams.  # noqa: E501

        Set Y for area for recognition.  # noqa: E501

        :return: The rect_y of this ReaderParams.  # noqa: E501
        :rtype: int
        """
        return self._rect_y

    @rect_y.setter
    def rect_y(self, rect_y):
        """Sets the rect_y of this ReaderParams.

        Set Y for area for recognition.  # noqa: E501

        :param rect_y: The rect_y of this ReaderParams.  # noqa: E501
        :type: int
        """

        self._rect_y = rect_y

    @property
    def rect_width(self):
        """Gets the rect_width of this ReaderParams.  # noqa: E501

        Set Width of area for recognition.  # noqa: E501

        :return: The rect_width of this ReaderParams.  # noqa: E501
        :rtype: int
        """
        return self._rect_width

    @rect_width.setter
    def rect_width(self, rect_width):
        """Sets the rect_width of this ReaderParams.

        Set Width of area for recognition.  # noqa: E501

        :param rect_width: The rect_width of this ReaderParams.  # noqa: E501
        :type: int
        """

        self._rect_width = rect_width

    @property
    def rect_height(self):
        """Gets the rect_height of this ReaderParams.  # noqa: E501

        Set Height of area for recognition.  # noqa: E501

        :return: The rect_height of this ReaderParams.  # noqa: E501
        :rtype: int
        """
        return self._rect_height

    @rect_height.setter
    def rect_height(self, rect_height):
        """Sets the rect_height of this ReaderParams.

        Set Height of area for recognition.  # noqa: E501

        :param rect_height: The rect_height of this ReaderParams.  # noqa: E501
        :type: int
        """

        self._rect_height = rect_height

    @property
    def strip_fnc(self):
        """Gets the strip_fnc of this ReaderParams.  # noqa: E501

        Value indicating whether FNC symbol strip must be done.  # noqa: E501

        :return: The strip_fnc of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._strip_fnc

    @strip_fnc.setter
    def strip_fnc(self, strip_fnc):
        """Sets the strip_fnc of this ReaderParams.

        Value indicating whether FNC symbol strip must be done.  # noqa: E501

        :param strip_fnc: The strip_fnc of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._strip_fnc = strip_fnc

    @property
    def timeout(self):
        """Gets the timeout of this ReaderParams.  # noqa: E501

        Timeout of recognition process.  # noqa: E501

        :return: The timeout of this ReaderParams.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this ReaderParams.

        Timeout of recognition process.  # noqa: E501

        :param timeout: The timeout of this ReaderParams.  # noqa: E501
        :type: int
        """

        self._timeout = timeout

    @property
    def median_smoothing_window_size(self):
        """Gets the median_smoothing_window_size of this ReaderParams.  # noqa: E501

        Window size for median smoothing. Typical values are 3 or 4. Default value is 3. AllowMedianSmoothing must be set.  # noqa: E501

        :return: The median_smoothing_window_size of this ReaderParams.  # noqa: E501
        :rtype: int
        """
        return self._median_smoothing_window_size

    @median_smoothing_window_size.setter
    def median_smoothing_window_size(self, median_smoothing_window_size):
        """Sets the median_smoothing_window_size of this ReaderParams.

        Window size for median smoothing. Typical values are 3 or 4. Default value is 3. AllowMedianSmoothing must be set.  # noqa: E501

        :param median_smoothing_window_size: The median_smoothing_window_size of this ReaderParams.  # noqa: E501
        :type: int
        """

        self._median_smoothing_window_size = median_smoothing_window_size

    @property
    def allow_median_smoothing(self):
        """Gets the allow_median_smoothing of this ReaderParams.  # noqa: E501

        Allows engine to enable median smoothing as additional scan. Mode helps to recognize noised barcodes.  # noqa: E501

        :return: The allow_median_smoothing of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_median_smoothing

    @allow_median_smoothing.setter
    def allow_median_smoothing(self, allow_median_smoothing):
        """Sets the allow_median_smoothing of this ReaderParams.

        Allows engine to enable median smoothing as additional scan. Mode helps to recognize noised barcodes.  # noqa: E501

        :param allow_median_smoothing: The allow_median_smoothing of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_median_smoothing = allow_median_smoothing

    @property
    def allow_complex_background(self):
        """Gets the allow_complex_background of this ReaderParams.  # noqa: E501

        Allows engine to recognize color barcodes on color background as additional scan. Extremely slow mode.  # noqa: E501

        :return: The allow_complex_background of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_complex_background

    @allow_complex_background.setter
    def allow_complex_background(self, allow_complex_background):
        """Sets the allow_complex_background of this ReaderParams.

        Allows engine to recognize color barcodes on color background as additional scan. Extremely slow mode.  # noqa: E501

        :param allow_complex_background: The allow_complex_background of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_complex_background = allow_complex_background

    @property
    def allow_datamatrix_industrial_barcodes(self):
        """Gets the allow_datamatrix_industrial_barcodes of this ReaderParams.  # noqa: E501

        Allows engine for Datamatrix to recognize dashed industrial Datamatrix barcodes. Slow mode which helps only for dashed barcodes which consist from spots.  # noqa: E501

        :return: The allow_datamatrix_industrial_barcodes of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_datamatrix_industrial_barcodes

    @allow_datamatrix_industrial_barcodes.setter
    def allow_datamatrix_industrial_barcodes(self, allow_datamatrix_industrial_barcodes):
        """Sets the allow_datamatrix_industrial_barcodes of this ReaderParams.

        Allows engine for Datamatrix to recognize dashed industrial Datamatrix barcodes. Slow mode which helps only for dashed barcodes which consist from spots.  # noqa: E501

        :param allow_datamatrix_industrial_barcodes: The allow_datamatrix_industrial_barcodes of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_datamatrix_industrial_barcodes = allow_datamatrix_industrial_barcodes

    @property
    def allow_decreased_image(self):
        """Gets the allow_decreased_image of this ReaderParams.  # noqa: E501

        Allows engine to recognize decreased image as additional scan. Size for decreasing is selected by internal engine algorithms. Mode helps to recognize barcodes which are noised and blurred but captured with high resolution.  # noqa: E501

        :return: The allow_decreased_image of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_decreased_image

    @allow_decreased_image.setter
    def allow_decreased_image(self, allow_decreased_image):
        """Sets the allow_decreased_image of this ReaderParams.

        Allows engine to recognize decreased image as additional scan. Size for decreasing is selected by internal engine algorithms. Mode helps to recognize barcodes which are noised and blurred but captured with high resolution.  # noqa: E501

        :param allow_decreased_image: The allow_decreased_image of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_decreased_image = allow_decreased_image

    @property
    def allow_detect_scan_gap(self):
        """Gets the allow_detect_scan_gap of this ReaderParams.  # noqa: E501

        Allows engine to use gap between scans to increase recognition speed. Mode can make recognition problems with low height barcodes.  # noqa: E501

        :return: The allow_detect_scan_gap of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_detect_scan_gap

    @allow_detect_scan_gap.setter
    def allow_detect_scan_gap(self, allow_detect_scan_gap):
        """Sets the allow_detect_scan_gap of this ReaderParams.

        Allows engine to use gap between scans to increase recognition speed. Mode can make recognition problems with low height barcodes.  # noqa: E501

        :param allow_detect_scan_gap: The allow_detect_scan_gap of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_detect_scan_gap = allow_detect_scan_gap

    @property
    def allow_incorrect_barcodes(self):
        """Gets the allow_incorrect_barcodes of this ReaderParams.  # noqa: E501

        Allows engine to recognize barcodes which has incorrect checksum or incorrect values. Mode can be used to recognize damaged barcodes with incorrect text.  # noqa: E501

        :return: The allow_incorrect_barcodes of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_incorrect_barcodes

    @allow_incorrect_barcodes.setter
    def allow_incorrect_barcodes(self, allow_incorrect_barcodes):
        """Sets the allow_incorrect_barcodes of this ReaderParams.

        Allows engine to recognize barcodes which has incorrect checksum or incorrect values. Mode can be used to recognize damaged barcodes with incorrect text.  # noqa: E501

        :param allow_incorrect_barcodes: The allow_incorrect_barcodes of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_incorrect_barcodes = allow_incorrect_barcodes

    @property
    def allow_invert_image(self):
        """Gets the allow_invert_image of this ReaderParams.  # noqa: E501

        Allows engine to recognize inverse color image as additional scan. Mode can be used when barcode is white on black background.  # noqa: E501

        :return: The allow_invert_image of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_invert_image

    @allow_invert_image.setter
    def allow_invert_image(self, allow_invert_image):
        """Sets the allow_invert_image of this ReaderParams.

        Allows engine to recognize inverse color image as additional scan. Mode can be used when barcode is white on black background.  # noqa: E501

        :param allow_invert_image: The allow_invert_image of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_invert_image = allow_invert_image

    @property
    def allow_micro_white_spots_removing(self):
        """Gets the allow_micro_white_spots_removing of this ReaderParams.  # noqa: E501

        Allows engine for Postal barcodes to recognize slightly noised images. Mode helps to recognize slightly damaged Postal barcodes.  # noqa: E501

        :return: The allow_micro_white_spots_removing of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_micro_white_spots_removing

    @allow_micro_white_spots_removing.setter
    def allow_micro_white_spots_removing(self, allow_micro_white_spots_removing):
        """Sets the allow_micro_white_spots_removing of this ReaderParams.

        Allows engine for Postal barcodes to recognize slightly noised images. Mode helps to recognize slightly damaged Postal barcodes.  # noqa: E501

        :param allow_micro_white_spots_removing: The allow_micro_white_spots_removing of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_micro_white_spots_removing = allow_micro_white_spots_removing

    @property
    def allow_one_d_fast_barcodes_detector(self):
        """Gets the allow_one_d_fast_barcodes_detector of this ReaderParams.  # noqa: E501

        Allows engine for 1D barcodes to quickly recognize high quality barcodes which fill almost whole image. Mode helps to quickly recognize generated barcodes from Internet.  # noqa: E501

        :return: The allow_one_d_fast_barcodes_detector of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_one_d_fast_barcodes_detector

    @allow_one_d_fast_barcodes_detector.setter
    def allow_one_d_fast_barcodes_detector(self, allow_one_d_fast_barcodes_detector):
        """Sets the allow_one_d_fast_barcodes_detector of this ReaderParams.

        Allows engine for 1D barcodes to quickly recognize high quality barcodes which fill almost whole image. Mode helps to quickly recognize generated barcodes from Internet.  # noqa: E501

        :param allow_one_d_fast_barcodes_detector: The allow_one_d_fast_barcodes_detector of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_one_d_fast_barcodes_detector = allow_one_d_fast_barcodes_detector

    @property
    def allow_one_d_wiped_bars_restoration(self):
        """Gets the allow_one_d_wiped_bars_restoration of this ReaderParams.  # noqa: E501

        Allows engine for 1D barcodes to recognize barcodes with single wiped/glued bars in pattern.  # noqa: E501

        :return: The allow_one_d_wiped_bars_restoration of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_one_d_wiped_bars_restoration

    @allow_one_d_wiped_bars_restoration.setter
    def allow_one_d_wiped_bars_restoration(self, allow_one_d_wiped_bars_restoration):
        """Sets the allow_one_d_wiped_bars_restoration of this ReaderParams.

        Allows engine for 1D barcodes to recognize barcodes with single wiped/glued bars in pattern.  # noqa: E501

        :param allow_one_d_wiped_bars_restoration: The allow_one_d_wiped_bars_restoration of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_one_d_wiped_bars_restoration = allow_one_d_wiped_bars_restoration

    @property
    def allow_qr_micro_qr_restoration(self):
        """Gets the allow_qr_micro_qr_restoration of this ReaderParams.  # noqa: E501

        Allows engine for QR/MicroQR to recognize damaged MicroQR barcodes.  # noqa: E501

        :return: The allow_qr_micro_qr_restoration of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_qr_micro_qr_restoration

    @allow_qr_micro_qr_restoration.setter
    def allow_qr_micro_qr_restoration(self, allow_qr_micro_qr_restoration):
        """Sets the allow_qr_micro_qr_restoration of this ReaderParams.

        Allows engine for QR/MicroQR to recognize damaged MicroQR barcodes.  # noqa: E501

        :param allow_qr_micro_qr_restoration: The allow_qr_micro_qr_restoration of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_qr_micro_qr_restoration = allow_qr_micro_qr_restoration

    @property
    def allow_regular_image(self):
        """Gets the allow_regular_image of this ReaderParams.  # noqa: E501

        Allows engine to recognize regular image without any restorations as main scan. Mode to recognize image as is.  # noqa: E501

        :return: The allow_regular_image of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_regular_image

    @allow_regular_image.setter
    def allow_regular_image(self, allow_regular_image):
        """Sets the allow_regular_image of this ReaderParams.

        Allows engine to recognize regular image without any restorations as main scan. Mode to recognize image as is.  # noqa: E501

        :param allow_regular_image: The allow_regular_image of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_regular_image = allow_regular_image

    @property
    def allow_salt_and_pepper_filtering(self):
        """Gets the allow_salt_and_pepper_filtering of this ReaderParams.  # noqa: E501

        Allows engine to recognize barcodes with salt and pepper noise type. Mode can remove small noise with white and black dots.  # noqa: E501

        :return: The allow_salt_and_pepper_filtering of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_salt_and_pepper_filtering

    @allow_salt_and_pepper_filtering.setter
    def allow_salt_and_pepper_filtering(self, allow_salt_and_pepper_filtering):
        """Sets the allow_salt_and_pepper_filtering of this ReaderParams.

        Allows engine to recognize barcodes with salt and pepper noise type. Mode can remove small noise with white and black dots.  # noqa: E501

        :param allow_salt_and_pepper_filtering: The allow_salt_and_pepper_filtering of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_salt_and_pepper_filtering = allow_salt_and_pepper_filtering

    @property
    def allow_white_spots_removing(self):
        """Gets the allow_white_spots_removing of this ReaderParams.  # noqa: E501

        Allows engine to recognize image without small white spots as additional scan. Mode helps to recognize noised image as well as median smoothing filtering.  # noqa: E501

        :return: The allow_white_spots_removing of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._allow_white_spots_removing

    @allow_white_spots_removing.setter
    def allow_white_spots_removing(self, allow_white_spots_removing):
        """Sets the allow_white_spots_removing of this ReaderParams.

        Allows engine to recognize image without small white spots as additional scan. Mode helps to recognize noised image as well as median smoothing filtering.  # noqa: E501

        :param allow_white_spots_removing: The allow_white_spots_removing of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._allow_white_spots_removing = allow_white_spots_removing

    @property
    def region_likelihood_threshold_percent(self):
        """Gets the region_likelihood_threshold_percent of this ReaderParams.  # noqa: E501

        Sets threshold for detected regions that may contain barcodes. Value 0.7 means that bottom 70% of possible regions are filtered out and not processed further. Region likelihood threshold must be between [0.05, 0.9] Use high values for clear images with few barcodes. Use low values for images with many barcodes or for noisy images. Low value may lead to a bigger recognition time.  # noqa: E501

        :return: The region_likelihood_threshold_percent of this ReaderParams.  # noqa: E501
        :rtype: float
        """
        return self._region_likelihood_threshold_percent

    @region_likelihood_threshold_percent.setter
    def region_likelihood_threshold_percent(self, region_likelihood_threshold_percent):
        """Sets the region_likelihood_threshold_percent of this ReaderParams.

        Sets threshold for detected regions that may contain barcodes. Value 0.7 means that bottom 70% of possible regions are filtered out and not processed further. Region likelihood threshold must be between [0.05, 0.9] Use high values for clear images with few barcodes. Use low values for images with many barcodes or for noisy images. Low value may lead to a bigger recognition time.  # noqa: E501

        :param region_likelihood_threshold_percent: The region_likelihood_threshold_percent of this ReaderParams.  # noqa: E501
        :type: float
        """

        self._region_likelihood_threshold_percent = region_likelihood_threshold_percent

    @property
    def scan_window_sizes(self):
        """Gets the scan_window_sizes of this ReaderParams.  # noqa: E501

        Scan window sizes in pixels. Allowed sizes are 10, 15, 20, 25, 30. Scanning with small window size takes more time and provides more accuracy but may fail in detecting very big barcodes. Combining of several window sizes can improve detection quality.  # noqa: E501

        :return: The scan_window_sizes of this ReaderParams.  # noqa: E501
        :rtype: list[int]
        """
        return self._scan_window_sizes

    @scan_window_sizes.setter
    def scan_window_sizes(self, scan_window_sizes):
        """Sets the scan_window_sizes of this ReaderParams.

        Scan window sizes in pixels. Allowed sizes are 10, 15, 20, 25, 30. Scanning with small window size takes more time and provides more accuracy but may fail in detecting very big barcodes. Combining of several window sizes can improve detection quality.  # noqa: E501

        :param scan_window_sizes: The scan_window_sizes of this ReaderParams.  # noqa: E501
        :type: list[int]
        """

        self._scan_window_sizes = scan_window_sizes

    @property
    def similarity(self):
        """Gets the similarity of this ReaderParams.  # noqa: E501

        Similarity coefficient depends on how homogeneous barcodes are. Use high value for for clear barcodes. Use low values to detect barcodes that ara partly damaged or not lighten evenly. Similarity coefficient must be between [0.5, 0.9]  # noqa: E501

        :return: The similarity of this ReaderParams.  # noqa: E501
        :rtype: float
        """
        return self._similarity

    @similarity.setter
    def similarity(self, similarity):
        """Sets the similarity of this ReaderParams.

        Similarity coefficient depends on how homogeneous barcodes are. Use high value for for clear barcodes. Use low values to detect barcodes that ara partly damaged or not lighten evenly. Similarity coefficient must be between [0.5, 0.9]  # noqa: E501

        :param similarity: The similarity of this ReaderParams.  # noqa: E501
        :type: float
        """

        self._similarity = similarity

    @property
    def skip_diagonal_search(self):
        """Gets the skip_diagonal_search of this ReaderParams.  # noqa: E501

        Allows detector to skip search for diagonal barcodes. Setting it to false will increase detection time but allow to find diagonal barcodes that can be missed otherwise. Enabling of diagonal search leads to a bigger detection time.  # noqa: E501

        :return: The skip_diagonal_search of this ReaderParams.  # noqa: E501
        :rtype: bool
        """
        return self._skip_diagonal_search

    @skip_diagonal_search.setter
    def skip_diagonal_search(self, skip_diagonal_search):
        """Sets the skip_diagonal_search of this ReaderParams.

        Allows detector to skip search for diagonal barcodes. Setting it to false will increase detection time but allow to find diagonal barcodes that can be missed otherwise. Enabling of diagonal search leads to a bigger detection time.  # noqa: E501

        :param skip_diagonal_search: The skip_diagonal_search of this ReaderParams.  # noqa: E501
        :type: bool
        """

        self._skip_diagonal_search = skip_diagonal_search

    @property
    def australian_post_encoding_table(self):
        """Gets the australian_post_encoding_table of this ReaderParams.  # noqa: E501

        Interpreting Type for the Customer Information of AustralianPost BarCode.Default is CustomerInformationInterpretingType.Other.  # noqa: E501

        :return: The australian_post_encoding_table of this ReaderParams.  # noqa: E501
        :rtype: CustomerInformationInterpretingType
        """
        return self._australian_post_encoding_table

    @australian_post_encoding_table.setter
    def australian_post_encoding_table(self, australian_post_encoding_table):
        """Sets the australian_post_encoding_table of this ReaderParams.

        Interpreting Type for the Customer Information of AustralianPost BarCode.Default is CustomerInformationInterpretingType.Other.  # noqa: E501

        :param australian_post_encoding_table: The australian_post_encoding_table of this ReaderParams.  # noqa: E501
        :type: CustomerInformationInterpretingType
        """

        self._australian_post_encoding_table = australian_post_encoding_table

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(ReaderParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReaderParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
