# coding: utf-8

"""

    Copyright (c) 2020 Aspose.BarCode for Cloud

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.

"""


import pprint
import re  # noqa: F401

import six


class ITFParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {"border_thickness": "float", "border_type": "ITF14BorderType", "quiet_zone_coef": "int"}

    attribute_map = {
        "border_thickness": "BorderThickness",
        "border_type": "BorderType",
        "quiet_zone_coef": "QuietZoneCoef",
    }

    def __init__(self, border_thickness=None, border_type=None, quiet_zone_coef=None):  # noqa: E501
        """ITFParams - a model defined in Swagger"""  # noqa: E501

        self._border_thickness = None
        self._border_type = None
        self._quiet_zone_coef = None
        self.discriminator = None

        if border_thickness is not None:
            self.border_thickness = border_thickness
        if border_type is not None:
            self.border_type = border_type
        if quiet_zone_coef is not None:
            self.quiet_zone_coef = quiet_zone_coef

    @property
    def border_thickness(self):
        """Gets the border_thickness of this ITFParams.  # noqa: E501

        ITF border (bearer bar) thickness in Unit value. Default value: 12pt.  # noqa: E501

        :return: The border_thickness of this ITFParams.  # noqa: E501
        :rtype: float
        """
        return self._border_thickness

    @border_thickness.setter
    def border_thickness(self, border_thickness):
        """Sets the border_thickness of this ITFParams.

        ITF border (bearer bar) thickness in Unit value. Default value: 12pt.  # noqa: E501

        :param border_thickness: The border_thickness of this ITFParams.  # noqa: E501
        :type: float
        """

        self._border_thickness = border_thickness

    @property
    def border_type(self):
        """Gets the border_type of this ITFParams.  # noqa: E501

        Border type of ITF barcode. Default value: ITF14BorderType.Bar.  # noqa: E501

        :return: The border_type of this ITFParams.  # noqa: E501
        :rtype: ITF14BorderType
        """
        return self._border_type

    @border_type.setter
    def border_type(self, border_type):
        """Sets the border_type of this ITFParams.

        Border type of ITF barcode. Default value: ITF14BorderType.Bar.  # noqa: E501

        :param border_type: The border_type of this ITFParams.  # noqa: E501
        :type: ITF14BorderType
        """

        self._border_type = border_type

    @property
    def quiet_zone_coef(self):
        """Gets the quiet_zone_coef of this ITFParams.  # noqa: E501

        Size of the quiet zones in xDimension. Default value: 10, meaning if xDimension = 2px than quiet zones will be 20px.  # noqa: E501

        :return: The quiet_zone_coef of this ITFParams.  # noqa: E501
        :rtype: int
        """
        return self._quiet_zone_coef

    @quiet_zone_coef.setter
    def quiet_zone_coef(self, quiet_zone_coef):
        """Sets the quiet_zone_coef of this ITFParams.

        Size of the quiet zones in xDimension. Default value: 10, meaning if xDimension = 2px than quiet zones will be 20px.  # noqa: E501

        :param quiet_zone_coef: The quiet_zone_coef of this ITFParams.  # noqa: E501
        :type: int
        """

        self._quiet_zone_coef = quiet_zone_coef

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(ITFParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ITFParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
