# coding: utf-8

"""

    Copyright (c) 2020 Aspose.BarCode for Cloud

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.

"""


import pprint
import re  # noqa: F401

import six


class GeneratorParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "type_of_barcode": "EncodeBarcodeType",
        "text": "str",
        "two_d_display_text": "str",
        "text_location": "CodeLocation",
        "text_alignment": "TextAlignment",
        "text_color": "str",
        "font": "FontParams",
        "font_size_mode": "FontMode",
        "resolution": "float",
        "resolution_x": "float",
        "resolution_y": "float",
        "dimension_x": "float",
        "text_space": "float",
        "units": "AvailableGraphicsUnit",
        "size_mode": "AutoSizeMode",
        "bar_height": "float",
        "image_height": "float",
        "image_width": "float",
        "rotation_angle": "float",
        "padding": "Padding",
        "caption_above": "CaptionParams",
        "caption_below": "CaptionParams",
        "back_color": "str",
        "bar_color": "str",
        "border_color": "str",
        "border_width": "float",
        "border_dash_style": "BorderDashStyle",
        "border_visible": "bool",
        "enable_checksum": "EnableChecksum",
        "enable_escape": "bool",
        "filled_bars": "bool",
        "always_show_checksum": "bool",
        "wide_narrow_ratio": "float",
        "validate_text": "bool",
        "supplement_data": "str",
        "supplement_space": "float",
        "australian_post": "AustralianPostParams",
        "aztec": "AztecParams",
        "codabar": "CodabarParams",
        "codablock": "CodablockParams",
        "code16_k": "Code16KParams",
        "coupon": "CouponParams",
        "data_bar": "DataBarParams",
        "data_matrix": "DataMatrixParams",
        "dot_code": "DotCodeParams",
        "itf": "ITFParams",
        "maxi_code": "MaxiCodeParams",
        "pdf417": "Pdf417Params",
        "postal": "PostalParams",
        "qr": "QrParams",
        "patch_code": "PatchCodeParams",
    }

    attribute_map = {
        "type_of_barcode": "TypeOfBarcode",
        "text": "Text",
        "two_d_display_text": "TwoDDisplayText",
        "text_location": "TextLocation",
        "text_alignment": "TextAlignment",
        "text_color": "TextColor",
        "font": "Font",
        "font_size_mode": "FontSizeMode",
        "resolution": "Resolution",
        "resolution_x": "ResolutionX",
        "resolution_y": "ResolutionY",
        "dimension_x": "DimensionX",
        "text_space": "TextSpace",
        "units": "Units",
        "size_mode": "SizeMode",
        "bar_height": "BarHeight",
        "image_height": "ImageHeight",
        "image_width": "ImageWidth",
        "rotation_angle": "RotationAngle",
        "padding": "Padding",
        "caption_above": "CaptionAbove",
        "caption_below": "CaptionBelow",
        "back_color": "BackColor",
        "bar_color": "BarColor",
        "border_color": "BorderColor",
        "border_width": "BorderWidth",
        "border_dash_style": "BorderDashStyle",
        "border_visible": "BorderVisible",
        "enable_checksum": "EnableChecksum",
        "enable_escape": "EnableEscape",
        "filled_bars": "FilledBars",
        "always_show_checksum": "AlwaysShowChecksum",
        "wide_narrow_ratio": "WideNarrowRatio",
        "validate_text": "ValidateText",
        "supplement_data": "SupplementData",
        "supplement_space": "SupplementSpace",
        "australian_post": "AustralianPost",
        "aztec": "Aztec",
        "codabar": "Codabar",
        "codablock": "Codablock",
        "code16_k": "Code16K",
        "coupon": "Coupon",
        "data_bar": "DataBar",
        "data_matrix": "DataMatrix",
        "dot_code": "DotCode",
        "itf": "ITF",
        "maxi_code": "MaxiCode",
        "pdf417": "Pdf417",
        "postal": "Postal",
        "qr": "QR",
        "patch_code": "PatchCode",
    }

    def __init__(
        self,
        type_of_barcode=None,
        text=None,
        two_d_display_text=None,
        text_location=None,
        text_alignment=None,
        text_color=None,
        font=None,
        font_size_mode=None,
        resolution=None,
        resolution_x=None,
        resolution_y=None,
        dimension_x=None,
        text_space=None,
        units=None,
        size_mode=None,
        bar_height=None,
        image_height=None,
        image_width=None,
        rotation_angle=None,
        padding=None,
        caption_above=None,
        caption_below=None,
        back_color=None,
        bar_color=None,
        border_color=None,
        border_width=None,
        border_dash_style=None,
        border_visible=None,
        enable_checksum=None,
        enable_escape=None,
        filled_bars=None,
        always_show_checksum=None,
        wide_narrow_ratio=None,
        validate_text=None,
        supplement_data=None,
        supplement_space=None,
        australian_post=None,
        aztec=None,
        codabar=None,
        codablock=None,
        code16_k=None,
        coupon=None,
        data_bar=None,
        data_matrix=None,
        dot_code=None,
        itf=None,
        maxi_code=None,
        pdf417=None,
        postal=None,
        qr=None,
        patch_code=None,
    ):  # noqa: E501
        """GeneratorParams - a model defined in Swagger"""  # noqa: E501

        self._type_of_barcode = None
        self._text = None
        self._two_d_display_text = None
        self._text_location = None
        self._text_alignment = None
        self._text_color = None
        self._font = None
        self._font_size_mode = None
        self._resolution = None
        self._resolution_x = None
        self._resolution_y = None
        self._dimension_x = None
        self._text_space = None
        self._units = None
        self._size_mode = None
        self._bar_height = None
        self._image_height = None
        self._image_width = None
        self._rotation_angle = None
        self._padding = None
        self._caption_above = None
        self._caption_below = None
        self._back_color = None
        self._bar_color = None
        self._border_color = None
        self._border_width = None
        self._border_dash_style = None
        self._border_visible = None
        self._enable_checksum = None
        self._enable_escape = None
        self._filled_bars = None
        self._always_show_checksum = None
        self._wide_narrow_ratio = None
        self._validate_text = None
        self._supplement_data = None
        self._supplement_space = None
        self._australian_post = None
        self._aztec = None
        self._codabar = None
        self._codablock = None
        self._code16_k = None
        self._coupon = None
        self._data_bar = None
        self._data_matrix = None
        self._dot_code = None
        self._itf = None
        self._maxi_code = None
        self._pdf417 = None
        self._postal = None
        self._qr = None
        self._patch_code = None
        self.discriminator = None

        self.type_of_barcode = type_of_barcode
        self.text = text
        if two_d_display_text is not None:
            self.two_d_display_text = two_d_display_text
        if text_location is not None:
            self.text_location = text_location
        if text_alignment is not None:
            self.text_alignment = text_alignment
        if text_color is not None:
            self.text_color = text_color
        if font is not None:
            self.font = font
        if font_size_mode is not None:
            self.font_size_mode = font_size_mode
        if resolution is not None:
            self.resolution = resolution
        if resolution_x is not None:
            self.resolution_x = resolution_x
        if resolution_y is not None:
            self.resolution_y = resolution_y
        if dimension_x is not None:
            self.dimension_x = dimension_x
        if text_space is not None:
            self.text_space = text_space
        if units is not None:
            self.units = units
        if size_mode is not None:
            self.size_mode = size_mode
        if bar_height is not None:
            self.bar_height = bar_height
        if image_height is not None:
            self.image_height = image_height
        if image_width is not None:
            self.image_width = image_width
        if rotation_angle is not None:
            self.rotation_angle = rotation_angle
        if padding is not None:
            self.padding = padding
        if caption_above is not None:
            self.caption_above = caption_above
        if caption_below is not None:
            self.caption_below = caption_below
        if back_color is not None:
            self.back_color = back_color
        if bar_color is not None:
            self.bar_color = bar_color
        if border_color is not None:
            self.border_color = border_color
        if border_width is not None:
            self.border_width = border_width
        if border_dash_style is not None:
            self.border_dash_style = border_dash_style
        if border_visible is not None:
            self.border_visible = border_visible
        if enable_checksum is not None:
            self.enable_checksum = enable_checksum
        if enable_escape is not None:
            self.enable_escape = enable_escape
        if filled_bars is not None:
            self.filled_bars = filled_bars
        if always_show_checksum is not None:
            self.always_show_checksum = always_show_checksum
        if wide_narrow_ratio is not None:
            self.wide_narrow_ratio = wide_narrow_ratio
        if validate_text is not None:
            self.validate_text = validate_text
        if supplement_data is not None:
            self.supplement_data = supplement_data
        if supplement_space is not None:
            self.supplement_space = supplement_space
        if australian_post is not None:
            self.australian_post = australian_post
        if aztec is not None:
            self.aztec = aztec
        if codabar is not None:
            self.codabar = codabar
        if codablock is not None:
            self.codablock = codablock
        if code16_k is not None:
            self.code16_k = code16_k
        if coupon is not None:
            self.coupon = coupon
        if data_bar is not None:
            self.data_bar = data_bar
        if data_matrix is not None:
            self.data_matrix = data_matrix
        if dot_code is not None:
            self.dot_code = dot_code
        if itf is not None:
            self.itf = itf
        if maxi_code is not None:
            self.maxi_code = maxi_code
        if pdf417 is not None:
            self.pdf417 = pdf417
        if postal is not None:
            self.postal = postal
        if qr is not None:
            self.qr = qr
        if patch_code is not None:
            self.patch_code = patch_code

    @property
    def type_of_barcode(self):
        """Gets the type_of_barcode of this GeneratorParams.  # noqa: E501

        Type of barcode to generate.  # noqa: E501

        :return: The type_of_barcode of this GeneratorParams.  # noqa: E501
        :rtype: EncodeBarcodeType
        """
        return self._type_of_barcode

    @type_of_barcode.setter
    def type_of_barcode(self, type_of_barcode):
        """Sets the type_of_barcode of this GeneratorParams.

        Type of barcode to generate.  # noqa: E501

        :param type_of_barcode: The type_of_barcode of this GeneratorParams.  # noqa: E501
        :type: EncodeBarcodeType
        """
        if type_of_barcode is None:
            raise ValueError("Invalid value for `type_of_barcode`, must not be `None`")  # noqa: E501

        self._type_of_barcode = type_of_barcode

    @property
    def text(self):
        """Gets the text of this GeneratorParams.  # noqa: E501

        Text to encode.  # noqa: E501

        :return: The text of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this GeneratorParams.

        Text to encode.  # noqa: E501

        :param text: The text of this GeneratorParams.  # noqa: E501
        :type: str
        """
        if text is None:
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501

        self._text = text

    @property
    def two_d_display_text(self):
        """Gets the two_d_display_text of this GeneratorParams.  # noqa: E501

        Text that will be displayed instead of codetext in 2D barcodes. Used for: Aztec, Pdf417, DataMatrix, QR, MaxiCode, DotCode  # noqa: E501

        :return: The two_d_display_text of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._two_d_display_text

    @two_d_display_text.setter
    def two_d_display_text(self, two_d_display_text):
        """Sets the two_d_display_text of this GeneratorParams.

        Text that will be displayed instead of codetext in 2D barcodes. Used for: Aztec, Pdf417, DataMatrix, QR, MaxiCode, DotCode  # noqa: E501

        :param two_d_display_text: The two_d_display_text of this GeneratorParams.  # noqa: E501
        :type: str
        """

        self._two_d_display_text = two_d_display_text

    @property
    def text_location(self):
        """Gets the text_location of this GeneratorParams.  # noqa: E501

        Specify the displaying Text Location, set to CodeLocation.None to hide CodeText. Default value: CodeLocation.Below.  # noqa: E501

        :return: The text_location of this GeneratorParams.  # noqa: E501
        :rtype: CodeLocation
        """
        return self._text_location

    @text_location.setter
    def text_location(self, text_location):
        """Sets the text_location of this GeneratorParams.

        Specify the displaying Text Location, set to CodeLocation.None to hide CodeText. Default value: CodeLocation.Below.  # noqa: E501

        :param text_location: The text_location of this GeneratorParams.  # noqa: E501
        :type: CodeLocation
        """

        self._text_location = text_location

    @property
    def text_alignment(self):
        """Gets the text_alignment of this GeneratorParams.  # noqa: E501

        Text alignment.  # noqa: E501

        :return: The text_alignment of this GeneratorParams.  # noqa: E501
        :rtype: TextAlignment
        """
        return self._text_alignment

    @text_alignment.setter
    def text_alignment(self, text_alignment):
        """Sets the text_alignment of this GeneratorParams.

        Text alignment.  # noqa: E501

        :param text_alignment: The text_alignment of this GeneratorParams.  # noqa: E501
        :type: TextAlignment
        """

        self._text_alignment = text_alignment

    @property
    def text_color(self):
        """Gets the text_color of this GeneratorParams.  # noqa: E501

        Specify the displaying CodeText's Color. Default value: Color.Black.  # noqa: E501

        :return: The text_color of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._text_color

    @text_color.setter
    def text_color(self, text_color):
        """Sets the text_color of this GeneratorParams.

        Specify the displaying CodeText's Color. Default value: Color.Black.  # noqa: E501

        :param text_color: The text_color of this GeneratorParams.  # noqa: E501
        :type: str
        """

        self._text_color = text_color

    @property
    def font(self):
        """Gets the font of this GeneratorParams.  # noqa: E501

        Specify the displaying Text's font. Default value: Arial 5pt regular. Ignored if FontSizeMode is set to FontSizeMode.Auto.  # noqa: E501

        :return: The font of this GeneratorParams.  # noqa: E501
        :rtype: FontParams
        """
        return self._font

    @font.setter
    def font(self, font):
        """Sets the font of this GeneratorParams.

        Specify the displaying Text's font. Default value: Arial 5pt regular. Ignored if FontSizeMode is set to FontSizeMode.Auto.  # noqa: E501

        :param font: The font of this GeneratorParams.  # noqa: E501
        :type: FontParams
        """

        self._font = font

    @property
    def font_size_mode(self):
        """Gets the font_size_mode of this GeneratorParams.  # noqa: E501

        Specify FontSizeMode. If FontSizeMode is set to Auto, font size will be calculated automatically based on xDimension value. It is recommended to use FontSizeMode.Auto especially in AutoSizeMode.Nearest or AutoSizeMode.Interpolation. Default value: FontSizeMode.Auto.  # noqa: E501

        :return: The font_size_mode of this GeneratorParams.  # noqa: E501
        :rtype: FontMode
        """
        return self._font_size_mode

    @font_size_mode.setter
    def font_size_mode(self, font_size_mode):
        """Sets the font_size_mode of this GeneratorParams.

        Specify FontSizeMode. If FontSizeMode is set to Auto, font size will be calculated automatically based on xDimension value. It is recommended to use FontSizeMode.Auto especially in AutoSizeMode.Nearest or AutoSizeMode.Interpolation. Default value: FontSizeMode.Auto.  # noqa: E501

        :param font_size_mode: The font_size_mode of this GeneratorParams.  # noqa: E501
        :type: FontMode
        """

        self._font_size_mode = font_size_mode

    @property
    def resolution(self):
        """Gets the resolution of this GeneratorParams.  # noqa: E501

        Resolution of the BarCode image. One value for both dimensions. Default value: 96 dpi.  # noqa: E501

        :return: The resolution of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """Sets the resolution of this GeneratorParams.

        Resolution of the BarCode image. One value for both dimensions. Default value: 96 dpi.  # noqa: E501

        :param resolution: The resolution of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._resolution = resolution

    @property
    def resolution_x(self):
        """Gets the resolution_x of this GeneratorParams.  # noqa: E501

        DEPRECATED: Use 'Resolution' instead.  # noqa: E501

        :return: The resolution_x of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._resolution_x

    @resolution_x.setter
    def resolution_x(self, resolution_x):
        """Sets the resolution_x of this GeneratorParams.

        DEPRECATED: Use 'Resolution' instead.  # noqa: E501

        :param resolution_x: The resolution_x of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._resolution_x = resolution_x

    @property
    def resolution_y(self):
        """Gets the resolution_y of this GeneratorParams.  # noqa: E501

        DEPRECATED: Use 'Resolution' instead.  # noqa: E501

        :return: The resolution_y of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._resolution_y

    @resolution_y.setter
    def resolution_y(self, resolution_y):
        """Sets the resolution_y of this GeneratorParams.

        DEPRECATED: Use 'Resolution' instead.  # noqa: E501

        :param resolution_y: The resolution_y of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._resolution_y = resolution_y

    @property
    def dimension_x(self):
        """Gets the dimension_x of this GeneratorParams.  # noqa: E501

        The smallest width of the unit of BarCode bars or spaces. Increase this will increase the whole barcode image width. Ignored if AutoSizeMode property is set to AutoSizeMode.Nearest or AutoSizeMode.Interpolation.  # noqa: E501

        :return: The dimension_x of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._dimension_x

    @dimension_x.setter
    def dimension_x(self, dimension_x):
        """Sets the dimension_x of this GeneratorParams.

        The smallest width of the unit of BarCode bars or spaces. Increase this will increase the whole barcode image width. Ignored if AutoSizeMode property is set to AutoSizeMode.Nearest or AutoSizeMode.Interpolation.  # noqa: E501

        :param dimension_x: The dimension_x of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._dimension_x = dimension_x

    @property
    def text_space(self):
        """Gets the text_space of this GeneratorParams.  # noqa: E501

        Space between the CodeText and the BarCode in Unit value. Default value: 2pt. Ignored for EAN8, EAN13, UPCE, UPCA, ISBN, ISMN, ISSN, UpcaGs1DatabarCoupon.  # noqa: E501

        :return: The text_space of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._text_space

    @text_space.setter
    def text_space(self, text_space):
        """Sets the text_space of this GeneratorParams.

        Space between the CodeText and the BarCode in Unit value. Default value: 2pt. Ignored for EAN8, EAN13, UPCE, UPCA, ISBN, ISMN, ISSN, UpcaGs1DatabarCoupon.  # noqa: E501

        :param text_space: The text_space of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._text_space = text_space

    @property
    def units(self):
        """Gets the units of this GeneratorParams.  # noqa: E501

        Common Units for all measuring in query. Default units: pixel.  # noqa: E501

        :return: The units of this GeneratorParams.  # noqa: E501
        :rtype: AvailableGraphicsUnit
        """
        return self._units

    @units.setter
    def units(self, units):
        """Sets the units of this GeneratorParams.

        Common Units for all measuring in query. Default units: pixel.  # noqa: E501

        :param units: The units of this GeneratorParams.  # noqa: E501
        :type: AvailableGraphicsUnit
        """

        self._units = units

    @property
    def size_mode(self):
        """Gets the size_mode of this GeneratorParams.  # noqa: E501

        Specifies the different types of automatic sizing modes. Default value: AutoSizeMode.None.  # noqa: E501

        :return: The size_mode of this GeneratorParams.  # noqa: E501
        :rtype: AutoSizeMode
        """
        return self._size_mode

    @size_mode.setter
    def size_mode(self, size_mode):
        """Sets the size_mode of this GeneratorParams.

        Specifies the different types of automatic sizing modes. Default value: AutoSizeMode.None.  # noqa: E501

        :param size_mode: The size_mode of this GeneratorParams.  # noqa: E501
        :type: AutoSizeMode
        """

        self._size_mode = size_mode

    @property
    def bar_height(self):
        """Gets the bar_height of this GeneratorParams.  # noqa: E501

        Height of the barcode in given units. Default units: pixel.  # noqa: E501

        :return: The bar_height of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._bar_height

    @bar_height.setter
    def bar_height(self, bar_height):
        """Sets the bar_height of this GeneratorParams.

        Height of the barcode in given units. Default units: pixel.  # noqa: E501

        :param bar_height: The bar_height of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._bar_height = bar_height

    @property
    def image_height(self):
        """Gets the image_height of this GeneratorParams.  # noqa: E501

        Height of the barcode image in given units. Default units: pixel.  # noqa: E501

        :return: The image_height of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._image_height

    @image_height.setter
    def image_height(self, image_height):
        """Sets the image_height of this GeneratorParams.

        Height of the barcode image in given units. Default units: pixel.  # noqa: E501

        :param image_height: The image_height of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._image_height = image_height

    @property
    def image_width(self):
        """Gets the image_width of this GeneratorParams.  # noqa: E501

        Width of the barcode image in given units. Default units: pixel.  # noqa: E501

        :return: The image_width of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._image_width

    @image_width.setter
    def image_width(self, image_width):
        """Sets the image_width of this GeneratorParams.

        Width of the barcode image in given units. Default units: pixel.  # noqa: E501

        :param image_width: The image_width of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._image_width = image_width

    @property
    def rotation_angle(self):
        """Gets the rotation_angle of this GeneratorParams.  # noqa: E501

        BarCode image rotation angle, measured in degree, e.g. RotationAngle = 0 or RotationAngle = 360 means no rotation. If RotationAngle NOT equal to 90, 180, 270 or 0, it may increase the difficulty for the scanner to read the image. Default value: 0.  # noqa: E501

        :return: The rotation_angle of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._rotation_angle

    @rotation_angle.setter
    def rotation_angle(self, rotation_angle):
        """Sets the rotation_angle of this GeneratorParams.

        BarCode image rotation angle, measured in degree, e.g. RotationAngle = 0 or RotationAngle = 360 means no rotation. If RotationAngle NOT equal to 90, 180, 270 or 0, it may increase the difficulty for the scanner to read the image. Default value: 0.  # noqa: E501

        :param rotation_angle: The rotation_angle of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._rotation_angle = rotation_angle

    @property
    def padding(self):
        """Gets the padding of this GeneratorParams.  # noqa: E501

        Barcode paddings. Default value: 5pt 5pt 5pt 5pt.  # noqa: E501

        :return: The padding of this GeneratorParams.  # noqa: E501
        :rtype: Padding
        """
        return self._padding

    @padding.setter
    def padding(self, padding):
        """Sets the padding of this GeneratorParams.

        Barcode paddings. Default value: 5pt 5pt 5pt 5pt.  # noqa: E501

        :param padding: The padding of this GeneratorParams.  # noqa: E501
        :type: Padding
        """

        self._padding = padding

    @property
    def caption_above(self):
        """Gets the caption_above of this GeneratorParams.  # noqa: E501

        Additional caption above barcode.  # noqa: E501

        :return: The caption_above of this GeneratorParams.  # noqa: E501
        :rtype: CaptionParams
        """
        return self._caption_above

    @caption_above.setter
    def caption_above(self, caption_above):
        """Sets the caption_above of this GeneratorParams.

        Additional caption above barcode.  # noqa: E501

        :param caption_above: The caption_above of this GeneratorParams.  # noqa: E501
        :type: CaptionParams
        """

        self._caption_above = caption_above

    @property
    def caption_below(self):
        """Gets the caption_below of this GeneratorParams.  # noqa: E501

        Additional caption below barcode.  # noqa: E501

        :return: The caption_below of this GeneratorParams.  # noqa: E501
        :rtype: CaptionParams
        """
        return self._caption_below

    @caption_below.setter
    def caption_below(self, caption_below):
        """Sets the caption_below of this GeneratorParams.

        Additional caption below barcode.  # noqa: E501

        :param caption_below: The caption_below of this GeneratorParams.  # noqa: E501
        :type: CaptionParams
        """

        self._caption_below = caption_below

    @property
    def back_color(self):
        """Gets the back_color of this GeneratorParams.  # noqa: E501

        Background color of the barcode image. Default value: Color.White.  # noqa: E501

        :return: The back_color of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._back_color

    @back_color.setter
    def back_color(self, back_color):
        """Sets the back_color of this GeneratorParams.

        Background color of the barcode image. Default value: Color.White.  # noqa: E501

        :param back_color: The back_color of this GeneratorParams.  # noqa: E501
        :type: str
        """

        self._back_color = back_color

    @property
    def bar_color(self):
        """Gets the bar_color of this GeneratorParams.  # noqa: E501

        Bars color. Default value: Color.Black.  # noqa: E501

        :return: The bar_color of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._bar_color

    @bar_color.setter
    def bar_color(self, bar_color):
        """Sets the bar_color of this GeneratorParams.

        Bars color. Default value: Color.Black.  # noqa: E501

        :param bar_color: The bar_color of this GeneratorParams.  # noqa: E501
        :type: str
        """

        self._bar_color = bar_color

    @property
    def border_color(self):
        """Gets the border_color of this GeneratorParams.  # noqa: E501

        Border color. Default value: Color.Black.  # noqa: E501

        :return: The border_color of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._border_color

    @border_color.setter
    def border_color(self, border_color):
        """Sets the border_color of this GeneratorParams.

        Border color. Default value: Color.Black.  # noqa: E501

        :param border_color: The border_color of this GeneratorParams.  # noqa: E501
        :type: str
        """

        self._border_color = border_color

    @property
    def border_width(self):
        """Gets the border_width of this GeneratorParams.  # noqa: E501

        Border width. Default value: 0. Ignored if Visible is set to false.  # noqa: E501

        :return: The border_width of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._border_width

    @border_width.setter
    def border_width(self, border_width):
        """Sets the border_width of this GeneratorParams.

        Border width. Default value: 0. Ignored if Visible is set to false.  # noqa: E501

        :param border_width: The border_width of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._border_width = border_width

    @property
    def border_dash_style(self):
        """Gets the border_dash_style of this GeneratorParams.  # noqa: E501

        Border dash style. Default value: BorderDashStyle.Solid.  # noqa: E501

        :return: The border_dash_style of this GeneratorParams.  # noqa: E501
        :rtype: BorderDashStyle
        """
        return self._border_dash_style

    @border_dash_style.setter
    def border_dash_style(self, border_dash_style):
        """Sets the border_dash_style of this GeneratorParams.

        Border dash style. Default value: BorderDashStyle.Solid.  # noqa: E501

        :param border_dash_style: The border_dash_style of this GeneratorParams.  # noqa: E501
        :type: BorderDashStyle
        """

        self._border_dash_style = border_dash_style

    @property
    def border_visible(self):
        """Gets the border_visible of this GeneratorParams.  # noqa: E501

        Border visibility. If false than parameter Width is always ignored (0). Default value: false.  # noqa: E501

        :return: The border_visible of this GeneratorParams.  # noqa: E501
        :rtype: bool
        """
        return self._border_visible

    @border_visible.setter
    def border_visible(self, border_visible):
        """Sets the border_visible of this GeneratorParams.

        Border visibility. If false than parameter Width is always ignored (0). Default value: false.  # noqa: E501

        :param border_visible: The border_visible of this GeneratorParams.  # noqa: E501
        :type: bool
        """

        self._border_visible = border_visible

    @property
    def enable_checksum(self):
        """Gets the enable_checksum of this GeneratorParams.  # noqa: E501

        Enable checksum during generation 1D barcodes. Default is treated as Yes for symbology which must contain checksum, as No where checksum only possible. Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN, Codabar Checksum always used: Rest symbology  # noqa: E501

        :return: The enable_checksum of this GeneratorParams.  # noqa: E501
        :rtype: EnableChecksum
        """
        return self._enable_checksum

    @enable_checksum.setter
    def enable_checksum(self, enable_checksum):
        """Sets the enable_checksum of this GeneratorParams.

        Enable checksum during generation 1D barcodes. Default is treated as Yes for symbology which must contain checksum, as No where checksum only possible. Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN, Codabar Checksum always used: Rest symbology  # noqa: E501

        :param enable_checksum: The enable_checksum of this GeneratorParams.  # noqa: E501
        :type: EnableChecksum
        """

        self._enable_checksum = enable_checksum

    @property
    def enable_escape(self):
        """Gets the enable_escape of this GeneratorParams.  # noqa: E501

        Indicates whether explains the character \"\\\" as an escape character in CodeText property. Used for Pdf417, DataMatrix, Code128 only If the EnableEscape is true, \"\\\" will be explained as a special escape character. Otherwise, \"\\\" acts as normal characters. Aspose.BarCode supports input decimal ascii code and mnemonic for ASCII control-code characters. For example, \\013 and \\\\CR stands for CR.  # noqa: E501

        :return: The enable_escape of this GeneratorParams.  # noqa: E501
        :rtype: bool
        """
        return self._enable_escape

    @enable_escape.setter
    def enable_escape(self, enable_escape):
        """Sets the enable_escape of this GeneratorParams.

        Indicates whether explains the character \"\\\" as an escape character in CodeText property. Used for Pdf417, DataMatrix, Code128 only If the EnableEscape is true, \"\\\" will be explained as a special escape character. Otherwise, \"\\\" acts as normal characters. Aspose.BarCode supports input decimal ascii code and mnemonic for ASCII control-code characters. For example, \\013 and \\\\CR stands for CR.  # noqa: E501

        :param enable_escape: The enable_escape of this GeneratorParams.  # noqa: E501
        :type: bool
        """

        self._enable_escape = enable_escape

    @property
    def filled_bars(self):
        """Gets the filled_bars of this GeneratorParams.  # noqa: E501

        Value indicating whether bars are filled. Only for 1D barcodes. Default value: true.  # noqa: E501

        :return: The filled_bars of this GeneratorParams.  # noqa: E501
        :rtype: bool
        """
        return self._filled_bars

    @filled_bars.setter
    def filled_bars(self, filled_bars):
        """Sets the filled_bars of this GeneratorParams.

        Value indicating whether bars are filled. Only for 1D barcodes. Default value: true.  # noqa: E501

        :param filled_bars: The filled_bars of this GeneratorParams.  # noqa: E501
        :type: bool
        """

        self._filled_bars = filled_bars

    @property
    def always_show_checksum(self):
        """Gets the always_show_checksum of this GeneratorParams.  # noqa: E501

        Always display checksum digit in the human readable text for Code128 and GS1Code128 barcodes.  # noqa: E501

        :return: The always_show_checksum of this GeneratorParams.  # noqa: E501
        :rtype: bool
        """
        return self._always_show_checksum

    @always_show_checksum.setter
    def always_show_checksum(self, always_show_checksum):
        """Sets the always_show_checksum of this GeneratorParams.

        Always display checksum digit in the human readable text for Code128 and GS1Code128 barcodes.  # noqa: E501

        :param always_show_checksum: The always_show_checksum of this GeneratorParams.  # noqa: E501
        :type: bool
        """

        self._always_show_checksum = always_show_checksum

    @property
    def wide_narrow_ratio(self):
        """Gets the wide_narrow_ratio of this GeneratorParams.  # noqa: E501

        Wide bars to Narrow bars ratio. Default value: 3, that is, wide bars are 3 times as wide as narrow bars. Used for ITF, PZN, PharmaCode, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, IATA2of5, VIN, DeutschePost, OPC, Code32, DataLogic2of5, PatchCode, Code39Extended, Code39Standard  # noqa: E501

        :return: The wide_narrow_ratio of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._wide_narrow_ratio

    @wide_narrow_ratio.setter
    def wide_narrow_ratio(self, wide_narrow_ratio):
        """Sets the wide_narrow_ratio of this GeneratorParams.

        Wide bars to Narrow bars ratio. Default value: 3, that is, wide bars are 3 times as wide as narrow bars. Used for ITF, PZN, PharmaCode, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, IATA2of5, VIN, DeutschePost, OPC, Code32, DataLogic2of5, PatchCode, Code39Extended, Code39Standard  # noqa: E501

        :param wide_narrow_ratio: The wide_narrow_ratio of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._wide_narrow_ratio = wide_narrow_ratio

    @property
    def validate_text(self):
        """Gets the validate_text of this GeneratorParams.  # noqa: E501

        Only for 1D barcodes. If codetext is incorrect and value set to true - exception will be thrown. Otherwise codetext will be corrected to match barcode's specification. Exception always will be thrown for: Databar symbology if codetext is incorrect. Exception always will not be thrown for: AustraliaPost, SingaporePost, Code39Extended, Code93Extended, Code16K, Code128 symbology if codetext is incorrect.  # noqa: E501

        :return: The validate_text of this GeneratorParams.  # noqa: E501
        :rtype: bool
        """
        return self._validate_text

    @validate_text.setter
    def validate_text(self, validate_text):
        """Sets the validate_text of this GeneratorParams.

        Only for 1D barcodes. If codetext is incorrect and value set to true - exception will be thrown. Otherwise codetext will be corrected to match barcode's specification. Exception always will be thrown for: Databar symbology if codetext is incorrect. Exception always will not be thrown for: AustraliaPost, SingaporePost, Code39Extended, Code93Extended, Code16K, Code128 symbology if codetext is incorrect.  # noqa: E501

        :param validate_text: The validate_text of this GeneratorParams.  # noqa: E501
        :type: bool
        """

        self._validate_text = validate_text

    @property
    def supplement_data(self):
        """Gets the supplement_data of this GeneratorParams.  # noqa: E501

        Supplement parameters. Used for Interleaved2of5, Standard2of5, EAN13, EAN8, UPCA, UPCE, ISBN, ISSN, ISMN.  # noqa: E501

        :return: The supplement_data of this GeneratorParams.  # noqa: E501
        :rtype: str
        """
        return self._supplement_data

    @supplement_data.setter
    def supplement_data(self, supplement_data):
        """Sets the supplement_data of this GeneratorParams.

        Supplement parameters. Used for Interleaved2of5, Standard2of5, EAN13, EAN8, UPCA, UPCE, ISBN, ISSN, ISMN.  # noqa: E501

        :param supplement_data: The supplement_data of this GeneratorParams.  # noqa: E501
        :type: str
        """

        self._supplement_data = supplement_data

    @property
    def supplement_space(self):
        """Gets the supplement_space of this GeneratorParams.  # noqa: E501

        Space between main the BarCode and supplement BarCode.  # noqa: E501

        :return: The supplement_space of this GeneratorParams.  # noqa: E501
        :rtype: float
        """
        return self._supplement_space

    @supplement_space.setter
    def supplement_space(self, supplement_space):
        """Sets the supplement_space of this GeneratorParams.

        Space between main the BarCode and supplement BarCode.  # noqa: E501

        :param supplement_space: The supplement_space of this GeneratorParams.  # noqa: E501
        :type: float
        """

        self._supplement_space = supplement_space

    @property
    def australian_post(self):
        """Gets the australian_post of this GeneratorParams.  # noqa: E501

        AustralianPost params.  # noqa: E501

        :return: The australian_post of this GeneratorParams.  # noqa: E501
        :rtype: AustralianPostParams
        """
        return self._australian_post

    @australian_post.setter
    def australian_post(self, australian_post):
        """Sets the australian_post of this GeneratorParams.

        AustralianPost params.  # noqa: E501

        :param australian_post: The australian_post of this GeneratorParams.  # noqa: E501
        :type: AustralianPostParams
        """

        self._australian_post = australian_post

    @property
    def aztec(self):
        """Gets the aztec of this GeneratorParams.  # noqa: E501

        Aztec params.  # noqa: E501

        :return: The aztec of this GeneratorParams.  # noqa: E501
        :rtype: AztecParams
        """
        return self._aztec

    @aztec.setter
    def aztec(self, aztec):
        """Sets the aztec of this GeneratorParams.

        Aztec params.  # noqa: E501

        :param aztec: The aztec of this GeneratorParams.  # noqa: E501
        :type: AztecParams
        """

        self._aztec = aztec

    @property
    def codabar(self):
        """Gets the codabar of this GeneratorParams.  # noqa: E501

        Codabar params.  # noqa: E501

        :return: The codabar of this GeneratorParams.  # noqa: E501
        :rtype: CodabarParams
        """
        return self._codabar

    @codabar.setter
    def codabar(self, codabar):
        """Sets the codabar of this GeneratorParams.

        Codabar params.  # noqa: E501

        :param codabar: The codabar of this GeneratorParams.  # noqa: E501
        :type: CodabarParams
        """

        self._codabar = codabar

    @property
    def codablock(self):
        """Gets the codablock of this GeneratorParams.  # noqa: E501

        Codablock params.  # noqa: E501

        :return: The codablock of this GeneratorParams.  # noqa: E501
        :rtype: CodablockParams
        """
        return self._codablock

    @codablock.setter
    def codablock(self, codablock):
        """Sets the codablock of this GeneratorParams.

        Codablock params.  # noqa: E501

        :param codablock: The codablock of this GeneratorParams.  # noqa: E501
        :type: CodablockParams
        """

        self._codablock = codablock

    @property
    def code16_k(self):
        """Gets the code16_k of this GeneratorParams.  # noqa: E501

        Code16K params.  # noqa: E501

        :return: The code16_k of this GeneratorParams.  # noqa: E501
        :rtype: Code16KParams
        """
        return self._code16_k

    @code16_k.setter
    def code16_k(self, code16_k):
        """Sets the code16_k of this GeneratorParams.

        Code16K params.  # noqa: E501

        :param code16_k: The code16_k of this GeneratorParams.  # noqa: E501
        :type: Code16KParams
        """

        self._code16_k = code16_k

    @property
    def coupon(self):
        """Gets the coupon of this GeneratorParams.  # noqa: E501

        Coupon params.  # noqa: E501

        :return: The coupon of this GeneratorParams.  # noqa: E501
        :rtype: CouponParams
        """
        return self._coupon

    @coupon.setter
    def coupon(self, coupon):
        """Sets the coupon of this GeneratorParams.

        Coupon params.  # noqa: E501

        :param coupon: The coupon of this GeneratorParams.  # noqa: E501
        :type: CouponParams
        """

        self._coupon = coupon

    @property
    def data_bar(self):
        """Gets the data_bar of this GeneratorParams.  # noqa: E501

        DataBar params.  # noqa: E501

        :return: The data_bar of this GeneratorParams.  # noqa: E501
        :rtype: DataBarParams
        """
        return self._data_bar

    @data_bar.setter
    def data_bar(self, data_bar):
        """Sets the data_bar of this GeneratorParams.

        DataBar params.  # noqa: E501

        :param data_bar: The data_bar of this GeneratorParams.  # noqa: E501
        :type: DataBarParams
        """

        self._data_bar = data_bar

    @property
    def data_matrix(self):
        """Gets the data_matrix of this GeneratorParams.  # noqa: E501

        DataMatrix params.  # noqa: E501

        :return: The data_matrix of this GeneratorParams.  # noqa: E501
        :rtype: DataMatrixParams
        """
        return self._data_matrix

    @data_matrix.setter
    def data_matrix(self, data_matrix):
        """Sets the data_matrix of this GeneratorParams.

        DataMatrix params.  # noqa: E501

        :param data_matrix: The data_matrix of this GeneratorParams.  # noqa: E501
        :type: DataMatrixParams
        """

        self._data_matrix = data_matrix

    @property
    def dot_code(self):
        """Gets the dot_code of this GeneratorParams.  # noqa: E501

        DotCode params.  # noqa: E501

        :return: The dot_code of this GeneratorParams.  # noqa: E501
        :rtype: DotCodeParams
        """
        return self._dot_code

    @dot_code.setter
    def dot_code(self, dot_code):
        """Sets the dot_code of this GeneratorParams.

        DotCode params.  # noqa: E501

        :param dot_code: The dot_code of this GeneratorParams.  # noqa: E501
        :type: DotCodeParams
        """

        self._dot_code = dot_code

    @property
    def itf(self):
        """Gets the itf of this GeneratorParams.  # noqa: E501

        ITF params.  # noqa: E501

        :return: The itf of this GeneratorParams.  # noqa: E501
        :rtype: ITFParams
        """
        return self._itf

    @itf.setter
    def itf(self, itf):
        """Sets the itf of this GeneratorParams.

        ITF params.  # noqa: E501

        :param itf: The itf of this GeneratorParams.  # noqa: E501
        :type: ITFParams
        """

        self._itf = itf

    @property
    def maxi_code(self):
        """Gets the maxi_code of this GeneratorParams.  # noqa: E501

        MaxiCode params.  # noqa: E501

        :return: The maxi_code of this GeneratorParams.  # noqa: E501
        :rtype: MaxiCodeParams
        """
        return self._maxi_code

    @maxi_code.setter
    def maxi_code(self, maxi_code):
        """Sets the maxi_code of this GeneratorParams.

        MaxiCode params.  # noqa: E501

        :param maxi_code: The maxi_code of this GeneratorParams.  # noqa: E501
        :type: MaxiCodeParams
        """

        self._maxi_code = maxi_code

    @property
    def pdf417(self):
        """Gets the pdf417 of this GeneratorParams.  # noqa: E501

        Pdf417 params.  # noqa: E501

        :return: The pdf417 of this GeneratorParams.  # noqa: E501
        :rtype: Pdf417Params
        """
        return self._pdf417

    @pdf417.setter
    def pdf417(self, pdf417):
        """Sets the pdf417 of this GeneratorParams.

        Pdf417 params.  # noqa: E501

        :param pdf417: The pdf417 of this GeneratorParams.  # noqa: E501
        :type: Pdf417Params
        """

        self._pdf417 = pdf417

    @property
    def postal(self):
        """Gets the postal of this GeneratorParams.  # noqa: E501

        Postal params.  # noqa: E501

        :return: The postal of this GeneratorParams.  # noqa: E501
        :rtype: PostalParams
        """
        return self._postal

    @postal.setter
    def postal(self, postal):
        """Sets the postal of this GeneratorParams.

        Postal params.  # noqa: E501

        :param postal: The postal of this GeneratorParams.  # noqa: E501
        :type: PostalParams
        """

        self._postal = postal

    @property
    def qr(self):
        """Gets the qr of this GeneratorParams.  # noqa: E501

        QR params.  # noqa: E501

        :return: The qr of this GeneratorParams.  # noqa: E501
        :rtype: QrParams
        """
        return self._qr

    @qr.setter
    def qr(self, qr):
        """Sets the qr of this GeneratorParams.

        QR params.  # noqa: E501

        :param qr: The qr of this GeneratorParams.  # noqa: E501
        :type: QrParams
        """

        self._qr = qr

    @property
    def patch_code(self):
        """Gets the patch_code of this GeneratorParams.  # noqa: E501

        PatchCode params.  # noqa: E501

        :return: The patch_code of this GeneratorParams.  # noqa: E501
        :rtype: PatchCodeParams
        """
        return self._patch_code

    @patch_code.setter
    def patch_code(self, patch_code):
        """Sets the patch_code of this GeneratorParams.

        PatchCode params.  # noqa: E501

        :param patch_code: The patch_code of this GeneratorParams.  # noqa: E501
        :type: PatchCodeParams
        """

        self._patch_code = patch_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(GeneratorParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GeneratorParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
