CONTRACT_EMITTER_CODE = (
    "608060405234801561001057600080fd5b5061176c806100206000396000f3fe6080604052348015610010576000"
    "80fd5b50600436106100b45760003560e01c80639c377053116100715780639c37705314610161578063aa6fd822"
    "1461017d578063acabb9ed14610199578063b2ddc449146101b5578063e17bf956146101d1578063f82ef69e1461"
    "01ed576100b4565b80630bb563d6146100b957806317c0c180146100d557806320f0256e146100f15780635da86c"
    "171461010d57806390b41d8b14610129578063966b50e014610145575b600080fd5b6100d3600480360381019061"
    "00ce9190610aff565b610209565b005b6100ef60048036038101906100ea9190610b6d565b610243565b005b6101"
    "0b60048036038101906101069190610bd0565b61031d565b005b61012760048036038101906101229190610cf056"
    "5b61043c565b005b610143600480360381019061013e9190610d30565b610479565b005b61015f60048036038101"
    "9061015a9190610ea3565b6105d9565b005b61017b60048036038101906101769190610f1b565b61062a565b005b"
    "61019760048036038101906101929190610f82565b610744565b005b6101b360048036038101906101ae9190610f"
    "c2565b61088b565b005b6101cf60048036038101906101ca9190611098565b6108dc565b005b6101eb6004803603"
    "8101906101e69190611179565b61092e565b005b61020760048036038101906102029190611098565b610968565b"
    "005b7fa95e6e2a182411e7a6f9ed114a85c3761d87f9b8f453d842c71235aa64fff99f8160405161023891906112"
    "4a565b60405180910390a150565b600160128111156102575761025661126c565b5b81601281111561026a576102"
    "6961126c565b5b14156102a1577f1e86022f78f8d04f8e3dfd13a2bdb280403e6632877c0dbee5e4eeb259908a5c"
    "60405160405180910390a161031a565b600060128111156102b5576102b461126c565b5b8160128111156102c857"
    "6102c761126c565b5b14156102de5760405160405180910390a0610319565b6040517f08c379a000000000000000"
    "00000000000000000000000000000000000000000081526004016103109061130d565b60405180910390fd5b5b50"
    "565b600560128111156103315761033061126c565b5b8560128111156103445761034361126c565b5b141561038c"
    "577ff039d147f23fe975a4254bdf6b1502b8c79132ae1833986b7ccef2638e73fdf98484848460405161037f9493"
    "92919061133c565b60405180910390a1610435565b600b60128111156103a05761039f61126c565b5b8560128111"
    "156103b3576103b261126c565b5b14156103f95780827fa30ece802b64cd2b7e57dabf4010aabf5df26d1556977a"
    "ffb07b98a77ad955b586866040516103ec929190611381565b60405180910390a3610434565b6040517f08c379a0"
    "00000000000000000000000000000000000000000000000000000000815260040161042b9061130d565b60405180"
    "910390fd5b5b5050505050565b7f8ccce2523cca5f3851d20df50b5a59509bc4ac7d9ddba344f5e331969d09b8e7"
    "828260405161046d929190611417565b60405180910390a15050565b6003601281111561048d5761048c61126c56"
    "5b5b8360128111156104a05761049f61126c565b5b14156104e4577fdf0cb1dea99afceb3ea698d62e705b736f13"
    "45a7eee9eb07e63d1f8f556c1bc582826040516104d7929190611381565b60405180910390a16105d4565b600960"
    "128111156104f8576104f761126c565b5b83601281111561050b5761050a61126c565b5b141561054e57807f057b"
    "c32826fbe161da1c110afcdcae7c109a8b69149f727fc37a603c60ef94ca836040516105419190611440565b6040"
    "5180910390a26105d3565b600860128111156105625761056161126c565b5b836012811115610575576105746112"
    "6c565b5b141561059757808260405161058a9190611440565b60405180910390a16105d2565b6040517f08c379a0"
    "0000000000000000000000000000000000000000000000000000000081526004016105c99061130d565b60405180"
    "910390fd5b5b5b505050565b816040516105e79190611513565b60405180910390207fdbc4c1d1d2f0d84e58d36c"
    "a767ec9ba2ec2f933c055e50e5ccdd57697f7b58b08260405161061e91906115c0565b60405180910390a2505056"
    "5b6004601281111561063e5761063d61126c565b5b8460128111156106515761065061126c565b5b141561069757"
    "7f4a25b279c7c585f25eda9788ac9420ebadae78ca6b206a0e6ab488fd81f5506283838360405161068a93929190"
    "6115e2565b60405180910390a161073e565b600a60128111156106ab576106aa61126c565b5b8460128111156106"
    "be576106bd61126c565b5b14156107025780827ff16c999b533366ca5138d78e85da51611089cd05749f098d6c22"
    "5d4cd42ee6ec856040516106f59190611440565b60405180910390a361073d565b6040517f08c379a00000000000"
    "000000000000000000000000000000000000000000000081526004016107349061130d565b60405180910390fd5b"
    "5b50505050565b600260128111156107585761075761126c565b5b82601281111561076b5761076a61126c565b5b"
    "14156107ad577f56d2ef3c5228bf5d88573621e325a4672ab50e033749a601e4f4a5e1dce905d4816040516107a0"
    "9190611440565b60405180910390a1610887565b600760128111156107c1576107c061126c565b5b826012811115"
    "6107d4576107d361126c565b5b141561080c57807ff70fe689e290d8ce2b2a388ac28db36fbb0e16a6d89c6804c4"
    "61f65a1b40bb1560405160405180910390a2610886565b600660128111156108205761081f61126c565b5b826012"
    "8111156108335761083261126c565b5b141561084a578060405160405180910390a1610885565b6040517f08c379"
    "a000000000000000000000000000000000000000000000000000000000815260040161087c9061130d565b604051"
    "80910390fd5b5b5b5050565b816040516108999190611655565b60405180910390207fe77cf33df73da7bc2e253a"
    "2dae617e6f15e4e337eaa462a108903af4643d1b75826040516108d0919061124a565b60405180910390a2505056"
    "5b8173ffffffffffffffffffffffffffffffffffffffff167ff922c215689548d72c3d2fe4ea8dafb2a30c43312c"
    "9b43fe5d10f713181f991c82604051610922919061167b565b60405180910390a25050565b7f532fd6ea96cfb78b"
    "b46e09279a26828b8b493de1a2b8b1ee1face527978a15a58160405161095d91906116eb565b60405180910390a1"
    "50565b7f06029e18f16caae06a69281f35b00ed3fcf47950e6c99dafa1bdd8c4b93479a082826040516109999291"
    "9061170d565b60405180910390a15050565b6000604051905090565b600080fd5b600080fd5b600080fd5b600080"
    "fd5b6000601f19601f8301169050919050565b7f4e487b7100000000000000000000000000000000000000000000"
    "000000000000600052604160045260246000fd5b610a0c826109c3565b810181811067ffffffffffffffff821117"
    "15610a2b57610a2a6109d4565b5b80604052505050565b6000610a3e6109a5565b9050610a4a8282610a03565b91"
    "9050565b600067ffffffffffffffff821115610a6a57610a696109d4565b5b610a73826109c3565b905060208101"
    "9050919050565b82818337600083830152505050565b6000610aa2610a9d84610a4f565b610a34565b9050828152"
    "60208101848484011115610abe57610abd6109be565b5b610ac9848285610a80565b509392505050565b60008260"
    "1f830112610ae657610ae56109b9565b5b8135610af6848260208601610a8f565b91505092915050565b60006020"
    "8284031215610b1557610b146109af565b5b600082013567ffffffffffffffff811115610b3357610b326109b456"
    "5b5b610b3f84828501610ad1565b91505092915050565b60138110610b5557600080fd5b50565b60008135905061"
    "0b6781610b48565b92915050565b600060208284031215610b8357610b826109af565b5b6000610b918482850161"
    "0b58565b91505092915050565b6000819050919050565b610bad81610b9a565b8114610bb857600080fd5b50565b"
    "600081359050610bca81610ba4565b92915050565b600080600080600060a08688031215610bec57610beb6109af"
    "565b5b6000610bfa88828901610b58565b9550506020610c0b88828901610bbb565b9450506040610c1c88828901"
    "610bbb565b9350506060610c2d88828901610bbb565b9250506080610c3e88828901610bbb565b91505092955092"
    "95909350565b600080fd5b600060208284031215610c6657610c65610c4b565b5b610c706020610a34565b905060"
    "00610c8084828501610bbb565b60008301525092915050565b600060608284031215610ca257610ca1610c4b565b"
    "5b610cac6060610a34565b90506000610cbc84828501610bbb565b6000830152506020610cd084828501610bbb56"
    "5b6020830152506040610ce484828501610c50565b60408301525092915050565b60008060808385031215610d07"
    "57610d066109af565b5b6000610d1585828601610bbb565b9250506020610d2685828601610c8c565b9150509250"
    "929050565b600080600060608486031215610d4957610d486109af565b5b6000610d5786828701610b58565b9350"
    "506020610d6886828701610bbb565b9250506040610d7986828701610bbb565b9150509250925092565b600067ff"
    "ffffffffffffff821115610d9e57610d9d6109d4565b5b602082029050602081019050919050565b600080fd5b60"
    "007fffff00000000000000000000000000000000000000000000000000000000000082169050919050565b610de9"
    "81610db4565b8114610df457600080fd5b50565b600081359050610e0681610de0565b92915050565b6000610e1f"
    "610e1a84610d83565b610a34565b90508083825260208201905060208402830185811115610e4257610e41610daf"
    "565b5b835b81811015610e6b5780610e578882610df7565b845260208401935050602081019050610e44565b5050"
    "509392505050565b600082601f830112610e8a57610e896109b9565b5b8135610e9a848260208601610e0c565b91"
    "505092915050565b60008060408385031215610eba57610eb96109af565b5b600083013567ffffffffffffffff81"
    "1115610ed857610ed76109b4565b5b610ee485828601610e75565b925050602083013567ffffffffffffffff8111"
    "15610f0557610f046109b4565b5b610f1185828601610e75565b9150509250929050565b60008060008060808587"
    "031215610f3557610f346109af565b5b6000610f4387828801610b58565b9450506020610f5487828801610bbb56"
    "5b9350506040610f6587828801610bbb565b9250506060610f7687828801610bbb565b9150509295919450925056"
    "5b60008060408385031215610f9957610f986109af565b5b6000610fa785828601610b58565b9250506020610fb8"
    "85828601610bbb565b9150509250929050565b60008060408385031215610fd957610fd86109af565b5b60008301"
    "3567ffffffffffffffff811115610ff757610ff66109b4565b5b61100385828601610ad1565b9250506020830135"
    "67ffffffffffffffff811115611024576110236109b4565b5b61103085828601610ad1565b915050925092905056"
    "5b600073ffffffffffffffffffffffffffffffffffffffff82169050919050565b60006110658261103a565b9050"
    "919050565b6110758161105a565b811461108057600080fd5b50565b6000813590506110928161106c565b929150"
    "50565b600080604083850312156110af576110ae6109af565b5b60006110bd85828601611083565b925050602061"
    "10ce85828601611083565b9150509250929050565b600067ffffffffffffffff8211156110f3576110f26109d456"
    "5b5b6110fc826109c3565b9050602081019050919050565b600061111c611117846110d8565b610a34565b905082"
    "815260208101848484011115611138576111376109be565b5b611143848285610a80565b509392505050565b6000"
    "82601f8301126111605761115f6109b9565b5b8135611170848260208601611109565b91505092915050565b6000"
    "6020828403121561118f5761118e6109af565b5b600082013567ffffffffffffffff8111156111ad576111ac6109"
    "b4565b5b6111b98482850161114b565b91505092915050565b600081519050919050565b60008282526020820190"
    "5092915050565b60005b838110156111fc5780820151818401526020810190506111e1565b8381111561120b5760"
    "00848401525b50505050565b600061121c826111c2565b61122681856111cd565b93506112368185602086016111"
    "de565b61123f816109c3565b840191505092915050565b6000602082019050818103600083015261126481846112"
    "11565b905092915050565b7f4e487b71000000000000000000000000000000000000000000000000000000006000"
    "52602160045260246000fd5b7f4469646e2774206d6174636820616e7920616c6c6f7761626c65206576656e7460"
    "008201527f20696e6465780000000000000000000000000000000000000000000000000000602082015250565b60"
    "006112f76026836111cd565b91506113028261129b565b604082019050919050565b600060208201905081810360"
    "00830152611326816112ea565b9050919050565b61133681610b9a565b82525050565b6000608082019050611351"
    "600083018761132d565b61135e602083018661132d565b61136b604083018561132d565b61137860608301846113"
    "2d565b95945050505050565b6000604082019050611396600083018561132d565b6113a3602083018461132d565b"
    "9392505050565b6113b381610b9a565b82525050565b6020820160008201516113cf60008501826113aa565b5050"
    "5050565b6060820160008201516113eb60008501826113aa565b5060208201516113fe60208501826113aa565b50"
    "604082015161141160408501826113b9565b50505050565b600060808201905061142c600083018561132d565b61"
    "143960208301846113d5565b9392505050565b6000602082019050611455600083018461132d565b92915050565b"
    "600081519050919050565b600081905092915050565b6000819050602082019050919050565b61148a81610db456"
    "5b82525050565b600061149c8383611481565b60208301905092915050565b6000602082019050919050565b6000"
    "6114c08261145b565b6114ca8185611466565b93506114d583611471565b8060005b838110156115065781516114"
    "ed8882611490565b97506114f8836114a8565b9250506001810190506114d9565b5085935050505092915050565b"
    "600061151f82846114b5565b915081905092915050565b600082825260208201905092915050565b61154481610d"
    "b4565b82525050565b6000611556838361153b565b60208301905092915050565b600061156d8261145b565b6115"
    "77818561152a565b935061158283611471565b8060005b838110156115b357815161159a888261154a565b975061"
    "15a5836114a8565b925050600181019050611586565b5085935050505092915050565b6000602082019050818103"
    "60008301526115da8184611562565b905092915050565b60006060820190506115f7600083018661132d565b6116"
    "04602083018561132d565b611611604083018461132d565b949350505050565b600081905092915050565b600061"
    "162f826111c2565b6116398185611619565b93506116498185602086016111de565b80840191505092915050565b"
    "60006116618284611624565b915081905092915050565b6116758161105a565b82525050565b6000602082019050"
    "611690600083018461166c565b92915050565b600081519050919050565b60008282526020820190509291505056"
    "5b60006116bd82611696565b6116c781856116a1565b93506116d78185602086016111de565b6116e0816109c356"
    "5b840191505092915050565b6000602082019050818103600083015261170581846116b2565b905092915050565b"
    "6000604082019050611722600083018561166c565b61172f602083018461166c565b939250505056fea264697066"
    "7358221220c210b75fcc1b13a7d08711ef833663000e885b94713c307622ffdc2214d1a22264736f6c634300080b"
    "0033"
)

CONTRACT_EMITTER_RUNTIME = (
    "608060405234801561001057600080fd5b50600436106100b45760003560e01c80639c377053116100715780639c"
    "37705314610161578063aa6fd8221461017d578063acabb9ed14610199578063b2ddc449146101b5578063e17bf9"
    "56146101d1578063f82ef69e146101ed576100b4565b80630bb563d6146100b957806317c0c180146100d5578063"
    "20f0256e146100f15780635da86c171461010d57806390b41d8b14610129578063966b50e014610145575b600080"
    "fd5b6100d360048036038101906100ce9190610aff565b610209565b005b6100ef60048036038101906100ea9190"
    "610b6d565b610243565b005b61010b60048036038101906101069190610bd0565b61031d565b005b610127600480"
    "36038101906101229190610cf0565b61043c565b005b610143600480360381019061013e9190610d30565b610479"
    "565b005b61015f600480360381019061015a9190610ea3565b6105d9565b005b61017b6004803603810190610176"
    "9190610f1b565b61062a565b005b61019760048036038101906101929190610f82565b610744565b005b6101b360"
    "048036038101906101ae9190610fc2565b61088b565b005b6101cf60048036038101906101ca9190611098565b61"
    "08dc565b005b6101eb60048036038101906101e69190611179565b61092e565b005b610207600480360381019061"
    "02029190611098565b610968565b005b7fa95e6e2a182411e7a6f9ed114a85c3761d87f9b8f453d842c71235aa64"
    "fff99f81604051610238919061124a565b60405180910390a150565b600160128111156102575761025661126c56"
    "5b5b81601281111561026a5761026961126c565b5b14156102a1577f1e86022f78f8d04f8e3dfd13a2bdb280403e"
    "6632877c0dbee5e4eeb259908a5c60405160405180910390a161031a565b600060128111156102b5576102b46112"
    "6c565b5b8160128111156102c8576102c761126c565b5b14156102de5760405160405180910390a0610319565b60"
    "40517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610310906113"
    "0d565b60405180910390fd5b5b50565b600560128111156103315761033061126c565b5b85601281111561034457"
    "61034361126c565b5b141561038c577ff039d147f23fe975a4254bdf6b1502b8c79132ae1833986b7ccef2638e73"
    "fdf98484848460405161037f949392919061133c565b60405180910390a1610435565b600b60128111156103a057"
    "61039f61126c565b5b8560128111156103b3576103b261126c565b5b14156103f95780827fa30ece802b64cd2b7e"
    "57dabf4010aabf5df26d1556977affb07b98a77ad955b586866040516103ec929190611381565b60405180910390"
    "a3610434565b6040517f08c379a00000000000000000000000000000000000000000000000000000000081526004"
    "0161042b9061130d565b60405180910390fd5b5b5050505050565b7f8ccce2523cca5f3851d20df50b5a59509bc4"
    "ac7d9ddba344f5e331969d09b8e7828260405161046d929190611417565b60405180910390a15050565b60036012"
    "81111561048d5761048c61126c565b5b8360128111156104a05761049f61126c565b5b14156104e4577fdf0cb1de"
    "a99afceb3ea698d62e705b736f1345a7eee9eb07e63d1f8f556c1bc582826040516104d7929190611381565b6040"
    "5180910390a16105d4565b600960128111156104f8576104f761126c565b5b83601281111561050b5761050a6112"
    "6c565b5b141561054e57807f057bc32826fbe161da1c110afcdcae7c109a8b69149f727fc37a603c60ef94ca8360"
    "40516105419190611440565b60405180910390a26105d3565b600860128111156105625761056161126c565b5b83"
    "60128111156105755761057461126c565b5b141561059757808260405161058a9190611440565b60405180910390"
    "a16105d2565b6040517f08c379a00000000000000000000000000000000000000000000000000000000081526004"
    "016105c99061130d565b60405180910390fd5b5b5b505050565b816040516105e79190611513565b604051809103"
    "90207fdbc4c1d1d2f0d84e58d36ca767ec9ba2ec2f933c055e50e5ccdd57697f7b58b08260405161061e91906115"
    "c0565b60405180910390a25050565b6004601281111561063e5761063d61126c565b5b8460128111156106515761"
    "065061126c565b5b1415610697577f4a25b279c7c585f25eda9788ac9420ebadae78ca6b206a0e6ab488fd81f550"
    "6283838360405161068a939291906115e2565b60405180910390a161073e565b600a60128111156106ab576106aa"
    "61126c565b5b8460128111156106be576106bd61126c565b5b14156107025780827ff16c999b533366ca5138d78e"
    "85da51611089cd05749f098d6c225d4cd42ee6ec856040516106f59190611440565b60405180910390a361073d56"
    "5b6040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161073490"
    "61130d565b60405180910390fd5b5b50505050565b600260128111156107585761075761126c565b5b8260128111"
    "1561076b5761076a61126c565b5b14156107ad577f56d2ef3c5228bf5d88573621e325a4672ab50e033749a601e4"
    "f4a5e1dce905d4816040516107a09190611440565b60405180910390a1610887565b600760128111156107c15761"
    "07c061126c565b5b8260128111156107d4576107d361126c565b5b141561080c57807ff70fe689e290d8ce2b2a38"
    "8ac28db36fbb0e16a6d89c6804c461f65a1b40bb1560405160405180910390a2610886565b600660128111156108"
    "205761081f61126c565b5b8260128111156108335761083261126c565b5b141561084a5780604051604051809103"
    "90a1610885565b6040517f08c379a000000000000000000000000000000000000000000000000000000000815260"
    "040161087c9061130d565b60405180910390fd5b5b5b5050565b816040516108999190611655565b604051809103"
    "90207fe77cf33df73da7bc2e253a2dae617e6f15e4e337eaa462a108903af4643d1b75826040516108d091906112"
    "4a565b60405180910390a25050565b8173ffffffffffffffffffffffffffffffffffffffff167ff922c215689548"
    "d72c3d2fe4ea8dafb2a30c43312c9b43fe5d10f713181f991c82604051610922919061167b565b60405180910390"
    "a25050565b7f532fd6ea96cfb78bb46e09279a26828b8b493de1a2b8b1ee1face527978a15a58160405161095d91"
    "906116eb565b60405180910390a150565b7f06029e18f16caae06a69281f35b00ed3fcf47950e6c99dafa1bdd8c4"
    "b93479a0828260405161099992919061170d565b60405180910390a15050565b6000604051905090565b600080fd"
    "5b600080fd5b600080fd5b600080fd5b6000601f19601f8301169050919050565b7f4e487b710000000000000000"
    "0000000000000000000000000000000000000000600052604160045260246000fd5b610a0c826109c3565b810181"
    "811067ffffffffffffffff82111715610a2b57610a2a6109d4565b5b80604052505050565b6000610a3e6109a556"
    "5b9050610a4a8282610a03565b919050565b600067ffffffffffffffff821115610a6a57610a696109d4565b5b61"
    "0a73826109c3565b9050602081019050919050565b82818337600083830152505050565b6000610aa2610a9d8461"
    "0a4f565b610a34565b905082815260208101848484011115610abe57610abd6109be565b5b610ac9848285610a80"
    "565b509392505050565b600082601f830112610ae657610ae56109b9565b5b8135610af6848260208601610a8f56"
    "5b91505092915050565b600060208284031215610b1557610b146109af565b5b600082013567ffffffffffffffff"
    "811115610b3357610b326109b4565b5b610b3f84828501610ad1565b91505092915050565b60138110610b555760"
    "0080fd5b50565b600081359050610b6781610b48565b92915050565b600060208284031215610b8357610b826109"
    "af565b5b6000610b9184828501610b58565b91505092915050565b6000819050919050565b610bad81610b9a565b"
    "8114610bb857600080fd5b50565b600081359050610bca81610ba4565b92915050565b600080600080600060a086"
    "88031215610bec57610beb6109af565b5b6000610bfa88828901610b58565b9550506020610c0b88828901610bbb"
    "565b9450506040610c1c88828901610bbb565b9350506060610c2d88828901610bbb565b9250506080610c3e8882"
    "8901610bbb565b9150509295509295909350565b600080fd5b600060208284031215610c6657610c65610c4b565b"
    "5b610c706020610a34565b90506000610c8084828501610bbb565b60008301525092915050565b60006060828403"
    "1215610ca257610ca1610c4b565b5b610cac6060610a34565b90506000610cbc84828501610bbb565b6000830152"
    "506020610cd084828501610bbb565b6020830152506040610ce484828501610c50565b6040830152509291505056"
    "5b60008060808385031215610d0757610d066109af565b5b6000610d1585828601610bbb565b9250506020610d26"
    "85828601610c8c565b9150509250929050565b600080600060608486031215610d4957610d486109af565b5b6000"
    "610d5786828701610b58565b9350506020610d6886828701610bbb565b9250506040610d7986828701610bbb565b"
    "9150509250925092565b600067ffffffffffffffff821115610d9e57610d9d6109d4565b5b602082029050602081"
    "019050919050565b600080fd5b60007fffff00000000000000000000000000000000000000000000000000000000"
    "000082169050919050565b610de981610db4565b8114610df457600080fd5b50565b600081359050610e0681610d"
    "e0565b92915050565b6000610e1f610e1a84610d83565b610a34565b905080838252602082019050602084028301"
    "85811115610e4257610e41610daf565b5b835b81811015610e6b5780610e578882610df7565b8452602084019350"
    "50602081019050610e44565b5050509392505050565b600082601f830112610e8a57610e896109b9565b5b813561"
    "0e9a848260208601610e0c565b91505092915050565b60008060408385031215610eba57610eb96109af565b5b60"
    "0083013567ffffffffffffffff811115610ed857610ed76109b4565b5b610ee485828601610e75565b9250506020"
    "83013567ffffffffffffffff811115610f0557610f046109b4565b5b610f1185828601610e75565b915050925092"
    "9050565b60008060008060808587031215610f3557610f346109af565b5b6000610f4387828801610b58565b9450"
    "506020610f5487828801610bbb565b9350506040610f6587828801610bbb565b9250506060610f7687828801610b"
    "bb565b91505092959194509250565b60008060408385031215610f9957610f986109af565b5b6000610fa7858286"
    "01610b58565b9250506020610fb885828601610bbb565b9150509250929050565b60008060408385031215610fd9"
    "57610fd86109af565b5b600083013567ffffffffffffffff811115610ff757610ff66109b4565b5b611003858286"
    "01610ad1565b925050602083013567ffffffffffffffff811115611024576110236109b4565b5b61103085828601"
    "610ad1565b9150509250929050565b600073ffffffffffffffffffffffffffffffffffffffff8216905091905056"
    "5b60006110658261103a565b9050919050565b6110758161105a565b811461108057600080fd5b50565b60008135"
    "90506110928161106c565b92915050565b600080604083850312156110af576110ae6109af565b5b60006110bd85"
    "828601611083565b92505060206110ce85828601611083565b9150509250929050565b600067ffffffffffffffff"
    "8211156110f3576110f26109d4565b5b6110fc826109c3565b9050602081019050919050565b600061111c611117"
    "846110d8565b610a34565b905082815260208101848484011115611138576111376109be565b5b61114384828561"
    "0a80565b509392505050565b600082601f8301126111605761115f6109b9565b5b81356111708482602086016111"
    "09565b91505092915050565b60006020828403121561118f5761118e6109af565b5b600082013567ffffffffffff"
    "ffff8111156111ad576111ac6109b4565b5b6111b98482850161114b565b91505092915050565b60008151905091"
    "9050565b600082825260208201905092915050565b60005b838110156111fc578082015181840152602081019050"
    "6111e1565b8381111561120b576000848401525b50505050565b600061121c826111c2565b61122681856111cd56"
    "5b93506112368185602086016111de565b61123f816109c3565b840191505092915050565b600060208201905081"
    "810360008301526112648184611211565b905092915050565b7f4e487b7100000000000000000000000000000000"
    "000000000000000000000000600052602160045260246000fd5b7f4469646e2774206d6174636820616e7920616c"
    "6c6f7761626c65206576656e7460008201527f20696e646578000000000000000000000000000000000000000000"
    "0000000000602082015250565b60006112f76026836111cd565b91506113028261129b565b604082019050919050"
    "565b60006020820190508181036000830152611326816112ea565b9050919050565b61133681610b9a565b825250"
    "50565b6000608082019050611351600083018761132d565b61135e602083018661132d565b61136b604083018561"
    "132d565b611378606083018461132d565b95945050505050565b6000604082019050611396600083018561132d56"
    "5b6113a3602083018461132d565b9392505050565b6113b381610b9a565b82525050565b60208201600082015161"
    "13cf60008501826113aa565b50505050565b6060820160008201516113eb60008501826113aa565b506020820151"
    "6113fe60208501826113aa565b50604082015161141160408501826113b9565b50505050565b6000608082019050"
    "61142c600083018561132d565b61143960208301846113d5565b9392505050565b60006020820190506114556000"
    "83018461132d565b92915050565b600081519050919050565b600081905092915050565b60008190506020820190"
    "50919050565b61148a81610db4565b82525050565b600061149c8383611481565b60208301905092915050565b60"
    "00602082019050919050565b60006114c08261145b565b6114ca8185611466565b93506114d583611471565b8060"
    "005b838110156115065781516114ed8882611490565b97506114f8836114a8565b9250506001810190506114d956"
    "5b5085935050505092915050565b600061151f82846114b5565b915081905092915050565b600082825260208201"
    "905092915050565b61154481610db4565b82525050565b6000611556838361153b565b6020830190509291505056"
    "5b600061156d8261145b565b611577818561152a565b935061158283611471565b8060005b838110156115b35781"
    "5161159a888261154a565b97506115a5836114a8565b925050600181019050611586565b50859350505050929150"
    "50565b600060208201905081810360008301526115da8184611562565b905092915050565b600060608201905061"
    "15f7600083018661132d565b611604602083018561132d565b611611604083018461132d565b949350505050565b"
    "600081905092915050565b600061162f826111c2565b6116398185611619565b93506116498185602086016111de"
    "565b80840191505092915050565b60006116618284611624565b915081905092915050565b6116758161105a565b"
    "82525050565b6000602082019050611690600083018461166c565b92915050565b600081519050919050565b6000"
    "82825260208201905092915050565b60006116bd82611696565b6116c781856116a1565b93506116d78185602086"
    "016111de565b6116e0816109c3565b840191505092915050565b6000602082019050818103600083015261170581"
    "846116b2565b905092915050565b6000604082019050611722600083018561166c565b61172f602083018461166c"
    "565b939250505056fea2646970667358221220c210b75fcc1b13a7d08711ef833663000e885b94713c307622ffdc"
    "2214d1a22264736f6c634300080b0033"
)

CONTRACT_EMITTER_ABI = [
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "arg0",
                "type": "address"
            },
            {
                "indexed": False,
                "internalType": "address",
                "name": "arg1",
                "type": "address"
            }
        ],
        "name": "LogAddressIndexed",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "address",
                "name": "arg0",
                "type": "address"
            },
            {
                "indexed": False,
                "internalType": "address",
                "name": "arg1",
                "type": "address"
            }
        ],
        "name": "LogAddressNotIndexed",
        "type": "event"
    },
    {
        "anonymous": True,
        "inputs": [],
        "name": "LogAnonymous",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "bytes",
                "name": "v",
                "type": "bytes"
            }
        ],
        "name": "LogBytes",
        "type": "event"
    },
    {
        "anonymous": True,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            }
        ],
        "name": "LogDoubleAnonymous",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            }
        ],
        "name": "LogDoubleArg",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            }
        ],
        "name": "LogDoubleWithIndex",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "string",
                "name": "arg0",
                "type": "string"
            },
            {
                "indexed": False,
                "internalType": "string",
                "name": "arg1",
                "type": "string"
            }
        ],
        "name": "LogDynamicArgs",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "bytes2[]",
                "name": "arg0",
                "type": "bytes2[]"
            },
            {
                "indexed": False,
                "internalType": "bytes2[]",
                "name": "arg1",
                "type": "bytes2[]"
            }
        ],
        "name": "LogListArgs",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [],
        "name": "LogNoArguments",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg2",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg3",
                "type": "uint256"
            }
        ],
        "name": "LogQuadrupleArg",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            },
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg2",
                "type": "uint256"
            },
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg3",
                "type": "uint256"
            }
        ],
        "name": "LogQuadrupleWithIndex",
        "type": "event"
    },
    {
        "anonymous": True,
        "inputs": [
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            }
        ],
        "name": "LogSingleAnonymous",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            }
        ],
        "name": "LogSingleArg",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            }
        ],
        "name": "LogSingleWithIndex",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "string",
                "name": "v",
                "type": "string"
            }
        ],
        "name": "LogString",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "components": [
                    {
                        "internalType": "uint256",
                        "name": "a",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "b",
                        "type": "uint256"
                    },
                    {
                        "components": [
                            {
                                "internalType": "uint256",
                                "name": "c",
                                "type": "uint256"
                            }
                        ],
                        "internalType": "struct Emitter.NestedTestTuple",
                        "name": "nested",
                        "type": "tuple"
                    }
                ],
                "indexed": False,
                "internalType": "struct Emitter.TestTuple",
                "name": "arg1",
                "type": "tuple"
            }
        ],
        "name": "LogStructArgs",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg2",
                "type": "uint256"
            }
        ],
        "name": "LogTripleArg",
        "type": "event"
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "arg0",
                "type": "uint256"
            },
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg1",
                "type": "uint256"
            },
            {
                "indexed": True,
                "internalType": "uint256",
                "name": "arg2",
                "type": "uint256"
            }
        ],
        "name": "LogTripleWithIndex",
        "type": "event"
    },
    {
        "inputs": [
            {
                "internalType": "address", "name": "arg0", "type": "address"
            },
            {
                "internalType": "address", "name": "arg1", "type": "address"
            }
        ],
        "name": "logAddressIndexedArgs",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {
                "internalType": "address", "name": "arg0", "type": "address"
            },
            {
                "internalType": "address", "name": "arg1", "type": "address"
            }
        ],
        "name": "logAddressNotIndexedArgs",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [{
            "internalType": "bytes", "name": "v", "type": "bytes"
        }],
        "name": "logBytes",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {
                "internalType": "enum Emitter.WhichEvent",
                "name": "which",
                "type": "uint8"
            },
            {
                "internalType": "uint256", "name": "arg0", "type": "uint256"
            },
            {
                "internalType": "uint256", "name": "arg1", "type": "uint256"
            }
        ],
        "name": "logDouble",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {"internalType": "string", "name": "arg0", "type": "string"},
            {"internalType": "string", "name": "arg1", "type": "string"}
        ],
        "name": "logDynamicArgs",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {"internalType": "bytes2[]", "name": "arg0", "type": "bytes2[]"},
            {"internalType": "bytes2[]", "name": "arg1", "type": "bytes2[]"}
        ],
        "name": "logListArgs",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {
                "internalType": "enum Emitter.WhichEvent",
                "name": "which",
                "type": "uint8"
            }
        ],
        "name": "logNoArgs",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {
                "internalType": "enum Emitter.WhichEvent",
                "name": "which",
                "type": "uint8"
            },
            {"internalType": "uint256", "name": "arg0", "type": "uint256"},
            {"internalType": "uint256", "name": "arg1", "type": "uint256"},
            {"internalType": "uint256", "name": "arg2", "type": "uint256"},
            {"internalType": "uint256", "name": "arg3", "type": "uint256"}
        ],
        "name": "logQuadruple",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {
                "internalType": "enum Emitter.WhichEvent",
                "name": "which",
                "type": "uint8"
            },
            {"internalType": "uint256", "name": "arg0", "type": "uint256"}
        ],
        "name": "logSingle",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [{"internalType": "string", "name": "v", "type": "string"}],
        "name": "logString",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {"internalType": "uint256", "name": "arg0", "type": "uint256"},
            {
                "components": [
                    {
                        "internalType": "uint256",
                        "name": "a",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "b",
                        "type": "uint256"
                    },
                    {
                        "components": [
                            {
                                "internalType": "uint256",
                                "name": "c",
                                "type": "uint256"
                            }
                        ],
                        "internalType": "struct Emitter.NestedTestTuple",
                        "name": "nested",
                        "type": "tuple"
                    }
                ],
                "internalType": "struct Emitter.TestTuple",
                "name": "arg1",
                "type": "tuple"
            }
        ],
        "name": "logStruct",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [
            {
                "internalType": "enum Emitter.WhichEvent",
                "name": "which",
                "type": "uint8"
            },
            {"internalType": "uint256", "name": "arg0", "type": "uint256"},
            {"internalType": "uint256", "name": "arg1", "type": "uint256"},
            {"internalType": "uint256", "name": "arg2", "type": "uint256"}
        ],
        "name": "logTriple",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    }
]


EMITTER_ENUM = {
    'LogAnonymous': 0,
    'LogNoArguments': 1,
    'LogSingleArg': 2,
    'LogDoubleArg': 3,
    'LogTripleArg': 4,
    'LogQuadrupleArg': 5,
    'LogSingleAnonymous': 6,
    'LogSingleWithIndex': 7,
    'LogDoubleAnonymous': 8,
    'LogDoubleWithIndex': 9,
    'LogTripleWithIndex': 10,
    'LogQuadrupleWithIndex': 11,
    'LogStructArg': 12
}
