'''
class ZernikePolynomials():
    """
    Fit Zernikes to the trimmed aperture generated by generateAperture.trim_apertures()
    """

    def __init__(self, coefficients, ntermsreal=67, ntermsimag=67, interpfac = 10, x = 256, y = 256, overwrite=True, parallel=False):
        coefficients = coefficients
        ntermsreal = ntermsreal
        ntermsimag = ntermsreal
        overwrite = overwrite
        x = x
        y = y
        zernike_surface = []
'''
from numba import jit

#@jit(nopython=True, cache=True, nogil=True)
def _powl(base, exp):
    """
    Algorithm taken from https://stackoverflow.com/questions/2198138/calculating-powers-e-g-211-quickly
    """
    if exp == 0:
        return 1
    elif exp == 1:
        return base
    elif (exp & 1) != 0:
        return base * _powl(base * base, exp // 2)
    else:
        return _powl(base * base, exp // 2)



def _generate_zernike_surface(coefficients, x, y):

    '''
    Use polynomial approximations to generate Zernike surface
    '''
    import numpy as np

    #Setting coefficients array
    Z = np.zeros(67,dtype=complex)
    if len(coefficients) < len(Z):
        c = Z.copy()
        c[:len(coefficients)] += coefficients
    else:
        c = Z.copy()
        c[:len(coefficients)] += coefficients
    
    #Setting the equations for the Zernike polynomials
    #r = np.sqrt(_powl(x,2) + _powl(y,2))
    Z1  =  c[0]  * 1 # m = 0    n = 0
    Z2  =  c[1]  * x # m = -1   n = 1
    Z3  =  c[2]  * y # m = 1    n = 1
    Z4  =  c[3]  * 2*x*y # m = -2   n = 2
    Z5  =  c[4]  * (2*_powl(x,2) + 2*_powl(y,2) -1)# m = 0  n = 2
    Z6  =  c[5]  * (-1*_powl(x,2) + _powl(y,2))# m = 2  n = 2
    Z7  =  c[6]  * (-1*_powl(x,3) + 3*x*_powl(y,2)) #m = -3     n = 3
    Z8  =  c[7]  * (-2*x + 3*(_powl(x,3)) + 3*x*(_powl(y,2)))# m = -1   n = 3
    Z9  =  c[8]  * (-2*y + 3*_powl(y,3) + 3*(_powl(x,2)) * y)# m = 1    n = 3
    Z10 =  c[9]  * (_powl(y,3)-3*(_powl(x,2))*y)# m = 3 n =3
    Z11 =  c[10] * (-4*(_powl(x,3))*y + 4*x*(_powl(y,3)))#m = -4    n = 4
    Z12 =  c[11] * (-6*x*y + 8*(_powl(x,3))*y + 8*x*(_powl(y,3)))# m = -2   n = 4
    Z13 =  c[12] * (1-6*_powl(x,2) - 6*_powl(y,2) + 6*_powl(x,4) + 12*(_powl(x,2))*(_powl(y,2)) + 6*_powl(y,4))# m = 0  n = 4
    Z14 =  c[13] * (3*_powl(x,2) - 3*_powl(y,2) - 4*_powl(x,4) + 4*_powl(y,4))#m = 2    n = 4
    Z15 =  c[14] * (_powl(x,4) - 6*(_powl(x,2))*(_powl(y,2)) + _powl(y,4))# m = 4   n = 4
    Z16 =  c[15] * (_powl(x,5)-10*(_powl(x,3))*powl(y,2) + 5*x*(powl(y,4)))# m = -5   n = 5
    Z17 =  c[16] * (4*powl(x,3) - 12*x*(powl(y,2)) -5*powl(x,5) + 10*(powl(x,3))*(powl(y,2)) + 15*x*powl(y,4))# m =-3     n = 5
    Z18 =  c[17] * (3*x - 12*powl(x,3) - 12*x*(powl(y,2)) + 10*powl(x,5) + 20*(powl(x,3))*(powl(y,2)) + 10*x*(powl(y,4)))# m= -1  n = 5
    Z19 =  c[18] * (3*y - 12*powl(y,3) - 12*y*(powl(x,2)) + 10*powl(y,5) + 20*(powl(y,3))*(powl(x,2)) + 10*y*(powl(x,4)))# m = 1  n = 5
    Z20 =  c[19] * (-4*powl(y,3) + 12*y*(powl(x,2)) + 5*powl(y,5) - 10*(powl(y,3))*(powl(x,2)) - 15*y*powl(x,4))# m = 3   n = 5
    Z21 =  c[20] * (powl(y,5)-10*(powl(y,3))*powl(x,2) + 5*y*(powl(x,4)))#m = 5 n = 5
    Z22 =  c[21] * (6*(powl(x,5))*y - 20*(powl(x,3))*(powl(y,3)) + 6*x*(powl(y,5)))# m = -6 n = 6
    Z23 =  c[22] * (20*(powl(x,3))*y - 20*x*(powl(y,3)) - 24*(powl(x,5))*y + 24*x*(powl(y,5)))#m = -4   n = 6
    Z24 =  c[23] * (12*x*y + 40*(powl(x,3))*y - 40*x*(powl(y,3)) + 30*(powl(x,5))*y + 60*(powl(x,3))*(powl(y,3)) - 30*x*(powl(y,5)))#m = -2   n = 6
    Z25 =  c[24] * (-1 + 12*(powl(x,2)) + 12*(powl(y,2)) - 30*(powl(x,4)) - 60*(powl(x,2))*(powl(y,2)) - 30*(powl(y,4)) + 20*(powl(x,6)) + 60*(powl(x,4))*powl(y,2) + 60 *(powl(x,2))*(powl(y,4)) + 20*(powl(y,6)))#m = 0   n = 6
    Z26 =  c[25] * (-6*(powl(x,2)) + 6*(powl(y,2)) + 20*(powl(x,4)) - 20*(powl(y,4)) - 15*(powl(x,6)) - 15*(powl(x,4))*(powl(y,2)) + 15*(powl(x,2))*(powl(y,4)) + 15*(powl(y,6)))#m = 2   n = 6
    Z27 =  c[26] * (-5*(powl(x,4)) + 30*(powl(x,2))*(powl(y,2)) - 5*(powl(y,4)) + 6*(powl(x,6)) - 30*(powl(x,4))*powl(y,2) - 30*(powl(x,2))*(powl(y,4)) + 6*(powl(y,6)))#m = 4    n = 6
    Z28 =  c[27] * (-1*(powl(x,6)) + 15*(powl(x,4))*(powl(y,2)) - 15*(powl(x,2))*(powl(y,4)) + powl(y,6))#m = 6   n = 6
    Z29 =  c[28] * (-1*(powl(x,7)) + 21*(powl(x,5))*(powl(y,2)) - 35*(powl(x,3))*(powl(y,4)) + 7*x*(powl(y,6)))#m = -7    n = 7
    Z30 =  c[29] * (-6*(powl(x,5)) + 60*(powl(x,3))*(powl(y,2)) - 30*x*(powl(y,4)) + 7*powl(x,7) - 63*(powl(x,5))*(powl(y,2)) - 35*(powl(x,3))*(powl(y,4)) + 35*x*(powl(y,6))) #m = -5    n = 7
    Z31 =  c[30] * (-10*(powl(x,3)) + 30*x*(powl(y,2)) + 30*powl(x,5) - 60*(powl(x,3))*(powl(y,2)) - 90*x*(powl(y,4)) - 21*powl(x,7) + 21*(powl(x,5))*(powl(y,2)) + 105*(powl(x,3))*(powl(y,4)) + 63*x*(powl(y,6)))#m =-3       n = 7
    Z32 =  c[31] * (-4*x + 30*powl(x,3) + 30*x*(powl(y,2)) - 60*(powl(x,5)) - 120*(powl(x,3))*(powl(y,2)) - 60*x*(powl(y,4)) + 35*powl(x,7) + 105*(powl(x,5))*(powl(y,2)) + 105*(powl(x,3))*(powl(y,4)) + 35*x*(powl(y,6)))#m = -1  n = 7
    Z33 =  c[32] * (-4*y + 30*powl(y,3) + 30*y*(powl(x,2)) - 60*(powl(y,5)) - 120*(powl(y,3))*(powl(x,2)) - 60*y*(powl(x,4)) + 35*powl(y,7) + 105*(powl(y,5))*(powl(x,2)) + 105*(powl(y,3))*(powl(x,4)) + 35*y*(powl(x,6)))#m = 1   n = 7
    Z34 =  c[33] * (10*(powl(y,3)) - 30*y*(powl(x,2)) - 30*powl(y,5) + 60*(powl(y,3))*(powl(x,2)) + 90*y*(powl(x,4)) + 21*powl(y,7) - 21*(powl(y,5))*(powl(x,2)) - 105*(powl(y,3))*(powl(x,4)) - 63*y*(powl(x,6)))#m =3     n = 7
    Z35 =  c[34] * (-6*(powl(y,5)) + 60*(powl(y,3))*(powl(x,2)) - 30*y*(powl(x,4)) + 7*powl(y,7) - 63*(powl(y,5))*(powl(x,2)) - 35*(powl(y,3))*(powl(x,4)) + 35*y*(powl(x,6)))#m = 5  n = 7
    Z36 =  c[35] * (powl(y,7) - 21*(powl(y,5))*(powl(x,2)) + 35*(powl(y,3))*(powl(x,4)) - 7*y*(powl(x,6)))#m = 7  n = 7
    Z37 =  c[36] * (-8*(powl(x,7))*y + 56*(powl(x,5))*(powl(y,3)) - 56*(powl(x,3))*(powl(y,5)) + 8*x*(powl(y,7)))#m = -8  n = 8
    Z38 =  c[37] * (-42*(powl(x,5))*y + 140*(powl(x,3))*(powl(y,3)) - 42*x*(powl(y,5)) + 48*(powl(x,7))*y - 112*(powl(x,5))*(powl(y,3)) - 112*(powl(x,3))*(powl(y,5)) + 48*x*(powl(y,7)))#m = -6  n = 8
    Z39 =  c[38] * (-60*(powl(x,3))*y + 60*x*(powl(y,3)) + 168*(powl(x,5))*y -168*x*(powl(y,5)) - 112*(powl(x,7))*y - 112*(powl(x,5))*(powl(y,3)) + 112*(powl(x,3))*(powl(y,5)) + 112*x*(powl(y,7)))#m = -4   n = 8
    Z40 =  c[39] * (-20*x*y + 120*(powl(x,3))*y + 120*x*(powl(y,3)) - 210*(powl(x,5))*y - 420*(powl(x,3))*(powl(y,3)) - 210*x*(powl(y,5)) - 112*(powl(x,7))*y + 336*(powl(x,5))*(powl(y,3)) + 336*(powl(x,3))*(powl(y,5)) + 112*x*(powl(y,7)))#m = -2   n = 8
    Z41 =  c[40] * (1 - 20*powl(x,2) - 20*powl(y,2) + 90*powl(x,4) + 180*(powl(x,2))*(powl(y,2)) + 90*powl(y,4) - 140*powl(x,6) - 420*(powl(x,4))*(powl(y,2)) - 420*(powl(x,2))*(powl(y,4)) - 140*(powl(y,6)) + 70*powl(x,8) + 280*(powl(x,6))*(powl(y,2)) + 420*(powl(x,4))*(powl(y,4)) + 280*(powl(x,2))*(powl(y,6)) + 70*powl(y,8))#m = 0    n = 8
    Z42 =  c[41] * (10*powl(x,2) - 10*powl(y,2) - 60*powl(x,4) + 105*(powl(x,4))*(powl(y,2)) - 105*(powl(x,2))*(powl(y,4)) + 60*powl(y,4) + 105*powl(x,6) - 105*powl(y,6) - 56*powl(x,8) - 112*(powl(x,6))*(powl(y,2)) + 112*(powl(x,2))*(powl(y,6)) + 56*powl(y,8))#m = 2  n = 8
    Z43 =  c[42] * (15*powl(x,4) - 90*(powl(x,2))*(powl(y,2)) + 15*powl(y,4) - 42*powl(x,6) + 210*(powl(x,4))*(powl(y,2)) + 210*(powl(x,2))*(powl(y,4)) - 42*powl(y,6) + 28*powl(x,8) - 112*(powl(x,6))*(powl(y,2)) - 280*(powl(x,4))*(powl(y,4)) - 112*(powl(x,2))*(powl(y,6)) + 28*powl(y,8))#m = 4     n = 8
    Z44 =  c[43] * (7*powl(x,6) - 105*(powl(x,4))*(powl(y,2)) + 105*(powl(x,2))*(powl(y,4)) - 7*powl(y,6) - 8*powl(x,8) + 112*(powl(x,6))*(powl(y,2)) - 112*(powl(x,2))*(powl(y,6)) + 8*powl(y,8))#m = 6    n = 8
    Z45 =  c[44] * (powl(x,8) - 28*(powl(x,6))*(powl(y,2)) + 70*(powl(x,4))*(powl(y,4)) - 28*(powl(x,2))*(powl(y,6)) + powl(y,8))#m = 8     n = 9
    Z46 =  c[45] * (powl(x,9) - 36*(powl(x,7))*(powl(y,2)) + 126*(powl(x,5))*(powl(y,4)) - 84*(powl(x,3))*(powl(y,6)) + 9*x*(powl(y,8)))#m = -9     n = 9
    Z47 =  c[46] * (8*powl(x,7) - 168*(powl(x,5))*(powl(y,2)) + 280*(powl(x,3))*(powl(y,4)) - 56 *x*(powl(y,6)) - 9*powl(x,9) + 180*(powl(x,7))*(powl(y,2)) - 126*(powl(x,5))*(powl(y,4)) - 252*(powl(x,3))*(powl(y,6)) + 63*x*(powl(y,8)))#m = -7    n = 9
    Z48 =  c[47] * (21*powl(x,5) - 210*(powl(x,3))*(powl(y,2)) + 105*x*(powl(y,4)) - 56*powl(x,7) + 504*(powl(x,5))*(powl(y,2)) + 280*(powl(x,3))*(powl(y,4)) - 280*x*(powl(y,6)) + 36*powl(x,9) - 288*(powl(x,7))*(powl(y,2)) - 504*(powl(x,5))*(powl(y,4)) + 180*x*(powl(y,8)))#m = -5    n = 9
    Z49 =  c[48] * (20*powl(x,3) - 60*x*(powl(y,2)) - 105*powl(x,5) + 210*(powl(x,3))*(powl(y,2)) + 315*x*(powl(y,4)) + 168*powl(x,7) - 168*(powl(x,5))*(powl(y,2)) - 840*(powl(x,3))*(powl(y,4)) - 504*x*(powl(y,6)) - 84*powl(x,9) + 504*(powl(x,5))*(powl(y,4)) + 672*(powl(x,3))*(powl(y,6)) + 252*x*(powl(y,8)))#m = -3  n = 9
    Z50 =  c[49] * (5*x - 60*powl(x,3) - 60*x*(powl(y,2)) + 210*powl(x,5) + 420*(powl(x,3))*(powl(y,2)) + 210*x*(powl(y,4)) - 280*powl(x,7) - 840*(powl(x,5))*(powl(y,2)) - 840*(powl(x,3))*(powl(y,4)) - 280*x*(powl(y,6)) + 126*powl(x,9) + 504*(powl(x,7))*(powl(y,2)) + 756*(powl(x,5))*(powl(y,4)) + 504*(powl(x,3))*(powl(y,6)) + 126*x*(powl(y,8)))#m = -1   n = 9
    Z51 =  c[50] * (5*y - 60*powl(y,3) - 60*y*(powl(x,2)) + 210*powl(y,5) + 420*(powl(y,3))*(powl(x,2)) + 210*y*(powl(x,4)) - 280*powl(y,7) - 840*(powl(y,5))*(powl(x,2)) - 840*(powl(y,3))*(powl(x,4)) - 280*y*(powl(x,6)) + 126*powl(y,9) + 504*(powl(y,7))*(powl(x,2)) + 756*(powl(y,5))*(powl(x,4)) + 504*(powl(y,3))*(powl(x,6)) + 126*y*(powl(x,8)))#m = -1   n = 9
    Z52 =  c[51] * (-20*powl(y,3) + 60*y*(powl(x,2)) + 105*powl(y,5) - 210*(powl(y,3))*(powl(x,2)) - 315*y*(powl(x,4)) - 168*powl(y,7) + 168*(powl(y,5))*(powl(x,2)) + 840*(powl(y,3))*(powl(x,4)) + 504*y*(powl(x,6)) + 84*powl(y,9) - 504*(powl(y,5))*(powl(x,4)) - 672*(powl(y,3))*(powl(x,6)) - 252*y*(powl(x,8)))#m = 3  n = 9
    Z53 =  c[52] * (21*powl(y,5) - 210*(powl(y,3))*(powl(x,2)) + 105*y*(powl(x,4)) - 56*powl(y,7) + 504*(powl(y,5))*(powl(x,2)) + 280*(powl(y,3))*(powl(x,4)) - 280*y*(powl(x,6)) + 36*powl(y,9) - 288*(powl(y,7))*(powl(x,2)) - 504*(powl(y,5))*(powl(x,4)) + 180*y*(powl(x,8)))#m = 5     n = 9
    Z54 =  c[53] *(-8*powl(y,7) + 168*(powl(y,5))*(powl(x,2)) - 280*(powl(y,3))*(powl(x,4)) + 56 *y*(powl(x,6)) + 9*powl(y,9) - 180*(powl(y,7))*(powl(x,2)) + 126*(powl(y,5))*(powl(x,4)) - 252*(powl(y,3))*(powl(x,6)) - 63*y*(powl(x,8)))#m = 7     n = 9
    Z55 =  c[54] *(powl(y,9) - 36*(powl(y,7))*(powl(x,2)) + 126*(powl(y,5))*(powl(x,4)) - 84*(powl(y,3))*(powl(x,6)) + 9*y*(powl(x,8)))#m = 9       n = 9
    Z56 =  c[55] *(10*(powl(x,9))*y - 120*(powl(x,7))*(powl(y,3)) + 252*(powl(x,5))*(powl(y,5)) - 120*(powl(x,3))*(powl(y,7)) + 10*x*(powl(y,9)))#m = -10   n = 10
    Z57 =  c[56] *(72*(powl(x,7))*y - 504*(powl(x,5))*(powl(y,3)) + 504*(powl(x,3))*(powl(y,5)) - 72*x*(powl(y,7)) - 80*(powl(x,9))*y + 480*(powl(x,7))*(powl(y,3)) - 480*(powl(x,3))*(powl(y,7)) + 80*x*(powl(y,9)))#m = -8    n = 10
    Z58 =  c[57] *(270*(powl(x,9))*y - 360*(powl(x,7))*(powl(y,3)) - 1260*(powl(x,5))*(powl(y,5)) - 360*(powl(x,3))*(powl(y,7)) + 270*x*(powl(y,9)) - 432*(powl(x,7))*y + 1008*(powl(x,5))*(powl(y,3)) + 1008*(powl(x,3))*(powl(y,5)) - 432*x*(powl(y,7)) + 168*(powl(x,5))*y - 560*(powl(x,3))*(powl(y,3)) + 168*x*(powl(y,5)))#m = -6   n = 10
    Z59 =  c[58] *(140*(powl(x,3))*y - 140*x*(powl(y,3)) - 672*(powl(x,5))*y + 672*x*(powl(y,5)) + 1008*(powl(x,7))*y + 1008*(powl(x,5))*(powl(y,3)) - 1008*(powl(x,3))*(powl(y,5)) - 1008*x*(powl(y,7)) - 480*(powl(x,9))*y - 960*(powl(x,7))*(powl(y,3)) + 960*(powl(x,3))*(powl(y,7)) + 480 *x*(powl(y,9)))#m = -4   n = 10
    Z60 =  c[59] *(30*x*y - 280*(powl(x,3))*y - 280*x*(powl(y,3)) + 840*(powl(x,5))*y + 1680*(powl(x,3))*(powl(y,3)) +840*x*(powl(y,5)) - 1008*(powl(x,7))*y - 3024*(powl(x,5))*(powl(y,3)) - 3024*(powl(x,3))*(powl(y,5)) - 1008*x*(powl(y,7)) + 420*(powl(x,9))*y + 1680*(powl(x,7))*(powl(y,3)) + 2520*(powl(x,5))*(powl(y,5)) + 1680*(powl(x,3))*(powl(y,7)) + 420*x*(powl(y,9)) )#m = -2   n = 10
    Z61 =  c[60] * (-1 + 30*powl(x,2) + 30*powl(y,2) - 210*powl(x,4) - 420*(powl(x,2))*(powl(y,2)) - 210*powl(y,4) + 560*powl(x,6) + 1680*(powl(x,4))*(powl(y,2)) + 1680*(powl(x,2))*(powl(y,4)) + 560*powl(y,6) - 630*powl(x,8) - 2520*(powl(x,6))*(powl(y,2)) - 3780*(powl(x,4))*(powl(y,4)) - 2520*(powl(x,2))*(powl(y,6)) - 630*powl(y,8) + 252*powl(x,10) + 1260*(powl(x,8))*(powl(y,2)) + 2520*(powl(x,6))*(powl(y,4)) + 2520*(powl(x,4))*(powl(y,6)) + 1260*(powl(x,2))*(powl(y,8)) + 252*powl(y,10))#m = 0    n = 10
    Z62 =  c[61] * (-15*powl(x,2) + 15*powl(y,2) + 140*powl(x,4) - 140*powl(y,4) - 420*powl(x,6) - 420*(powl(x,4))*(powl(y,2)) + 420*(powl(x,2))*(powl(y,4)) + 420*powl(y,6) + 504*powl(x,8) + 1008*(powl(x,6))*(powl(y,2)) - 1008*(powl(x,2))*(powl(y,6)) - 504*powl(y,8) - 210*powl(x,10) - 630*(powl(x,8))*(powl(y,2)) - 420*(powl(x,6))*(powl(y,4)) + 420*(powl(x,4))*(powl(y,6)) + 630*(powl(x,2))*(powl(y,8)) + 210*powl(y,10))# m = 2  n = 10
    Z63 =  c[62] *(-35*powl(x,4) + 210*(powl(x,2))*(powl(y,2)) - 35*powl(y,4) + 168*powl(x,6) - 840*(powl(x,4))*(powl(y,2)) - 840*(powl(x,2))*(powl(y,4)) + 168*powl(y,6) - 252*powl(x,8) + 1008*(powl(x,6))*(powl(y,2)) + 2520*(powl(x,4))*(powl(y,4)) + 1008*(powl(x,2))*(powl(y,6)) - 252*(powl(y,8)) + 120*powl(x,10) - 360*(powl(x,8))*(powl(y,2)) - 1680*(powl(x,6))*(powl(y,4)) - 1680*(powl(x,4))*(powl(y,6)) - 360*(powl(x,2))*(powl(y,8)) + 120*powl(y,10))#m = 4     n = 10
    Z64 =  c[63] *(-28*powl(x,6) + 420*(powl(x,4))*(powl(y,2)) - 420*(powl(x,2))*(powl(y,4)) + 28*powl(y,6) + 72*powl(x,8) - 1008*(powl(x,6))*(powl(y,2)) + 1008*(powl(x,2))*(powl(y,6)) - 72*powl(y,8) - 45*powl(x,10) + 585*(powl(x,8))*(powl(y,2)) + 630*(powl(x,6))*(powl(y,4)) - 630*(powl(x,4))*(powl(y,6)) - 585*(powl(x,2))*(powl(y,8)) + 45*powl(y,10))#m = 6    n = 10
    Z65 =  c[64] *(-9*powl(x,8) + 252*(powl(x,6))*(powl(y,2)) - 630*(powl(x,4))*(powl(y,4)) + 252*(powl(x,2))*(powl(y,6)) - 9*powl(y,8) + 10*powl(x,10) - 270*(powl(x,8))*(powl(y,2)) + 420*(powl(x,6))*(powl(y,4)) + 420*(powl(x,4))*(powl(y,6)) - 270*(powl(x,2))*(powl(y,8)) + 10*powl(y,10))#m = 8    n = 10
    Z66 =  c[65] *(-1*powl(x,10) + 45*(powl(x,8))*(powl(y,2)) - 210*(powl(x,6))*(powl(y,4)) + 210*(powl(x,4))*(powl(y,6)) - 45*(powl(x,2))*(powl(y,8)) + powl(y,10))#m = 10   n = 10

    ZW =    Z1 + Z2 +  Z3+  Z4+  Z5+  Z6+  Z7+  Z8+  Z9+  Z10+ Z11+ Z12+ Z13+ Z14+ Z15+ Z16+ Z17+ Z18+ Z19+ Z20+ Z21+ Z22+ Z23+ Z24+ Z25+ Z26+ Z27+ Z28+ Z29+ Z30+ Z31+ Z32+ Z33+ Z34+ Z35+ Z36+ Z37+ Z38+ Z39+ Z40+ Z41+ Z42+ Z43+ Z44+ Z45+ Z46+ Z47+ Z48+ Z49+Z50+ Z51+ Z52+ Z53+ Z54+ Z55+ Z56+ Z57+ Z58+ Z59+Z60+ Z61+ Z62+ Z63+ Z64+ Z65+ Z66
    return ZW
