"""
    Comotion Dash API

    Comotion Dash API  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from comodash_api_client_lowlevel.api_client import ApiClient, Endpoint as _Endpoint
from comodash_api_client_lowlevel.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from comodash_api_client_lowlevel.model.error import Error
from comodash_api_client_lowlevel.model.query import Query
from comodash_api_client_lowlevel.model.query_id import QueryId
from comodash_api_client_lowlevel.model.query_result import QueryResult
from comodash_api_client_lowlevel.model.query_text import QueryText


class QueriesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __download_csv(
            self,
            query_id,
            **kwargs
        ):
            """Download the csv result file of a query  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.download_csv(query_id, async_req=True)
            >>> result = thread.get()

            Args:
                query_id (str): Unique Identifier for the query

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['query_id'] = \
                query_id
            return self.call_with_http_info(**kwargs)

        self.download_csv = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'OAuth2Authorizer'
                ],
                'endpoint_path': '/query/{query_id}/csv',
                'operation_id': 'download_csv',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query_id',
                ],
                'required': [
                    'query_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query_id':
                        (str,),
                },
                'attribute_map': {
                    'query_id': 'query_id',
                },
                'location_map': {
                    'query_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'binary/octet-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__download_csv
        )

        def __get_query(
            self,
            query_id,
            **kwargs
        ):
            """Get information about a query  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_query(query_id, async_req=True)
            >>> result = thread.get()

            Args:
                query_id (str): Unique Identifier for the query

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Query
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['query_id'] = \
                query_id
            return self.call_with_http_info(**kwargs)

        self.get_query = _Endpoint(
            settings={
                'response_type': (Query,),
                'auth': [
                    'OAuth2Authorizer'
                ],
                'endpoint_path': '/query/{query_id}',
                'operation_id': 'get_query',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query_id',
                ],
                'required': [
                    'query_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query_id':
                        (str,),
                },
                'attribute_map': {
                    'query_id': 'query_id',
                },
                'location_map': {
                    'query_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_query
        )

        def __get_query_results(
            self,
            query_id,
            **kwargs
        ):
            """Get paginated results of a query  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_query_results(query_id, async_req=True)
            >>> result = thread.get()

            Args:
                query_id (str): Unique Identifier for the query

            Keyword Args:
                next_token (str): token to get next page of query results.  Will be supplied in the response of the previous call if the result set is truncated.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                QueryResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['query_id'] = \
                query_id
            return self.call_with_http_info(**kwargs)

        self.get_query_results = _Endpoint(
            settings={
                'response_type': (QueryResult,),
                'auth': [
                    'OAuth2Authorizer'
                ],
                'endpoint_path': '/query/{query_id}/result',
                'operation_id': 'get_query_results',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query_id',
                    'next_token',
                ],
                'required': [
                    'query_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query_id':
                        (str,),
                    'next_token':
                        (str,),
                },
                'attribute_map': {
                    'query_id': 'query_id',
                    'next_token': 'next_token',
                },
                'location_map': {
                    'query_id': 'path',
                    'next_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_query_results
        )

        def __run_query(
            self,
            query_text,
            **kwargs
        ):
            """Run a query  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.run_query(query_text, async_req=True)
            >>> result = thread.get()

            Args:
                query_text (QueryText):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                QueryId
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['query_text'] = \
                query_text
            return self.call_with_http_info(**kwargs)

        self.run_query = _Endpoint(
            settings={
                'response_type': (QueryId,),
                'auth': [
                    'OAuth2Authorizer'
                ],
                'endpoint_path': '/query',
                'operation_id': 'run_query',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'query_text',
                ],
                'required': [
                    'query_text',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query_text':
                        (QueryText,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'query_text': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__run_query
        )

        def __stop_query(
            self,
            query_id,
            **kwargs
        ):
            """Stop a running query  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.stop_query(query_id, async_req=True)
            >>> result = thread.get()

            Args:
                query_id (str): Unique Identifier for the query

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['query_id'] = \
                query_id
            return self.call_with_http_info(**kwargs)

        self.stop_query = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2Authorizer'
                ],
                'endpoint_path': '/query/{query_id}',
                'operation_id': 'stop_query',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'query_id',
                ],
                'required': [
                    'query_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query_id':
                        (str,),
                },
                'attribute_map': {
                    'query_id': 'query_id',
                },
                'location_map': {
                    'query_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__stop_query
        )
