# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openpy_dsse',
 'openpy_dsse.DSSE_algorithms',
 'openpy_dsse.DSSE_algorithms.Symb_Eqn']

package_data = \
{'': ['*'],
 'openpy_dsse': ['examples/13NodeIEEE/*',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/13NodeIEEE/OpenDSS files/*',
                 'examples/13NodeIEEE/OpenDSS files/PosSeq circuit/*',
                 'examples/13NodeIEEE/Results/Results_DSSE_13NodeIEEE.json',
                 'examples/15NodeIEEE/*',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/15NodeIEEE/OpenDSS files/*',
                 'examples/15NodeIEEE/Results/Results_DSSE_15NodeIEEE.json',
                 'examples/37NodeIEEE/*',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Init_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Bus_i_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/MEAS_files/Pos_MEAS_Elem_ft_PMU.json',
                 'examples/37NodeIEEE/OpenDSS files/*',
                 'examples/37NodeIEEE/OpenDSS files/PosSeq circuit/*',
                 'examples/37NodeIEEE/Results/Results_DSSE_37nodeIEEE.json',
                 'examples/4Node/MEAS_files/*',
                 'examples/4Node/OpenDSS files/*',
                 'examples/4Node/Results/Results_DSSE_4Node.json']}

install_requires = \
['colorama==0.4.6',
 'contourpy==1.0.5',
 'cycler==0.11.0',
 'et-xmlfile==1.1.0',
 'fonttools==4.38.0',
 'kiwisolver==1.4.4',
 'matplotlib==3.6.0',
 'mpmath==1.2.1',
 'numpy==1.23.5',
 'openpyxl==3.0.10',
 'packaging==21.3',
 'pandas==1.2.3',
 'pillow==9.2.0',
 'py-dss-interface==1.0.2',
 'pyparsing==3.0.9',
 'python-dateutil==2.8.2',
 'pytz==2022.6',
 'scipy==1.9.3',
 'seaborn==0.12.1',
 'six==1.16.0',
 'sympy==1.11.1']

setup_kwargs = {
    'name': 'openpy-dsse',
    'version': '0.1.1',
    'description': 'Open source library for state estimation of a distribution network modeled in OpenDSS',
    'long_description': '# openpy_dsse\n\nIt is an open-source library developed in Python for estimating distribution networks (DSSE). It communicates with the free software for the simulation of electrical networks (OpenDSS) and collects the results of power flow and distribution system parameters and executes the DSSE, obtaining an estimated state according to the type and location of measurements.\n\nIt is developed within the framework of the OpenREiD project (Integral software for simulation and optimization of electrical distribution networks), of the Instituto de Energía Eléctrica (IEE), UNSJ - CONICET, San Juan - Argentina.\n\n**Index**\n\n- [Installation](#id1)\n- [How to use](#id2)\n  - [Measurements](#id3)\n    - [Definition and creation of meters](#id4)\n    - [Generate metrics from OpenDSS results](#id5)\n  - [Run the state estimation algorithm](#id6)\n  - [Sample tests](#id7)\n- [License](#id8)\n\n<div id=\'id1\' />\n## Installation\n\nWith pip\n\n``pip install py-open-dsse``\n\nWithout pip, clone or download the repository, in the dist folder is the .whl file, copy the location of the file, and in the CMD:\n\n``pip install {path-save-files}/openpy_dsse-{version}-py3-none-any.whl’``\n\n<div id=\'id2\'/>\n\n## How to use  <a name="id1"></a>\n\nFirst, in the IDE (Integrated Development Environment) of preference, we import the library:\n\n```Python\nimport openpy_dsse\n```\n\nThe object class that contains all the functions of the library is activated as follows:\n\n```Python\ndsse = openpy_dsse.init_DSSE()\n```\n\nThe class ``init_DSSE()``, has default values as shown in table 1 and can be modified as appropriate.\n\n**Table 1.** Description and attributes of function ``init_DSSE()``\n| **Parameters** | **Description** | **Default value** |\n|:---:|---|:---:|\n| ``Sbas3ph_MVA`` | Three-phase system base power     | ``30`` |\n| ``tolerance`` | Convergence tolerance of selected algorithm | ``1e-3`` |\n| ``max_iter`` | Maximum number of iterations of the selected algorithm | ``30`` |\n| ``init_values`` | Initial values for state estimation. With ``flat`` start with 1.0 p.u. / 0° on all buses and with ``dss`` start with OpenDSS voltage and angle results| ``flat`` |\n\nOnce the class is initialized, we can use the functions described below.\n\n<div id=\'id3\' />\n\n### Measurements\n\n<div id=\'id4\' />\n\n#### Definition and creation of meters\n\nThe library supports meters and their respective error variance described in Table 2.\n\n**Table 2.** Measurement type of the ``openpy_dsse`` library.\n\n|              **Meter**                 |                                **Description**                |\n|:--------------------------------------:|---------------------------------------------------------------|\n| $\\left\\|V_{i}\\right\\|$                 | Node voltage magnitude.                                       |\n| $PQ_{ft}$                              | Branch power flow                                             |\n| $\\left\\|I_{ft}\\right\\|$                | Magnitude of branch current.                                  |\n| $PQ_{i}^{SM}$                          | Injection power or node consumption obtained by a smart meter |\n| $PQ_{i}^{0}$                           | Passive node or zero injection power.                         |\n| $PQ_{i}^{PSD}$                         | Artificial node injection power known as pseudo-measurement   |\n| $\\left\\|V_{i}\\right\\|\\angle \\theta$    | Voltage phasor measurement                                    |\n| $\\left\\|I_{ft}\\right\\|\\angle \\delta$   | Current phasor measurement                                              |\n\nThe measurement data per phase **𝜌 (1, 2, 3)** and measurement error variance ``Rii`` of a network modeled in OpenDSS. They must be entered in the ``MEAS_Bus_i.json``, ``MEAS_Elem_ft.json``, ``MEAS_Bus_i_PMU.json`` and ``MEAS_Elem_ft_PMU.json`` files. The ``.json`` measurement files without data are generated with the ``empty_MEAS_files()`` function and the parameters from table 3 must be entered.\n\n**Table 3.** Parameters and description of ``empty_file_MEAS()`` function\n|    **Parameter**   |                           **Description**                         |**Default value** |\n|:------------------:|-------------------------------------------------------------------|:----------------:|\n| ``DSS_path``       | A path of the ``.DSS`` files of the circuit modeled in OpenDSS    | ``None ``        |\n| ``MEAS_path_save`` | Path where the measurement ``.json`` files will be saved          | ``None ``        |\n\nThe description of the identifiers that can be modified is detailed in tables 4, 5, 6, and 7. The other identifiers in the ``.json`` files, are node characteristics or elements extracted from the circuit modeled in OpenDSS, these data should not be modified since they would affect the result of the state estimation algorithm.\n\n**Table 4.** Description of identifiers of the ``MEAS_Bus_i.json`` file.\n\n| **Identifier**     |                                       **Description**                         |\n|:---------------------:|-------------------------------------------------------------------------------|\n| ``STS_Vm``            | Status (1: Enabled, 0: Disabled)                                              |\n| ``Rii_Vm``            | Variance of voltage magnitude measurement error.                              |\n| ``Vρm(pu)``           | Measurement of voltage magnitude voltage in phase 𝜌.                          |\n| ``STS_PQd(SM)``       | Status (1: Enabled, 0: Disabled)                                              |\n| ``Rii_SM``            | Measurement error variance of injection power or consumption of a smart meter.|\n| ``STS_PQd(0)``        | Status (1: Enabled, 0: Disabled)                                              |\n| ``Rii_0``             | Zero or passive injection power measurement error variance.                   |\n| ``STS_PQd(Psd)``      | Status (1: Enabled, 0: Disabled)                                              |\n| ``Rii_Psd``           | Measurement error variance of pseudo power injection measurement              |\n| ``Pρmd(pu)``          | Measurement of active power injection in phase 𝜌.                             |\n| ``Qρmd(pu)``          | Measurement of reactive power injection in phase 𝜌.                           |\n\n**Table 5.** Description of identifiers of the ``MEAS_Elem_ft.json`` file.\n\n| **Identifier**        | **Description**                                    |\n|:---------------------:|----------------------------------------------------|\n| ``STS_PQft``          | Status (1: Enabled, 0: Disabled)                   |\n| ``Rii_PQft``          | Branch power flow measurement error variance.      |\n| ``Pρmft(pu)``         | Measurement of branch active power in phase 𝜌.     |\n| ``Qρmft(pu)``         | Measurement of branch reactive power in phase 𝜌.   |\n| ``STS_Ift``           | Status (1: Enabled, 0: Disabled)                   |\n| ``Rii_Ift``           | Branch current magnitude error variance.           |\n| ``Iρmft(pu)``         | Measurement of branch current magnitude in phase 𝜌.|\n\n**Table 6.** Description of identifiers of the ``MEAS_Elem_ft_PMU.json`` file.\n| **Identifier**     |                   **Description**           |\n|:---------------------:|---------------------------------------------|\n| ``STS_Vm``            | Status (1: Enabled, 0: Disabled)            |\n| ``Rii_Vm``            | Variance of voltage phasor measurement error|\n| ``Vρm(pu)``           | Measurement of voltage magnitude in phase 𝜌 |\n| ``Angρm(deg)``        | Measurement of volage angle in phase 𝜌      |\n\n**Table 7.** Description of identifiers of the ``MEAS_Elem_ft_PMU.json`` file.\n| **Identifier**    |                 **Description**             |\n|:-----------------:|---------------------------------------------|\n| ``STS_Ift``       | Status (1: Enabled, 0: Disabled)            |\n| ``Rii_Ift``       | Variance of current phasor measurement error|\n| ``Iρmft(pu)``     | Measurement of current magnitude in phase 𝜌 |\n| ``Angρm(deg)``    | Measurement of current angle in phase 𝜌     |\n\n<div id=\'id5\' />\n\n#### Generate metrics from OpenDSS results\n\n##### Initial measurements with uncertainty of measurement error\n\nThe ``empty_init_files_MEAS_Unc()`` function generates ``.json`` files where all the nodes and elements that can participate as measurement in the state estimation algorithm are placed. For this purpose, the parameters of table 8 must be specified.\n\n**Table 8.** Parameters and description of ``empty_file_MEAS()`` function\n|    **Parameters**   |                           **Description**                     | **Default value** |\n|:------------------:|----------------------------------------------------------------|:-----------------:|\n| ``DSS_path``       | A path of the ``.DSS`` files of the circuit modeled in OpenDSS | ``None``          |\n| ``MEAS_path_save`` | Path where the measurement ``.json`` files will be saved       | ``None``          |\n\nIn the ``MEAS_path_save`` path, it generates the files ``Init_Bus_i.json``, ``Init_Elem_ft.json``, ``Init_Bus_i_PMU.json`` and ``Init_Elem_ft_PMU.json``. Depending on the case study, the ``STS`` meter status (1: Enabled, 0: Disabled) and the measurement error rate in ``Unc(%)`` can be modified.\n\n##### Adding random errors and generating measurement files\n\nWith the ``.json`` files generated by the ``empty_file_MEAS()`` function and the changes indicated by the user, with the ``add_error_file_MEAS()`` function and the Parameters described in Table 9.\n\n**Table 9.** Description and attributes of function ``add_error_files_MEAS()``\n| **Parameters** |                        **Description**                        | **Default value**|\n|:--------------:|---------------------------------------------------------------|:----------------:|\n| ``DSS_path``   | A path of the ``.DSS`` files of the circuit modeled in OpenDSS| ``None``         |\n| ``MEAS_path``  | Path of initial ``.json`` files                               | ``None``         |\n| ``seed_DS``    | Random error generation seed                                  | ``1``            |\n\nAdds random errors from a normal distribution to the OpenDSS power flow results, for use as a measurement. The result of generating random errors is contained in the files ``MEAS_Bus_i.json``, ``MEAS_Elem_ft.json``, ``MEAS_Bus_i_PMU.json`` and ``MEAS_Elem_ft_PMU.json``, stored in ``MEAS_path``.\n\n<div id=\'id6\' />\n\n### Run the state estimation algorithm\n\nTo run the state estimation algorithm, function ``estimate()`` is called, it is necessary to enter or change parameters detailed in table 10. \n\n**Table 10.** Parameters and description of ``estimate()`` function\n\n|   **Parameters** |                                   **Description**                                  | **Default value** |\n|:----------------:|------------------------------------------------------------------------------------|:---------------------:|\n| ``DSS_path``     | A path of the ``.DSS`` files of the circuit modeled in OpenDSS.                    | ``None``              |\n| ``MEAS_path``    | Path where measurement files are located.                                          | ``None``              |\n| ``path_save``    | Path where the results will be saved                                               | ``None``              |\n| ``Typ_cir``      | Circuit type, can be ``1ph`` or ``Pos``.                                           | ``None``              |\n| ``ALG``          | Type of algorithm state variables. At the moment ``NV``                            | ``NV``                |\n| ``coord``        | Type of coordinates to solve. For the moment ``polar``.                            | ``Polar``             |\n| ``method``       | Solution method, can be ``nonlinear``, ``linear_PMU`` and ``nonlinear_PMU``.| ``nonlinear_PMU``|\n| ``name_project`` | Project name                                                                       | ``Default``           |\n| ``View_res``     | Displays the result of the selected algorithm by console                           | ``False``             |\n| ``DSS_coll``     | Displays next to the estimated status, the actual status according to OpenDSS      | ``False``             |\n| ``summary``      | Displays a summary of the simulation by console                                    | ``False``             |\n| ``MEAS_Pos``     | ``True`` if it is a ``Pos`` circuit, take the ``.json`` files in positive sequence.| ``False``             |\n\n<div id=\'id7\' />\n\n## Sample tests\n\nIn the path ``:{Python_library_path}/openpy_dsse/examples``, the ``.DSS`` and ``.json`` files of single-phase (``1ph``) and positive sequence equivalent (``Pos``) circuit measurements detailed in Table 11 are located.\n\n**Table 11.** Sample tests\n| **Circuit** | **Tpy_circ** | **Case** |\n|:------------:|:------------:|:--------:|\n|     4Node    |      1ph     |     1    |\n|  15NodeIEEE  |      1ph     |     2    |\n|  13NodeIEEE  |      Pos     |     1    |\n|  37NodeIEEE  |      Pos     |     2    |\n\nThe function ``test_circuit(Typ_cir, case)``, returns a dictionary with the keys ``\'DSS_file\'``, ``\'MEAS_path\'``, ``\'save_path\'``, ``\'name_project\'`` and ``\'Typ_cir\'`` which correspond to the ``.DSS`` file path, measurement file path, path where results will be saved and circuit type respectively.\n```Python\nimport openpy_dsse\n\ndsse = openpy_dsse.init_DSSE() #Start the class.\n\nif __name__ == \'__main__\':\n    net = dsse.test_circuit(Typ_cir=\'1ph\', case=1)\n    \n    #dsse.empty_init_files_MEAS_Unc(DSS_path=net[\'DSS_file\'], MEAS_path=net[\'MEAS_path\'])\n    #dsse.add_error_files_MEAS(DSS_path=net[\'DSS_file\'], MEAS_path=net[\'MEAS_path\'])\n    #dsse.empty_MEAS_files(DSS_path=net[\'DSS_file\'], MEAS_path=net[\'MEAS_path\'])\n\n    #execute the state estimation algorithm\n    Results = dsse.estimate(\n        DSS_path=net[\'DSS_file\'],\n        MEAS_path=net[\'MEAS_path\'],\n        path_save=net[\'save_path\'],\n        Typ_cir=net[\'Typ_cir\'],\n        name_project=net[\'name_project\'],\n        View_res=True,\n        summary=True,\n        DSS_coll=True,\n        #MEAS_Pos=True,\n        #method=\'nonlinear\'\n        #method=\'linear_PMU\',\n    )\n```\n\n<div id=\'id8\' />\n\n### License\n\nLicense: CC BY-NC-SA 4.0\n\n<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />\n\nThis work has a license <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.\n',
    'author': 'Jorge Lara',
    'author_email': 'jlara@iee.unsj.edu.ar',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
