# Pypet2bids

This library contains several tools and many methods to aid in the conversion of PET imaging and blood data into 
[BIDS]() formatted data. For more detailed documentation refer to the pages at our 
[readthedocs.io site](https://pet2bids.readthedocs.io/en/latest/).

# Python DICOM PET converter

This converter is a simple wrapper around Chris Rorden's [Dcm2niix](https://github.com/rordenlab/dcm2niix) that provides
additional functionality to convert and deliver more BIDS PET friendly output (supplemented sidecar jsons, tsvs, etc)
following image conversion from dicom to nifti.

# Python ECAT PET converter

This converter takes an ecat file, reads it in and then with the help of nibabel spits out a Nifti w/ a BIDS compliant
json replete with any relevant fields parsed from the ecat headers. Required fields that cannot be filled from data
present in the ecat image are still included in the bids json but as empty string values e.g. `RequiredField: ''`.

## Installation and Nifti Generation/Conversion

### Installation

Use pip to install the library via:
```bash
pip install pypet2bids
```

### Converting Dicoms to Nifti

```bash
dcm2niix4pet /path/to/folder/with/dicoms
```

### Converting ECAT to Nifti

```bash
# for ecat to Nii use the cli to create a nifti from the ecat via:
ecatpet2bids /path/to/ecat/image.v --convert
```

If you wish to generate the converted image(s) and json somewhere other than the current directory of your ecat image(s)
include the `--nifti` argument and specify a filename w/ a full path included e.g.:

```bash
ecatpet2bids /path/to/ecat/image.v --convert --nifti /path/to/new/nifti
```

### Additional Usage

This converter was written originally as a method to extract ecat header/subheader data into stdout key: value format
and/or json.

For more information about those arguments see `python main.py --help` or read below:

```bash
ecatpet2bids --help
usage: ecatpet2bids [-h] [--affine] [--convert] [--dump] [--json] [--nifti file_name]
       [--subheader] [--sidecar] [--kwargs [KWARGS ...]]
       [--scannerparams [SCANNERPARAMS ...]] ecat_file

positional arguments:
  ecat_file             Ecat image to collect info from.

optional arguments:
  -h, --help            show this help message and exit
  --affine, -a          Show affine matrix
  --convert, -c         If supplied will attempt conversion.
  --dump, -d            Dump information in Header
  --json, -j            Output header and subheader info as JSON to stdout,
                        overrides all other options
  --nifti file_name, -n file_name
                        Name of nifti output file
  --subheader, -s       Display subheaders
  --sidecar             Output a bids formatted sidecar for pairing witha nifti.
  --kwargs [KWARGS ...], -k [KWARGS ...]
                        Include additional values int the nifti sidecar json or
                        override values extracted from the supplied nifti. e.g.
                        including `--kwargs TimeZero='12:12:12'` would override
                        the calculated TimeZero. Any number of additional
                        arguments can be supplied after --kwargs e.g. `--kwargs
                        BidsVariable1=1 BidsVariable2=2` etc etc.
  --scannerparams [SCANNERPARAMS ...]
                        Loads saved scanner params from a configuration file
                        following --scanner-params/-s if this option is used
                        without an argument this cli will look for any scanner
                        parameters file in the directory with the name
                        *parameters.txt from which this cli is called.
```

### Configuring a default scanner parameters file

When converting a files from ECAT to Nifti originating from the same scanner or institution it
may be desirable to include these same values in your BIDS sidecar.json across all files/scans/subjects.

This can be done by populating a txt or .env file with the common BIDS scanner parameters and
specifying to the command line to use this file with `--scannerparams`.

Note: Values included in the scanneparameter file will be overridden with any corresponding
values supplied via the `--kwargs` argument. e.g. `--kwargs Manufacturer=GE` would override

```bash
# scannerparameters.txt file
Manufacturer=Siemens
```

### File Formatting

Scannerparam files are configured as simply as environment variables, that is to say:
```bash
# Number signs can be used for comments
# String variables such as institution name are entered after the equals sign
InstitutionName='Your Prestigous Institution'
# a list of strings would be entered as a bracketed list of comma separated quoted strings
ReconMethodParameterUnits=['None','None', 'keV', 'keV']
# A list of real numbers
ReconMethodParameterValues=[0.0, 1.2, 3.0, 42.1]
# Similarly, a list of integers
ValidBidsTerm=[1,2,3,4]
# Single numerical values are entered directly without quotes
BidsFloat=3.2
BidsInt=7

```

### Usage

- Pointing directly at a scannerparams file `--scannerparams /path/to/scannerparams.txt`
- **NOTE**: `--scannerparams` usage by itself with no file path requires a parameter file exist in the directory
that the CLI is being called from. `$ecat_dir: ecatpet2bids ecatfile.v --scannerparms` assumes that `ls ecat_dir` will
reveal a file containing `*parameters.txt`

## Testing

To run the tests in `tests/` first copy the `template.env` file to `.env` with in this folder and then populate it with
paths to read ecats from as well as paths to write test niftis to.

```bash
cp template.env .env
cat .env
TEST_ECAT_PATH=
OUTPUT_NIFTI_PATH=
READ_ECAT_SAVE_AS_MATLAB=
NIBABEL_READ_ECAT_SAVE_AS_MATLAB=
```

And after you've filled in you .env file it should resemble the following:

```bash
cat .env
TEST_ECAT_PATH=/Users/user/ecat_file.v
OUTPUT_NIFTI_PATH=/Users/user/test_nifti.nii
READ_ECAT_SAVE_AS_MATLAB=/Users/user/python_ecat_read_object.mat
NIBABEL_READ_ECAT_SAVE_AS_MATLAB=/Users/user/nibabel_ecat_read_object.mat
```
