"""Class implementation for copy interface.
"""

from copy import deepcopy
from typing import Any

from apyscript.expression import expression_file_util
from apyscript.expression import expression_variables_util
from apyscript.type.type_name_interface import TypeNameInterface
from apyscript.type.variable_name_interface import VariableNameInterface


class CopyInterface(TypeNameInterface, VariableNameInterface):

    def _copy(self) -> Any:
        """
        Make a deep copy of this instance.

        Returns
        -------
        result : *
            Copied instance.
        """
        result: CopyInterface = deepcopy(self)
        result.variable_name = \
            expression_variables_util.get_next_variable_name(
                type_name=self.type_name)
        self._append_copy_expression(
            result_variable_name=result.variable_name)
        return result

    def _append_copy_expression(self, result_variable_name: str) -> None:
        """
        Append copy expression to file.

        Parameters
        ----------
        result_variable_name : str
            Copied value's variable name.
        """
        expression: str = (
            f'var {result_variable_name} = '
            f'JSON.parse(JSON.stringify({self.variable_name}));'
        )
        expression_file_util.wrap_by_script_tag_and_append_expression(
            expression=expression)
