
from typing import (
        Any, Tuple, Union, Optional, overload, TypeGuard, 
        Literal, Dict)

from .base import Backend, Size, Number
from .base import TensorLike as _DT


"""
This class serves as an interface for the computation backend.
All methods in this class are static methods by default,
unless explicitly annotated otherwise.
"""

class BackendManager():
    def __init__(self, *, default_backend: str): ... # instance method
    def set_backend(self, name: str) -> None: ... # instance method
    def load_backend(self, name: str) -> None: ... # instance method
    def get_current_backend(self) -> Backend: ... # instance method

    def context(self, tensor) -> Dict: ...
    ### constants ###

    pi: float
    e: float
    nan: float
    inf: float
    dtype: type
    device: type
    bool_: Any
    uint8: Any
    int_: Any
    int8: Any
    int16: Any
    int32: Any
    int64: Any
    float_: Any
    float16: Any
    float32: Any
    float64: Any
    complex_: Any
    complex64: Any
    complex128: Any

    ### Backend tools ###

    def is_tensor(self, obj: Any, /) -> TypeGuard[_DT]: ...
    # PyTorch
    def set_default_device(self, device: Any) -> None: ...
    def get_device(self, tensor_like: _DT, /) -> Any: ...
    def to_numpy(self, tensor_like: _DT, /) -> Any: ...
    # PyTorch
    def from_numpy(self, ndarray: Any, /) -> _DT: ...

    ###Functional programming
    def apply_along_axis(self, func1d, axis, arr: _DT, *args, **kwargs) 

    ### Tensor creation methods ###

    # Numpy + PyTorch(tensor)
    def array(self, object, /, dtype=None, **kwargs) -> _DT: ...
    # Numpy(array) + PyTorch
    def tensor(self, data, /, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    @overload
    def arange(self, stop: int, /, *, dtype=None, **kwargs) -> _DT: ...
    @overload
    def arange(self, start: int, stop: int, /, step=1, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def linspace(self, start, stop, num, /, endpoint=True, retstep=False, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def empty(self, shape: Size, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def zeros(self, shape: Size, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def ones(self, shape: Size, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def full(self, shape: Size, fill_value: Number, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def empty_like(self, a: _DT, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def zeros_like(self, a: _DT, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def ones_like(self, a: _DT, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def full_like(self, a: _DT, fill_value: Number, /, *, dtype=None, **kwargs) -> _DT: ...
    # Numpy
    def eye(self, n: int, m: Optional[int]=None, /, k: int=0, dtype=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def meshgrid(self, *xi: Any, copy=True, sparse=False, indexing='xy', **kwargs) -> Tuple[_DT, ...]: ...

    ### Reduction methods ###

    # Numpy
    def all(self, a: _DT, axis=None, out=None, keepdims=False) -> _DT: ...
    # Numpy
    def any(self, a: _DT, axis=None, out=None, keepdims=False) -> _DT: ...
    # Numpy
    def sum(self, a: _DT, axis=None, dtype=None, out=None, keepdims=False, initial: Number=...) -> _DT: ...
    # Numpy
    def prod(self, a: _DT, axis=None, dtype=None, out=None, keepdims=False, initial: Number=...) -> _DT: ...
    # Numpy
    def mean(self, a: _DT, axis=None, dtype=None, out=None, keepdims=False) -> _DT: ...
    # Numpy
    def max(self, a: _DT, axis=None, out=None, keepdims=False): ...
    # Numpy
    def min(self, a: _DT, axis=None, out=None, keepdims=False): ...
    # Numpy
    def argmax(self, a: _DT, axis=None, out=None, *, keepdims=False) -> _DT: ...
    # Numpy
    def argmin(self, a: _DT, axis=None, out=None, *, keepdims=False) -> _DT: ...

    ### Unary operations ###

    # Numpy + PyTorch
    def abs(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def sign(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def sqrt(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def square(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def exp(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def log(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def log10(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def log2(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def sin(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def cos(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def tan(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arcsin(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arccos(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arctan(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arctan2(self, __y: _DT, __x: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arcsinh(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arccosh(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def arctanh(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def sinh(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def cosh(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def tanh(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def clip(self, a: _DT, a_min: Number, a_max: Number, /, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def floor(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def ceil(self, __x1: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def round(self, __x1: _DT, *, decimals=0, out=None, **kwargs) -> _DT: ...

    ### Binary operations ###

    # Numpy + PyTorch
    def add(self, __x1: _DT, __x2: _DT, out=None, **kwargs) -> _DT: ...
    # -
    def add_at(self, a: _DT, indices, src: _DT, /) -> None: ...
    # PyTorch only
    def index_add_(self, a: _DT, /, dim: int, index: _DT, src: _DT, *, alpha: Number=1.) -> _DT: ...
    # Numpy + PyTorch
    def substract(self, __x1: _DT, __x2: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def multiply(self, __x1: _DT, __x2: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def divide(self, __x1: _DT, __x2: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def power(self, __x1: _DT, __x2: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def matmul(self, __x1: _DT, __x2: _DT, out=None, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def dot(self, a: _DT, b: _DT, out=None) -> _DT: ...
    # Numpy
    def cross(self, a: _DT, b: _DT, axis: Optional[int]=None, **kwargs) -> _DT: ...
    # Numpy
    def tensordot(self, a: _DT, b: _DT, axes: Union[int, Tuple]) -> _DT: ...

    ### Other methods ###

    # Numpy
    def copy(self, a: _DT, /, **kwargs) -> _DT: ...
    # Numpy + PyTorch
    def reshape(self, a: _DT, newshape: Size, /) -> _DT: ...
    # Numpy + PyTorch
    def broadcast_to(self, array: _DT, shape: Size, /) -> _DT: ...
    # Numpy + PyTorch
    def einsum(self, subscripts: str, /, *operands: _DT, **kwargs) -> _DT: ...
    # Numpy
    def unique(self, ar: _DT, return_index=False, return_inverse=False, return_counts=False, axis=0, **kwargs): ...
    # Numpy
    def sort(self, a: _DT, axis=0, **kwargs) -> _DT: ...
    # Numpy
    def argsort(self, a: _DT, axis=-1, **kwargs) -> _DT: ...
    # -
    @overload
    def nonzero(self, a: _DT, /) -> Tuple[_DT, ...]: ...
    @overload
    def nonzero(self, a: _DT, /, as_tuple: Literal[True]) -> Tuple[_DT, ...]: ...
    @overload
    def nonzero(self, a: _DT, /, as_tuple: Literal[False]) -> _DT: ...
    # Numpy
    def cumsum(self, a: _DT, axis=None, dtype=None, out=None) -> _DT: ...
    # Numpy
    def cumprod(self, a: _DT, axis=None, dtype=None, out=None) -> _DT: ...
    # PyTorch
    def cat(self, tensors, dim=0, *, out=None) -> _DT: ...
    # Numpy
    def concatenate(self, arrays, /, axis=0, out=None, *, dtype=None) -> _DT: ...
    # Numpy
    def stack(self, arrays, axis=0, out=None, *, dtype=None) -> _DT: ...
    # Numpy + PyTorch
    def repeat(self, a: _DT, repeats: int, axis: Optional[int]=None, /) -> _DT: ...
    # Numpy + PyTorch(permute)
    def transpose(self, a: _DT, axes: Size, /) -> _DT: ...
    # Numpy + PyTorch
    def swapaxes(self, a: _DT, axis1: int, axis2: int, /) -> _DT: ...
    # Numpy
    def flip(self, a: _DT, axis: Optional[Union[int, Tuple[int, ...]]]=None) -> _DT: ...
    # Numpy
    def where(self, condition: _DT, x: Optional[_DT]=None, y: Optional[_DT]=None, /, out=None) -> _DT: ...
    # Numpy + PyTorch
    def tile(self, a: _DT, reps: Size, /) -> _DT: ...

    ### FEALPy functionals ###

    def multi_index_matrix(self, p: int, dim: int, *, dtype=None) -> _DT: ...
    def edge_length(self, edge: _DT, node: _DT, *, out=None) -> _DT: ...
    def edge_normal(self, edge: _DT, node: _DT, unit=False, *, out=None) -> _DT: ...
    def edge_tangent(self, edge: _DT, node: _DT, unit=False, *, out=None) -> _DT: ...
    def tensorprod(self, *tensors: _DT) -> _DT: ...
    def bc_to_points(self, bcs: Union[_DT, Tuple[_DT, ...]], node: _DT, entity: _DT) -> _DT: ...
    def barycenter(self, entity: _DT, node: _DT, loc: Optional[_DT]=None) -> _DT: ...
    def simplex_ldof(self, p: int, iptype: int) -> int: ... # implement in base
    def simplex_gdof(self, p: int, nums: Tuple[int, ...]) -> int: ... # implement in base
    def simplex_measure(self, entity: _DT, node: _DT) -> _DT: ...
    def simplex_shape_function(self, bc: _DT, p: int, mi: Optional[_DT]=None) -> _DT: ...
    def simplex_grad_shape_function(self, bc: _DT, p: int, mi: Optional[_DT]=None) -> _DT: ...
    def simplex_hess_shape_function(self, bc: _DT, p: int, mi: Optional[_DT]=None) -> _DT: ...
    def tensor_ldof(self, p: int, iptype: int) -> int: ... # implement in base
    def tensor_gdof(self, p: int, nums: Tuple[int, ...]) -> int: ... # implement in base
    def tensor_measure(self, entity: _DT, node: _DT) -> _DT: ...

    def interval_grad_lambda(self, line: _DT, node: _DT) -> _DT: ...
    def triangle_area_3d(self, tri: _DT, node: _DT) -> _DT: ...
    def triangle_grad_lambda_2d(self, tri: _DT, node: _DT) -> _DT: ...
    def triangle_grad_lambda_3d(self, tri: _DT, node: _DT) -> _DT: ...
    def quadrangle_grad_lambda_2d(self, quad: _DT, node: _DT) -> _DT: ...
    def tetrahedron_grad_lambda_3d(self, tet: _DT, node: _DT, local_face: _DT) -> _DT: ...
